/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3.bean;

import java.awt.Color;
import java.awt.Frame;
import java.beans.PropertyEditorSupport;
import jclass.table3.bean.ColorChooser;
import jclass.util.JCUtilConverter;

public class ColorEditor
extends PropertyEditorSupport {
    static String[] color_names = new String[]{"Black", "Blue", "Cyan", "DarkGray", "Gray", "Green", "LightGray", "LightBlue", "Magenta", "Orange", "Pink", "Red", "Yellow", "White", "Custom"};
    ColorChooser chooser = new ColorChooser(this);

    protected boolean eqColor(Color color, Color color2) {
        return color.getRed() == color2.getRed() && color.getGreen() == color2.getGreen() && color.getBlue() == color2.getBlue();
    }

    public Frame findParent() {
        return new Frame();
    }

    public String getAsText() {
        Color color = this.getColor();
        if (color == null) {
            return "Black";
        }
        if (this.eqColor(color, Color.black)) {
            return "Black";
        }
        if (this.eqColor(color, Color.blue)) {
            return "Blue";
        }
        if (this.eqColor(color, Color.cyan)) {
            return "Cyan";
        }
        if (this.eqColor(color, Color.darkGray)) {
            return "DarkGray";
        }
        if (this.eqColor(color, Color.gray)) {
            return "Gray";
        }
        if (this.eqColor(color, Color.green)) {
            return "Green";
        }
        if (this.eqColor(color, JCUtilConverter.lightBlue)) {
            return "LightBlue";
        }
        if (this.eqColor(color, Color.lightGray)) {
            return "LightGray";
        }
        if (this.eqColor(color, Color.magenta)) {
            return "Magenta";
        }
        if (this.eqColor(color, Color.orange)) {
            return "Orange";
        }
        if (this.eqColor(color, Color.pink)) {
            return "Pink";
        }
        if (this.eqColor(color, Color.red)) {
            return "Red";
        }
        if (this.eqColor(color, Color.white)) {
            return "White";
        }
        if (this.eqColor(color, Color.yellow)) {
            return "Yellow";
        }
        return "Custom";
    }

    Color getColor() {
        return (Color)this.getValue();
    }

    public String getJavaInitializationString() {
        if (this.getValue() == null) {
            return "Color.black";
        }
        return "new Color(" + this.getColor().getRGB() + ")";
    }

    public String[] getTags() {
        return color_names;
    }

    void selectColor(Color color) {
        if (color != null) {
            this.setColor(color);
        }
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Color color = null;
        if (string.equals("Custom")) {
            this.chooser = new ColorChooser(this);
            this.chooser.pack();
            this.chooser.show();
        } else {
            color = JCUtilConverter.toColor(string);
            if (color == null) {
                throw new IllegalArgumentException("invalid color: " + string);
            }
            this.setValue(color);
        }
    }

    private void setColor(Color color) {
        if (color != null) {
            this.setValue(color);
            this.firePropertyChange();
        }
    }
}

