/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import jclass.table3.JCCellRange;
import jclass.table3.Series;
import jclass.table3.SeriesValue;
import jclass.table3.Shift;
import jclass.table3.Table;
import jclass.table3.WidgetSeriesValue;

class SeriesUtil {
    SeriesUtil() {
    }

    static void cvtRangeContextToRange(Table table, JCCellRange jCCellRange, JCCellRange jCCellRange2) {
        int n;
        if (jCCellRange.start_row == -998 || jCCellRange.start_row == -997) {
            jCCellRange2.start_row = jCCellRange2.end_row = jCCellRange.start_row;
        } else if (jCCellRange.start_row == -1 && jCCellRange.end_row == Integer.MAX_VALUE) {
            jCCellRange2.end_row = -998;
            jCCellRange2.start_row = -998;
        } else if (jCCellRange.start_row == -1) {
            jCCellRange2.end_row = -1;
            jCCellRange2.start_row = -1;
        } else if (jCCellRange.start_row == 0 && jCCellRange.end_row == Integer.MAX_VALUE) {
            jCCellRange2.end_row = -997;
            jCCellRange2.start_row = -997;
        } else if (!table.isLiveTable) {
            jCCellRange2.start_row = Math.min(table.rows - 1, jCCellRange.start_row);
            jCCellRange2.end_row = Math.min(table.rows - 1, jCCellRange.end_row);
        } else {
            jCCellRange2.start_row = jCCellRange.start_row;
            jCCellRange2.end_row = jCCellRange.end_row;
        }
        if (jCCellRange.start_column == -998 || jCCellRange.start_column == -997) {
            jCCellRange2.start_column = jCCellRange2.end_column = jCCellRange.start_column;
        } else if (jCCellRange.start_column == -1 && jCCellRange.end_column == Integer.MAX_VALUE) {
            jCCellRange2.end_column = -998;
            jCCellRange2.start_column = -998;
        } else if (jCCellRange.start_column == -1) {
            jCCellRange2.end_column = -1;
            jCCellRange2.start_column = -1;
        } else if (jCCellRange.start_column == 0 && jCCellRange.end_column == Integer.MAX_VALUE) {
            jCCellRange2.end_column = -997;
            jCCellRange2.start_column = -997;
        } else if (!table.isLiveTable) {
            jCCellRange2.start_column = Math.min(table.columns - 1, jCCellRange.start_column);
            jCCellRange2.end_column = Math.min(table.columns - 1, jCCellRange.end_column);
        } else {
            jCCellRange2.start_column = jCCellRange.start_column;
            jCCellRange2.end_column = jCCellRange.end_column;
        }
        if (jCCellRange2.start_row > jCCellRange2.end_row) {
            n = jCCellRange2.start_row;
            jCCellRange2.start_row = jCCellRange2.end_row;
            jCCellRange2.end_row = n;
        }
        if (jCCellRange2.start_column > jCCellRange2.end_column) {
            n = jCCellRange2.start_column;
            jCCellRange2.start_column = jCCellRange2.end_column;
            jCCellRange2.end_column = n;
        }
    }

    static void moveColumns(Series series, int n, int n2, int n3) {
        series.last_index = -999;
        int n4 = 0;
        while (n4 < series.size()) {
            SeriesValue seriesValue = (SeriesValue)series.elementAt(n4);
            seriesValue.column = Shift.adjust(seriesValue.column, n, n2, n3);
            ++n4;
        }
    }

    static void moveRows(Series series, int n, int n2, int n3) {
        series.last_index = -999;
        int n4 = 0;
        while (n4 < series.size()) {
            SeriesValue seriesValue = (SeriesValue)series.elementAt(n4);
            seriesValue.row = Shift.adjust(seriesValue.row, n, n2, n3);
            ++n4;
        }
    }

    static void reorderColumns(Series series, int[] nArray) {
        series.last_index = -999;
        int n = 0;
        while (n < series.size()) {
            SeriesValue seriesValue = (SeriesValue)series.elementAt(n);
            if (seriesValue.column >= 0 && seriesValue.column < nArray.length) {
                seriesValue.column = nArray[seriesValue.column];
            }
            ++n;
        }
    }

    static void reorderRows(Series series, int[] nArray) {
        series.last_index = -999;
        int n = 0;
        while (n < series.size()) {
            SeriesValue seriesValue = (SeriesValue)series.elementAt(n);
            if (seriesValue.row >= 0 && seriesValue.row < nArray.length) {
                seriesValue.row = nArray[seriesValue.row];
            }
            ++n;
        }
    }

    static boolean setValue(Table table, Series series, JCCellRange jCCellRange, Object object) {
        if (!table.isLiveTable && jCCellRange.start_row == -998 && jCCellRange.start_column == -998) {
            series.setDefault(object);
            return true;
        }
        boolean bl = false;
        JCCellRange jCCellRange2 = new JCCellRange();
        SeriesUtil.cvtRangeContextToRange(table, jCCellRange, jCCellRange2);
        int n = jCCellRange2.start_row;
        while (n <= jCCellRange2.end_row) {
            int n2 = jCCellRange2.start_column;
            while (n2 <= jCCellRange2.end_column) {
                if (series.setValue(n, n2, object)) {
                    bl = true;
                }
                ++n2;
            }
            ++n;
        }
        return bl;
    }

    static void shiftColumn(Series series, int n, int n2, int n3) {
        series.last_index = -999;
        int n4 = series.size() - 1;
        while (n4 >= 0) {
            SeriesValue seriesValue = (SeriesValue)series.elementAt(n4);
            if (n3 > 0) {
                if (seriesValue.column >= n) {
                    seriesValue.column += n2;
                }
            } else if (seriesValue.column >= n && seriesValue.column < n + n2) {
                if (seriesValue.value instanceof WidgetSeriesValue) {
                    ((WidgetSeriesValue)seriesValue.value).destroy();
                }
                series.removeElementAt(n4);
            } else if (seriesValue.column >= n + n2) {
                seriesValue.column -= n2;
            }
            --n4;
        }
    }

    static void shiftRow(Series series, int n, int n2, int n3) {
        series.last_index = -999;
        int n4 = series.size() - 1;
        while (n4 >= 0) {
            SeriesValue seriesValue = (SeriesValue)series.elementAt(n4);
            if (n3 > 0) {
                if (seriesValue.row >= n) {
                    seriesValue.row += n2;
                }
            } else if (seriesValue.row >= n && seriesValue.row < n + n2) {
                if (seriesValue.value instanceof WidgetSeriesValue) {
                    ((WidgetSeriesValue)seriesValue.value).destroy();
                }
                series.removeElementAt(n4);
            } else if (seriesValue.row >= n + n2) {
                seriesValue.row -= n2;
            }
            --n4;
        }
    }

    static void swapColumns(Series series, int n, int n2) {
        series.last_index = -999;
        int n3 = 0;
        while (n3 < series.size()) {
            SeriesValue seriesValue = (SeriesValue)series.elementAt(n3);
            seriesValue.column = Shift.swap(seriesValue.column, n, n2);
            ++n3;
        }
    }

    static void swapRows(Series series, int n, int n2) {
        series.last_index = -999;
        int n3 = 0;
        while (n3 < series.size()) {
            SeriesValue seriesValue = (SeriesValue)series.elementAt(n3);
            seriesValue.row = Shift.swap(seriesValue.row, n, n2);
            ++n3;
        }
    }
}

