/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import jclass.table3.VectorDataSource;

public class ResultSetDataSource
extends VectorDataSource {
    protected Connection dbcon;
    protected String query;
    protected int column_count;
    protected int[] column_type;

    public ResultSetDataSource() {
        this.dbcon = null;
        this.query = null;
    }

    public ResultSetDataSource(Connection connection, String string) {
        this.dbcon = connection;
        this.query = string;
    }

    public boolean connect(String string, String string2, Properties properties) throws SQLException {
        boolean bl = false;
        try {
            Class.forName(string).newInstance();
            this.dbcon = DriverManager.getConnection(string2, properties);
            bl = true;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            System.out.println("Unable to load driver: " + exception.getMessage());
        }
        return bl;
    }

    public boolean executeQuery() throws SQLException {
        boolean bl = false;
        Vector vector = new Vector();
        int n = -1;
        if (this.dbcon == null) {
            return bl;
        }
        Statement statement = this.dbcon.createStatement();
        ResultSet resultSet = statement.executeQuery(this.query);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        this.column_count = resultSetMetaData.getColumnCount();
        this.setNumColumns(this.column_count);
        this.column_type = new int[this.column_count];
        int n2 = 0;
        while (n2 < this.column_count) {
            this.setColumnLabel(n2, resultSetMetaData.getColumnName(n2 + 1));
            this.column_type[n2] = resultSetMetaData.getColumnType(n2 + 1);
            ++n2;
        }
        while (resultSet.next()) {
            ++n;
            int n3 = 0;
            while (n3 < this.column_count) {
                this.setCell(n, n3, resultSet.getObject(n3 + 1));
                ++n3;
            }
        }
        bl = true;
        this.setNumRows(n + 1);
        return bl;
    }

    public int getColumnDatatype(int n) {
        int n2 = 5;
        if (n < 0 || n >= this.columns) {
            return n2;
        }
        switch (this.column_type[n]) {
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                n2 = 4;
                break;
            }
            case -5: 
            case 8: {
                n2 = 2;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                n2 = 5;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                n2 = 1;
                break;
            }
            default: {
                n2 = 5;
            }
        }
        return n2;
    }

    public int getColumnType(int n) {
        if (n < 0 || n >= this.columns) {
            return -1;
        }
        return this.column_type[n];
    }

    public int[] getColumnTypes() {
        return this.column_type;
    }

    public Connection getConnection() {
        return this.dbcon;
    }

    public String getQuery() {
        return this.query;
    }

    public void setConnection(Connection connection) {
        this.dbcon = connection;
    }

    public void setQuery(String string) {
        this.query = string;
    }
}

