/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.table.TableModel;
import jclass.table3.AppWrapper;
import jclass.table3.BeanFileDataSource;
import jclass.table3.CellBorder;
import jclass.table3.CellSizeWrapper;
import jclass.table3.DataWrapper;
import jclass.table3.EditStateWrapper;
import jclass.table3.EditableVectorDataSource;
import jclass.table3.FrozenCellLayoutWrapper;
import jclass.table3.JCCellPosition;
import jclass.table3.JCCellRange;
import jclass.table3.JCPrintEvent;
import jclass.table3.JCPrintListener;
import jclass.table3.JCTblConverter;
import jclass.table3.JCTblRevConverter;
import jclass.table3.JCVersion;
import jclass.table3.LabelLayoutWrapper;
import jclass.table3.LabelTrigger;
import jclass.table3.PrintWrapper;
import jclass.table3.SBLayoutWrapper;
import jclass.table3.Series;
import jclass.table3.SeriesValue;
import jclass.table3.Size;
import jclass.table3.StandardCellBorder;
import jclass.table3.Table;
import jclass.table3.TableData;
import jclass.table3.TablePopupMenu;
import jclass.table3.TableSwingDataSource;
import jclass.table3.TextPositioningWrapper;
import jclass.table3.VectorDataSource;
import jclass.util.BasePopupMenu;
import jclass.util.JCUtilConverter;
import jclass.util.JCVector;

public class LiveTable
extends Table
implements JCPrintListener {
    public static final int ALIGNMENT = 0;
    public static final int BACKGROUND = 1;
    public static final int BORDERSIDES = 2;
    public static final int BORDERTYPE = 3;
    public static final int CHARHEIGHT = 4;
    public static final int CHARWIDTH = 5;
    public static final int COMPONENT = 6;
    public static final int DATATYPE = 7;
    public static final int EDITABLE = 8;
    public static final int FONT = 9;
    public static final int FOREGROUND = 10;
    public static final int MAXLENGTH = 11;
    public static final int MULTILINE = 12;
    public static final int PIXELHEIGHT = 13;
    public static final int PIXELWIDTH = 14;
    public static final int STRINGCASE = 15;
    public static final int TRAVERSABLE = 16;
    public static final int USERDATA = 17;
    protected static int numColumns = 4;
    protected static int numRows = 4;
    protected boolean column_label_sort = false;
    private JCCellPosition find_cell = new JCCellPosition();
    private String search_string;

    public LiveTable() {
        this.isLiveTable = true;
        this.setColumnLabelDisplay(true);
        this.setMarginHeight(1);
        this.setMarginWidth(2);
        this.setPixelWidth(-1, 40);
        this.setRowLabelDisplay(true);
        this.setPixelWidth(-998, 33001);
        this.setPixelHeight(-998, 33001);
        this.setStyled();
        this.makeDataSource();
        this.addPrintListener(this);
    }

    private boolean findInternal(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        this.search_string = string.toUpperCase();
        int n = this.edit_row;
        int n2 = this.edit_column;
        if (this.edit_row == -999) {
            if (this.matches(0, 0)) {
                return true;
            }
            n2 = 0;
            n = 0;
        }
        int n3 = n;
        int n4 = n2++;
        while (true) {
            if (n2 >= this.columns) {
                n2 = 0;
                ++n;
            }
            if (n >= this.rows) {
                n = 0;
            }
            if (n == n3 && n2 == n4) break;
            if (this.matches(n, n2)) {
                return true;
            }
            ++n2;
        }
        return this.matches(n, n2);
    }

    public boolean findString(String string) {
        if (!this.findInternal(string)) {
            return false;
        }
        int n = this.edit_row;
        int n2 = this.edit_column;
        this.edit_row = this.find_cell.row;
        this.edit_column = this.find_cell.column;
        if (!this.isVisible(this.find_cell.row, this.find_cell.column)) {
            this.makeVisible(this.find_cell.row, this.find_cell.column);
        } else {
            this.paint(this.find_cell.row, this.find_cell.column);
        }
        if (this.find_cell.row != n || this.find_cell.column != n2 && this.isVisible(n, n2)) {
            this.edit_row = -999;
            this.paint(n, n2);
            this.edit_row = this.find_cell.row;
        }
        return true;
    }

    public String fromSeries(int n) {
        JCVector jCVector = new JCVector();
        JCVector jCVector2 = new JCVector();
        StringBuffer stringBuffer = new StringBuffer();
        this.resourceToString(n, jCVector, jCVector2);
        int n2 = 0;
        while (n2 < jCVector.size() && n2 < jCVector2.size()) {
            JCCellRange jCCellRange = (JCCellRange)jCVector.elementAt(n2);
            Object e = jCVector2.elementAt(n2);
            int n3 = e instanceof Number ? ((Number)e).intValue() : 0;
            stringBuffer.append("(");
            switch (n) {
                case 4: 
                case 13: {
                    stringBuffer.append(JCTblRevConverter.fromRowRange(jCCellRange));
                    break;
                }
                case 5: 
                case 14: {
                    stringBuffer.append(JCTblRevConverter.fromColumnRange(jCCellRange));
                    break;
                }
                default: {
                    stringBuffer.append(JCTblRevConverter.fromRange(jCCellRange));
                }
            }
            stringBuffer.append(" ");
            switch (n) {
                case 0: {
                    stringBuffer.append(JCTblConverter.fromEnum("Alignment", n3));
                    break;
                }
                case 2: {
                    stringBuffer.append(JCTblRevConverter.fromBorderSides(n3, "BorderSides", ""));
                    break;
                }
                case 3: {
                    stringBuffer.append(JCTblConverter.fromEnum("Bordertype", n3));
                    break;
                }
                case 4: {
                    stringBuffer.append(JCTblRevConverter.fromInt(n3));
                    break;
                }
                case 5: {
                    stringBuffer.append(JCTblRevConverter.fromInt(n3));
                    break;
                }
                case 6: {
                    stringBuffer.append(e.toString());
                    break;
                }
                case 7: {
                    stringBuffer.append(JCTblConverter.fromEnum("Datatype", n3));
                    break;
                }
                case 8: {
                    stringBuffer.append(e.toString());
                    break;
                }
                case 9: {
                    Font font = e instanceof Font ? (Font)e : new Font("Serif", 0, 12);
                    stringBuffer.append(JCUtilConverter.fromFont(font));
                    break;
                }
                case 1: 
                case 10: {
                    if (e instanceof Color) {
                        stringBuffer.append(JCUtilConverter.fromColor((Color)e));
                        break;
                    }
                    stringBuffer.append(JCUtilConverter.fromColor(Color.gray));
                    break;
                }
                case 11: {
                    stringBuffer.append(JCTblRevConverter.fromInt(n3));
                    break;
                }
                case 12: {
                    stringBuffer.append(e.toString());
                    break;
                }
                case 13: {
                    stringBuffer.append(JCTblRevConverter.fromCellSize(n3));
                    break;
                }
                case 14: {
                    stringBuffer.append(JCTblRevConverter.fromCellSize(n3));
                    break;
                }
                case 15: {
                    stringBuffer.append(JCTblConverter.fromEnum("Stringcase", n3));
                    break;
                }
                case 16: {
                    stringBuffer.append(e.toString());
                    break;
                }
                case 17: {
                    stringBuffer.append(e.toString());
                    break;
                }
            }
            stringBuffer.append(")");
            ++n2;
        }
        return new String(stringBuffer);
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public AppWrapper getAppearance() {
        AppWrapper appWrapper = new AppWrapper(this.fromSeries(10), this.fromSeries(1), this.fromSeries(9));
        return appWrapper;
    }

    public int getCellBorderType() {
        CellBorder cellBorder = this.getCellBorderType(0, 0);
        if (cellBorder == null || !(cellBorder instanceof StandardCellBorder)) {
            return 8;
        }
        return ((StandardCellBorder)cellBorder).getBorderType();
    }

    public CellSizeWrapper getCellSize() {
        CellSizeWrapper cellSizeWrapper = new CellSizeWrapper(this.fromSeries(14), this.fromSeries(13));
        return cellSizeWrapper;
    }

    public int getColumnLabelBorderType() {
        CellBorder cellBorder = this.getCellBorderType(-1, 0);
        if (cellBorder == null || !(cellBorder instanceof StandardCellBorder)) {
            return 8;
        }
        return ((StandardCellBorder)cellBorder).getBorderType();
    }

    public boolean getColumnLabelSort() {
        return this.column_label_sort;
    }

    public DataWrapper getData() {
        String string;
        TableData tableData = this.getDataSource();
        boolean bl = tableData instanceof BeanFileDataSource ^ true;
        String string2 = null;
        String string3 = null;
        if (bl) {
            string = ((VectorDataSource)tableData).toString();
            string2 = JCTblRevConverter.fromVector(((VectorDataSource)this.dataView.getDataSource()).column_labels, '|');
            string3 = JCTblRevConverter.fromVector(((VectorDataSource)this.dataView.getDataSource()).row_labels, '|');
        } else {
            string = ((BeanFileDataSource)tableData).getName();
        }
        return new DataWrapper(bl, tableData.getNumRows(), tableData.getNumColumns(), string3, string2, string);
    }

    public boolean getDisplayClipArrows() {
        return this.getClipArrows() == 4;
    }

    public EditStateWrapper getEditState() {
        EditStateWrapper editStateWrapper = new EditStateWrapper(this.fromSeries(16), this.fromSeries(8));
        return editStateWrapper;
    }

    public FrozenCellLayoutWrapper getFrozenCellLayout() {
        FrozenCellLayoutWrapper frozenCellLayoutWrapper = new FrozenCellLayoutWrapper(this.frozen_row_placement, this.frozen_column_placement);
        return frozenCellLayoutWrapper;
    }

    public LabelLayoutWrapper getLabelLayout() {
        LabelLayoutWrapper labelLayoutWrapper = new LabelLayoutWrapper(this.row_label_offset, this.row_label_placement, this.column_label_offset, this.column_label_placement);
        return labelLayoutWrapper;
    }

    public static int getNumEditorColumns() {
        return numColumns;
    }

    public static int getNumEditorRows() {
        return numRows;
    }

    public Dimension getPreferredSize() {
        int n = 20;
        try {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont(0, 0));
            n = fontMetrics.getAscent() + fontMetrics.getDescent();
        }
        catch (Exception exception) {}
        return new Dimension(n * 16, n * 12);
    }

    public PrintWrapper getPrintSettings() {
        return new PrintWrapper(this.printHeader, this.printFooter, this.showPrintMenu, this.showPrintPreview);
    }

    public int getRowLabelBorderType() {
        CellBorder cellBorder = this.getCellBorderType(0, -1);
        if (cellBorder == null || !(cellBorder instanceof StandardCellBorder)) {
            return 8;
        }
        return ((StandardCellBorder)cellBorder).getBorderType();
    }

    public SBLayoutWrapper getSBLayout() {
        SBLayoutWrapper sBLayoutWrapper = new SBLayoutWrapper(this.vertsb_offset, this.horizsb_offset);
        return sBLayoutWrapper;
    }

    public JCVector getSpanList() {
        return this.span.span_list;
    }

    public Vector getSpanningCells() {
        return this.getSpans();
    }

    public TableModel getSwingDataModel() {
        TableData tableData = this.getDataSource();
        return tableData instanceof TableSwingDataSource ? ((TableSwingDataSource)tableData).getTableModel() : null;
    }

    public TextPositioningWrapper getTextPositioning() {
        TextPositioningWrapper textPositioningWrapper = new TextPositioningWrapper(this.fromSeries(0));
        return textPositioningWrapper;
    }

    protected void makeDataSource() {
        EditableVectorDataSource editableVectorDataSource = new EditableVectorDataSource();
        editableVectorDataSource.setNumRows(this.rows);
        editableVectorDataSource.setNumColumns(this.columns);
        this.setVisibleRows(this.rows);
        this.setVisibleColumns(this.columns);
        int n = 0;
        while (n < editableVectorDataSource.getNumColumns()) {
            editableVectorDataSource.setColumnLabel(n, "Column: " + n);
            ++n;
        }
        int n2 = 0;
        while (n2 < editableVectorDataSource.getNumRows()) {
            editableVectorDataSource.setRowLabel(n2, "Row: " + n2);
            int n3 = 0;
            while (n3 < editableVectorDataSource.getNumColumns()) {
                editableVectorDataSource.setCell(n2, n3, "Cell: R" + n2 + "C" + n3);
                ++n3;
            }
            ++n2;
        }
        this.setDataSource(editableVectorDataSource);
        LiveTable.setNumEditorRows(this.rows);
        LiveTable.setNumEditorColumns(this.columns);
    }

    private boolean matches(int n, int n2) {
        if (this.getDataSource() == null) {
            return false;
        }
        Object object = this.getDataSource().getTableDataItem(n, n2);
        if (object == null) {
            return false;
        }
        if (object.toString().toUpperCase().indexOf(this.search_string) != -1) {
            this.find_cell.row = n;
            this.find_cell.column = n2;
            return true;
        }
        return false;
    }

    public void printEnd(JCPrintEvent jCPrintEvent) {
    }

    public void printPageBody(JCPrintEvent jCPrintEvent) {
    }

    public void printPageFooter(JCPrintEvent jCPrintEvent) {
        Graphics graphics = jCPrintEvent.getGraphics();
        Rectangle rectangle = graphics.getClipRect();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(this.replacePage(this.printFooter, jCPrintEvent.getPage()), 0, rectangle.height / 2);
    }

    public void printPageHeader(JCPrintEvent jCPrintEvent) {
        Graphics graphics = jCPrintEvent.getGraphics();
        Rectangle rectangle = graphics.getClipRect();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(this.replacePage(this.printHeader, jCPrintEvent.getPage()), 0, rectangle.height / 2);
    }

    String replacePage(String string, int n) {
        String string2 = new String(string);
        int n2;
        while ((n2 = string2.indexOf("^P")) != -1) {
            string2 = String.valueOf(string.substring(0, n2)) + String.valueOf(n);
            if (string.length() <= n2 + 2) continue;
            string2 = String.valueOf(string2) + string.substring(n2 + 2);
        }
        return string2;
    }

    private boolean resourceToString(int n, JCVector jCVector, JCVector jCVector2) {
        if (jCVector == null || jCVector2 == null) {
            return false;
        }
        try {
            Series series = null;
            switch (n) {
                case 0: {
                    series = this.alignment_series;
                    break;
                }
                case 1: {
                    series = this.bg_series;
                    break;
                }
                case 2: {
                    series = this.bordersides_series;
                    break;
                }
                case 3: {
                    series = this.bordertype_series;
                    break;
                }
                case 4: {
                    series = this.charheight_series;
                    break;
                }
                case 5: {
                    series = this.charwidth_series;
                    break;
                }
                case 6: {
                    series = this.component_series;
                    break;
                }
                case 8: {
                    series = this.editable_series;
                    break;
                }
                case 9: {
                    series = this.font_series;
                    break;
                }
                case 10: {
                    series = this.fg_series;
                    break;
                }
                case 11: {
                    series = this.maxlength_series;
                    break;
                }
                case 12: {
                    series = this.multiline_series;
                    break;
                }
                case 13: {
                    series = this.pixelheight_series;
                    break;
                }
                case 14: {
                    series = this.pixelwidth_series;
                    break;
                }
                case 15: {
                    series = this.stringcase_series;
                    break;
                }
                case 16: {
                    series = this.traversable_series;
                    break;
                }
                case 17: {
                    series = this.userdata_series;
                    break;
                }
            }
            if (series == null) {
                return false;
            }
            int n2 = 0;
            while (n2 < series.size()) {
                SeriesValue seriesValue = (SeriesValue)series.elementAt(n2);
                boolean bl = true;
                if (seriesValue.row >= 0 && seriesValue.column >= 0) {
                    int n3 = 0;
                    while (n3 < jCVector.size() && bl) {
                        JCCellRange jCCellRange = (JCCellRange)jCVector.elementAt(n3);
                        if (jCVector2.elementAt(n3) == seriesValue.value) {
                            if (jCCellRange.inside(seriesValue.row, seriesValue.column)) {
                                bl = false;
                            } else if (jCCellRange.start_column == jCCellRange.end_column && seriesValue.column == jCCellRange.start_column) {
                                bl = false;
                                if (seriesValue.row == jCCellRange.start_row - 1) {
                                    --jCCellRange.start_row;
                                } else if (seriesValue.row == jCCellRange.end_row + 1) {
                                    ++jCCellRange.end_row;
                                } else {
                                    bl = true;
                                }
                            } else if (jCCellRange.start_row == jCCellRange.end_row && seriesValue.row == jCCellRange.start_row) {
                                bl = false;
                                if (seriesValue.column == jCCellRange.start_column - 1) {
                                    --jCCellRange.start_column;
                                } else if (seriesValue.column == jCCellRange.end_column + 1) {
                                    ++jCCellRange.end_column;
                                } else {
                                    bl = true;
                                }
                            }
                        }
                        ++n3;
                    }
                }
                if (bl) {
                    jCVector.addElement(new JCCellRange(seriesValue.row, seriesValue.column, seriesValue.row, seriesValue.column));
                    jCVector2.addElement(seriesValue.value);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void setAbout(String string) {
    }

    public void setAppearance(AppWrapper appWrapper) {
        if (appWrapper == null) {
            return;
        }
        if (!(appWrapper instanceof AppWrapper)) {
            throw new IllegalArgumentException("Object is not an instance of AppWrapper.");
        }
        try {
            Series series = JCTblConverter.toSeries(null, this, 7, appWrapper.background);
            Series series2 = JCTblConverter.toSeries(null, this, 7, appWrapper.foreground);
            Series series3 = JCTblConverter.toSeries(null, this, 10, appWrapper.font);
            this.setAppearanceSeries(series, series2, series3);
        }
        catch (Exception exception) {}
    }

    private void setAppearanceSeries(Series series, Series series2, Series series3) {
        this.series_list.removeElement(this.bg_series);
        this.series_list.removeElement(this.fg_series);
        this.series_list.removeElement(this.font_series);
        this.bg_series = series;
        this.fg_series = series2;
        this.font_series = series3;
        this.updateTableSize();
        this.setProperty(786624);
    }

    public void setCellBorderType(int n) {
        this.setCellBorderType(-997, -997, new StandardCellBorder(n));
    }

    public void setCellSize(CellSizeWrapper cellSizeWrapper) {
        if (cellSizeWrapper == null) {
            return;
        }
        if (!(cellSizeWrapper instanceof CellSizeWrapper)) {
            throw new IllegalArgumentException("Object is not an instance of CellSizeWrapper.");
        }
        try {
            Series series = JCTblConverter.toSeries(null, this, 13, cellSizeWrapper.width);
            Series series2 = JCTblConverter.toSeries(null, this, 12, cellSizeWrapper.height);
            this.setCellSizeSeries(series, series2);
        }
        catch (Exception exception) {}
    }

    private void setCellSizeSeries(Series series, Series series2) {
        this.series_list.removeElement(this.pixelwidth_series);
        this.series_list.removeElement(this.pixelheight_series);
        this.pixelwidth_series = series;
        this.pixelheight_series = series2;
        this.updateTableSize();
    }

    public void setColumnLabelBorderType(int n) {
        this.setCellBorderType(-1, -997, new StandardCellBorder(n));
    }

    public void setColumnLabelSort(boolean bl) {
        this.column_label_sort = bl;
        if (bl) {
            this.setColumnTrigger(new LabelTrigger(0, 1));
        } else {
            if (this.column_triggers == null) {
                return;
            }
            this.removeColumnTrigger(0);
        }
    }

    public void setData(DataWrapper dataWrapper) {
        VectorDataSource vectorDataSource = dataWrapper.table ? new EditableVectorDataSource(dataWrapper.rows, dataWrapper.columns, dataWrapper.rowLabels, dataWrapper.columnLabels, dataWrapper.data) : new BeanFileDataSource(dataWrapper.data);
        this.setDataSource(vectorDataSource);
    }

    public void setDisplayClipArrows(boolean bl) {
        if (bl) {
            this.setClipArrows(4);
        } else {
            this.setClipArrows(0);
        }
    }

    public void setEditState(EditStateWrapper editStateWrapper) {
        if (editStateWrapper == null) {
            return;
        }
        if (!(editStateWrapper instanceof EditStateWrapper)) {
            throw new IllegalArgumentException("Object is not an instance of EditStateWrapper.");
        }
        try {
            Series series = JCTblConverter.toSeries(null, this, 2, editStateWrapper.traversable);
            Series series2 = JCTblConverter.toSeries(null, this, 2, editStateWrapper.editable);
            this.setEditStateSeries(series, series2);
        }
        catch (Exception exception) {}
    }

    private void setEditStateSeries(Series series, Series series2) {
        this.series_list.removeElement(this.traversable_series);
        this.series_list.removeElement(this.editable_series);
        this.traversable_series = series;
        this.editable_series = series2;
        this.updateTheTable();
    }

    private void setFrozenCellLayout(int n, int n2) {
        this.frozen_row_placement = n;
        this.frozen_column_placement = n2;
        this.updateTheTable();
    }

    public void setFrozenCellLayout(FrozenCellLayoutWrapper frozenCellLayoutWrapper) {
        if (frozenCellLayoutWrapper == null) {
            return;
        }
        if (!(frozenCellLayoutWrapper instanceof FrozenCellLayoutWrapper)) {
            throw new IllegalArgumentException("Object is not an instance of FrozenCellLayoutWrapper.");
        }
        this.setFrozenCellLayout(frozenCellLayoutWrapper.rowPlacement, frozenCellLayoutWrapper.colPlacement);
    }

    private void setLabelLayout(int n, int n2, int n3, int n4) {
        this.row_label_offset = n;
        this.row_label_placement = n2;
        this.column_label_offset = n3;
        this.column_label_placement = n4;
        this.updateTheTable();
    }

    public void setLabelLayout(LabelLayoutWrapper labelLayoutWrapper) {
        if (labelLayoutWrapper == null) {
            return;
        }
        if (!(labelLayoutWrapper instanceof LabelLayoutWrapper)) {
            throw new IllegalArgumentException("Object is not an instance of LabelLayoutWrapper.");
        }
        this.setLabelLayout(labelLayoutWrapper.rowOffset, labelLayoutWrapper.rowPlacement, labelLayoutWrapper.colOffset, labelLayoutWrapper.colPlacement);
    }

    public static void setNumEditorColumns(int n) {
        numColumns = n;
    }

    public static void setNumEditorRows(int n) {
        numRows = n;
    }

    public void setPrintSettings(PrintWrapper printWrapper) {
        if (printWrapper == null) {
            return;
        }
        if (!(printWrapper instanceof PrintWrapper)) {
            throw new IllegalArgumentException("Object is not an instance of PrintWrapper.");
        }
        this.printHeader = printWrapper.printHeader;
        this.printFooter = printWrapper.printFooter;
        this.showPrintMenu = printWrapper.showPrintMenu;
        this.showPrintPreview = printWrapper.showPrintPreview;
        if (this.popupMenu != null) {
            BasePopupMenu.enableMenuItem(this.popupMenu, TablePopupMenu.commands[3], this.showPrintMenu);
            BasePopupMenu.enableMenuItem(this.popupMenu, TablePopupMenu.commands[4], this.showPrintPreview);
        }
    }

    public void setRowLabelBorderType(int n) {
        this.setCellBorderType(-997, -1, new StandardCellBorder(n));
    }

    private void setSBLayout(int n, int n2) {
        this.vertsb_offset = n;
        this.horizsb_offset = n2;
        this.updateTheTable();
    }

    public void setSBLayout(SBLayoutWrapper sBLayoutWrapper) {
        if (sBLayoutWrapper == null) {
            return;
        }
        if (!(sBLayoutWrapper instanceof SBLayoutWrapper)) {
            throw new IllegalArgumentException("Object is not an instance of SBLayoutWrapper.");
        }
        this.setSBLayout(sBLayoutWrapper.vertOffset, sBLayoutWrapper.horizOffset);
    }

    public void setSpanningCells(String string) {
        this.setSpanningCells(JCTblConverter.toRangeList(string));
    }

    public void setSpanningCells(Vector vector) {
        this.setSpans(vector);
        this.updateTheTable();
    }

    public void setSwingDataModel(TableModel tableModel) {
        TableSwingDataSource tableSwingDataSource = new TableSwingDataSource(tableModel);
        if (tableSwingDataSource.isEnabled()) {
            this.setDataSource(tableSwingDataSource);
        }
    }

    public void setTextPositioning(TextPositioningWrapper textPositioningWrapper) {
        if (textPositioningWrapper == null) {
            return;
        }
        if (!(textPositioningWrapper instanceof TextPositioningWrapper)) {
            throw new IllegalArgumentException("Object is not an instance of TextPositioningWrapper.");
        }
        try {
            Series series = JCTblConverter.toSeries(null, this, 1, textPositioningWrapper.alignment);
            this.setTextPositioningSeries(series);
        }
        catch (Exception exception) {}
    }

    private void setTextPositioningSeries(Series series) {
        this.series_list.removeElement(this.alignment_series);
        this.alignment_series = series;
        this.updateTheTable();
    }

    private Series toStringSeries(int n, String string) {
        return JCTblConverter.toSeries(null, this, n, string);
    }

    protected void updateTableSize() {
        Size.getColumnWidths(this, -998, 0, -998, 0, null);
        Size.getRowHeights(this, -998, 0, -998, 0, null);
        this.updateTheTable();
    }

    protected void updateTheTable() {
        this.setProperty(786560);
    }
}

