/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import jclass.table3.CellImage;
import jclass.table3.Clip;
import jclass.table3.JCCell;
import jclass.table3.JCCellPosition;
import jclass.table3.JDKSupport;
import jclass.table3.StandardCellBorder;
import jclass.table3.Table;
import jclass.table3.TableCellInfo;
import jclass.table3.Widget;
import jclass.util.JCEnvironment;

class Draw {
    static final int ARROW_RIGHT = 0;
    static final int ARROW_DOWN = 1;
    static final int ARROW_SIZE = 4;
    static final int MAX_CELL_IMAGES = 30;
    static CellImage[] cell_images = new CellImage[30];
    static int num_cell_images;
    static boolean JDK102;
    static Rectangle cell_size;

    static {
        JDK102 = JCEnvironment.getJavaVersion() == 102;
        cell_size = new Rectangle();
    }

    Draw() {
    }

    private static void arrow(Graphics graphics, int n, int n2, int n3, int n4) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = n2 - n4;
        nArray2[0] = n3 - n4;
        switch (n) {
            case 0: {
                nArray[1] = nArray[0];
                nArray2[1] = nArray2[0] + n4;
                nArray[2] = n2;
                nArray2[2] = n3 - n4 / 2;
                break;
            }
            case 1: {
                nArray[1] = nArray[0] + n4;
                nArray2[1] = nArray2[0];
                nArray[2] = n2 - n4 / 2;
                nArray2[2] = n3;
                break;
            }
            default: {
                return;
            }
        }
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    static synchronized void background(TableCellInfo tableCellInfo, int n, int n2, int n3, int n4) {
        if (tableCellInfo.clip.gc == null) {
            return;
        }
        tableCellInfo.gc = tableCellInfo.clip.gc;
        if (!(tableCellInfo.cellBorder instanceof StandardCellBorder)) {
            Draw.do_background(tableCellInfo.gc, tableCellInfo, n, n2, n3, n4);
            return;
        }
        if (!tableCellInfo.table.double_buffer && n3 * n4 <= 100000 || !tableCellInfo.table.useCellDoubleBuffer) {
            Draw.do_background(tableCellInfo.gc, tableCellInfo, n, n2, n3, n4);
            return;
        }
        StandardCellBorder standardCellBorder = (StandardCellBorder)tableCellInfo.cellBorder;
        int n5 = standardCellBorder.getBorderType();
        Image image = null;
        int n6 = 0;
        while (n6 < num_cell_images) {
            if (cell_images[n6] != null && Draw.cell_images[n6].image != null && Draw.cell_images[n6].image.getWidth(null) == n3 && Draw.cell_images[n6].image.getHeight(null) == n4 && Draw.cell_images[n6].sides == tableCellInfo.cellBorderSides && Draw.cell_images[n6].border == n5 && Draw.cell_images[n6].shadow_thickness == tableCellInfo.cellBorderWidth && Draw.cell_images[n6].bg.equals(tableCellInfo.background)) break;
            ++n6;
        }
        if (n6 == num_cell_images) {
            if (num_cell_images == 30) {
                int n7 = 0;
                int n8 = 0;
                if (JDK102 && cell_images[--n6] != null && Draw.cell_images[n6].image != null && (n7 = Draw.cell_images[n6].image.getWidth(null)) >= n3 && (n8 = Draw.cell_images[n6].image.getHeight(null)) >= n4) {
                    image = Draw.cell_images[n6].image;
                    if (n7 > n3 || n8 > n4) {
                        Draw.cell_images[n6].gc.setColor(tableCellInfo.background);
                        Draw.cell_images[n6].gc.fillRect(0, 0, n7, n8);
                    }
                }
            }
            if (image == null) {
                try {
                    image = tableCellInfo.clip.createImage(n3, n4);
                }
                catch (Exception exception) {
                    image = null;
                }
                if (image == null) {
                    Draw.do_background(tableCellInfo.gc, tableCellInfo, n, n2, n3, n4);
                    return;
                }
                if (num_cell_images < 30) {
                    Draw.cell_images[Draw.num_cell_images] = new CellImage();
                    ++num_cell_images;
                }
                if (cell_images[n6] == null) {
                    Draw.cell_images[n6] = new CellImage();
                }
                Draw.cell_images[n6].image = image;
                Draw.cell_images[n6].gc = image.getGraphics();
            }
            Draw.cell_images[n6].bg = tableCellInfo.background;
            Draw.cell_images[n6].border = n5;
            Draw.cell_images[n6].sides = tableCellInfo.cellBorderSides;
            Draw.cell_images[n6].shadow_thickness = tableCellInfo.cellBorderWidth;
            Draw.cell_images[n6].count = 0;
            Draw.do_background(Draw.cell_images[n6].gc, tableCellInfo, 0, 0, n3, n4);
        } else {
            image = Draw.cell_images[n6].image;
        }
        tableCellInfo.gc.drawImage(image, n, n2, null);
        ++Draw.cell_images[n6].count;
        if (n6 > 0 && Draw.cell_images[n6 - 1].count < Draw.cell_images[n6].count) {
            CellImage cellImage = cell_images[n6 - 1];
            Draw.cell_images[n6 - 1] = cell_images[n6];
            Draw.cell_images[n6] = cellImage;
        }
    }

    static void cell(Table table, int n, int n2) {
        Serializable serializable;
        if (table.rowHeight(n) == 0 || table.columnWidth(n2) == 0) {
            return;
        }
        boolean bl = false;
        Clip clip = Clip.find(table, n, n2);
        if (clip == null) {
            return;
        }
        if (table.span.span_list.size() > 0 && table.span.find(n, n2, (JCCellPosition)(serializable = new JCCellPosition())) != -999 && (n != serializable.row || n2 != serializable.column)) {
            if (table.draw_range.start_row == -999 || !table.draw_range.inside(serializable.row, serializable.column)) {
                Draw.cell(table, serializable.row, serializable.column);
            }
            return;
        }
        if (table.component_series.size() > 0) {
            bl = Widget.draw(table, n, n2);
        }
        serializable = new TableCellInfo(table, clip, n, n2);
        int n3 = table.textWidthOffset();
        int n4 = table.textHeightOffset();
        Point point = new Point(0, 0);
        table.getPosition(n, n2, point);
        int n5 = point.x;
        int n6 = point.y;
        int n7 = ((TableCellInfo)serializable).cellWidth;
        int n8 = ((TableCellInfo)serializable).cellHeight;
        Rectangle rectangle = new Rectangle();
        JDKSupport.setBounds(rectangle, n5 + n3, n6 + n4, Math.max(0, n7 - 2 * n3), Math.max(0, n8 - 2 * n4));
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.width;
        if (table.getMarginWidth() == Integer.MAX_VALUE) {
            n11 = 0;
        }
        int n12 = rectangle.height;
        if (table.getMarginHeight() == Integer.MAX_VALUE) {
            n12 = 0;
        }
        ((TableCellInfo)serializable).isSpanned = false;
        Rectangle rectangle2 = rectangle;
        if (!table.is_printing) {
            Draw.intersect(clip.expose, rectangle2, rectangle2);
        }
        Draw.background((TableCellInfo)serializable, n5, n6, n7, n8);
        if (table.edit_row == n && table.edit_column == n2 && !bl && table.getEditingComponent() == null) {
            Draw.drawRect(table, ((TableCellInfo)serializable).gc, n, n2, table.getFocusRectColor());
        }
        if (bl) {
            return;
        }
        int n13 = ((TableCellInfo)serializable).str_height;
        int n14 = ((TableCellInfo)serializable).str_width;
        boolean bl2 = n14 > n11;
        boolean bl3 = n13 > n12;
        int n15 = 0;
        int n16 = 0;
        if (bl2 || bl3) {
            n15 = n5 + n7 - ((TableCellInfo)serializable).cellBorderWidth;
            n16 = n6 + n8 - ((TableCellInfo)serializable).cellBorderWidth;
        }
        Draw.foreground(table, (TableCellInfo)serializable, n9, n10, n14, n13, bl2, bl3, n15, n16, rectangle2);
        serializable = null;
    }

    static synchronized void clearCellImages() {
        if (cell_images != null) {
            int n = 0;
            while (n < cell_images.length) {
                if (cell_images[n] != null) {
                    Draw.cell_images[n].image = null;
                    Draw.cell_images[n] = null;
                }
                ++n;
            }
        }
        num_cell_images = 0;
    }

    static void do_background(Graphics graphics, TableCellInfo tableCellInfo, int n, int n2, int n3, int n4) {
        Color color;
        graphics.setColor(tableCellInfo.background);
        graphics.fillRect(n, n2, n3, n4);
        if (tableCellInfo.cellWidth == 0 || tableCellInfo.cellHeight == 0 || tableCellInfo.cellBorderSides == 0 || tableCellInfo.cellBorderWidth == 0) {
            return;
        }
        if (tableCellInfo.table.cellBorderColor != null) {
            color = tableCellInfo.table.cellBorderColor;
            if (tableCellInfo.cellBorder instanceof StandardCellBorder && ((StandardCellBorder)tableCellInfo.cellBorder).getBorderType() == 5) {
                tableCellInfo.bottomShadow = tableCellInfo.table.cellBorderDarker;
            }
        } else {
            color = tableCellInfo.table.getBackground();
        }
        tableCellInfo.cellBorder.drawBackground(graphics, tableCellInfo.cellBorderWidth, tableCellInfo.cellBorderSides, n, n2, n3, n4, tableCellInfo.topShadow, tableCellInfo.bottomShadow, color);
    }

    static final void drawBottomLines(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
        graphics.setColor(color);
        int n6 = 1;
        while (n6 <= n) {
            graphics.drawLine(n2 + n6 - 1, n3 + n5 - n6, n2 + n4 - n6, n3 + n5 - n6);
            graphics.drawLine(n2 + n4 - n6, n3 + n6 - 1, n2 + n4 - n6, n3 + n5 - n6);
            ++n6;
        }
    }

    static void drawRect(Table table, Graphics graphics, int n, int n2, Color color) {
        if (table.component_series.size() > 0 && Widget.getComponent(table, n, n2, true) != null) {
            return;
        }
        JCCell.getBounds(table, null, n, n2, cell_size);
        int n3 = table.shadow_thickness;
        boolean bl = false;
        Clip clip = Clip.find(table, n, n2);
        if (clip == null) {
            return;
        }
        if (graphics == null) {
            graphics = clip.getGraphics();
            if (graphics == null) {
                return;
            }
            bl = true;
        }
        graphics.setColor(color);
        graphics.drawRect(Draw.cell_size.x + n3, Draw.cell_size.y + n3, Draw.cell_size.width - 1 - 2 * n3, Draw.cell_size.height - 1 - 2 * n3);
        graphics.drawRect(Draw.cell_size.x + 1 + n3, Draw.cell_size.y + 1 + n3, Draw.cell_size.width - 3 - 2 * n3, Draw.cell_size.height - 3 - 2 * n3);
        if (bl) {
            graphics.dispose();
        }
        if (table.double_buffer && clip.dbl_image != null) {
            graphics = clip.dbl_image.getGraphics();
            graphics.setColor(color);
            graphics.drawRect(Draw.cell_size.x + n3, Draw.cell_size.y + n3, Draw.cell_size.width - 1 - 2 * n3, Draw.cell_size.height - 1 - 2 * n3);
            graphics.drawRect(Draw.cell_size.x + 1 + n3, Draw.cell_size.y + 1 + n3, Draw.cell_size.width - 3 - 2 * n3, Draw.cell_size.height - 3 - 2 * n3);
            graphics.dispose();
        }
    }

    static void drawShadow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2) {
        if (n == 3) {
            Draw.drawTopLines(graphics, n2, n3, n4, n5, n6, color2);
            Draw.drawBottomLines(graphics, n2, n3, n4, n5, n6, color);
        } else {
            Draw.drawTopLines(graphics, n2, n3, n4, n5, n6, color);
            Draw.drawBottomLines(graphics, n2, n3, n4, n5, n6, color2);
        }
    }

    static final void drawTopLines(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
        graphics.setColor(color);
        int n6 = 0;
        while (n6 < n) {
            graphics.drawLine(n2 + n6, n3 + n6, n2 + n4 - (n6 + 1), n3 + n6);
            graphics.drawLine(n2 + n6, n3 + n6 + 1, n2 + n6, n3 + n5 - (n6 + 1));
            ++n6;
        }
    }

    static void foreground(Table table, TableCellInfo tableCellInfo, int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, int n6, Rectangle rectangle) {
        Graphics graphics;
        if (tableCellInfo.clip.gc == null) {
            return;
        }
        boolean bl3 = false;
        if (bl || bl2) {
            bl3 = true;
            graphics = Draw.getGraphics(tableCellInfo.clip, rectangle);
        } else {
            graphics = tableCellInfo.clip.gc;
        }
        tableCellInfo.draw(graphics, n, n2);
        if (bl || bl2) {
            if (bl3) {
                graphics.dispose();
            }
            bl3 = false;
            graphics = tableCellInfo.clip.gc;
            graphics.setColor(tableCellInfo.getForeground());
        }
        if (bl3) {
            graphics.dispose();
        }
    }

    static Graphics getGraphics(Clip clip, Rectangle rectangle) {
        Graphics graphics = clip.gc.create();
        if (!clip.table.is_printing) {
            Rectangle rectangle2 = clip.getVisibleRect();
            graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return graphics;
    }

    static void intersect(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n = Math.max(rectangle.x, rectangle2.x);
        int n2 = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
        int n3 = Math.max(rectangle.y, rectangle2.y);
        int n4 = Math.min(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height);
        JDKSupport.setBounds(rectangle3, n, n3, n2 - n, n4 - n3);
    }
}

