/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import jclass.table3.Border;
import jclass.table3.DragDraw;
import jclass.table3.Draw;
import jclass.table3.JCCell;
import jclass.table3.JCCellRange;
import jclass.table3.JCPaintEvent;
import jclass.table3.JCPrintTable;
import jclass.table3.JDKSupport;
import jclass.table3.Table;
import jclass.table3.Widget;

class Clip
extends JComponent {
    int orientation;
    JCCellRange range = new JCCellRange();
    Table table;
    int type;
    int horiz_origin;
    int vert_origin;
    int total_width;
    int total_height;
    int width;
    int height;
    Rectangle expose = new Rectangle();
    transient Graphics gc;
    boolean dragging = false;
    int drag_row = -999;
    int drag_column = -999;
    int over_row = -999;
    int over_column = -999;
    boolean changed;
    transient Image dbl_image;
    Color background_color;
    boolean suspend_paint = false;
    static final int NONE = 0;
    static final int HORIZONTAL = 1;
    static final int VERTICAL = 2;
    static final int CELL = 0;
    static final int FIXEDCELL = 1;
    static final int FROZENCOLUMN = 2;
    static final int FROZENROW = 3;
    static final int ROWLABEL = 4;
    static final int COLUMNLABEL = 5;
    static final int FROZENROWLABEL = 6;
    static final int FROZENCOLUMNLABEL = 7;
    static final int PRINTPAGE = 8;
    static final int NUM_TYPE = 9;
    private Rectangle rect = new Rectangle(0, 0);
    JCPrintTable printtable;
    protected static boolean inRequestFocus = false;

    Clip(Table table, int n) {
        this.type = n;
        this.table = table;
        Clip[] clipArray = this.table.clip_list;
        this.table.clip_list = new Clip[clipArray.length + 1];
        System.arraycopy(clipArray, 0, this.table.clip_list, 0, clipArray.length);
        this.table.clip_list[clipArray.length] = this;
        this.setLayout(null);
        switch (n) {
            case 0: {
                this.orientation = 3;
                break;
            }
            case 2: {
                this.orientation = 2;
                break;
            }
            case 3: {
                this.orientation = 1;
                break;
            }
            case 1: {
                this.orientation = 0;
                break;
            }
            case 4: {
                this.orientation = 2;
                break;
            }
            case 5: {
                this.orientation = 1;
                break;
            }
            case 6: {
                this.orientation = 0;
                break;
            }
            case 7: {
                this.orientation = 0;
                break;
            }
        }
        if (n != 0) {
            if (this.isHorizontal()) {
                this.horiz_origin = this.table.clip.horiz_origin;
            }
            if (this.isVertical()) {
                this.vert_origin = this.table.clip.vert_origin;
            }
        }
        this.table.add(this);
    }

    static Clip Create(Table table, int n) {
        Clip clip = Clip.find_by_type(table, n);
        if (clip != null) {
            return clip;
        }
        switch (n) {
            case 2: {
                if (table.columns != 0 && table.frozen_columns > 0) break;
                return null;
            }
            case 3: {
                if (table.rows != 0 && table.frozen_rows > 0) break;
                return null;
            }
        }
        return Clip.clip_create(table, n);
    }

    public boolean IN_COLUMNRANGE(int n) {
        return this.range.start_row != -999 && n >= this.range.start_column && n <= this.range.end_column;
    }

    public boolean IN_ROWRANGE(int n) {
        return this.range.start_row != -999 && n >= this.range.start_row && n <= this.range.end_row;
    }

    void beginDrag(int n, int n2, int n3, int n4) {
        if (!this.dragging || this.drag_row != n || this.drag_column != n2 || this.over_row != n3 || this.over_column != n4) {
            this.dragging = true;
            this.drag_row = n;
            this.drag_column = n2;
            this.over_row = n3;
            this.over_column = n4;
            this.repaint();
        }
    }

    static Clip clip_create(Table table, int n) {
        Clip clip = Clip.find_by_type(table, n);
        if (clip != null) {
            return clip;
        }
        return new Clip(table, n);
    }

    void copyArea(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (graphics == null) {
            return;
        }
        if (!this.table.double_buffer || this.dbl_image == null) {
            graphics.copyArea(n, n2, n3, n4, n5, n6);
            return;
        }
        Graphics graphics2 = graphics;
        graphics = this.dbl_image.getGraphics();
        graphics.clipRect(0, 0, this.size().width, this.size().height);
        graphics.copyArea(n, n2, n3, n4, n5, n6);
        graphics.clipRect(n + n5, n2 + n6, n3, n4);
        graphics2.drawImage(this.dbl_image, 0, 0, null);
        graphics.dispose();
    }

    void dispose() {
        this.dbl_image = null;
        this.removeAll();
        this.table = null;
    }

    private static void drawFrame(Graphics graphics, Table table, Rectangle rectangle, boolean bl) {
        Color color = table.getBackground();
        Border.draw(graphics, table.frame_bordertype, table.frame_shadow, 15, rectangle.x - table.frame_shadow, rectangle.y - table.frame_shadow, rectangle.width + 2 * table.frame_shadow, rectangle.height + 2 * table.frame_shadow, bl ? color : color.brighter(), bl ? color : color.darker(), color);
    }

    static void drawFrames(Graphics graphics, Table table, boolean bl) {
        Clip.drawFrame(graphics, table, table.cell_rect, bl);
        if (table.rowLabelWidth() > 0) {
            Clip.drawFrame(graphics, table, table.rowlabel_rect, bl);
        }
        if (table.columnLabelHeight() > 0) {
            Clip.drawFrame(graphics, table, table.collabel_rect, bl);
        }
    }

    void endDrag() {
        this.dragging = false;
        this.drag_row = -999;
        this.drag_column = -999;
        this.over_row = -999;
        this.over_column = -999;
    }

    public static Clip find(Table table, int n, int n2) {
        if (table == null) {
            return null;
        }
        if (table.getPrinting()) {
            return Clip.find_by_type(table, 8);
        }
        int n3 = 0;
        while (n3 < table.clip_list.length) {
            Clip clip = table.clip_list[n3];
            JCCellRange jCCellRange = clip.range;
            if (jCCellRange.start_row != -999 && (jCCellRange.start_row < jCCellRange.end_row ? jCCellRange.start_row : jCCellRange.end_row) <= n && (jCCellRange.start_row > jCCellRange.end_row ? jCCellRange.start_row : jCCellRange.end_row) >= n && (jCCellRange.start_column < jCCellRange.end_column ? jCCellRange.start_column : jCCellRange.end_column) <= n2 && (jCCellRange.start_column > jCCellRange.end_column ? jCCellRange.start_column : jCCellRange.end_column) >= n2) {
                return clip;
            }
            ++n3;
        }
        return null;
    }

    public static Clip find_by_type(Table table, int n) {
        if (table == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < table.clip_list.length) {
            Clip clip = table.clip_list[n2];
            if (clip.type == n) {
                return clip;
            }
            ++n2;
        }
        return null;
    }

    public Object getAWTLock() {
        return this.getTreeLock();
    }

    public Graphics getGraphics() {
        Graphics graphics = super.getGraphics();
        Rectangle rectangle = this.getVisibleRect();
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return graphics;
    }

    JCPrintTable getPrintTable() {
        if (this.type == 8) {
            return this.printtable;
        }
        return null;
    }

    static JCCellRange get_range(Table table, int n) {
        switch (n) {
            case 0: {
                return new JCCellRange(table.rows > 0 ? table.frozen_rows : -999, table.columns > 0 ? table.frozen_columns : -999, table.rows > 0 ? table.rows - 1 : -999, table.columns > 0 ? table.columns - 1 : -999);
            }
            case 1: {
                if (table.frozen_rows == 0 || table.frozen_columns == 0) {
                    return null;
                }
                return new JCCellRange(0, 0, table.frozen_rows - 1, table.frozen_columns - 1);
            }
            case 2: {
                if (table.rows == 0 || table.columns == 0 || table.frozen_columns == 0) {
                    return null;
                }
                return new JCCellRange(table.frozen_rows, 0, table.rows - 1, table.frozen_columns - 1);
            }
            case 3: {
                if (table.rows == 0 || table.columns == 0 || table.frozen_rows == 0) {
                    return null;
                }
                return new JCCellRange(0, table.frozen_columns, table.frozen_rows - 1, table.columns - 1);
            }
            case 6: {
                if (table.frozen_rows == 0 || table.rowLabelWidth() == 0) {
                    return null;
                }
                return new JCCellRange(0, -1, table.frozen_rows - 1, -1);
            }
            case 4: {
                if (table.rowLabelWidth() == 0) {
                    return null;
                }
                return new JCCellRange(table.frozen_rows, -1, table.rows - 1, -1);
            }
            case 7: {
                if (table.frozen_columns == 0 || table.columnLabelHeight() == 0) {
                    return null;
                }
                return new JCCellRange(-1, 0, -1, table.frozen_columns - 1);
            }
            case 5: {
                if (table.columnLabelHeight() == 0) {
                    return null;
                }
                return new JCCellRange(-1, table.frozen_columns, -1, table.columns - 1);
            }
        }
        return null;
    }

    static JCCellRange[] get_rangeList(Table table) {
        JCCellRange[] jCCellRangeArray = new JCCellRange[9];
        int n = 0;
        while (n < 9) {
            JCCellRange jCCellRange = Clip.get_range(table, n);
            jCCellRangeArray[n] = jCCellRange != null ? jCCellRange : new JCCellRange();
            ++n;
        }
        return jCCellRangeArray;
    }

    public boolean hasOrientation(int n) {
        return (this.orientation & n) != 0;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isHorizontal() {
        return (this.orientation & 1) != 0;
    }

    public boolean isVertical() {
        return (this.orientation & 2) != 0;
    }

    void paint(int n, int n2) {
        JCCell.getBounds(this.table, null, n, n2, this.rect);
        this.paintImmediately(this.rect);
    }

    void paint(int n, int n2, int n3, int n4) {
        Point point = new Point(0, 0);
        Object object = this.getAWTLock();
        synchronized (object) {
            if (n < this.range.start_row) {
                n = this.range.start_row;
            }
            if (n2 < this.range.start_column) {
                n2 = this.range.start_column;
            }
            if (n3 > this.range.end_row) {
                n3 = this.range.end_row;
            }
            if (n4 > this.range.end_column) {
                n4 = this.range.end_column;
            }
            this.table.getPosition(n, n2, point);
            JCCell.getBounds(this.table, null, n3, n4, this.rect);
        }
        JDKSupport.setBounds(this.rect, point.x, point.y, this.rect.x + this.rect.width - point.x, this.rect.y + this.rect.height - point.y);
        this.paint(null, this.rect, n, n2, n3, n4);
    }

    public void paint(Graphics graphics) {
        try {
            if (!this.table.repaint) {
                this.table.needs_repaint = true;
            } else {
                this.paint(graphics, graphics.getClipRect());
            }
        }
        catch (Exception exception) {}
    }

    void paint(Graphics graphics, Rectangle rectangle) {
        int n = -999;
        int n2 = -999;
        int n3 = -999;
        int n4 = -999;
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, this.size().width, this.size().height);
        }
        switch (this.type) {
            case 4: {
                n3 = -1;
                n4 = -1;
                break;
            }
            case 6: {
                n2 = this.range.start_row;
                n = this.range.end_row;
                n3 = -1;
                n4 = -1;
                break;
            }
            case 5: {
                n = -1;
                n2 = -1;
                break;
            }
            case 7: {
                n4 = this.range.start_column;
                n3 = this.range.end_column;
                n = -1;
                n2 = -1;
                break;
            }
            case 2: {
                n4 = this.range.start_column;
                n3 = this.range.end_column;
                break;
            }
            case 3: {
                n2 = this.range.start_row;
                n = this.range.end_row;
                break;
            }
            case 1: {
                n4 = this.range.start_column;
                n3 = this.range.end_column;
                n2 = this.range.start_row;
                n = this.range.end_row;
                break;
            }
        }
        int n5 = rectangle.y + this.yOffset() + this.vert_origin;
        int n6 = rectangle.x + this.xOffset() + this.horiz_origin;
        if (n2 == -999) {
            n2 = this.table.YtoRow(n5);
        }
        if (n == -999) {
            n = this.table.YtoRow(n5 + rectangle.height);
        }
        if (n4 == -999) {
            n4 = this.table.XtoColumn(n6);
        }
        if (n3 == -999) {
            n3 = this.table.XtoColumn(n6 + rectangle.width);
        }
        if (!Table.isCell(n2, n4) && !Table.isLabel(n2, n4) && this.table.dataView.getNumRows() != 0 && this.table.dataView.getNumColumns() != 0) {
            return;
        }
        this.paint(graphics, rectangle, n2, n4, n, n3);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void paint(Graphics var1_1, Rectangle var2_2, int var3_3, int var4_4, int var5_5, int var6_6) {
        var7_7 = this.size();
        if (var7_7.width <= 0) return;
        if (var7_7.height <= 0) {
            return;
        }
        var8_8 = this.getAWTLock();
        synchronized (var8_8) {
            block25: {
                block27: {
                    var10_9 = false;
                    JDKSupport.setBounds(this.expose, var2_2.x, var2_2.y, var2_2.width, var2_2.height);
                    this.table.draw_range.reshape(var3_3, var4_4, var5_5, var6_6);
                    var11_10 = null;
                    if (this.table.paintListeners != null) {
                        var11_10 = new JCPaintEvent(this.table, 1, var2_2, var3_3, var4_4, var5_5, var6_6);
                        this.table.fireJCPaintEvent(var11_10);
                    }
                    if (var1_1 == null) {
                        var1_1 = this.getGraphics();
                        if (var1_1 == null) {
                            return;
                        }
                        var10_9 = true;
                    }
                    var1_1.clipRect(var2_2.x, var2_2.y, var2_2.width, var2_2.height);
                    var12_13 = null;
                    if (!this.table.double_buffer) break block27;
                    if (this.dbl_image == null || this.dbl_image.getWidth(null) < var7_7.width || this.dbl_image.getHeight(null) < var7_7.height) {
                        try {
                            this.dbl_image = this.createImage(var7_7.width, var7_7.height);
                        }
                        catch (Throwable v0) {
                            this.dbl_image = null;
                        }
                    }
                    if (this.dbl_image == null) ** GOTO lbl-1000
                    this.gc = var12_13 = this.dbl_image.getGraphics();
                    if (var12_13 == null) lbl-1000:
                    // 2 sources

                    {
                        this.gc = var1_1;
                        break block25;
                    } else {
                        this.gc.clipRect(var2_2.x, var2_2.y, var2_2.width, var2_2.height);
                    }
                    break block25;
                }
                this.gc = var1_1;
            }
            if (this.gc == null) {
                return;
            }
            if (this.table.getMode() == 1) {
                this.gc.setColor(this.getBackground());
                this.gc.fillRect(0, 0, var7_7.width, var7_7.height);
            }
            var13_14 = var3_3;
            var14_15 = var4_4;
            var15_16 = var5_5;
            var16_17 = var6_6;
            if (this.type == 0) {
                var17_18 = this.table.getVisibleCells();
                var13_14 = Math.max(var13_14, var17_18.start_row);
                var14_15 = Math.max(var14_15, var17_18.start_column);
                var15_16 = Math.min(var15_16, var17_18.end_row);
                var16_17 = Math.min(var16_17, var17_18.end_column);
            }
            var17_19 = var13_14;
            block7: while (true) {
                if (var17_19 > var15_16) {
                    if (this.table.double_buffer) {
                        var1_1.drawImage(this.dbl_image, 0, 0, null);
                        var12_13.dispose();
                    }
                    if (var11_10 != null) {
                        var11_10 = new JCPaintEvent(this.table, 2, var2_2, var3_3, var4_4, var5_5, var6_6);
                        this.table.fireJCPaintEvent(var11_10);
                    }
                    super.paint(var1_1);
                    this.gc = null;
                    if (var10_9 == false) return;
                    var1_1.dispose();
                    return;
                }
                var18_20 = var14_15;
                while (true) {
                    if (var18_20 > var16_17) {
                        ++var17_19;
                        continue block7;
                    }
                    try {
                        if (this.dragging && (this.drag_row != this.over_row || this.drag_column != this.over_column)) {
                            DragDraw.cell(this.table, var17_19, var18_20, this.drag_row, this.drag_column, this.over_row, this.over_column);
                        } else {
                            Draw.cell(this.table, var17_19, var18_20);
                        }
                    }
                    catch (Exception var19_21) {
                        var19_21.printStackTrace(System.out);
                    }
                    ++var18_20;
                }
                break;
            }
        }
    }

    void paint(Graphics graphics, JCCellRange jCCellRange) {
        if (this.type == 8 && this.printtable != null) {
            this.gc = graphics;
            this.range = jCCellRange;
            this.printtable.paintPage(graphics, jCCellRange);
        }
    }

    void paint(JCCellRange jCCellRange) {
        this.paint(jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 9) {
            keyEvent.consume();
            this.table.keyPressed(keyEvent);
        } else if (keyEvent.getID() == 401 && (keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 18)) {
            keyEvent.consume();
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    public void repaint() {
        super.repaint();
    }

    public void requestFocus() {
        if (inRequestFocus) {
            return;
        }
        inRequestFocus = true;
        if (this.table != null && this.table.editHandler != null && this.table.editHandler.editComponent != null) {
            this.table.editHandler.editComponent.requestFocus();
        } else {
            super.requestFocus();
        }
        inRequestFocus = false;
    }

    void reset_internal_values() {
        this.range = Clip.get_range(this.table, this.type);
        if (this.range == null) {
            this.range = new JCCellRange();
        } else {
            this.background_color = this.table.getBackground(this.range.start_row, this.range.start_column);
        }
    }

    static void reshape(Table table) {
        Clip clip;
        Clip clip2 = table.clip;
        JDKSupport.setBounds(table.cell_rect, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, 0);
        JDKSupport.setBounds(table.rowlabel_rect, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, 0);
        JDKSupport.setBounds(table.collabel_rect, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, 0);
        int n = clip2.width;
        int n2 = clip2.height;
        if (table.horizsb_position == 1 && table.column_label_placement == 0 && table.frozen_row_placement == 0) {
            n2 = table.containerHeight() - table.frozenRowLabelOffset() - 2 * table.frame_shadow;
            if (table.hasHorizSB()) {
                n2 -= table.horizSBheight();
            }
        }
        if (table.vertsb_position == 1 && table.row_label_placement == 0 && table.frozen_column_placement == 0) {
            n = table.containerWidth() - table.frozenColumnLabelOffset() - 2 * table.frame_shadow;
            if (table.hasVertSB()) {
                n -= table.vertSBwidth();
            }
        }
        clip2.set_size(table.cell_rect, table.frozenColumnLabelOffset(), table.frozenRowLabelOffset(), n, n2);
        if (table.frozen_columns > 0 && table.frozen_rows > 0) {
            clip = Clip.clip_create(table, 1);
            clip.set_size(table.cell_rect, table.frozenColumnPosition(), table.frozenRowPosition(), table.frozenColumnWidth(), table.frozenRowHeight());
        } else {
            clip = Clip.find_by_type(table, 1);
            if (clip != null) {
                ((Component)clip).hide();
            }
        }
        if (table.frozen_columns > 0 && table.columns > 0) {
            clip = Clip.clip_create(table, 2);
            int n3 = table.frozen_rows > 0 ? table.frozenRowLabelOffset() : table.rowLabelOffset();
            clip.set_size(table.cell_rect, table.frozenColumnPosition(), n3, table.frozenColumnWidth(), n2);
        } else {
            clip = Clip.find_by_type(table, 2);
            if (clip != null) {
                ((Component)clip).hide();
            }
        }
        if (table.frozen_rows > 0 && table.rows > 0) {
            clip = Clip.clip_create(table, 3);
            int n4 = table.frozen_columns > 0 ? table.frozenColumnLabelOffset() : table.columnLabelOffset();
            clip.set_size(table.cell_rect, n4, table.frozenRowPosition(), n, table.frozenRowHeight());
        } else {
            clip = Clip.find_by_type(table, 3);
            if (clip != null) {
                ((Component)clip).hide();
            }
        }
        if (table.rowLabelWidth() > 0 && table.frozen_rows > 0) {
            clip = Clip.clip_create(table, 6);
            clip.set_size(table.rowlabel_rect, table.rowLabelPosition(), table.frozenRowPosition(), table.rowLabelWidth(), table.frozenRowHeight());
        } else {
            clip = Clip.find_by_type(table, 6);
            if (clip != null) {
                ((Component)clip).hide();
            }
        }
        if (table.rowLabelWidth() > 0) {
            clip = Clip.clip_create(table, 4);
            clip.set_size(table.rowlabel_rect, table.rowLabelPosition(), table.frozenRowLabelOffset(), table.rowLabelWidth(), n2);
        } else {
            clip = Clip.find_by_type(table, 4);
            if (clip != null) {
                ((Component)clip).hide();
            }
        }
        if (table.columnLabelHeight() > 0 && table.frozen_columns > 0) {
            clip = Clip.clip_create(table, 7);
            clip.set_size(table.collabel_rect, table.frozenColumnPosition(), table.columnLabelPosition(), table.frozenColumnWidth(), table.columnLabelHeight());
        } else {
            clip = Clip.find_by_type(table, 7);
            if (clip != null) {
                ((Component)clip).hide();
            }
        }
        if (table.columnLabelHeight() > 0) {
            clip = Clip.clip_create(table, 5);
            clip.set_size(table.collabel_rect, table.frozenColumnLabelOffset(), table.columnLabelPosition(), n, table.columnLabelHeight());
        } else {
            clip = Clip.find_by_type(table, 5);
            if (clip != null) {
                ((Component)clip).hide();
            }
        }
        int n5 = 0;
        while (n5 < table.clip_list.length) {
            clip = table.clip_list[n5];
            clip.reset_internal_values();
            ++n5;
        }
        if (table.hasComponents()) {
            Widget.unmanageInvisible(table);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Object object = this.getAWTLock();
        synchronized (object) {
            if (!this.table.ignore_container_size) {
                Dimension dimension = this.getToolkit().getScreenSize();
                n3 = Math.max(1, Math.min(n3, dimension.width));
                n4 = Math.max(1, Math.min(n4, dimension.height));
            } else {
                n3 = Math.max(1, n3);
                n4 = Math.max(1, n4);
            }
        }
        super.setBounds(n, n2, n3, n4);
    }

    static void setPrintTable(JCPrintTable jCPrintTable) {
        Clip clip = Clip.Create(jCPrintTable.print_table, 8);
        clip.printtable = jCPrintTable;
    }

    private void set_size(Rectangle rectangle, int n, int n2, int n3, int n4) {
        int n5 = Math.max(1, n3);
        int n6 = Math.max(1, n4);
        this.setBounds(n += this.table.frame_shadow, n2 += this.table.frame_shadow, n5, n6);
        boolean bl = false;
        int n7 = 0;
        while (n7 < this.table.clip_list.length) {
            if (this.table.clip_list[n7] == this) {
                bl = true;
                break;
            }
            ++n7;
        }
        if (!bl) {
            this.table.add(this);
        }
        this.show(n3 > 0 && n4 > 0);
        rectangle.x = Math.min(rectangle.x, n);
        rectangle.y = Math.min(rectangle.y, n2);
        switch (this.type) {
            case 4: 
            case 6: {
                rectangle.width = n3;
                rectangle.height += n4;
                break;
            }
            case 3: {
                rectangle.height += n4;
                break;
            }
            case 5: 
            case 7: {
                rectangle.width += n3;
                rectangle.height = n4;
                break;
            }
            case 2: {
                rectangle.width += n3;
                break;
            }
            case 0: {
                rectangle.width += n3;
                rectangle.height += n4;
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void validate() {
        if (this.isValid() || this.getPeer() == null) {
            return;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
    }

    public int xOffset() {
        Object object = this.getAWTLock();
        synchronized (object) {
            int n = this.range.start_column >= 0 ? this.table.columnPosition(this.range.start_column) : 0;
            Object var3_3 = null;
            return n;
        }
    }

    public int yOffset() {
        Object object = this.getAWTLock();
        synchronized (object) {
            int n = this.range.start_row >= 0 ? this.table.rowPosition(this.range.start_row) : 0;
            Object var3_3 = null;
            return n;
        }
    }
}

