/*
 * Decompiled with CFR 0.152.
 */
package jclass.field;

import java.awt.Event;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Calendar;
import java.util.Locale;
import jclass.field.JCCalendar;
import jclass.field.JCCalendarPopup;
import jclass.util.JCEnvironment;

class PopupCalendar
extends JCCalendar
implements KeyListener {
    JCCalendarPopup box;
    boolean exited = true;

    PopupCalendar(JCCalendarPopup jCCalendarPopup, Calendar calendar, Locale locale) {
        super(calendar, locale);
        this.box = jCCalendarPopup;
        this.exited = false;
        this.calendar.addKeyListener(this);
        this.spin_time.addKeyListener(this);
        this.spin_month.addKeyListener(this);
        this.spin_year.addKeyListener(this);
        this.enableEvents(32L);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.box.hidePopup();
        }
        if (keyEvent.getKeyCode() == 10) {
            this.calendar.postDateSelectedEvent();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void lostCalendarFocus(Object object) {
        long l;
        if (JCEnvironment.isVisualAge() && (l = System.currentTimeMillis() - this.box.calendar_popdown_time) >= 0L && l < 600L) {
            this.requestCalendarFocus();
            return;
        }
        if (this.exited && (JCEnvironment.getJavaVersion() < 116 || JCEnvironment.isVisualAge())) {
            this.box.hidePopup();
        }
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        this.exited = this.inside(n, n2) ^ true;
        return super.mouseEnter(event, n, n2);
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.exited = this.inside(n, n2) ^ true;
        return super.mouseExit(event, n, n2);
    }

    public boolean mouseMove(Event event, int n, int n2) {
        this.exited = this.inside(n, n2) ^ true;
        return super.mouseMove(event, n, n2);
    }

    public void requestCalendarFocus() {
        this.calendar.requestFocus();
    }
}

