/*
 * Decompiled with CFR 0.152.
 */
package jclass.field;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import javax.swing.border.Border;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCArrowButton;
import jclass.bwt.JCContainer;
import jclass.bwt.JCTextCursorListener;
import jclass.bwt.JCTextField;
import jclass.bwt.JCTextInterface;
import jclass.bwt.JCTextListener;
import jclass.field.JCSpinEvent;
import jclass.field.JCSpinListener;
import jclass.field.SpinArrowButton;
import jclass.field.SpinField;
import jclass.util.JCListenerList;

public abstract class JCSpin
extends JCContainer
implements JCActionListener,
JCTextInterface {
    protected JCTextField text;
    protected SpinArrowButton decr_arrow;
    protected SpinArrowButton incr_arrow;
    protected Object value;
    protected boolean auto_arrow_disable = true;
    protected boolean arrow_key_spinning_allowed = true;
    private static boolean TRACE = false;
    protected int border = 2;
    protected static final int NONE = 0;
    protected static final int INCREMENT = 1;
    protected static final int DECREMENT = -1;
    static final int BEGIN = 0;
    static final int END = 1;
    protected JCListenerList listener_list = null;

    public JCSpin() {
        super.setLayout(null);
        this.text = this.createTextField();
        this.add(this.text);
        this.incr_arrow = new SpinArrowButton(10, this);
        this.add(this.incr_arrow);
        this.decr_arrow = new SpinArrowButton(9, this);
        this.add(this.decr_arrow);
        this.text.addKeyListener(new textKeyListener());
        this.incr_arrow.setInitialRepeatDelay(250);
        this.decr_arrow.setInitialRepeatDelay(250);
        this.incr_arrow.setTraversable(false);
        this.decr_arrow.setTraversable(false);
        this.text.setShadowThickness(0);
        this.incr_arrow.addActionListener(this);
        this.decr_arrow.addActionListener(this);
    }

    public JCSpin(int n) {
        this();
        this.text.setColumns(n);
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (TRACE) {
            System.out.println("JCSpin.actionPerformed()");
        }
        int n = JCSpinEvent.NO_SPIN;
        if (jCActionEvent.getSource() == this.incr_arrow) {
            n = JCSpinEvent.SPIN_UP;
        } else if (jCActionEvent.getSource() == this.decr_arrow) {
            n = JCSpinEvent.SPIN_DOWN;
        }
        if (TRACE) {
            System.out.println("\tposting spin event");
        }
        JCSpinEvent jCSpinEvent = new JCSpinEvent(this, n, this.text.getText());
        Enumeration enumeration = JCListenerList.elements(this.listener_list);
        while (enumeration.hasMoreElements()) {
            JCSpinListener jCSpinListener = (JCSpinListener)enumeration.nextElement();
            if (TRACE) {
                System.out.println("\t\tcalling l.spin()");
            }
            jCSpinListener.spin(jCSpinEvent);
        }
        if (TRACE) {
            System.out.println("\tabout to check arrow buttons");
        }
        this.checkArrowButtons();
        if (TRACE) {
            System.out.println("\tarrow buttons checked");
        }
    }

    public void addFocusListener(FocusListener focusListener) {
        if (this.text != null) {
            this.text.addFocusListener(focusListener);
        }
    }

    public void addKeyListener(KeyListener keyListener) {
        if (this.text != null) {
            this.text.addKeyListener(keyListener);
        }
    }

    public void addSpinListener(JCSpinListener jCSpinListener) {
        this.listener_list = JCListenerList.add(this.listener_list, jCSpinListener);
    }

    public void addTextCursorListener(JCTextCursorListener jCTextCursorListener) {
        this.text.addTextCursorListener(jCTextCursorListener);
    }

    public void addTextListener(JCTextListener jCTextListener) {
        this.text.addTextListener(jCTextListener);
    }

    public void append(String string) {
        this.text.append(string);
    }

    public void beep() {
        this.text.beep();
    }

    public abstract void checkArrowButtons();

    protected JCTextField createTextField() {
        return new SpinField();
    }

    public synchronized void doLayout() {
        int n = this.text.getPreferredSize().height;
        int n2 = n / 2;
        int n3 = this.incr_arrow.getPreferredSize().width;
        int n4 = this.getSize().width - n3 - this.border;
        int n5 = n % 2;
        ((Component)this.text).setBounds(this.border, this.border, this.getSize().width - n3 - 2 * this.border, n2 * 2);
        this.incr_arrow.setBounds(n4, this.border, n3, n2);
        this.decr_arrow.setBounds(n4, n2 + this.border, n3, n2 + n5);
        this.checkArrowButtons();
    }

    public int getAlignment() {
        return this.text.getAlignment();
    }

    public boolean getAutoArrowDisable() {
        return this.auto_arrow_disable;
    }

    public boolean getChanged() {
        return this.text.getChanged();
    }

    public int getColumns() {
        return this.text.getColumns();
    }

    public int getCursorPosition() {
        return this.text.getCursorPosition();
    }

    public JCArrowButton getDecrementArrow() {
        return this.decr_arrow;
    }

    public boolean getEditable() {
        return this.text.getEditable();
    }

    public Color getHighlightColor() {
        return this.text.getHighlightColor();
    }

    public int getHighlightThickness() {
        return this.text.getHighlightThickness();
    }

    public JCArrowButton getIncrementArrow() {
        return this.incr_arrow;
    }

    public int getLastPosition() {
        return this.text.getLastPosition();
    }

    public int getMaximumLength() {
        return this.text.getMaximumLength();
    }

    public Dimension getMinimumSize(int n) {
        return this.text.getMinimumSize(n);
    }

    public boolean getOverstrike() {
        return this.text.getOverstrike();
    }

    public Color getSelectedBackground() {
        return this.text.getSelectedBackground();
    }

    public Color getSelectedForeground() {
        return this.text.getSelectedForeground();
    }

    public String getSelectedText() {
        return this.text.getSelectedText();
    }

    public int getSelectionEnd() {
        return this.text.getSelectionEnd();
    }

    public int[] getSelectionList() {
        return this.text.getSelectionList();
    }

    public int getSelectionStart() {
        return this.text.getSelectionStart();
    }

    public int getShadowThickness() {
        return this.border;
    }

    public boolean getShowCursorPosition() {
        return this.text.getShowCursorPosition();
    }

    public int getStringCase() {
        return this.text.getStringCase();
    }

    public synchronized String getText() {
        return "";
    }

    public JCTextField getTextField() {
        return this.text;
    }

    public void insert(String string, int n) {
        this.text.insert(string, n);
    }

    public boolean isArrowKeySpinningAllowed() {
        return this.arrow_key_spinning_allowed;
    }

    public boolean isEditable() {
        return this.text.isEditable();
    }

    public void paintInterior(Graphics graphics) {
        graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.swing_border != null) {
            this.swing_border.paintBorder(this, graphics, 0, 0, this.size().width, this.size().height);
        } else {
            jclass.base.Border.draw(graphics, 8, this.border, 0, 0, this.getSize().width, this.getSize().height, this.getBackground(), this.getForeground());
        }
    }

    public int pointToPosition(int n, int n2) {
        return this.text.pointToPosition(n, n2);
    }

    protected int preferredHeight() {
        return 2 * this.border + this.text.getPreferredSize().height;
    }

    protected int preferredWidth() {
        return this.text.getPreferredSize().width + this.incr_arrow.getPreferredSize().width + 2 * this.border;
    }

    public void removeFocusListener(FocusListener focusListener) {
        if (this.text != null) {
            this.text.removeFocusListener(focusListener);
        }
    }

    public void removeKeyListener(KeyListener keyListener) {
        if (this.text != null) {
            this.text.removeKeyListener(keyListener);
        }
    }

    public void removeSpinListener(JCSpinListener jCSpinListener) {
        this.listener_list = JCListenerList.remove(this.listener_list, jCSpinListener);
    }

    public void removeTextCursorListener(JCTextCursorListener jCTextCursorListener) {
        this.text.removeTextCursorListener(jCTextCursorListener);
    }

    public void removeTextListener(JCTextListener jCTextListener) {
        this.text.removeTextListener(jCTextListener);
    }

    public void replaceRange(String string, int n, int n2) {
        this.text.replaceRange(string, n, n2);
    }

    public void requestFocus() {
        if (this.text != null) {
            this.text.requestFocus();
        }
    }

    public void select(int n, int n2) {
        this.text.select(n, n2);
    }

    public void selectAll() {
        this.text.selectAll();
    }

    public void setAlignment(int n) {
        this.text.setAlignment(n);
    }

    public void setArrowKeySpinningAllowed(boolean bl) {
        this.arrow_key_spinning_allowed = bl;
    }

    public void setAutoArrowDisable(boolean bl) {
        this.auto_arrow_disable = bl;
        this.checkArrowButtons();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.decr_arrow.setBackground(color);
        this.incr_arrow.setBackground(color);
    }

    public void setBorder(Border border) {
        this.swing_border = border;
        this.setChildrenBorder(border);
    }

    public void setColumns(int n) {
        this.text.setColumns(n);
    }

    public void setCursorPosition(int n) {
        this.text.setCursorPosition(n);
    }

    public void setEditable(boolean bl) {
        this.text.setEditable(bl);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.decr_arrow.setForeground(color);
        this.incr_arrow.setForeground(color);
    }

    public void setHighlightColor(Color color) {
        this.text.setHighlightColor(color);
    }

    public void setHighlightThickness(int n) {
        this.text.setHighlightThickness(n);
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    public void setMaximumLength(int n) {
        this.text.setMaximumLength(n);
    }

    public void setOverstrike(boolean bl) {
        this.text.setOverstrike(bl);
    }

    public void setSelectedBackground(Color color) {
        this.text.setSelectedBackground(color);
    }

    public void setSelectedForeground(Color color) {
        this.text.setSelectedForeground(color);
    }

    public void setSelectionEnd(int n) {
        this.text.setSelectionEnd(n);
    }

    public void setSelectionList(int[] nArray) {
        this.text.setSelectionList(nArray);
    }

    public void setSelectionStart(int n) {
        this.text.setSelectionStart(n);
    }

    public void setShadowThickness(int n) {
        this.border = n;
    }

    public void setShowCursorPosition(boolean bl) {
        this.text.setShowCursorPosition(bl);
    }

    public void setStringCase(int n) {
        this.text.setStringCase(n);
    }

    public synchronized void setText(String string) {
    }

    public void showPosition(int n) {
        this.text.showPosition(n);
    }

    class textKeyListener
    implements KeyListener {
        textKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Object var3_2 = null;
            JCSpinEvent jCSpinEvent = null;
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 38: {
                    if (!JCSpin.this.arrow_key_spinning_allowed) break;
                    jCSpinEvent = new JCSpinEvent(this, JCSpinEvent.SPIN_UP, JCSpin.this.text.getText());
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    if (!JCSpin.this.arrow_key_spinning_allowed) break;
                    jCSpinEvent = new JCSpinEvent(this, JCSpinEvent.SPIN_DOWN, JCSpin.this.text.getText());
                    keyEvent.consume();
                    break;
                }
            }
            if (jCSpinEvent != null) {
                Enumeration enumeration = JCListenerList.elements(JCSpin.this.listener_list);
                while (enumeration.hasMoreElements()) {
                    JCSpinListener jCSpinListener = (JCSpinListener)enumeration.nextElement();
                    jCSpinListener.spin(jCSpinEvent);
                }
                JCSpin.this.checkArrowButtons();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

