/*
 * Decompiled with CFR 0.152.
 */
package jclass.field;

import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import jclass.base.Border;
import jclass.bwt.JCComponent;
import jclass.field.JCCalendarEvent;
import jclass.field.JCCalendarListener;
import jclass.field.JCDateMonthYear;
import jclass.field.JCDayOfWeek;
import jclass.field.JCMonthDayOfMonth;
import jclass.field.JCMonthWeekDayOfWeek;
import jclass.util.JCVector;

public class JCCalendarComponent
extends JCComponent {
    private String[] days;
    static final int[] days_in_month = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    protected JCVector listeners = new JCVector(0);
    private int num_of_days;
    private int num_rows = 0;
    private int startx;
    private int starty;
    private Point start_point = new Point(0, 0);
    private Point end_point = new Point(0, 0);
    private Point selected_point = new Point(0, 0);
    private Date time;
    protected JCVector special_dates = new JCVector(0);
    protected boolean selected = false;
    protected Color selected_foreground = null;
    protected Color selected_background = null;
    protected Color special_day_background = null;
    protected Color special_day_foreground = null;
    protected Color header_foreground = null;
    protected Color header_background = null;
    protected Font header_font = null;
    protected int cell_margin = 0;
    protected int cell_size;
    protected Calendar selected_calendar;
    protected int first_day_of_week;
    protected int cell_highlight_thickness = 1;
    protected int header_gap = 2;
    protected int num_header_chars = 0;

    public JCCalendarComponent() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public JCCalendarComponent(Calendar calendar, Locale locale) {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        this.setBorderThickness(2);
        this.setHighlightThickness(0);
        this.days = dateFormatSymbols.getShortWeekdays();
        this.selected_calendar = calendar;
        this.first_day_of_week = (this.selected_calendar.getFirstDayOfWeek() + 6) % 7;
    }

    public JCCalendarComponent(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public JCCalendarComponent(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public JCCalendarComponent(TimeZone timeZone, Locale locale) {
        this(Calendar.getInstance(timeZone, locale), locale);
    }

    public void addCalendarListener(JCCalendarListener jCCalendarListener) {
        this.listeners.addUnique(jCCalendarListener);
    }

    public void addNotify() {
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        super.addNotify();
        this.enableEvents(32L);
        if (this.header_foreground == null) {
            this.header_foreground = color2;
        }
        if (this.header_background == null) {
            this.header_background = color;
        }
        String string = this.getFont().getName();
        int n = this.getFont().getSize();
        if (this.header_font == null) {
            this.header_font = new Font(string, 1, n);
        }
        if (this.selected_foreground == null) {
            this.selected_foreground = color2;
        }
        if (this.selected_background == null) {
            this.selected_background = color;
        }
        if (this.special_day_background == null) {
            this.special_day_background = color;
        }
        if (this.special_day_foreground == null) {
            this.special_day_foreground = color2;
        }
        this.calculateCellSize();
    }

    public void addSpecialDay(JCDateMonthYear jCDateMonthYear) {
        this.special_dates.addUnique(jCDateMonthYear);
        this.repaint();
    }

    public void addSpecialDay(JCDayOfWeek jCDayOfWeek) {
        this.special_dates.addUnique(jCDayOfWeek);
        this.repaint();
    }

    public void addSpecialDay(JCMonthDayOfMonth jCMonthDayOfMonth) {
        this.special_dates.addUnique(jCMonthDayOfMonth);
        this.repaint();
    }

    public void addSpecialDay(JCMonthWeekDayOfWeek jCMonthWeekDayOfWeek) {
        this.special_dates.addUnique(jCMonthWeekDayOfWeek);
        this.repaint();
    }

    protected synchronized void calculateCellSize() {
        int n = 0;
        Font font = this.getFont();
        if (this.getPeer() == null) {
            return;
        }
        int n2 = Math.max(((Component)this).getFontMetrics(font).getHeight(), ((Component)this).getFontMetrics(this.header_font).getHeight());
        int n3 = 0;
        while (n3 < this.days.length) {
            int n4 = this.num_header_chars <= 0 || this.num_header_chars > this.days[n3].length() ? this.days[n3].length() : this.num_header_chars;
            if (n < ((Component)this).getFontMetrics(this.header_font).stringWidth(this.days[n3].substring(0, n4))) {
                n = ((Component)this).getFontMetrics(this.header_font).stringWidth(this.days[n3].substring(0, n4));
            }
            ++n3;
        }
        int n5 = Math.max(((Component)this).getFontMetrics(font).stringWidth("00"), n);
        this.cell_size = Math.max(n2, n5) + 2 * this.cell_margin + 2 * this.cell_highlight_thickness;
        this.setPreferredSize(this.cell_size * 7, this.cell_size * 7 + this.header_gap);
    }

    private void calculateNewDate(int n, int n2) {
        int n3 = this.selected_calendar.get(5);
        if (n == this.selected_point.x) {
            n3 += n2 - this.selected_point.y;
        }
        if (n > this.selected_point.x) {
            n3 += 7 * (n - this.selected_point.x - 1);
            n3 += n2 - this.selected_point.y + 7;
        } else if (n < this.selected_point.x) {
            n3 += 7 * (n - this.selected_point.x + 1);
            n3 += n2 - this.selected_point.y - 7;
        }
        if (n3 <= 0 || n3 > this.num_of_days) {
            return;
        }
        this.selected_calendar.set(5, n3);
    }

    protected Point centerInCell(String string, Font font, int n, int n2) {
        Point point = new Point(n, n2);
        int n3 = ((Component)this).getFontMetrics(font).stringWidth(string);
        int n4 = ((Component)this).getFontMetrics(font).getHeight();
        if (n + this.cell_size > n3) {
            point.x = n + (this.cell_size - n3) / 2;
        }
        if (n2 + this.cell_size > n4) {
            point.y = n2 + (this.cell_size - n4) / 2;
        }
        return point;
    }

    public static int dayOfWeek(int n, int n2, int n3) {
        if (n2 == 0 || n2 == 1) {
            --n3;
        }
        int n4 = n3 % 100;
        int n5 = n3 / 100;
        int n6 = (n2 + 10) % 12 + 1;
        int n7 = (int)((double)n + Math.floor(2.6 * (double)n6 - 0.2) - (double)(2 * n5) + (double)n4 + Math.floor(n4 / 4) + Math.floor(n5 / 4)) % 7;
        n7 = (n7 + 7) % 7;
        return n7;
    }

    protected synchronized void drawCalendar(Graphics graphics, int n, int n2) {
        int n3 = this.selected_calendar.get(2);
        int n4 = this.selected_calendar.get(1);
        int n5 = this.selected_calendar.get(5);
        Point point = new Point(n, n2);
        Font font = this.getFont();
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        this.num_of_days = days_in_month[n3];
        if (n3 == 1 && JCCalendarComponent.isLeapYear(n4)) {
            ++this.num_of_days;
        }
        int n6 = JCCalendarComponent.dayOfWeek(1, n3, n4);
        if (this.first_day_of_week != 0) {
            n6 = (n6 - this.first_day_of_week + 7) % 7;
        }
        n = this.startx + n6 * this.cell_size;
        this.starty = n2 += this.cell_size + this.header_gap;
        this.start_point.x = 0;
        this.start_point.y = n6;
        graphics.setFont(font);
        graphics.setColor(color);
        int n7 = ((Component)this).getFontMetrics(font).getAscent();
        this.num_rows = 0;
        int n8 = 1;
        int n9 = n6;
        while (n8 <= this.num_of_days) {
            if (n9 > 6) {
                n9 = 0;
                ++this.num_rows;
                n = this.startx;
                n2 += this.cell_size;
            }
            point = this.centerInCell(String.valueOf(n8), this.getFont(), n, n2);
            if (n8 == n5) {
                graphics.setColor(this.selected_background);
                graphics.fillRect(n + this.cell_highlight_thickness, n2 + this.cell_highlight_thickness, this.cell_size - 2 * this.cell_highlight_thickness, this.cell_size - 2 * this.cell_highlight_thickness);
                graphics.setColor(this.selected_foreground);
                graphics.drawString(String.valueOf(n8), point.x, point.y + n7);
                graphics.setColor(color);
                Border.draw(graphics, 3, this.cell_highlight_thickness, n, n2, this.cell_size, this.cell_size, color2, color);
                this.selected_point.x = this.num_rows;
                this.selected_point.y = n9;
            } else if (this.isSpecialDay(n4, n3, n8, this.num_rows + 1)) {
                graphics.setColor(this.special_day_background);
                graphics.fillRect(n, n2, this.cell_size, this.cell_size);
                graphics.setColor(this.special_day_foreground);
                graphics.drawString(String.valueOf(n8), point.x, point.y + n7);
                graphics.setColor(color);
            } else {
                graphics.drawString(String.valueOf(n8), point.x, point.y + n7);
            }
            n += this.cell_size;
            ++n8;
            ++n9;
        }
        this.end_point.x = this.num_rows;
        this.end_point.y = n9 - 1;
    }

    protected synchronized void drawHeader(Graphics graphics, int n, int n2) {
        Point point = new Point(n, n2);
        graphics.setColor(this.header_background);
        graphics.fillRect(0, 0, this.cell_size * 7, this.cell_size);
        graphics.setColor(this.header_foreground);
        graphics.setFont(this.header_font);
        if (this.header_background.equals(this.getBackground())) {
            graphics.drawLine(n, n2 + this.cell_size, n + 7 * this.cell_size, n2 + this.cell_size);
        } else {
            graphics.setColor(this.header_background);
            graphics.fillRect(0, 0, this.getSize().width, this.cell_size);
        }
        graphics.setFont(this.header_font);
        graphics.setColor(this.header_foreground);
        int n3 = ((Component)this).getFontMetrics(this.header_font).getAscent();
        int n4 = 0;
        int n5 = this.first_day_of_week + 1;
        while (n4 < 7) {
            n5 = (n5 + 6) % 7 + 1;
            int n6 = this.num_header_chars <= 0 || this.num_header_chars > this.days[n5].length() ? this.days[n5].length() : this.num_header_chars;
            point = this.centerInCell(this.days[n5].substring(0, n6), this.getHeaderFont(), n, n2);
            graphics.drawString(this.days[n5].substring(0, n6), point.x, point.y + n3);
            n += this.cell_size;
            ++n4;
            ++n5;
        }
    }

    public int getCellHighlightThickness() {
        return this.cell_highlight_thickness;
    }

    public int getCellMargin() {
        return this.cell_margin;
    }

    public Color getHeaderBackground() {
        return this.header_background;
    }

    public Font getHeaderFont() {
        return this.header_font;
    }

    public Color getHeaderForeground() {
        return this.header_foreground;
    }

    protected boolean getNewSelectedDate(Event event, int n, int n2) {
        if (n < this.startx || n2 < this.starty || n > this.startx + this.cell_size * 7 || n2 > this.cell_size * 7) {
            return false;
        }
        int n3 = (n - this.startx) / this.cell_size;
        int n4 = (n2 - this.starty) / this.cell_size;
        if (n4 < this.start_point.x || n4 > this.end_point.x || n4 == this.start_point.x && n3 < this.start_point.y || n4 == this.end_point.x && n3 > this.end_point.y) {
            this.selected = false;
            return false;
        }
        this.selected = true;
        this.calculateNewDate(n4, n3);
        this.time = this.selected_calendar.getTime();
        this.repaint();
        this.requestFocus();
        this.postDateChangedEvent();
        return true;
    }

    public int getNumHeaderChars() {
        return this.num_header_chars;
    }

    public Color getSelectedBackground() {
        return this.selected_background;
    }

    public Color getSelectedForeground() {
        return this.selected_foreground;
    }

    public Color getSpecialDayBackground() {
        return this.special_day_background;
    }

    public Color getSpecialDayForeground() {
        return this.special_day_foreground;
    }

    public Calendar getValue() {
        return this.selected_calendar;
    }

    protected int isInSpecialDayList(int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < this.special_dates.size()) {
            int n6;
            Object e = this.special_dates.elementAt(n5);
            if (e instanceof JCDateMonthYear) {
                JCDateMonthYear jCDateMonthYear = (JCDateMonthYear)e;
                if (jCDateMonthYear.year == n && jCDateMonthYear.month == n2 && jCDateMonthYear.date == n3) {
                    return n5;
                }
            } else if (e instanceof JCDayOfWeek) {
                JCDayOfWeek jCDayOfWeek = (JCDayOfWeek)e;
                n6 = JCCalendarComponent.dayOfWeek(n3, n2, n);
                if (jCDayOfWeek.day_of_week == n6) {
                    return n5;
                }
            } else if (e instanceof JCMonthDayOfMonth) {
                JCMonthDayOfMonth jCMonthDayOfMonth = (JCMonthDayOfMonth)e;
                if (jCMonthDayOfMonth.month == n2 && jCMonthDayOfMonth.day_of_month == n3) {
                    return n5;
                }
            } else if (e instanceof JCMonthWeekDayOfWeek) {
                JCMonthWeekDayOfWeek jCMonthWeekDayOfWeek = (JCMonthWeekDayOfWeek)e;
                n6 = JCCalendarComponent.dayOfWeek(n3, n2, n);
                if (jCMonthWeekDayOfWeek.month == n2 && jCMonthWeekDayOfWeek.day_of_week == n6 && jCMonthWeekDayOfWeek.week == n4) {
                    return n5;
                }
            }
            ++n5;
        }
        return -1;
    }

    public static boolean isLeapYear(int n) {
        boolean bl = false;
        if (n % 100 == 0) {
            if (n % 400 == 0) {
                bl = true;
            }
        } else if (n % 4 == 0) {
            bl = true;
        }
        return bl;
    }

    protected boolean isSpecialDay(int n, int n2, int n3, int n4) {
        return this.isInSpecialDayList(n, n2, n3, n4) >= 0;
    }

    public boolean keyDown(Event event, int n) {
        switch (n) {
            case 1004: {
                this.selected_calendar.add(5, -7);
                break;
            }
            case 1005: {
                this.selected_calendar.add(5, 7);
                break;
            }
            case 1006: {
                this.selected_calendar.add(5, -1);
                break;
            }
            case 1007: {
                this.selected_calendar.add(5, 1);
                break;
            }
            case 1002: {
                this.selected_calendar.add(2, -1);
                break;
            }
            case 1003: {
                this.selected_calendar.add(2, 1);
                break;
            }
            default: {
                return false;
            }
        }
        this.time = this.selected_calendar.getTime();
        this.repaint();
        this.postDateChangedEvent();
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        return this.getNewSelectedDate(event, n, n2);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        return this.getNewSelectedDate(event, n, n2);
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.selected) {
            this.postDateSelectedEvent();
            this.selected = false;
        }
        return true;
    }

    protected synchronized void paintComponent(Graphics graphics) {
        int n = this.startx = (this.getSize().width - 7 * this.cell_size) / 2;
        int n2 = (this.getSize().height - (7 * this.cell_size + this.header_gap)) / 2;
        this.drawHeader(graphics, n, n2);
        this.drawCalendar(graphics, n, n2);
    }

    protected void postDateChangedEvent() {
        if (this.listeners.size() == 0) {
            return;
        }
        JCCalendarEvent jCCalendarEvent = new JCCalendarEvent(this, 0, this.selected_calendar);
        int n = 0;
        while (n < this.listeners.size()) {
            ((JCCalendarListener)this.listeners.elementAt(n)).dateChanged(jCCalendarEvent);
            ++n;
        }
    }

    protected void postDateSelectedEvent() {
        if (this.listeners.size() == 0) {
            return;
        }
        JCCalendarEvent jCCalendarEvent = new JCCalendarEvent(this, 0, this.selected_calendar);
        int n = 0;
        while (n < this.listeners.size()) {
            ((JCCalendarListener)this.listeners.elementAt(n)).dateSelected(jCCalendarEvent);
            ++n;
        }
    }

    public void removeCalendarListener(JCCalendarListener jCCalendarListener) {
        this.listeners.removeElement(jCCalendarListener);
    }

    public void removeSpecialDay(JCDateMonthYear jCDateMonthYear) {
        int n = 0;
        while (n < this.special_dates.size()) {
            Object e = this.special_dates.elementAt(n);
            if (e instanceof JCDateMonthYear) {
                JCDateMonthYear jCDateMonthYear2 = (JCDateMonthYear)e;
                if (jCDateMonthYear2.year == jCDateMonthYear.year && jCDateMonthYear2.month == jCDateMonthYear.month && jCDateMonthYear2.date == jCDateMonthYear.date) {
                    this.special_dates.removeElementAt(n);
                }
            }
            ++n;
        }
        this.repaint();
    }

    public void removeSpecialDay(JCDayOfWeek jCDayOfWeek) {
        int n = 0;
        while (n < this.special_dates.size()) {
            Object e = this.special_dates.elementAt(n);
            if (e instanceof JCDayOfWeek) {
                JCDayOfWeek jCDayOfWeek2 = (JCDayOfWeek)e;
                if (jCDayOfWeek2.day_of_week == jCDayOfWeek.day_of_week) {
                    this.special_dates.removeElementAt(n);
                }
            }
            ++n;
        }
        this.repaint();
    }

    public void removeSpecialDay(JCMonthDayOfMonth jCMonthDayOfMonth) {
        int n = 0;
        while (n < this.special_dates.size()) {
            Object e = this.special_dates.elementAt(n);
            if (e instanceof JCMonthDayOfMonth) {
                JCMonthDayOfMonth jCMonthDayOfMonth2 = (JCMonthDayOfMonth)e;
                if (jCMonthDayOfMonth2.month == jCMonthDayOfMonth.month && jCMonthDayOfMonth2.day_of_month == jCMonthDayOfMonth.day_of_month) {
                    this.special_dates.removeElementAt(n);
                }
            }
            ++n;
        }
        this.repaint();
    }

    public void removeSpecialDay(JCMonthWeekDayOfWeek jCMonthWeekDayOfWeek) {
        int n = 0;
        while (n < this.special_dates.size()) {
            Object e = this.special_dates.elementAt(n);
            if (e instanceof JCMonthWeekDayOfWeek) {
                JCMonthWeekDayOfWeek jCMonthWeekDayOfWeek2 = (JCMonthWeekDayOfWeek)e;
                if (jCMonthWeekDayOfWeek2.month == jCMonthWeekDayOfWeek.month && jCMonthWeekDayOfWeek2.week == jCMonthWeekDayOfWeek.week && jCMonthWeekDayOfWeek2.day_of_week == jCMonthWeekDayOfWeek.day_of_week) {
                    this.special_dates.removeElementAt(n);
                }
            }
            ++n;
        }
        this.repaint();
    }

    public void setCellHighlightThickness(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid value for highlight thickness");
        }
        this.cell_highlight_thickness = n;
        this.calculateCellSize();
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    public void setCellMargin(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid value for cell margin");
        }
        this.cell_margin = n;
        this.calculateCellSize();
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    public synchronized void setFont(Font font) {
        super.setFont(font);
        this.calculateCellSize();
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    public void setHeaderBackground(Color color) {
        this.header_background = color;
        this.repaint();
    }

    public void setHeaderFont(Font font) {
        this.header_font = font;
        this.calculateCellSize();
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    public void setHeaderForeground(Color color) {
        this.header_foreground = color;
        this.repaint();
    }

    public void setNumHeaderChars(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid value for number of header chars");
        }
        this.num_header_chars = n;
        this.calculateCellSize();
        this.setSize(this.getPreferredSize());
        this.repaint();
    }

    public void setSelectedBackground(Color color) {
        this.selected_background = color;
        this.repaint();
    }

    public void setSelectedDate(int n, int n2, int n3) {
        if (n <= 0) {
            n = 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 11) {
            n2 = 11;
        }
        int n4 = days_in_month[n2];
        if (n2 == 1 && JCCalendarComponent.isLeapYear(n)) {
            ++n4;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        if (n3 < 1) {
            n3 = 1;
        }
        this.selected_calendar.set(n, n2, n3);
        this.time = this.selected_calendar.getTime();
        this.repaint();
        this.postDateChangedEvent();
    }

    public void setSelectedForeground(Color color) {
        this.selected_foreground = color;
        this.repaint();
    }

    public void setSpecialDayBackground(Color color) {
        this.special_day_background = color;
        this.repaint();
    }

    public void setSpecialDayForeground(Color color) {
        this.special_day_foreground = color;
        this.repaint();
    }

    public void setValue(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("invalid value");
        }
        this.selected_calendar = calendar;
        this.repaint();
        this.postDateChangedEvent();
    }
}

