/*
 * Decompiled with CFR 0.152.
 */
package jclass.field;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JPanel;
import javax.swing.border.Border;
import jclass.bwt.JCContainer;
import jclass.field.JCCalendarComponent;
import jclass.field.JCCalendarEvent;
import jclass.field.JCCalendarListener;
import jclass.field.JCDateMonthYear;
import jclass.field.JCDayOfWeek;
import jclass.field.JCFieldEvent;
import jclass.field.JCFieldListener;
import jclass.field.JCIntSpinField;
import jclass.field.JCMonthDayOfMonth;
import jclass.field.JCMonthWeekDayOfWeek;
import jclass.field.JCTimeSpinField;
import jclass.field.JCVersion;

public class JCCalendar
extends JCContainer
implements JCFieldListener,
JCCalendarListener,
FocusListener {
    public static final String version = JCVersion.getVersionString();
    public static final String about = JCVersion.getAboutString();
    protected JCIntSpinField spin_month;
    protected JCIntSpinField spin_year;
    protected JCTimeSpinField spin_time;
    protected JCCalendarComponent calendar;
    protected JPanel container;
    protected Calendar max_roll_date = Calendar.getInstance();
    protected Calendar min_roll_date = Calendar.getInstance();
    protected boolean hide_time_spinner = false;
    protected String[] months;

    public JCCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public JCCalendar(Calendar calendar, Locale locale) {
        this.container = new JPanel();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        this.months = dateFormatSymbols.getMonths();
        super.setLayout(new BorderLayout());
        this.spin_month = new JCIntSpinField();
        this.spin_year = new JCIntSpinField();
        this.spin_time = new JCTimeSpinField();
        Calendar calendar2 = calendar == null ? Calendar.getInstance(locale) : calendar;
        this.calendar = new JCCalendarComponent(calendar2, locale);
        this.calendar.addCalendarListener(this);
        this.calendar.addFocusListener(this);
        this.max_roll_date.set(Integer.MAX_VALUE, 11, 31);
        this.min_roll_date.set(0, 0, 1);
        this.spin_month.setDisplayList(this.months);
        this.spin_month.setRange(0, 11);
        this.spin_month.setEditable(false);
        this.spin_month.setValue(calendar2.get(2));
        this.spin_month.setIncrement(1);
        this.spin_month.setSpinPolicy(2);
        this.spin_month.addFieldListener(this);
        this.spin_month.getTextField().setShowCursorPosition(false);
        this.spin_year.setRange(0, Integer.MAX_VALUE);
        this.spin_year.setDisplayPattern("#");
        this.spin_year.setValue(calendar2.get(1));
        this.spin_year.setIncrement(1);
        this.spin_year.setMin(1);
        this.spin_year.addFieldListener(this);
        this.spin_year.getTextField().addFocusListener(this);
        this.spin_time.setValue(calendar2.getTime());
        this.spin_time.getTextField().setAlignment(1);
        this.spin_time.addFieldListener(this);
        this.container.setLayout(new BorderLayout());
        this.container.add("West", this.spin_month);
        this.container.add("East", this.spin_year);
        this.add("North", this.container);
        this.add("Center", this.calendar);
        this.add("South", this.spin_time);
    }

    public JCCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public JCCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public JCCalendar(TimeZone timeZone, Locale locale) {
        this(Calendar.getInstance(timeZone, locale), locale);
    }

    public void addCalendarListener(JCCalendarListener jCCalendarListener) {
        this.calendar.addCalendarListener(jCCalendarListener);
    }

    public void addNotify() {
        super.addNotify();
        this.calculateSpinYearSize();
        this.calculateSpinMonthSize();
        if (!this.hide_time_spinner) {
            this.calculateSpinTimeSize();
        }
    }

    public void addSpecialDay(JCDateMonthYear jCDateMonthYear) {
        this.calendar.addSpecialDay(jCDateMonthYear);
    }

    public void addSpecialDay(JCDayOfWeek jCDayOfWeek) {
        this.calendar.addSpecialDay(jCDayOfWeek);
    }

    public void addSpecialDay(JCMonthDayOfMonth jCMonthDayOfMonth) {
        this.calendar.addSpecialDay(jCMonthDayOfMonth);
    }

    public void addSpecialDay(JCMonthWeekDayOfWeek jCMonthWeekDayOfWeek) {
        this.calendar.addSpecialDay(jCMonthWeekDayOfWeek);
    }

    protected void calculateContainerSize() {
        this.calculateSpinYearSize();
        this.spin_year.setSize(this.spin_year.getTextField().getPreferredSize());
        this.calculateSpinMonthSize();
        this.spin_month.setSize(this.spin_month.getTextField().getPreferredSize());
        if (!this.hide_time_spinner) {
            this.calculateSpinTimeSize();
            this.spin_time.setSize(this.spin_time.getTextField().getPreferredSize());
        }
        this.updateParent();
    }

    protected void calculateSpinMonthSize() {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.spin_month.getFont());
        int n = 0;
        int n2 = fontMetrics.getHeight();
        int n3 = 0;
        while (n3 < this.months.length) {
            if (n < fontMetrics.stringWidth(this.months[n3])) {
                n = fontMetrics.stringWidth(this.months[n3]);
            }
            ++n3;
        }
        this.spin_month.getTextField().setPreferredSize(n, n2);
    }

    protected void calculateSpinTimeSize() {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.spin_time.getFont());
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.stringWidth("00:00:00");
        this.spin_time.getTextField().setPreferredSize(n2, n);
    }

    protected void calculateSpinYearSize() {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.spin_year.getFont());
        int n = 0;
        int n2 = fontMetrics.getHeight();
        if (n < fontMetrics.stringWidth("0000")) {
            n = fontMetrics.stringWidth("0000");
        }
        this.spin_year.getTextField().setPreferredSize(n, n2);
    }

    public void dateChanged(JCCalendarEvent jCCalendarEvent) {
        int n = jCCalendarEvent.getCalendar().get(1);
        int n2 = jCCalendarEvent.getCalendar().get(2);
        if (this.spin_year.getValue() != n) {
            this.spin_year.setValue(n);
        }
        if (this.spin_month.getValue() != n2) {
            this.spin_month.setValue(n2);
        }
    }

    public void dateSelected(JCCalendarEvent jCCalendarEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.spin_time.getTextField().hasFocus() || this.spin_month.getTextField().hasFocus() || this.spin_year.getTextField().hasFocus() || this.calendar.hasFocus()) {
            return;
        }
        this.lostCalendarFocus(this);
    }

    public String getAbout() {
        return about;
    }

    public Color getBackground() {
        return super.getBackground();
    }

    public int getCellHighlightThickness() {
        return this.calendar.getCellHighlightThickness();
    }

    public int getCellMargin() {
        return this.calendar.getCellMargin();
    }

    public Font getFont() {
        return super.getFont();
    }

    public Color getForeground() {
        return super.getForeground();
    }

    public Color getHeaderBackground() {
        return this.calendar.getHeaderBackground();
    }

    public Font getHeaderFont() {
        return this.calendar.getHeaderFont();
    }

    public Color getHeaderForeground() {
        return this.calendar.getHeaderForeground();
    }

    public boolean getHideTimeSpinner() {
        return this.hide_time_spinner;
    }

    public Calendar getMaxRollDate() {
        return this.max_roll_date;
    }

    public Calendar getMinRollDate() {
        return this.min_roll_date;
    }

    public int getNumHeaderChars() {
        return this.calendar.getNumHeaderChars();
    }

    public Color getSelectedBackground() {
        return this.calendar.getSelectedBackground();
    }

    public Color getSelectedForeground() {
        return this.calendar.getSelectedForeground();
    }

    public Color getSpecialDayBackground() {
        return this.calendar.getSpecialDayBackground();
    }

    public Color getSpecialDayForeground() {
        return this.calendar.getSpecialDayForeground();
    }

    public Calendar getValue() {
        return this.calendar.getValue();
    }

    public String getVersion() {
        return version;
    }

    protected void lostCalendarFocus(Object object) {
    }

    public void removeCalendarListener(JCCalendarListener jCCalendarListener) {
        this.calendar.removeCalendarListener(jCCalendarListener);
    }

    public void removeSpecialDay(JCDateMonthYear jCDateMonthYear) {
        this.calendar.removeSpecialDay(jCDateMonthYear);
    }

    public void removeSpecialDay(JCDayOfWeek jCDayOfWeek) {
        this.calendar.removeSpecialDay(jCDayOfWeek);
    }

    public void removeSpecialDay(JCMonthDayOfMonth jCMonthDayOfMonth) {
        this.calendar.removeSpecialDay(jCMonthDayOfMonth);
    }

    public void removeSpecialDay(JCMonthWeekDayOfWeek jCMonthWeekDayOfWeek) {
        this.calendar.removeSpecialDay(jCMonthWeekDayOfWeek);
    }

    public synchronized void setAbout(String string) {
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.container.setBackground(color);
        this.calendar.setBackground(color);
        this.spin_year.setBackground(color);
        this.spin_month.setBackground(color);
    }

    public void setBorder(Border border) {
        this.swing_border = border;
        this.setChildrenBorder(border);
        this.spin_year.setBorder(border);
        this.spin_month.setBorder(border);
        this.spin_time.setBorder(border);
    }

    public void setCellHighlightThickness(int n) {
        this.calendar.setCellHighlightThickness(n);
        if (this.getPeer() != null) {
            this.calculateContainerSize();
        }
    }

    public void setCellMargin(int n) {
        this.calendar.setCellMargin(n);
        if (this.getPeer() != null) {
            this.calculateContainerSize();
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.calendar.setFont(font);
        this.spin_month.getTextField().repaint();
        if (this.getPeer() != null) {
            this.calculateContainerSize();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.calendar.setForeground(color);
        this.spin_year.setForeground(color);
        this.spin_month.setForeground(color);
    }

    public void setHeaderBackground(Color color) {
        this.calendar.setHeaderBackground(color);
    }

    public void setHeaderFont(Font font) {
        this.calendar.setHeaderFont(font);
        if (this.getPeer() != null) {
            this.calculateContainerSize();
        }
    }

    public void setHeaderForeground(Color color) {
        this.calendar.setHeaderForeground(color);
    }

    public void setHideTimeSpinner(boolean bl) {
        if (bl == this.hide_time_spinner) {
            return;
        }
        this.hide_time_spinner = bl;
        if (bl) {
            this.remove(this.spin_time);
            this.spin_time.removeFieldListener(this);
        } else {
            this.add("South", this.spin_time);
            this.spin_time.addFieldListener(this);
            this.calculateContainerSize();
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    public void setMaxRollDate(Calendar calendar) {
        this.max_roll_date = calendar;
        this.spin_year.setMax(calendar.get(1));
    }

    public void setMinRollDate(Calendar calendar) {
        this.min_roll_date = calendar;
        this.spin_year.setMin(calendar.get(1));
    }

    public void setNumHeaderChars(int n) {
        this.calendar.setNumHeaderChars(n);
        if (this.getPeer() != null) {
            this.calculateContainerSize();
        }
    }

    public void setSelectedBackground(Color color) {
        this.calendar.setSelectedBackground(color);
    }

    public void setSelectedDate(int n, int n2, int n3) {
        this.calendar.setSelectedDate(n, n2, n3);
    }

    public void setSelectedForeground(Color color) {
        this.calendar.setSelectedForeground(color);
    }

    public void setSpecialDayBackground(Color color) {
        this.calendar.setSpecialDayBackground(color);
    }

    public void setSpecialDayForeground(Color color) {
        this.calendar.setSpecialDayForeground(color);
    }

    public void setValue(Calendar calendar) {
        this.calendar.setValue(calendar);
    }

    public void setVersion(String string) {
    }

    public void stateIsInvalid(JCFieldEvent jCFieldEvent) {
    }

    public void valueChangedBegin(JCFieldEvent jCFieldEvent) {
    }

    public void valueChangedEnd(JCFieldEvent jCFieldEvent) {
        Calendar calendar = this.calendar.getValue();
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        if (jCFieldEvent.getSource() == this.spin_year) {
            this.calendar.setSelectedDate((Integer)jCFieldEvent.getValue(), n2, n3);
        } else if (jCFieldEvent.getSource() == this.spin_month) {
            this.calendar.setSelectedDate(n, (Integer)jCFieldEvent.getValue(), n3);
        } else {
            Calendar calendar2 = this.spin_time.getValue();
            calendar.set(10, calendar2.get(10));
            calendar.set(11, calendar2.get(11));
            calendar.set(12, calendar2.get(12));
            calendar.set(13, calendar2.get(13));
            calendar.set(9, calendar2.get(9));
            this.calendar.setValue(calendar);
        }
    }
}

