/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JPropertyPage;
import jclass.chart.customizer.swing.JSpinBox;
import jclass.util.JCUtilConverter;

public class JFontEditor
extends JPropertyPage
implements ActionListener,
ItemListener,
AdjustmentListener,
PropertyEditor {
    protected JComboBox fontNameCombo = null;
    protected JComboBox fontStyleCombo = null;
    protected JSpinBox fontSizeSpin = null;
    protected JTextField fontSizeField = null;
    protected JButton useFontButton = null;
    static int[] font_style_values;
    static String[] font_style_names;
    String long_label = "      " + JCustomizerBundle.string("jclass.chart.customizer.swing.Key129") + "       ";
    String short_label = " " + JCustomizerBundle.string("jclass.chart.customizer.swing.Key129") + " ";
    protected PropertyChangeSupport listeners = null;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        font_style_values = nArray;
        font_style_names = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};
    }

    public JFontEditor() {
        this.setToolTipText(JFontEditor.getPageTitle());
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JTextField) {
            try {
                this.fontSizeSpin.setTextValue(actionEvent.getActionCommand());
                this.textChanged(actionEvent);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key130")) + ": " + exception.getMessage());
            }
        } else if (actionEvent.getSource() instanceof JButton && this.listeners != null) {
            this.listeners.firePropertyChange("", null, this.getValue());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent != null && adjustmentEvent.getSource() == this.fontSizeSpin.getScrollBar()) {
            this.fontSizeSpin.setIntValue(adjustmentEvent.getValue());
            this.fontChanged();
        }
    }

    private void comboChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        JComboBox jComboBox = (JComboBox)itemEvent.getSource();
        if (jComboBox == this.fontNameCombo || jComboBox == this.fontStyleCombo) {
            this.fontChanged();
        }
    }

    private void fontChanged() {
        try {
            String string = (String)this.fontNameCombo.getSelectedItem();
            String string2 = (String)this.fontStyleCombo.getSelectedItem();
            String string3 = this.fontSizeField.getText();
            if (string != "" && string2 != "" && string3 != "") {
                int n = JCUtilConverter.toEnum(string2, font_style_names, font_style_values, 0);
                Integer n2 = new Integer(string3);
                int n3 = n2;
                Font font = new Font(string, n, n3);
                if (n3 > 14) {
                    this.useFontButton.setText(this.short_label);
                } else {
                    this.useFontButton.setText(this.long_label);
                }
                this.useFontButton.setFont(font);
            }
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key130")) + JCustomizerBundle.string("jclass.chart.customizer.swing.Key112") + ":" + exception.getMessage());
        }
    }

    public String getAsText() {
        Font font = this.getEditFont();
        return font.toString();
    }

    public Component getCustomEditor() {
        return null;
    }

    public Font getEditFont() {
        Font font = null;
        try {
            String string = (String)this.fontNameCombo.getSelectedItem();
            int n = this.fontStyleCombo.getSelectedIndex();
            int n2 = font_style_values[n];
            String string2 = this.fontSizeField.getText();
            int n3 = Integer.parseInt(string2);
            font = new Font(string, n2, n3);
        }
        catch (Exception exception) {}
        return font;
    }

    public String getJavaInitializationString() {
        String string;
        Font font = this.getEditFont();
        switch (font.getStyle()) {
            case 1: {
                string = "Font.BOLD";
                break;
            }
            case 2: {
                string = "Font.ITALIC";
                break;
            }
            case 3: {
                string = "Font.BOLD + Font.ITALIC";
                break;
            }
            default: {
                string = "Font.PLAIN";
            }
        }
        return "new Font(" + font.getName() + ", " + string + ", " + font.getSize() + ")";
    }

    public static String getPageName() {
        return "JFontEditor";
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key131");
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return this.getEditFont();
    }

    public void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        String[] stringArray = this.getToolkit().getFontList();
        this.fontNameCombo = new JComboBox<String>(stringArray);
        this.fontNameCombo.addItemListener(this);
        gridBagLayout.setConstraints(this.fontNameCombo, gridBagConstraints);
        this.add(this.fontNameCombo);
        this.fontStyleCombo = new JComboBox<String>(font_style_names);
        this.fontStyleCombo.addItemListener(this);
        gridBagLayout.setConstraints(this.fontStyleCombo, gridBagConstraints);
        this.add(this.fontStyleCombo);
        this.fontSizeSpin = new JSpinBox();
        this.fontSizeSpin.setMinimum(8);
        this.fontSizeSpin.setMaximum(36);
        this.fontSizeField = this.fontSizeSpin.getTextField();
        this.fontSizeField.addActionListener(this);
        this.fontSizeSpin.getScrollBar().addAdjustmentListener(this);
        gridBagLayout.setConstraints(this.fontSizeSpin, gridBagConstraints);
        this.add(this.fontSizeSpin);
        this.useFontButton = new JButton(this.long_label);
        this.useFontButton.addActionListener(this);
        gridBagLayout.setConstraints(this.useFontButton, gridBagConstraints);
        this.add(this.useFontButton);
    }

    public boolean isPaintable() {
        return false;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JComboBox) {
            this.comboChanged(itemEvent);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(JFontEditor.getPageTitle());
        serializable = new JFontEditor();
        ((JFontEditor)serializable).setBackground(Color.lightGray);
        jFrame.getContentPane().add((Component)serializable);
        ((JFontEditor)serializable).setValue(new Font("TimesNewRoman", 1, 12));
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    public void setBackground(Color color) {
        if (this.fontNameCombo != null) {
            this.fontNameCombo.setBackground(color);
        }
        if (this.fontStyleCombo != null) {
            this.fontStyleCombo.setBackground(color);
        }
        if (this.fontSizeField != null) {
            this.fontSizeField.setBackground(color);
        }
    }

    public void setEditFont(Font font) {
        String string = font.getName();
        int n = this.fontNameCombo.getItemCount();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            if (string.equalsIgnoreCase((String)this.fontNameCombo.getItemAt(n2))) {
                if (this.fontNameCombo.getSelectedIndex() != n2) {
                    this.fontNameCombo.setSelectedIndex(n2);
                }
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            try {
                this.fontNameCombo.addItem(string);
                this.fontNameCombo.setSelectedItem(string);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key24")) + " " + JCustomizerBundle.string("jclass.chart.customizer.swing.Key112") + " " + string);
            }
        }
        int n3 = font.getStyle();
        int n4 = 0;
        while (n4 < font_style_values.length) {
            if (n3 == font_style_values[n4]) {
                if (this.fontStyleCombo.getSelectedIndex() == n4) break;
                this.fontStyleCombo.setSelectedIndex(n4);
                break;
            }
            ++n4;
        }
        int n5 = font.getSize();
        this.fontSizeSpin.setIntValue(n5);
        this.fontChanged();
    }

    public void setValue(Object object) {
        if (object instanceof Font) {
            this.setEditFont((Font)object);
        }
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    private void textChanged(ActionEvent actionEvent) {
        JTextField jTextField = (JTextField)actionEvent.getSource();
        if (jTextField == this.fontSizeField) {
            this.fontChanged();
        }
    }
}

