/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.Serializable;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jclass.chart.customizer.swing.JCustomizerBundle;
import jclass.chart.customizer.swing.JPropertyPage;

public class JEnumEditor
extends JPropertyPage
implements ItemListener,
PropertyEditor {
    private String[] strings;
    private int[] enumValues;
    private JComboBox comboBox = null;
    private String prepend = "";
    private Object[] itemValues = null;
    private boolean settingObjectItems = false;
    protected PropertyChangeSupport listeners = null;

    public JEnumEditor() {
        this(null, null);
    }

    public JEnumEditor(String[] stringArray, int[] nArray) {
        this.setToolTipText(JEnumEditor.getPageTitle());
        this.setLayout(new GridLayout(1, 1));
        this.comboBox = new JComboBox();
        this.strings = stringArray;
        this.enumValues = nArray;
        this.itemValues = this.strings;
        if (stringArray != null && nArray != null) {
            this.setItems(stringArray);
        }
        this.comboBox.addItemListener(this);
        this.add(this.comboBox);
    }

    public JEnumEditor(String[] stringArray, int[] nArray, String string) {
        this(stringArray, nArray);
        this.prepend = string;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public String getAsText() {
        return (String)this.comboBox.getSelectedItem();
    }

    public Component getCustomEditor() {
        return null;
    }

    public Object getItem(int n) {
        Object object = null;
        if (this.itemValues != null && n < this.itemValues.length) {
            object = this.itemValues[n];
        }
        return object;
    }

    public Object[] getItems() {
        return this.itemValues;
    }

    public String getJavaInitializationString() {
        if (this.getValue() == null) {
            return "NULL";
        }
        return String.valueOf(this.prepend) + this.getAsText();
    }

    public static String getPageName() {
        return "JEnumEditor";
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("jclass.chart.customizer.swing.Key162");
    }

    public String[] getTags() {
        return this.strings;
    }

    public Object getValue() {
        int n = this.comboBox.getSelectedIndex();
        int n2 = -1;
        n2 = this.enumValues != null ? this.enumValues[n] : n;
        return new Integer(n2);
    }

    public int indexOf(int n) {
        if (this.enumValues != null) {
            int n2 = 0;
            while (n2 < this.enumValues.length) {
                if (this.enumValues[n2] == n) {
                    return n2;
                }
                ++n2;
            }
        }
        return -1;
    }

    public int indexOf(Object object) {
        if (this.itemValues != null) {
            int n = 0;
            while (n < this.itemValues.length) {
                if (this.itemValues[n] == object) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public int indexOf(String string) {
        if (this.enumValues != null) {
            int n = 0;
            while (n < this.enumValues.length) {
                if (string.equalsIgnoreCase((String)this.comboBox.getItemAt(n))) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public boolean isPaintable() {
        return false;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.settingObjectItems) {
            return;
        }
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        if (this.listeners != null) {
            this.listeners.firePropertyChange("", null, this.getValue());
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(JEnumEditor.getPageTitle());
        serializable = new JEnumEditor();
        ((JComponent)serializable).setBackground(Color.lightGray);
        ((JPropertyPage)serializable).init();
        jFrame.getContentPane().add((Component)serializable);
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    private boolean sameStrings(String[] stringArray) {
        if (this.strings == null) {
            return false;
        }
        boolean bl = stringArray.length == this.strings.length;
        int n = 0;
        while (n < stringArray.length && bl) {
            if (this.strings[n].compareTo(stringArray[n]) != 0) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    private void setItems(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.comboBox.addItem(new String(stringArray[n2]));
            ++n2;
        }
    }

    public void setItems(String[] stringArray, Object[] objectArray) {
        this.settingObjectItems = true;
        if (!this.sameStrings(stringArray)) {
            this.strings = stringArray;
            this.itemValues = objectArray;
            if (stringArray != null && objectArray != null) {
                this.setItems(stringArray);
            }
        }
        this.settingObjectItems = false;
    }

    public void setValue(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Integer) {
            int n;
            int n2 = (Integer)object;
            int n3 = this.indexOf(n2);
            if (n3 < 0) {
                n3 = n2;
            }
            if (n3 != (n = this.comboBox.getSelectedIndex())) {
                try {
                    this.comboBox.setSelectedIndex(n3);
                }
                catch (Exception exception) {
                    this.comboBox.insertItemAt(new String(String.valueOf(JCustomizerBundle.string("jclass.chart.customizer.swing.Key24")) + n3), 0);
                    this.comboBox.setSelectedIndex(0);
                }
            }
        } else if (object instanceof String) {
            int n = this.indexOf((String)object);
            int n4 = this.comboBox.getSelectedIndex();
            if (n >= 0 && n != n4) {
                this.comboBox.setSelectedIndex(n);
            }
        } else if (object instanceof Object) {
            int n = this.indexOf(object);
            int n5 = this.comboBox.getSelectedIndex();
            if (n >= 0 && n != n5) {
                this.comboBox.setSelectedIndex(n);
            }
        }
    }

    public boolean supportsCustomEditor() {
        return false;
    }
}

