/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer.swing;

import java.awt.Color;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jclass.chart.customizer.swing.JCustomNode;

public class JCustomTree
extends JTree {
    private DefaultTreeModel treeModel = null;
    private DefaultTreeSelectionModel selectionModel = null;

    public JCustomTree(JCustomNode jCustomNode) {
        super(jCustomNode);
        this.treeModel = new DefaultTreeModel(jCustomNode);
        this.selectionModel = new DefaultTreeSelectionModel();
        this.selectionModel.setSelectionMode(1);
        this.setModel(this.treeModel);
        this.setSelectionModel(this.selectionModel);
        this.setRootVisible(true);
        this.setBackground(Color.white);
    }

    public JCustomNode addNode(JCustomNode jCustomNode, String string, int n) {
        JCustomNode jCustomNode2 = null;
        if (jCustomNode != null) {
            Enumeration<TreeNode> enumeration = jCustomNode.children();
            int n2 = jCustomNode.getChildCount();
            if (enumeration != null && n < n2) {
                jCustomNode2 = (JCustomNode)jCustomNode.getChildAt(n);
                jCustomNode2.setUserObject(new String(string));
            } else {
                jCustomNode2 = new JCustomNode(string);
                this.treeModel.insertNodeInto(jCustomNode2, jCustomNode, n);
            }
        }
        return jCustomNode2;
    }

    public void addNode(JCustomNode jCustomNode, JCustomNode jCustomNode2) {
        if (jCustomNode2 != null && jCustomNode != null) {
            this.treeModel.insertNodeInto(jCustomNode, jCustomNode2, jCustomNode2.getChildCount());
        }
    }

    public void addNode(JCustomNode jCustomNode, JCustomNode jCustomNode2, int n) {
        if (jCustomNode2 != null && jCustomNode != null && n > jCustomNode2.getChildCount()) {
            this.treeModel.insertNodeInto(jCustomNode, jCustomNode2, n);
        }
    }

    public JCustomNode findNode(JCustomNode jCustomNode, Object object) {
        JCustomNode jCustomNode2 = null;
        int n = this.treeModel.getChildCount(jCustomNode);
        int n2 = 0;
        while (n2 < n) {
            jCustomNode2 = (JCustomNode)this.treeModel.getChild(jCustomNode, n2);
            Object object2 = jCustomNode2.getUserData();
            if (object2 != null && object2 == object) {
                return jCustomNode2;
            }
            if (!this.treeModel.isLeaf(jCustomNode2) && (jCustomNode2 = this.findNode(jCustomNode2, object)) != null) {
                return jCustomNode2;
            }
            ++n2;
        }
        return null;
    }

    public void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        super.fireValueChanged(treeSelectionEvent);
    }

    public JCustomNode getRoot() {
        return (JCustomNode)this.treeModel.getRoot();
    }

    public JCustomNode getSelectedNode() {
        JCustomNode jCustomNode = null;
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            jCustomNode = (JCustomNode)treePath.getLastPathComponent();
        }
        return jCustomNode;
    }

    public void initSelection(boolean bl) {
        JCustomNode jCustomNode = this.getRoot();
        int n = 0;
        while (this.treeModel.getChildCount(jCustomNode) > 0) {
            JCustomNode jCustomNode2 = (JCustomNode)this.treeModel.getChild(jCustomNode, 0);
            this.expandRow(n);
            if (this.treeModel.isLeaf(jCustomNode2)) {
                if (!bl) break;
                this.setSelectionRow(n + 1);
                break;
            }
            jCustomNode = jCustomNode2;
            ++n;
        }
    }

    protected void printTree(JCustomNode jCustomNode) {
        int n = this.treeModel.getChildCount(jCustomNode);
        int n2 = 0;
        while (n2 < n) {
            JCustomNode jCustomNode2 = (JCustomNode)this.treeModel.getChild(jCustomNode, n2);
            if (!this.treeModel.isLeaf(jCustomNode2)) {
                this.printTree(jCustomNode2);
            }
            System.out.println(jCustomNode2);
            ++n2;
        }
    }

    public void removeAllChildren(JCustomNode jCustomNode) {
        int n = this.treeModel.getChildCount(jCustomNode);
        int n2 = 0;
        while (n2 < n) {
            JCustomNode jCustomNode2 = (JCustomNode)this.treeModel.getChild(jCustomNode, n2);
            if (!this.treeModel.isLeaf(jCustomNode2)) {
                this.removeAllChildren(jCustomNode2);
            }
            this.removeNode(jCustomNode2);
            ++n2;
        }
    }

    public void removeNode(JCustomNode jCustomNode) {
        if (jCustomNode != null && jCustomNode != this.getRoot()) {
            this.treeModel.removeNodeFromParent(jCustomNode);
        }
    }
}

