/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.Vector;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCButton;
import jclass.chart.customizer.EndsWithFilter;
import jclass.chart.customizer.JCFieldEditor;
import jclass.chart.customizer.JCPropertyChangeEvent;
import jclass.chart.customizer.JCPropertyPage;
import jclass.util.JCImageCreator;
import jclass.util.JCString;

public class JCFileNameEditor
extends JCPropertyPage
implements JCActionListener,
PropertyEditor {
    public JCFieldEditor dirField;
    public JCFieldEditor nameField;
    public JCButton loadButton;
    public JCButton saveButton;
    private FilenameFilter filter;
    protected FileDialog loadDialog = null;
    protected FileDialog saveDialog = null;
    String directory;
    String filename;
    private static String[] loadPixels = new String[]{"                    ", "           ddd      ", "          d   d d   ", "               dd   ", "   ...        ddd   ", "  .ccc.......       ", "  .ggggggggg.       ", "  .ggggggggg.       ", "  .gggg...........  ", "  .ggg.bbbbbbbbb.   ", "  .gg.bbbbbbbbb.    ", "  .g.bbbbbbbbb.     ", "  ..bbbbbbbbb.      ", "  ...........       ", "                    ", "                    "};
    private static String[] savePixels = new String[]{"                    ", "  dddrrrrrrrrrrddd  ", "  dcdrrrrrrrrrrdcd  ", "  dddccccccccccddd  ", "  dddcc.c..c.ccddd  ", "  dddccccccccccddd  ", "  dddcc...c..ccddd  ", "  dddccccccccccddd  ", "  dddcc..c.c.ccddd  ", "  ddddccccccccdddd  ", "  dddddddddddddddd  ", "  ddddaaaaaaaadddd  ", "  dddda..aaaaadddd  ", "  dddda..aaaaadddd  ", "  dddda..aaaaadddd  ", "   ddda..aaaaadddd  ", "    dddddddddddddd  ", "                    "};

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() instanceof JCButton) {
            JCButton jCButton = (JCButton)jCActionEvent.getSource();
            if (jCButton == this.loadButton) {
                if (this.loadDialog == null) {
                    this.loadDialog = new FileDialog(this.getDialogFrame(), "Load Data", 0);
                }
                this.setDialogFile(this.loadDialog, this.nameField.getText());
                this.loadDialog.show();
                this.directory = this.loadDialog.getDirectory();
                this.filename = this.loadDialog.getFile();
                boolean bl = false;
                if (this.directory != null && !this.directory.equals("") && !this.dirField.getText().equals(this.directory)) {
                    this.dirField.setText(this.directory);
                    bl = true;
                }
                if (this.filename != null && !this.filename.equals("") && !this.nameField.getText().equals(this.filename)) {
                    this.nameField.setText(this.filename);
                    bl = true;
                }
                if (bl) {
                    this.firePropertyChange(this.loadButton, null, this.getValue());
                }
            } else if (jCButton == this.saveButton) {
                if (this.saveDialog == null) {
                    this.saveDialog = new FileDialog(this.getDialogFrame(), "Save Data", 1);
                    String string = this.nameField.getText();
                    if (string.indexOf(42) >= 0) {
                        this.saveDialog.setFile(string);
                    }
                }
                this.setDialogFile(this.saveDialog, this.nameField.getText());
                this.saveDialog.show();
                this.directory = this.saveDialog.getDirectory();
                this.filename = this.saveDialog.getFile();
                boolean bl = false;
                if (this.directory != null && !this.directory.equals("") && !this.dirField.getText().equals(this.directory)) {
                    this.dirField.setText(this.directory);
                    bl = true;
                }
                if (this.filename != null && !this.filename.equals("") && !this.nameField.getText().equals(this.filename)) {
                    this.nameField.setText(this.filename);
                    bl = true;
                }
                if (bl) {
                    this.firePropertyChange(this.saveButton, null, this.getValue());
                }
            }
        }
    }

    public void firePropertyChange(Component component, Object object, Object object2) {
        Vector vector;
        if (object != null && object.equals(object2)) {
            return;
        }
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners == null) {
                Object var6_5 = null;
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        serializable = new JCPropertyChangeEvent(component, null, object, object2);
        int n = 0;
        while (n < vector.size()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(n);
            propertyChangeListener.propertyChange((PropertyChangeEvent)serializable);
            ++n;
        }
    }

    public String getAsText() {
        return (String)this.getValue();
    }

    public Component getCustomEditor() {
        return null;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFile() {
        return this.filename;
    }

    public String getJavaInitializationString() {
        return this.getAsText();
    }

    public static String getPageName() {
        return "JCFileNameEditor";
    }

    public static String getPageTitle() {
        return "JClass File Name Editor";
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return String.valueOf(this.directory) + this.filename;
    }

    public void init() {
        super.init();
        this.setLayout(new FlowLayout(0, 2, 2));
        this.dirField = new JCFieldEditor("", 12);
        this.dirField.setBackground(JCPropertyPage.textBG);
        this.dirField.addPropertyChangeListener(this);
        this.nameField = new JCFieldEditor("", 12);
        this.nameField.setBackground(JCPropertyPage.textBG);
        this.nameField.addPropertyChangeListener(this);
        this.add(this.nameField);
        JCString jCString = new JCString("");
        jCString.add(JCFileNameEditor.makeLoadImage(this));
        jCString.add("Load...");
        this.loadButton = new JCButton(jCString);
        this.loadButton.setInsets(new Insets(0, 2, 0, 0));
        this.loadButton.addActionListener(this);
        this.add(this.loadButton);
        JCString jCString2 = new JCString("");
        jCString2.add(JCFileNameEditor.makeSaveImage(this));
        jCString2.add("Save...");
        this.saveButton = new JCButton(jCString2);
        this.saveButton.setInsets(new Insets(0, 2, 0, 0));
        this.saveButton.addActionListener(this);
        this.add(this.saveButton);
    }

    public boolean isPaintable() {
        return false;
    }

    public static void main(String[] stringArray) {
        String string = JCFileNameEditor.getPageName();
        JCPropertyPage jCPropertyPage = JCPropertyPage.getPage(string);
        jCPropertyPage.init();
        jCPropertyPage.launch();
        Frame frame = JCPropertyPage.getFrame(jCPropertyPage);
        frame.setTitle(JCFileNameEditor.getPageTitle());
    }

    static Image makeLoadImage(Component component) {
        JCImageCreator jCImageCreator = new JCImageCreator(component, loadPixels[0].length(), loadPixels.length);
        jCImageCreator.setColor('.', new Color(0));
        jCImageCreator.setColor('g', new Color(65280));
        jCImageCreator.setColor('b', new Color(0x848400));
        jCImageCreator.setColor('c', new Color(0xFFFFFF));
        jCImageCreator.setColor('d', new Color(255));
        jCImageCreator.setPixels(loadPixels);
        return jCImageCreator.create();
    }

    static Image makeSaveImage(Component component) {
        JCImageCreator jCImageCreator = new JCImageCreator(component, savePixels[0].length(), savePixels.length);
        jCImageCreator.setColor('.', new Color(0));
        jCImageCreator.setColor('b', new Color(0x848400));
        jCImageCreator.setColor('c', new Color(0xFFFFFF));
        jCImageCreator.setColor('d', new Color(255));
        jCImageCreator.setPixels(savePixels);
        return jCImageCreator.create();
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public void propertyChanged(Object object, Object object2) {
        boolean bl = false;
        if (object == this.dirField) {
            if (!((String)object2).equals(this.directory)) {
                this.directory = (String)object2;
                bl = true;
            }
        } else if (object == this.nameField) {
            if (object2 instanceof String) {
                this.filename = (String)object2;
            }
            bl = true;
        }
        if (bl) {
            if (object instanceof Component) {
                this.firePropertyChange((Component)object, null, this.getValue());
            } else {
                this.firePropertyChange("", null, this.getValue());
            }
        }
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    public void setBackground(Color color) {
        if (this.dirField != null) {
            this.dirField.setBackground(color);
        }
        if (this.nameField != null) {
            this.nameField.setBackground(color);
        }
    }

    private void setDialogFile(FileDialog fileDialog, String string) {
        if (string == null == string.equals("")) {
            fileDialog.setFile("*");
        }
        if (string.indexOf(42) >= 0) {
            fileDialog.setFile(string);
        } else {
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                fileDialog.setFilenameFilter(new EndsWithFilter(string.substring(n)));
            }
        }
    }

    public void setValue(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            int n = string.lastIndexOf(47);
            if (n > 0) {
                this.dirField.setValue(string.substring(0, n));
            }
            this.nameField.setValue(string.substring(n + 1));
        }
    }

    public boolean supportsCustomEditor() {
        return false;
    }
}

