/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.customizer;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.util.Vector;
import jclass.chart.Chartable;

public class GridInputStreamDataSource
implements Chartable {
    private StreamTokenizer tokenizer;
    private Vector data = new Vector();
    private String name = null;
    private Vector seriesNames = new Vector();
    private Vector pointLabels = new Vector();

    protected GridInputStreamDataSource() {
    }

    public GridInputStreamDataSource(InputStream inputStream) throws IOException {
        this.ctor(inputStream);
    }

    protected void ctor(InputStream inputStream) throws IOException {
        this.tokenizer = new StreamTokenizer(inputStream);
        this.tokenizer.commentChar(35);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.lowerCaseMode(true);
        this.tokenizer.parseNumbers();
        this.tokenizer.whitespaceChars(43, 43);
        this.tokenizer.eolIsSignificant(true);
        this.init();
        this.tokenizer = null;
    }

    public Vector getData() {
        return this.data;
    }

    public int getDataInterpretation() {
        return 0;
    }

    public synchronized Object getDataItem(int n, int n2) {
        Object var3_3 = null;
        if (n < this.getNumRows() && n2 < this.getNumColumns()) {
            Vector vector = this.getRow(n);
            var3_3 = vector.elementAt(n2);
        }
        return var3_3;
    }

    public String getName() {
        return this.name;
    }

    public int getNumColumns() {
        int n = 0;
        Vector vector = this.getRow(0);
        if (vector != null) {
            n = vector.size();
        }
        return n;
    }

    public int getNumRows() {
        return this.getData().size();
    }

    public String[] getPointLabels() {
        if (this.pointLabels == null) {
            return null;
        }
        Object[] objectArray = new String[this.pointLabels.size()];
        this.pointLabels.copyInto(objectArray);
        return objectArray;
    }

    public synchronized Vector getRow(int n) {
        Vector vector = null;
        if (n < this.getNumRows()) {
            vector = (Vector)this.getData().elementAt(n);
        }
        return vector;
    }

    public String getSeriesLabel(int n) {
        String string;
        try {
            string = (String)this.seriesNames.elementAt(n);
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public String getSeriesName(int n) {
        String string;
        try {
            string = (String)this.seriesNames.elementAt(n);
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public synchronized void init() throws IOException {
        this.readArrayData();
    }

    private void readArrayData() throws IOException {
        int n;
        Vector<Double> vector = null;
        int n2 = 0;
        int n3 = 0;
        while ((n = this.tokenizer.nextToken()) != -1) {
            vector = new Vector<Double>();
            do {
                if (n == -3) {
                    this.seriesNames.addElement(new String(this.tokenizer.sval));
                    continue;
                }
                this.seriesNames.addElement("");
                if (n != -2) continue;
                vector.addElement(new Double(this.tokenizer.nval));
            } while ((n = this.tokenizer.nextToken()) != 10);
            int n4 = vector.size();
            if (n4 > 0) {
                this.data.addElement(vector);
                ++n2;
                n3 = Math.max(n4, n3);
            }
            int n5 = 0;
            while (n5 < this.data.size()) {
                Vector vector2 = (Vector)this.data.elementAt(n5);
                int n6 = n3 - vector2.size();
                int n7 = n3 - n6;
                while (n7 < n3) {
                    vector2.addElement(new Double(0.0));
                    ++n7;
                }
                ++n5;
            }
        }
    }
}

