/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.bean;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import jclass.chart.AxisGridWrapper;
import jclass.chart.JCChartBundle;
import jclass.chart.MultiChart;
import jclass.chart.bean.ColorDialog;
import jclass.chart.bean.ColorEditable;
import jclass.chart.bean.GroupPanel;
import jclass.chart.bean.RadioEditor;
import jclass.util.JCUtilConverter;

public class AxisGridEditor
extends RadioEditor
implements ItemListener,
ActionListener,
FocusListener,
ColorEditable {
    protected Checkbox showing_cb;
    protected TextField spacing_tf;
    protected TextField width_tf;
    protected Choice color_ch;
    protected Button color_bt;
    static String[] color_names = new String[]{"Black", "Blue", "Cyan", "DarkGray", "Gray", "Green", "LightGray", "LightBlue", "Magenta", "Orange", "Pink", "Red", "Yellow", "White", "Custom"};
    static Color[] color_vals;
    AxisGridWrapper wrap = null;
    static Frame dialogFrame;

    static {
        dialogFrame = null;
    }

    public AxisGridEditor() {
        super(MultiChart.AXIS_RADIO_TITLE, MultiChart.AXIS_RADIO_NAMES);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.checkProperties(object);
    }

    public void checkProperties(Object object) {
        try {
            if (object == this.showing_cb) {
                this.wrap.showing[this.radioSel] = this.showing_cb.getState();
                this.support.firePropertyChange("", null, null);
            } else if (object == this.spacing_tf) {
                this.setDoubleIsDefProperty(this.spacing_tf.getText(), this.wrap.spacing, this.wrap.spacing_isdef, this.radioSel);
                this.switchValues(this.radioSel);
            } else if (object == this.width_tf) {
                this.setIntProperty(this.width_tf.getText(), this.wrap.width, this.radioSel, this.wrap.width_def);
                this.switchValues(this.radioSel);
            } else if (object == this.color_ch) {
                int n = this.color_ch.getSelectedIndex();
                Color color = JCUtilConverter.toColor(color_names[n]);
                if (color != null) {
                    this.selectColor(color, null);
                }
            } else if (object == this.color_bt) {
                ColorDialog colorDialog = new ColorDialog(this, JCChartBundle.string("jclass.chart.Key209"), null);
                colorDialog.show();
            }
        }
        catch (Exception exception) {}
    }

    public Frame findParent() {
        Container container = this;
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        if (container == null) {
            if (dialogFrame == null) {
                dialogFrame = new Frame();
            }
            container = dialogFrame;
        }
        return (Frame)container;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        this.checkProperties(object);
    }

    public Color getColor(Component component) {
        return this.wrap.color[this.radioSel];
    }

    public String getJavaInitializationString() {
        return "new jclass.chart.AxisGridWrapper(" + this.wrap + ")";
    }

    public Object getValue() {
        return this.wrap;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        this.checkProperties(object);
    }

    public static void main(String[] stringArray) {
        Frame frame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            frame = (Frame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            frame = new Frame();
        }
        serializable = new AxisGridEditor();
        ((Component)serializable).setBackground(Color.lightGray);
        AxisGridWrapper axisGridWrapper = new AxisGridWrapper(4);
        ((AxisGridEditor)serializable).setValue(axisGridWrapper);
        frame.add((Component)serializable);
        frame.pack();
        Dimension dimension = ((Container)serializable).getPreferredSize();
        ((Component)frame).setSize(dimension.width + 100, dimension.height + 50);
        frame.show();
    }

    protected Panel makePropertyPanel() {
        GroupPanel groupPanel = new GroupPanel(JCChartBundle.string("jclass.chart.Key205"));
        groupPanel.setLayout(new GridLayout(2, 1));
        GroupPanel groupPanel2 = new GroupPanel(JCChartBundle.string("jclass.chart.Key198"));
        groupPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.gridx = -1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
        this.color_ch = new Choice();
        this.setEnumArrays();
        int n = 0;
        while (n < color_names.length) {
            this.color_ch.addItem(color_names[n]);
            ++n;
        }
        Label label = new Label(JCChartBundle.string("jclass.chart.Key206"));
        Label label2 = new Label(JCChartBundle.string("jclass.chart.Key190"));
        this.color_bt = new Button(JCChartBundle.string("jclass.chart.Key186"));
        this.width_tf = new TextField(5);
        this.showing_cb = new Checkbox(JCChartBundle.string("jclass.chart.Key191"));
        Label label3 = new Label(JCChartBundle.string("jclass.chart.Key208"));
        this.spacing_tf = new TextField(5);
        groupPanel2.add((Component)label, gridBagConstraints);
        groupPanel2.add((Component)this.color_ch, gridBagConstraints);
        groupPanel2.add((Component)this.color_bt, gridBagConstraints);
        groupPanel2.add((Component)label2, gridBagConstraints);
        groupPanel2.add((Component)this.width_tf, gridBagConstraints);
        panel.add((Component)this.showing_cb, gridBagConstraints2);
        panel.add((Component)label3, gridBagConstraints2);
        panel.add((Component)this.spacing_tf, gridBagConstraints2);
        groupPanel.add(panel);
        groupPanel.add(groupPanel2);
        this.add("Center", groupPanel);
        this.showing_cb.addItemListener(this);
        this.spacing_tf.addActionListener(this);
        this.spacing_tf.addFocusListener(this);
        this.width_tf.addActionListener(this);
        this.width_tf.addFocusListener(this);
        this.color_ch.addItemListener(this);
        this.color_bt.addActionListener(this);
        return groupPanel;
    }

    public Dimension preferredSize() {
        Dimension dimension = super.preferredSize();
        dimension.width = Math.max(dimension.width, 500);
        dimension.height += 200;
        return dimension;
    }

    public void selectColor(Color color, Component component) {
        this.wrap.color[this.radioSel] = color;
        this.support.firePropertyChange("", null, null);
        this.switchValues(this.radioSel);
    }

    protected void setEnumArrays() {
        color_vals = new Color[color_names.length - 1];
        int n = 0;
        while (n < color_names.length - 1) {
            AxisGridEditor.color_vals[n] = JCUtilConverter.toColor(color_names[n]);
            ++n;
        }
    }

    public void setValue(Object object) {
        this.wrap = (AxisGridWrapper)object;
        if (this.wrap == null) {
            this.wrap = new AxisGridWrapper();
        }
        Checkbox checkbox = this.radioG.getSelectedCheckbox();
        this.switchItem(checkbox);
    }

    protected void switchValues(int n) {
        if (n < 0 || this.wrap == null) {
            return;
        }
        this.showing_cb.setState(this.wrap.showing[n]);
        if (this.wrap.spacing[n] != Double.MAX_VALUE) {
            this.spacing_tf.setText(String.valueOf(this.wrap.spacing[n]));
        } else {
            this.spacing_tf.setText("");
        }
        this.width_tf.setText(String.valueOf(this.wrap.width[n]));
        boolean bl = false;
        if (this.wrap.color[n] == null) {
            this.color_ch.select(0);
        } else {
            int n2 = 0;
            while (n2 < color_vals.length) {
                if (this.wrap.color[n].equals(color_vals[n2])) {
                    this.color_ch.select(n2);
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                this.color_ch.select(this.color_ch.getItemCount() - 1);
            }
        }
    }
}

