/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart.bean;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import jclass.chart.AppearanceWrapper;
import jclass.chart.ChartRegion;
import jclass.chart.JCChartBundle;
import jclass.chart.bean.BaseEditor;
import jclass.chart.bean.ColorDialog;
import jclass.chart.bean.ColorEditable;
import jclass.chart.bean.DisabledDialog;
import jclass.chart.bean.GroupPanel;
import jclass.util.JCUtilConverter;

public class AppearanceEditor
extends BaseEditor
implements ItemListener,
ActionListener,
FocusListener,
ColorEditable {
    protected Choice background_ch;
    protected Button background_bt;
    protected Choice foreground_ch;
    protected Button foreground_bt;
    protected Checkbox showing_cb;
    protected Choice bordertype_ch;
    protected TextField borderwidth_tf;
    protected Checkbox axisbounding_cb;
    protected GroupPanel this_pn;
    protected GroupPanel border_pn;
    String[] bordertype_names;
    int[] bordertype_vals;
    static String[] color_names = new String[]{"Black", "Blue", "Cyan", "DarkGray", "Gray", "Green", "LightGray", "LightBlue", "Magenta", "Orange", "Pink", "Red", "Yellow", "White", "Custom"};
    static Color[] color_vals;
    AppearanceWrapper wrap = null;
    static Frame dialogFrame;

    static {
        dialogFrame = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.checkProperties(object);
    }

    public void checkProperties(Object object) {
        try {
            if (object == this.showing_cb) {
                this.wrap.showing = this.showing_cb.getState();
                this.support.firePropertyChange("", null, null);
            } else if (object == this.axisbounding_cb) {
                this.wrap.axisbounding = this.axisbounding_cb.getState();
                this.support.firePropertyChange("", null, null);
            } else if (object == this.borderwidth_tf) {
                String string = this.borderwidth_tf.getText();
                if (string != null && string.length() > 0) {
                    this.wrap.borderwidth = Integer.valueOf(string);
                } else {
                    this.wrap.borderwidth = this.wrap.bw_def;
                    this.switchValues();
                }
                this.support.firePropertyChange("", null, null);
            } else if (object == this.bordertype_ch) {
                int n = this.bordertype_ch.getSelectedIndex();
                boolean bl = false;
                if (this.bordertype_names[n].indexOf(JCChartBundle.string("jclass.chart.Key183")) >= 0) {
                    DisabledDialog disabledDialog = new DisabledDialog(this, JCChartBundle.string("jclass.chart.Key194"));
                    disabledDialog.show();
                    int n2 = 0;
                    while (n2 < this.bordertype_vals.length) {
                        if (this.bordertype_vals[n2] == this.wrap.bordertype) {
                            bl = true;
                            n = n2;
                            break;
                        }
                        ++n2;
                    }
                    if (bl) {
                        this.bordertype_ch.select(n);
                    }
                } else {
                    this.wrap.bordertype = this.bordertype_vals[this.bordertype_ch.getSelectedIndex()];
                    this.support.firePropertyChange("", null, null);
                }
            } else if (object == this.background_ch) {
                int n = this.background_ch.getSelectedIndex();
                Color color = JCUtilConverter.toColor(color_names[n]);
                if (color != null) {
                    this.selectColor(color, this.background_bt);
                }
            } else if (object == this.foreground_ch) {
                int n = this.foreground_ch.getSelectedIndex();
                Color color = JCUtilConverter.toColor(color_names[n]);
                if (color != null) {
                    this.selectColor(color, this.foreground_bt);
                }
            } else if (object == this.background_bt) {
                ColorDialog colorDialog = new ColorDialog(this, JCChartBundle.string("jclass.chart.Key185"), this.background_bt);
                colorDialog.show();
            } else if (object == this.foreground_bt) {
                ColorDialog colorDialog = new ColorDialog(this, JCChartBundle.string("jclass.chart.Key187"), this.foreground_bt);
                colorDialog.show();
            }
        }
        catch (Exception exception) {}
    }

    public Frame findParent() {
        Container container = this;
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        if (container == null) {
            if (dialogFrame == null) {
                dialogFrame = new Frame();
            }
            container = dialogFrame;
        }
        return (Frame)container;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        this.checkProperties(object);
    }

    public Color getColor(Component component) {
        if (component == this.background_bt) {
            return this.wrap.background;
        }
        if (component == this.foreground_bt) {
            return this.wrap.foreground;
        }
        return Color.black;
    }

    public String getJavaInitializationString() {
        return "new jclass.chart.AppearanceWrapper(" + this.wrap + ")";
    }

    protected String getLiteMessage() {
        return JCChartBundle.string("jclass.chart.Key193");
    }

    public Object getValue() {
        return this.wrap;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        this.checkProperties(object);
    }

    public static void main(String[] stringArray) {
        Frame frame;
        Serializable serializable;
        try {
            serializable = Class.forName("jclass.chart.customizer.swing.JCustomizerCustomFrame");
            frame = (Frame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            frame = new Frame();
        }
        serializable = new AppearanceEditor();
        ((Component)serializable).setBackground(Color.lightGray);
        AppearanceWrapper appearanceWrapper = new AppearanceWrapper("blue", "30-108-92", true, "", 3, true);
        ((AppearanceEditor)serializable).setValue(appearanceWrapper);
        frame.add((Component)serializable);
        frame.pack();
        Dimension dimension = ((Container)serializable).getPreferredSize();
        ((Component)frame).setSize(dimension.width + 100, dimension.height + 50);
        frame.show();
    }

    protected Panel makePropertyPanel() {
        GroupPanel groupPanel = new GroupPanel(JCChartBundle.string("jclass.chart.Key184"));
        groupPanel.setLayout(new GridLayout(3, 1));
        this.background_ch = new Choice();
        this.foreground_ch = new Choice();
        this.bordertype_ch = new Choice();
        this.setEnumArrays();
        int n = 0;
        while (n < this.bordertype_names.length) {
            this.bordertype_ch.addItem(this.bordertype_names[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < color_names.length) {
            this.background_ch.addItem(color_names[n2]);
            this.foreground_ch.addItem(color_names[n2]);
            ++n2;
        }
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1));
        GroupPanel groupPanel2 = new GroupPanel(JCChartBundle.string("jclass.chart.Key185"));
        groupPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        groupPanel2.add((Component)this.background_ch, gridBagConstraints);
        this.background_bt = new Button(JCChartBundle.string("jclass.chart.Key186"));
        groupPanel2.add((Component)this.background_bt, gridBagConstraints);
        GroupPanel groupPanel3 = new GroupPanel(JCChartBundle.string("jclass.chart.Key187"));
        groupPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridx = -1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
        groupPanel3.add((Component)this.foreground_ch, gridBagConstraints2);
        this.foreground_bt = new Button(JCChartBundle.string("jclass.chart.Key186"));
        groupPanel3.add((Component)this.foreground_bt, gridBagConstraints2);
        panel.add(groupPanel2);
        panel.add(groupPanel3);
        groupPanel.add(panel);
        GroupPanel groupPanel4 = new GroupPanel(JCChartBundle.string("jclass.chart.Key188"));
        groupPanel4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.gridx = -1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
        Label label = new Label(JCChartBundle.string("jclass.chart.Key189"));
        Label label2 = new Label(JCChartBundle.string("jclass.chart.Key190"));
        this.borderwidth_tf = new TextField(5);
        groupPanel4.add((Component)label, gridBagConstraints3);
        groupPanel4.add((Component)this.bordertype_ch, gridBagConstraints3);
        ++gridBagConstraints3.gridy;
        groupPanel4.add((Component)label2, gridBagConstraints3);
        groupPanel4.add((Component)this.borderwidth_tf, gridBagConstraints3);
        this.border_pn = groupPanel4;
        groupPanel.add(groupPanel4);
        Panel panel2 = new Panel();
        this.showing_cb = new Checkbox(JCChartBundle.string("jclass.chart.Key191"));
        this.axisbounding_cb = new Checkbox(JCChartBundle.string("jclass.chart.Key192"));
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridx = -1;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
        panel2.add((Component)this.showing_cb, gridBagConstraints4);
        ++gridBagConstraints4.gridy;
        panel2.add((Component)this.axisbounding_cb, gridBagConstraints4);
        groupPanel.add(panel2);
        this.add("Center", groupPanel);
        this.showing_cb.addItemListener(this);
        this.axisbounding_cb.addItemListener(this);
        this.borderwidth_tf.addActionListener(this);
        this.borderwidth_tf.addFocusListener(this);
        this.bordertype_ch.addItemListener(this);
        this.background_ch.addItemListener(this);
        this.background_bt.addActionListener(this);
        this.foreground_ch.addItemListener(this);
        this.foreground_bt.addActionListener(this);
        this.this_pn = groupPanel;
        return groupPanel;
    }

    public Dimension preferredSize() {
        Dimension dimension = super.preferredSize();
        dimension.width = Math.max(dimension.width, 200);
        dimension.height += 350;
        return dimension;
    }

    public void selectColor(Color color, Component component) {
        if (component == this.background_bt) {
            this.wrap.background = color;
            this.support.firePropertyChange("", null, null);
            this.switchValues();
        } else if (component == this.foreground_bt) {
            this.wrap.foreground = color;
            this.support.firePropertyChange("", null, null);
            this.switchValues();
        }
    }

    protected void setEnumArrays() {
        this.bordertype_names = new String[ChartRegion.border_strings.length];
        System.arraycopy(ChartRegion.border_strings, 0, this.bordertype_names, 0, ChartRegion.border_strings.length);
        this.bordertype_vals = ChartRegion.border_values;
        String string = JCChartBundle.string("jclass.chart.Key183");
        int n = 0;
        while (n < this.bordertype_vals.length) {
            if (this.bordertype_vals[n] != 0 && this.bordertype_vals[n] != 5 && this.bordertype_vals[n] != 3 && this.bordertype_vals[n] != 6 && this.bordertype_vals[n] != 1 && this.bordertype_names[n].indexOf(string) < 0) {
                int n2 = n;
                this.bordertype_names[n2] = String.valueOf(this.bordertype_names[n2]) + " - " + string;
            }
            ++n;
        }
        color_vals = new Color[color_names.length - 1];
        int n3 = 0;
        while (n3 < color_names.length - 1) {
            AppearanceEditor.color_vals[n3] = JCUtilConverter.toColor(color_names[n3]);
            ++n3;
        }
    }

    public void setValue(Object object) {
        this.wrap = (AppearanceWrapper)object;
        if (this.wrap == null) {
            this.wrap = new AppearanceWrapper();
        }
        this.switchValues();
    }

    protected void switchValues() {
        int n;
        int n2;
        if (this.wrap == null) {
            return;
        }
        this.this_pn.setLabel(String.valueOf(this.wrap.prefix) + " " + JCChartBundle.string("jclass.chart.Key184"));
        if (this.wrap.thisobj == 0 || this.wrap.thisobj == -1) {
            this.showing_cb.setState(this.wrap.showing);
            this.showing_cb.show();
        } else {
            this.showing_cb.setState(true);
            this.showing_cb.hide();
        }
        if (this.wrap.thisobj == 1) {
            this.axisbounding_cb.show();
            this.axisbounding_cb.setState(this.wrap.axisbounding);
            this.borderwidth_tf.setText(" ");
            this.border_pn.hide();
        } else {
            this.axisbounding_cb.setState(true);
            this.axisbounding_cb.hide();
            this.border_pn.show();
            this.borderwidth_tf.setText(String.valueOf(this.wrap.borderwidth));
            n2 = 0;
            while (n2 < this.bordertype_vals.length) {
                if (this.wrap.bordertype == this.bordertype_vals[n2]) {
                    this.bordertype_ch.select(n2);
                    break;
                }
                ++n2;
            }
        }
        n2 = 0;
        if (this.wrap.background == null) {
            this.background_ch.select(0);
        } else {
            n = 0;
            while (n < color_vals.length) {
                if (this.wrap.background.equals(color_vals[n])) {
                    this.background_ch.select(n);
                    n2 = 1;
                    break;
                }
                ++n;
            }
            if (n2 == 0) {
                this.background_ch.select(this.background_ch.getItemCount() - 1);
            }
        }
        n2 = 0;
        if (this.wrap.foreground == null) {
            this.foreground_ch.select(0);
        } else {
            n = 0;
            while (n < color_vals.length) {
                if (this.wrap.foreground.equals(color_vals[n])) {
                    this.foreground_ch.select(n);
                    n2 = 1;
                    break;
                }
                ++n;
            }
            if (n2 == 0) {
                this.foreground_ch.select(this.foreground_ch.getItemCount() - 1);
            }
        }
    }
}

