/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import jclass.chart.BarPoint;
import jclass.chart.ChartDraw;
import jclass.chart.ChartDrawUtil;
import jclass.chart.JCBarChartFormat;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCFillStyle;
import jclass.chart.JCLineStyle;
import jclass.chart.MinMax;
import jclass.chart.SBarVal;

class SBarChartDraw
extends ChartDraw {
    public static final int OUTLINE_SENSITIVITY = 3;
    Point firstLast = null;
    Color outlineColor = Color.black;
    int x_reversed = 0;
    int y_reversed = 0;
    int delta_x = 0;
    int delta_y = 0;
    boolean is_3d = false;
    double xAxisPos = Double.MAX_VALUE;
    double[] xGridLineList = null;
    JCLineStyle gridLineStyle = null;
    boolean fastAction = false;
    boolean inAction = false;
    double yOrigin = 0.0;
    BarPoint[][] pts = null;
    double bar_base;
    int left;
    int right;
    int top;
    int bottom;
    int height;
    MinMax x;
    MinMax y;
    MinMax datax;
    MinMax datay;
    boolean is_100_percent;
    boolean drawOutline = true;
    SBarVal[][] set_pos;
    SBarVal[][] set_neg;
    double[] ytotal;
    double[] ysum;
    double[] ysum_neg;
    double[][] ywork;
    int opp_x;
    int opp_y;
    Rectangle r = null;
    boolean editInverted = false;
    Point start = null;
    Point end = null;

    void DrawBarFace(Graphics graphics, Point[] pointArray, int n, boolean bl, boolean bl2) {
        JCFillStyle jCFillStyle = this.seriesList[n].getStyle().getFillStyle();
        int n2 = this.chartArea.deltaX;
        int n3 = this.chartArea.deltaY;
        boolean bl3 = bl && n3 <= 0 || !bl && n2 <= 0;
        Polygon polygon = new Polygon();
        int n4 = 0;
        while (n4 < pointArray.length) {
            if (n4 == 0) {
                polygon.addPoint(pointArray[n4].x, pointArray[n4].y);
            } else {
                polygon.addPoint(polygon.xpoints[n4 - 1] + pointArray[n4].x, polygon.ypoints[n4 - 1] + pointArray[n4].y);
            }
            ++n4;
        }
        if (bl3) {
            if (bl2) {
                jCFillStyle.fillOutlinePolygonHighlight(graphics, polygon, this.outlineColor);
            } else {
                jCFillStyle.fillPolygonHighlight(graphics, polygon);
            }
        } else if (bl2) {
            jCFillStyle.fillOutlinePolygonShadow(graphics, polygon, this.outlineColor);
        } else {
            jCFillStyle.fillPolygonShadow(graphics, polygon);
        }
    }

    private Point[] copyPointArray(Point[] pointArray) {
        int n = pointArray.length;
        Point[] pointArray2 = new Point[n];
        int n2 = 0;
        while (n2 < n) {
            pointArray2[n2] = new Point(pointArray[n2].x, pointArray[n2].y);
            ++n2;
        }
        return pointArray2;
    }

    public void draw(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (this.pts == null) {
            return;
        }
        int n4 = this.seriesList.length;
        if (n4 == 0 || this.firstLast == null) {
            return;
        }
        int n5 = this.firstLast.y - this.firstLast.x + 1;
        if (this.is_3d || this.is_100_percent) {
            boolean bl = false;
            boolean bl2 = false;
            int n6 = 0;
            if (this.opp_x != 0) {
                n3 = this.firstLast.y;
                n2 = -1;
                n = n3 < this.firstLast.x ? 0 : 1;
                n6 = this.xGridLineList.length - 1;
            } else {
                n3 = this.firstLast.x;
                n2 = 1;
                n = n3 > this.firstLast.y ? 0 : 1;
                n6 = 0;
            }
            int n7 = n3;
            while (n != 0) {
                int n8;
                int n9;
                SBarVal[][] sBarValArray;
                n = this.opp_x != 0 ? (n7 <= this.firstLast.x ? 0 : 1) : (n7 >= this.firstLast.y ? 0 : 1);
                int n10 = n7 - this.firstLast.x;
                if (!this.fastAction || !this.inAction) {
                    sBarValArray = null;
                    n9 = this.set_neg[n10].length - 1;
                    while (n9 >= 0) {
                        if (this.set_neg[n10][n9] != null) {
                            n8 = this.set_neg[n10][n9].nset_index;
                            BarPoint barPoint = null;
                            try {
                                barPoint = this.pts[n10][n8];
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                            if (barPoint != null) {
                                sBarValArray = barPoint;
                                break;
                            }
                        }
                        --n9;
                    }
                    if (sBarValArray == null) {
                        n8 = 0;
                        while (n8 < this.set_pos[n10].length && this.set_pos[n10][n8] != null) {
                            int n11 = this.set_pos[n10][n8].nset_index;
                            BarPoint barPoint = null;
                            try {
                                barPoint = this.pts[n10][n11];
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                            if (barPoint != null) {
                                sBarValArray = barPoint;
                            }
                            ++n8;
                        }
                    }
                    if (sBarValArray != null) {
                        n8 = 0;
                        int n12 = 0;
                        if (this.inverted) {
                            n12 = sBarValArray.front.y + sBarValArray.front.height;
                            n8 = sBarValArray.front.y;
                        } else {
                            n8 = sBarValArray.front.x;
                            n12 = sBarValArray.front.x + sBarValArray.front.width;
                        }
                        if (!bl) {
                            int n13 = this.tryDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, n8, n12);
                            if (n13 == 1) {
                                bl = true;
                            } else if (n13 == 2) {
                                bl2 = true;
                                bl = true;
                            }
                        }
                        if (this.xaxis.gridIsShowing) {
                            n6 = this.drawXAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.xaxis, this.y_reversed, this.xAxisPos, n8, n12, this.ysum[n10], this.ysum_neg[n10], this.xGridLineList, n6, n2, this.gridLineStyle);
                        }
                    }
                }
                sBarValArray = this.opp_y != 0 ? this.set_pos : this.set_neg;
                n9 = sBarValArray[n10].length - 1;
                while (n9 >= 0) {
                    if (sBarValArray[n10][n9] != null) {
                        n8 = sBarValArray[n10][n9].nset_index;
                        BarPoint barPoint = null;
                        try {
                            barPoint = this.pts[n10][n8];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        if (barPoint != null && this.seriesList[n8].getStyle().getFillStyle().getImage() == null) {
                            if (this.inverted) {
                                this.DrawBarFace(graphics, barPoint.top, n8, true, this.drawOutline);
                                this.DrawBarFace(graphics, barPoint.side, n8, false, this.drawOutline);
                            } else {
                                this.DrawBarFace(graphics, barPoint.side, n8, false, this.drawOutline);
                                this.DrawBarFace(graphics, barPoint.top, n8, true, this.drawOutline);
                            }
                        }
                    }
                    --n9;
                }
                sBarValArray = this.opp_y != 0 ? this.set_neg : this.set_pos;
                n8 = 0;
                while (n8 < sBarValArray[n10].length && sBarValArray[n10][n8] != null) {
                    int n14 = sBarValArray[n10][n8].nset_index;
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n10][n14];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    if (barPoint != null && this.seriesList[n14].getStyle().getFillStyle().getImage() == null) {
                        if (this.inverted) {
                            this.DrawBarFace(graphics, barPoint.top, n14, true, this.drawOutline);
                            this.DrawBarFace(graphics, barPoint.side, n14, false, this.drawOutline);
                        } else {
                            this.DrawBarFace(graphics, barPoint.side, n14, false, this.drawOutline);
                            this.DrawBarFace(graphics, barPoint.top, n14, true, this.drawOutline);
                        }
                    }
                    ++n8;
                }
                if (bl2) {
                    this.finishDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, this.y_reversed, this.ysum_neg[n10], this.ysum[n10]);
                    bl2 = false;
                }
                n7 += n2;
            }
            if (!this.fastAction || !this.inAction) {
                this.finalDrawAxisTroughGrid(graphics, this.xaxis, this.yaxis, this.opp_x, bl, this.xGridLineList, n6, n2, this.gridLineStyle);
            }
        }
        n3 = this.firstLast.x;
        while (n3 <= this.firstLast.y) {
            if (this.seriesList.length == 0) break;
            n2 = n3 - this.firstLast.x;
            n = 0;
            while (n < this.seriesList.length) {
                if (this.seriesList[n].isShowing && this.seriesList[n].isIncluded) {
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n2][n];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    JCChartStyle jCChartStyle = this.seriesList[n].getStyle();
                    if (barPoint != null && barPoint.front != null) {
                        if (this.seriesList[n].getStyle().getFillStyle().getImage() != null) {
                            jCChartStyle.getFillStyle().fillImageRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, barPoint.y >= 0.0, this.inverted);
                        } else if (this.drawOutline) {
                            jCChartStyle.getFillStyle().fillOutlineRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, this.outlineColor);
                        } else {
                            jCChartStyle.getFillStyle().fillRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height);
                        }
                    }
                }
                ++n;
            }
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    int endEdit(JCDataIndex var1_1, int var2_2, int var3_3) {
        block4: {
            block3: {
                if (var1_1 == null || var1_1.dataView != this.dataObject) {
                    return -1;
                }
                this.chartArea.drawRubberBand(this.end, this.start);
                var4_4 = this.pts[var1_1.point - this.firstLast.x][var1_1.series.drawingOrder];
                var5_5 = this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront);
                if (!this.editInverted) break block3;
                if (var4_4.front.x >= var5_5) ** GOTO lbl-1000
                v0 = false;
                break block4;
            }
            if (var4_4.front.y < var5_5) ** GOTO lbl-1000
            v0 = false;
        }
        if (v0) lbl-1000:
        // 3 sources

        {
            var6_6 = this.editInverted != false ? var2_2 - this.r.x - var4_4.front.x : var4_4.front.y + var4_4.front.height - (var3_3 - this.r.y);
        } else {
            var6_6 = this.editInverted != false ? var2_2 - this.r.x - (var4_4.front.x + var4_4.front.width) : var4_4.front.y - (var3_3 - this.r.y);
        }
        var7_7 = this.editInverted != false ? var5_5 + var6_6 : var5_5 - var6_6;
        return var7_7;
    }

    JCDataIndex pick(Point point, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        point.x -= rectangle.x;
        point.y -= rectangle.y;
        int n6 = -1;
        int n7 = -1;
        JCDataIndex jCDataIndex = null;
        int n8 = Integer.MAX_VALUE;
        int n9 = this.chartArea.deltaX;
        int n10 = this.chartArea.deltaY;
        boolean bl = n9 != 0 || n10 != 0;
        int n11 = this.seriesList.length;
        if (n11 == 0 || this.firstLast == null || this.pts == null) {
            return null;
        }
        int n12 = this.firstLast.y - this.firstLast.x + 1;
        if (bl || this.is_100_percent) {
            if (this.opp_x != 0) {
                n5 = this.firstLast.y;
                n4 = -1;
                n3 = n5 < this.firstLast.x ? 0 : 1;
            } else {
                n5 = this.firstLast.x;
                n4 = 1;
                n3 = n5 > this.firstLast.y ? 0 : 1;
            }
            int n13 = n5;
            while (n3 != 0) {
                n3 = this.opp_x != 0 ? (n13 <= this.firstLast.x ? 0 : 1) : (n13 >= this.firstLast.y ? 0 : 1);
                n2 = n13 - this.firstLast.x;
                BarPoint[] barPointArray = this.pts[n2];
                int n14 = 0;
                while (n14 < this.seriesList.length) {
                    if (barPointArray[n14] != null) {
                        int n15 = JCChartUtil.distanceTo3dPolygon(point.x, point.y, barPointArray[n14].top, this.inverted, n);
                        int n16 = JCChartUtil.distanceTo3dPolygon(point.x, point.y, barPointArray[n14].side, this.inverted, n);
                        if (n15 <= n8 || n16 <= n8) {
                            n6 = n14;
                            n7 = n13;
                            n8 = Math.min(n16, n15);
                        }
                    }
                    ++n14;
                }
                n13 += n4;
            }
        }
        n5 = this.firstLast.x;
        while (n5 <= this.firstLast.y) {
            n4 = n5 - this.firstLast.x;
            if (this.pts[n4] != null) {
                n3 = 0;
                while (n3 < this.pts[n4].length) {
                    if (this.seriesList[n3].isShowing) {
                        BarPoint barPoint = null;
                        try {
                            barPoint = this.pts[n4][n3];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        if (barPoint != null && barPoint.x != this.holeValue && barPoint.y != this.holeValue && barPoint.front != null && (n2 = JCChartUtil.distance(point.x, point.y, barPoint.front)) <= n8) {
                            n6 = n3;
                            n7 = n5;
                            n8 = n2;
                        }
                    }
                    ++n3;
                }
            }
            ++n5;
        }
        if (n6 >= 0 && n7 >= 0) {
            jCDataIndex = new JCDataIndex(n7, this.seriesList[n6], n6);
            jCDataIndex.distance = n8;
        }
        return jCDataIndex;
    }

    public void recalc() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        double d;
        double d2;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        block58: {
            super.recalc();
            JCBarChartFormat jCBarChartFormat = this.dataObject.getBarChartFormat();
            this.is_100_percent = jCBarChartFormat.get100Percent();
            if (jCBarChartFormat == null || jCBarChartFormat.clusterWidth == 0) {
                return;
            }
            this.outlineColor = this.dataObject.getOutlineColor();
            this.holeValue = this.dataObject.holeValue;
            this.datax = new MinMax(this.dataObject.xLimits.min, this.dataObject.xLimits.max);
            this.datay = new MinMax(this.dataObject.yLimits.min, this.dataObject.yLimits.max);
            this.dataObject.getDataBounds(this.datax, this.datay);
            this.xaxis = this.dataObject.xaxis;
            this.yaxis = this.dataObject.yaxis;
            this.bar_base = this.xaxis.step * (double)jCBarChartFormat.clusterWidth / 100.0;
            this.inverted = this.xaxis.isVertical;
            this.x = new MinMax();
            this.y = new MinMax();
            this.x.min = this.datax.min - this.bar_base / 2.0;
            this.x.max = this.datax.max + this.bar_base / 2.0;
            this.xaxis.setLimits(this.x);
            this.xaxis.calcTransformation();
            this.xaxis.layoutAnnotations();
            this.xaxis.checkAnnotations();
            this.x = this.xaxis.dataLimits;
            this.y = this.yaxis.dataLimits;
            this.drawOutline = Math.abs(this.xaxis.toPixel(this.xaxis.min.value + this.bar_base, this.drawFront) - this.xaxis.toPixel(this.xaxis.min.value, this.drawFront)) > 3;
            int n14 = this.inverted ? this.yaxis.getWidth() : this.xaxis.getHeight();
            int n15 = this.inverted ? this.xaxis.getWidth() : this.yaxis.getHeight();
            this.left = this.inverted ? this.yaxis.getLeft() : this.xaxis.getLeft();
            this.right = this.left + n14 - 1;
            int n16 = this.inverted ? this.xaxis.getTop() : this.yaxis.getTop();
            int n17 = n16 + n15 - 1;
            this.yOrigin = this.yaxis.origin.value;
            n13 = this.yaxis.toPixel(this.yOrigin, this.drawFront);
            this.firstLast = this.dataObject.getFirstLast();
            this.x_reversed = this.xaxis.isReversed ? 1 : 0;
            this.y_reversed = this.yaxis.isReversed ? 1 : 0;
            this.delta_x = this.chartArea.deltaX;
            this.delta_y = this.chartArea.deltaY;
            this.is_3d = this.delta_x != 0 || this.delta_y != 0;
            this.seriesList = this.dataObject.getSeries();
            int n18 = this.seriesList.length;
            if (n18 == 0 || this.firstLast == null) {
                return;
            }
            int n19 = this.firstLast.y - this.firstLast.x + 1;
            this.fastAction = this.chartArea.fastAction;
            this.inAction = this.chartArea.inAction;
            if (!this.fastAction || !this.inAction) {
                this.xAxisPos = this.xaxis.getRealPlacementLocation();
                this.xGridLineList = this.xaxis.getGridLineList();
                if (this.xGridLineList == null) {
                    this.xGridLineList = new double[0];
                }
                this.gridLineStyle = this.xaxis.getGridStyle().getLineStyle();
            }
            this.set_pos = new SBarVal[n19][n18];
            this.set_neg = new SBarVal[n19][n18];
            this.ytotal = new double[n19];
            this.ysum = new double[n19];
            this.ysum_neg = new double[n19];
            this.ywork = new double[n18][n19];
            ChartDrawUtil.calcStackingInfo(this.ysum, this.ysum_neg, this.ytotal, this.ywork, this.firstLast.x, this.firstLast.y, this.seriesList, this.is_100_percent, this.holeValue, this.y, this.yaxis);
            Point[] pointArray = new Point[]{new Point(0, 0), new Point(this.delta_x, this.delta_y), new Point(0, 0), new Point(-this.delta_x, -this.delta_y)};
            Point[] pointArray2 = new Point[]{new Point(0, 0), new Point(this.delta_x, this.delta_y), new Point(0, 0), new Point(-this.delta_x, -this.delta_y)};
            n12 = 0;
            n11 = 0;
            int n20 = 0;
            int n21 = 0;
            n10 = 0;
            n9 = 0;
            this.pts = new BarPoint[this.firstLast.y - this.firstLast.x + 1][n18];
            if (!this.is_3d) break block58;
            if (this.inverted) {
                this.opp_x = (this.delta_y > 0 ? 1 : 0) ^ this.x_reversed;
                this.opp_y = (this.delta_x <= 0 ? 1 : 0) ^ this.y_reversed;
            } else {
                this.opp_x = (this.delta_x <= 0 ? 1 : 0) ^ this.x_reversed;
                this.opp_y = (this.delta_y > 0 ? 1 : 0) ^ this.y_reversed;
            }
            n8 = this.firstLast.x;
            while (n8 <= this.firstLast.y) {
                block59: {
                    int n22;
                    int n23;
                    int n24;
                    SBarVal sBarVal;
                    n7 = n8 - this.firstLast.x;
                    d2 = this.seriesList[0].getX(n8) - this.bar_base / 2.0;
                    d = d2 + this.bar_base;
                    if (d < this.datax.min || d2 > this.datax.max) break block59;
                    if (d2 < this.x.min) {
                        d2 = this.x.min;
                    }
                    if (d > this.x.max) {
                        d = this.x.max;
                    }
                    if (this.inverted) {
                        n11 = this.xaxis.toPixel(d2, this.drawFront);
                        n9 = n11 - this.xaxis.toPixel(d, this.drawFront);
                        pointArray[0].y = n20 = this.opp_x != 0 ? n11 : n11 - n9;
                        pointArray2[0].y = n11 - n9;
                        pointArray2[2].y = n9;
                    } else {
                        n12 = this.xaxis.toPixel(d2, this.drawFront);
                        n10 = this.xaxis.toPixel(d, this.drawFront) - n12;
                        pointArray2[0].x = n21 = this.opp_x != 0 ? n12 : n12 + n10;
                        pointArray[0].x = n12;
                        pointArray[2].x = n10;
                    }
                    n6 = 0;
                    n5 = 0;
                    n4 = n13;
                    n3 = n13;
                    int n25 = 0;
                    n2 = 0;
                    boolean bl = false;
                    n = 0;
                    while (n < n18) {
                        block60: {
                            block62: {
                                block61: {
                                    if (this.ywork[n][n7] == this.holeValue) break block60;
                                    boolean bl2 = bl = this.ywork[n][n7] < 0.0;
                                    if (!bl) break block61;
                                    if (this.ywork[n][n7] > this.y.max) break block60;
                                    n25 = this.yaxis.toPixel(Math.max(this.ywork[n][n7], this.y.min), this.drawFront);
                                    n2 = n3;
                                    break block62;
                                }
                                if (this.ywork[n][n7] < this.y.min) break block60;
                                n25 = this.yaxis.toPixel(Math.min(this.ywork[n][n7], this.y.max), this.drawFront);
                                n2 = n4;
                            }
                            if (this.inverted) {
                                if (bl) {
                                    SBarVal sBarVal2 = new SBarVal();
                                    this.set_neg[n7][n5] = sBarVal2;
                                    sBarVal = sBarVal2;
                                    ++n5;
                                } else {
                                    SBarVal sBarVal3 = new SBarVal();
                                    this.set_pos[n7][n6] = sBarVal3;
                                    sBarVal = sBarVal3;
                                    ++n6;
                                }
                                sBarVal.nset_index = n;
                                sBarVal.side_point0.x = n25;
                                sBarVal.side_point2.x = n2 - n25;
                                sBarVal.top_point.x = this.opp_y == 0 && !bl || this.opp_y != 0 && bl ? n25 : n2;
                            } else {
                                if (bl) {
                                    SBarVal sBarVal4 = new SBarVal();
                                    this.set_neg[n7][n5] = sBarVal4;
                                    sBarVal = sBarVal4;
                                    ++n5;
                                } else {
                                    SBarVal sBarVal5 = new SBarVal();
                                    this.set_pos[n7][n6] = sBarVal5;
                                    sBarVal = sBarVal5;
                                    ++n6;
                                }
                                sBarVal.nset_index = n;
                                sBarVal.side_point0.y = n2;
                                sBarVal.side_point2.y = n25 - n2;
                                sBarVal.top_point.y = this.opp_y == 0 && !bl || this.opp_y != 0 && bl ? n25 : n2;
                            }
                            if (bl) {
                                n3 = n25;
                            } else {
                                n4 = n25;
                            }
                        }
                        ++n;
                    }
                    if (this.opp_y != 0) {
                        n24 = n6 - 1;
                        n23 = n5;
                    } else {
                        n24 = n5 - 1;
                        n23 = n6;
                    }
                    BarPoint[] barPointArray = this.pts[n7];
                    int n26 = n24;
                    while (n26 >= 0) {
                        sBarVal = this.opp_y != 0 ? this.set_pos[n7][n26] : this.set_neg[n7][n26];
                        n22 = sBarVal.nset_index;
                        if (barPointArray[n22] == null) {
                            barPointArray[n22] = new BarPoint();
                        }
                        BarPoint barPoint = barPointArray[n22];
                        if (this.inverted) {
                            pointArray[0].x = sBarVal.side_point0.x;
                            pointArray[2].x = sBarVal.side_point2.x;
                            barPoint.top = this.copyPointArray(pointArray);
                            pointArray2[0].x = sBarVal.top_point.x;
                            barPoint.side = this.copyPointArray(pointArray2);
                        } else {
                            pointArray2[0].y = sBarVal.side_point0.y;
                            pointArray2[2].y = sBarVal.side_point2.y;
                            barPoint.side = this.copyPointArray(pointArray2);
                            pointArray[0].y = sBarVal.top_point.y;
                            barPoint.top = this.copyPointArray(pointArray);
                        }
                        --n26;
                    }
                    n22 = 0;
                    while (n22 < n23) {
                        sBarVal = this.opp_y != 0 ? this.set_neg[n7][n22] : this.set_pos[n7][n22];
                        int n27 = sBarVal.nset_index;
                        if (barPointArray[n27] == null) {
                            barPointArray[n27] = new BarPoint();
                        }
                        BarPoint barPoint = barPointArray[n27];
                        if (this.inverted) {
                            pointArray[0].x = sBarVal.side_point0.x;
                            pointArray[2].x = sBarVal.side_point2.x;
                            barPoint.top = this.copyPointArray(pointArray);
                            pointArray2[0].x = sBarVal.top_point.x;
                            barPoint.side = this.copyPointArray(pointArray2);
                        } else {
                            pointArray2[0].y = sBarVal.side_point0.y;
                            pointArray2[2].y = sBarVal.side_point2.y;
                            barPoint.side = this.copyPointArray(pointArray2);
                            pointArray[0].y = sBarVal.top_point.y;
                            barPoint.top = this.copyPointArray(pointArray);
                        }
                        ++n22;
                    }
                }
                ++n8;
            }
            if (this.is_3d) {
                if (this.inverted) {
                    n11 = this.delta_y > 0 ? n16 + n15 - 1 : n16;
                } else {
                    n12 = this.delta_x <= 0 ? this.left : this.right;
                }
            }
        }
        n8 = 1;
        n7 = this.firstLast.x;
        while (n7 <= this.firstLast.y) {
            block63: {
                if (this.seriesList.length == 0) break;
                n6 = n7 - this.firstLast.x;
                d2 = this.seriesList[0].getX(n7) - this.bar_base / 2.0;
                d = d2 + this.bar_base;
                if (d < this.x.min || d2 > this.x.max) break block63;
                if (d2 < this.x.min) {
                    d2 = this.x.min;
                }
                if (d > this.x.max) {
                    d = this.x.max;
                }
                if (this.inverted) {
                    n11 = this.xaxis.toPixel(d2, this.drawFront);
                    n9 = Math.abs(this.xaxis.toPixel(d, this.drawFront) - n11);
                    if (this.x_reversed == 0) {
                        n11 -= n9;
                    }
                } else {
                    n12 = this.xaxis.toPixel(d2, this.drawFront);
                    n10 = Math.abs(this.xaxis.toPixel(d, this.drawFront) - n12);
                    if (this.x_reversed != 0) {
                        n12 -= n10;
                    }
                }
                n5 = n13;
                n4 = n13;
                n3 = 0;
                int n28 = 0;
                BarPoint[] barPointArray = this.pts[n6];
                n2 = 0;
                while (n2 < this.seriesList.length) {
                    block64: {
                        block66: {
                            block65: {
                                if (this.ywork[n2][n6] == this.holeValue) break block64;
                                if (barPointArray[n2] == null) {
                                    barPointArray[n2] = new BarPoint();
                                }
                                BarPoint barPoint = barPointArray[n2];
                                double d3 = this.seriesList[n2].getY(n7);
                                barPoint.x = d2;
                                barPoint.y = d3;
                                int n29 = n = !(this.ywork[n2][n6] < 0.0) ? 0 : 1;
                                if (n == 0) break block65;
                                if (this.ywork[n2][n6] > this.y.max) break block64;
                                n3 = this.yaxis.toPixel(Math.max(this.ywork[n2][n6], this.y.min), this.drawFront);
                                n28 = n4;
                                break block66;
                            }
                            if (this.ywork[n2][n6] < this.y.min) break block64;
                            n3 = this.yaxis.toPixel(Math.min(this.ywork[n2][n6], this.y.max), this.drawFront);
                            n28 = n5;
                        }
                        if (this.inverted) {
                            if ((this.y_reversed ^ (n != 0 ? 1 : 0)) != 0) {
                                n10 = n28 - n3;
                                n12 = n3;
                            } else {
                                n12 = n28;
                                n10 = n3 - n28;
                            }
                        } else if ((this.y_reversed ^ (n != 0 ? 1 : 0)) != 0) {
                            n11 = n28;
                            n9 = n3 - n28;
                        } else {
                            n11 = n3;
                            n9 = n28 - n3;
                        }
                        barPoint.front = new Rectangle(n12, n11, n10, n9);
                        if (n != 0) {
                            n4 = n3;
                        } else {
                            n5 = n3;
                        }
                    }
                    ++n2;
                }
            }
            ++n7;
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[jCDataIndex.point - this.firstLast.x][jCDataIndex.series.drawingOrder];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (barPoint == null) {
            return;
        }
        if (this.start == null || this.end == null) {
            this.start = new Point(0, 0);
            this.end = new Point(0, 0);
        } else {
            this.chartArea.drawRubberBand(this.end, this.start);
        }
        if (this.editInverted) {
            this.start.x = n;
            this.start.y = barPoint.front.y + this.r.y;
            this.end.x = barPoint.front.x + this.r.x;
            this.end.y = barPoint.front.y + this.r.y + barPoint.front.height;
        } else {
            this.start.x = barPoint.front.x + this.r.x;
            this.start.y = n2;
            this.end.x = barPoint.front.x + this.r.x + barPoint.front.width;
            this.end.y = barPoint.front.height + barPoint.front.y + this.r.y;
        }
        this.chartArea.drawRubberBand(this.end, this.start);
    }

    void startEdit(JCDataIndex jCDataIndex) {
        this.r = this.chartArea.getDrawingArea();
        this.editInverted = jCDataIndex.dataView.xaxis.isVertical;
        this.end = null;
        this.start = null;
    }

    Point unpick(int n, int n2) {
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[n - this.firstLast.x][n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (barPoint == null) {
            return null;
        }
        double d = barPoint.y;
        double d2 = barPoint.x;
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            n4 = barPoint.front.y + barPoint.front.height / 2;
            n3 = barPoint.front.x + barPoint.front.width / 2;
            return new Point(n3, n4);
        }
        return null;
    }
}

