/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Graphics;
import jclass.chart.Diamond;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCChart;
import jclass.chart.JCChartBundle;
import jclass.chart.JCShape;
import jclass.chart.JCStyle;
import jclass.chart.Triangle;
import jclass.util.JCUtilConverter;

public class JCSymbolStyle
extends JCStyle
implements HTMLHandler {
    int shape = 1;
    int colorIndex;
    int shapeIndex = 1;
    Color color = null;
    int size = 6;
    JCShape customShape = null;
    public static final int NONE = 0;
    public static final int DOT = 1;
    public static final int BOX = 2;
    public static final int TRIANGLE = 3;
    public static final int DIAMOND = 4;
    public static final int STAR = 5;
    public static final int VERT_LINE = 6;
    public static final int HORIZ_LINE = 7;
    public static final int CROSS = 8;
    public static final int CIRCLE = 9;
    public static final int SQUARE = 10;
    public static final int OTHER = 11;
    public static final int LAST = 10;
    public static final String[] shape_strings = new String[]{"None", "Dot", "Box", "Triangle", "Diamond", "Star", "Vert_Line", "Horiz_Line", "Cross", "Circle", "Square"};
    public static final int[] shape_values;

    static {
        int[] nArray = new int[11];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        shape_values = nArray;
    }

    public JCSymbolStyle(int n, Color color, int n2) {
        this.setShape(n);
        this.color = color;
        this.size = n2;
    }

    public void draw(Graphics graphics, int n, int n2) {
        this.draw(graphics, n, n2, this.size, null);
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        this.draw(graphics, n, n2, n3, null);
    }

    public void draw(Graphics graphics, int n, int n2, int n3, Color color) {
        Color color2 = color != null ? color : this.color;
        graphics.setColor(color2);
        if (this.customShape != null) {
            this.customShape.resize(n3);
            this.customShape.draw(graphics, n, n2);
            return;
        }
        boolean bl = n3 % 2 == 0;
        int n4 = n3 / 2;
        if (bl) {
            n4 = (n3 - 1) / 2;
        }
        int n5 = (int)((double)n3 / 2.8284271247461903);
        switch (this.shape) {
            case 1: {
                graphics.fillOval(n - n3 / 2, n2 - n3 / 2, n3, n3);
                break;
            }
            case 2: {
                graphics.fillRect(n - n3 / 2, n2 - n3 / 2, n3, n3);
                break;
            }
            case 5: {
                graphics.drawLine(n - n3 / 2, n2, n + n4, n2);
                graphics.drawLine(n, n2 - n3 / 2, n, n2 + n4);
                graphics.drawLine(n - n5, n2 - n5, n + n5, n2 + n5);
                graphics.drawLine(n - n5, n2 + n5, n + n5, n2 - n5);
                break;
            }
            case 6: {
                graphics.drawLine(n, n2 - n3 / 2, n, n2 + n4);
                break;
            }
            case 7: {
                graphics.drawLine(n - n3 / 2, n2, n + n4, n2);
                break;
            }
            case 8: {
                graphics.drawLine(n, n2 - n3 / 2, n, n2 + n4);
                graphics.drawLine(n - n3 / 2, n2, n + n4, n2);
                break;
            }
            case 9: {
                graphics.drawArc(n - n3 / 2, n2 - n3 / 2, n3 - 1, n3 - 1, 0, 360);
                break;
            }
            case 10: {
                graphics.drawRect(n - n3 / 2, n2 - n3 / 2, n3 - 1, n3 - 1);
                break;
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, Color color) {
        this.draw(graphics, n, n2, this.size, color);
    }

    public Color getColor() {
        return this.color;
    }

    public JCShape getCustomShape() {
        return this.customShape;
    }

    static Color getDefaultColor(JCChart jCChart) {
        Color color;
        if (jCChart == null) {
            color = JCStyle.defaultColors[0];
        } else {
            color = JCStyle.defaultColors[jCChart.symbolColorIndex++];
            if (jCChart.symbolColorIndex >= JCStyle.defaultColors.length) {
                jCChart.symbolColorIndex = 0;
            }
            if (jCChart != null && jCChart.chartArea != null && color == jCChart.chartArea.getPlotArea().getBackground()) {
                color = JCStyle.defaultColors[jCChart.symbolColorIndex++];
                if (jCChart.symbolColorIndex >= JCStyle.defaultColors.length) {
                    jCChart.symbolColorIndex = 0;
                }
            }
        }
        return color;
    }

    static int getDefaultShape(JCChart jCChart) {
        int n;
        if (jCChart == null) {
            n = 1;
        } else {
            n = jCChart.symbolShapeIndex++;
            if (jCChart.symbolShapeIndex > 10) {
                jCChart.symbolShapeIndex = 1;
            }
        }
        return n;
    }

    public int getShape() {
        return this.shape;
    }

    public int getSize() {
        return this.size;
    }

    public void loadParams(String string, JCChart jCChart) {
        int n;
        String string2 = jCChart.getParam(String.valueOf(string) + ".color");
        if (string2 != null) {
            this.setColor(JCChart.getConverter().toColor(string2));
        } else {
            n = JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".colorIndex"), this.colorIndex);
            if (n != this.colorIndex) {
                this.setColor(JCStyle.defaultColors[n]);
            }
        }
        string2 = jCChart.getParam(String.valueOf(string) + ".shape");
        if (string2 != null) {
            this.setShape(JCChart.getConverter().toEnum(string2, "symbol shape", shape_strings, shape_values, this.shape));
        } else {
            n = JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".shapeIndex"), this.shape);
            if (n != this.shape) {
                this.setShape(shape_values[n]);
            }
        }
        this.setSize(JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".size"), this.getSize()));
    }

    public static JCSymbolStyle makeDefault(JCChart jCChart) {
        JCSymbolStyle jCSymbolStyle = new JCSymbolStyle(JCSymbolStyle.getDefaultShape(jCChart), JCSymbolStyle.getDefaultColor(jCChart), 6);
        int n = 1;
        int n2 = 0;
        if (jCChart != null) {
            n2 = jCChart.getSymbolColorIndex();
            n2 = n2 == 0 ? JCStyle.defaultColors.length - 1 : --n2;
            n = jCChart.getSymbolShapeIndex();
            n = n == 1 ? 10 : --n;
        }
        jCSymbolStyle.colorIndex = n2;
        jCSymbolStyle.shapeIndex = n;
        return jCSymbolStyle;
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        JCSymbolStyle jCSymbolStyle = JCSymbolStyle.makeDefault(null);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".colorIndex", jCSymbolStyle.colorIndex, this.colorIndex);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".color", JCStyle.defaultColors[jCSymbolStyle.colorIndex], this.color);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".shapeIndex", jCSymbolStyle.shapeIndex, this.shapeIndex);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".shape", JCUtilConverter.fromEnum(jCSymbolStyle.shapeIndex, shape_strings, shape_values), JCUtilConverter.fromEnum(this.shapeIndex, shape_strings, shape_values));
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".size", jCSymbolStyle.size, this.size);
    }

    public void setColor(Color color) {
        JCSymbolStyle jCSymbolStyle = this;
        synchronized (jCSymbolStyle) {
            if (this.color == color) {
                Object var3_3 = null;
                return;
            }
            this.color = color;
        }
        this.setChanged(true, 17);
    }

    public void setCustomShape(JCShape jCShape) {
        JCSymbolStyle jCSymbolStyle = this;
        synchronized (jCSymbolStyle) {
            if (this.customShape == jCShape) {
                Object var3_3 = null;
                return;
            }
            this.shape = jCShape == null ? 0 : 11;
            this.customShape = jCShape;
        }
        this.setChanged(true, 17);
    }

    public void setShape(int n) {
        JCSymbolStyle jCSymbolStyle = this;
        synchronized (jCSymbolStyle) {
            if (this.shape == n) {
                Object var3_3 = null;
                return;
            }
            this.shapeIndex = n;
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this.shape = n;
                    this.customShape = null;
                    break;
                }
                case 3: {
                    this.shape = n;
                    this.customShape = new Triangle();
                    break;
                }
                case 4: {
                    this.shape = n;
                    this.customShape = new Diamond();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key77"));
                }
            }
        }
        this.setChanged(true, 17);
    }

    public void setSize(int n) {
        if (this.size == n) {
            return;
        }
        this.size = n;
        this.setChanged(true, 18);
    }
}

