/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.io.Serializable;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCChart;
import jclass.chart.JCChartConverter;

public class JCDataIndex
implements HTMLHandler,
Serializable {
    Object obj = null;
    ChartDataView dataView = null;
    ChartDataViewSeries series = null;
    int seriesIndex = -1;
    int point = -1;
    int distance = Integer.MAX_VALUE;

    public JCDataIndex() {
    }

    public JCDataIndex(int n, ChartDataViewSeries chartDataViewSeries) {
        this.point = n;
        this.series = chartDataViewSeries;
        if (chartDataViewSeries != null) {
            this.seriesIndex = chartDataViewSeries.parent.getSeriesIndex(chartDataViewSeries);
            this.dataView = chartDataViewSeries.parent;
        }
    }

    JCDataIndex(int n, ChartDataViewSeries chartDataViewSeries, int n2) {
        this.point = n;
        this.series = chartDataViewSeries;
        this.seriesIndex = n2;
    }

    public JCDataIndex(ChartDataView chartDataView, ChartDataViewSeries chartDataViewSeries, int n, int n2) {
        this.dataView = chartDataView;
        this.point = n2;
        this.series = chartDataViewSeries;
        this.seriesIndex = n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof JCDataIndex) {
            JCDataIndex jCDataIndex = (JCDataIndex)object;
            return this.dataView == jCDataIndex.dataView && this.seriesIndex == jCDataIndex.seriesIndex && this.point == jCDataIndex.point;
        }
        return false;
    }

    public ChartDataView getDataView() {
        return this.dataView;
    }

    public int getDistance() {
        return this.distance;
    }

    public Object getObject() {
        return this.obj;
    }

    public int getPoint() {
        return this.point;
    }

    public ChartDataViewSeries getSeries() {
        return this.series;
    }

    public int getSeriesIndex() {
        return this.seriesIndex;
    }

    public void loadParams(String string, JCChart jCChart) {
        this.setPoint(JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".point"), this.getPoint()));
        this.setDistance(JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".distance"), this.getDistance()));
        this.setSeriesIndex(JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".seriesIndex"), this.getSeriesIndex()));
        JCChartConverter jCChartConverter = new JCChartConverter();
        this.setDataView(jCChartConverter.toDataView(jCChart, jCChart.getParam(String.valueOf(string) + ".dataView"), this.getDataView()));
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        JCChartConverter jCChartConverter = new JCChartConverter();
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".dataView", jCChartConverter.toDataViewName(this.getDataView().getParent(), this.getDataView().getName(), this.dataView.getName()));
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".seriesIndex", this.getSeriesIndex());
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".point", this.getPoint());
        JCDataIndex jCDataIndex = new JCDataIndex();
        if (this.getDistance() != jCDataIndex.getDistance()) {
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".distance", this.getDistance());
        }
    }

    public void setDataView(ChartDataView chartDataView) {
        this.dataView = chartDataView;
    }

    public void setDistance(int n) {
        this.distance = n;
    }

    public void setObject(Object object) {
        this.obj = object;
    }

    public void setPoint(int n) {
        this.point = n;
    }

    public void setSeries(ChartDataViewSeries chartDataViewSeries) {
        this.series = chartDataViewSeries;
        this.seriesIndex = chartDataViewSeries.parent.getSeriesIndex(chartDataViewSeries);
        this.dataView = chartDataViewSeries.parent;
    }

    public void setSeriesIndex(int n) {
        this.seriesIndex = n;
    }
}

