/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import jclass.chart.ChartRegion;
import jclass.chart.JCAxis;

public class JCChartNumberFormat {
    private static final NumberFormat defaultFormatter = NumberFormat.getInstance(Locale.getDefault());
    private NumberFormat formatter = null;
    private ChartRegion parentRegion = null;
    private static final int MAX_COUNT = 19;

    public JCChartNumberFormat(ChartRegion chartRegion) {
        this.parentRegion = chartRegion;
        this.formatter = defaultFormatter;
    }

    public String localize(String string) {
        String string2 = null;
        int n = this.formatter.getMaximumFractionDigits();
        boolean bl = System.getProperty("java.vendor").indexOf("Microsoft") >= 0;
        this.formatter.setGroupingUsed(this.parentRegion.getGroupingUsed());
        if (this.parentRegion instanceof JCAxis) {
            this.formatter.setMaximumFractionDigits(((JCAxis)this.parentRegion).getPrecision());
        }
        string2 = !bl && this.parentRegion.getNumberLocalization() ? this.parse(string) : string;
        this.formatter.setMaximumFractionDigits(n);
        return string2;
    }

    private String parse(String string) {
        String string2 = new String();
        String string3 = " \t\n\r[]()";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string3.indexOf(string4) >= 0) {
                string2 = String.valueOf(string2) + string4;
                continue;
            }
            try {
                Double d = Double.valueOf(string4);
                int n = this.formatter.getMaximumFractionDigits();
                boolean bl = true;
                String string5 = this.formatter.format(d);
                while ((string5.compareTo("-0") == 0 || string5.compareTo("0") == 0) && d != 0.0) {
                    int n2 = this.formatter.getMaximumFractionDigits() <= 19 ? this.formatter.getMaximumFractionDigits() + 1 : 19;
                    this.formatter.setMaximumFractionDigits(n2);
                    if (n2 == 19) {
                        bl = false;
                        break;
                    }
                    string5 = this.formatter.format(d);
                }
                string2 = bl ? String.valueOf(string2) + string5 : String.valueOf(string2) + string4;
                this.formatter.setMaximumFractionDigits(n);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = String.valueOf(string2) + string4;
            }
        }
        return string2;
    }

    public void setNumberFormatterLocale(Locale locale) {
        this.formatter = NumberFormat.getInstance(locale);
    }
}

