/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import jclass.chart.Changeable;
import jclass.chart.ChartDataView;
import jclass.chart.HTMLHandler;
import jclass.chart.HTMLSaveDriver;
import jclass.chart.JCChart;
import jclass.chart.JCChartBundle;
import jclass.chart.JCChartConverter;
import jclass.chart.JCDataCoord;
import jclass.chart.JCDataIndex;
import jclass.chart.JCTitle;
import jclass.util.JCUtilConverter;

public class JCChartLabel
extends JCTitle
implements Serializable,
HTMLHandler {
    public static final int NORTHEAST = 1;
    public static final int NORTH = 2;
    public static final int NORTHWEST = 3;
    public static final int EAST = 4;
    public static final int WEST = 5;
    public static final int SOUTHEAST = 6;
    public static final int SOUTH = 7;
    public static final int SOUTHWEST = 8;
    public static final int CENTER = 9;
    public static final int AUTO = 10;
    public static final int ATTACH_NONE = 0;
    public static final int ATTACH_COORD = 1;
    public static final int ATTACH_DATACOORD = 2;
    public static final int ATTACH_DATAINDEX = 3;
    public static final int[] attachMethod_values;
    public static final String[] attachMethod_strings;
    public static final int[] anchor_values;
    public static final String[] anchor_strings;
    private static int index_no;
    int anchor = 9;
    int attachMethod = 1;
    int attachX = 0;
    int attachY = 0;
    double dataAttachX = 0.0;
    double dataAttachY = 0.0;
    int offsetX = 0;
    int offsetY = 0;
    JCDataIndex attachDataIndex = null;
    ChartDataView dataView = null;
    boolean isDwellLabel = false;
    int dwellDelay = 0;
    boolean isConnected = false;
    private Point attachBeforeAnchor = null;
    private Point attachPoint = null;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        attachMethod_values = nArray;
        attachMethod_strings = new String[]{"Attach_None", "Attach_Coord", "Attach_Datacoord", "Attach_Dataindex"};
        anchor_values = new int[]{10, 9, 1, 6, 3, 8, 2, 7, 4, 5};
        anchor_strings = new String[]{"Auto", "Center", "Northeast", "Southeast", "Northwest", "Southwest", "North", "South", "East", "West"};
        index_no = 0;
    }

    public JCChartLabel() {
        this.setText("label", false);
        this.isShowing = true;
    }

    public JCChartLabel(String string, boolean bl) {
        this.setText(string, bl);
        this.setParentAxis(null);
        this.isShowing = true;
    }

    public void draw(Graphics graphics) {
        Object object = this.getRegionLock();
        synchronized (object) {
            block7: {
                block9: {
                    block8: {
                        ChartDataView chartDataView = this.getDataView();
                        if (chartDataView == null || chartDataView.getChartType() == 11 || this.attachMethod != 2 && this.attachMethod != 3 || this.attachBeforeAnchor == null) break block7;
                        Rectangle rectangle = this.getChart().getChartArea().plotRect;
                        Rectangle rectangle2 = this.getChart().getChartArea().getDrawingArea();
                        if (this.attachBeforeAnchor.x < rectangle.x + rectangle2.x || this.attachBeforeAnchor.x > rectangle.x + rectangle2.x + rectangle.width || this.attachBeforeAnchor.y < rectangle.y + rectangle2.y) break block8;
                        if (this.attachBeforeAnchor.y <= rectangle.y + rectangle2.y + rectangle.height) break block9;
                    }
                    Object var3_6 = null;
                    return;
                }
                if (this.isConnected && this.attachPoint != null) {
                    graphics.drawLine(this.attachBeforeAnchor.x, this.attachBeforeAnchor.y, this.attachPoint.x + this.getWidth() / 2, this.attachPoint.y + this.getHeight() / 2);
                }
            }
            super.draw(graphics);
        }
    }

    public int getAnchor() {
        return this.anchor;
    }

    public int getAttachMethod() {
        return this.attachMethod;
    }

    public JCChart getChart() {
        return this.getParent();
    }

    public Point getCoord() {
        return new Point(this.attachX, this.attachY);
    }

    public JCDataCoord getDataCoord() {
        return new JCDataCoord(this.dataAttachX, this.dataAttachY);
    }

    public JCDataIndex getDataIndex() {
        return this.attachDataIndex;
    }

    public ChartDataView getDataView() {
        try {
            return this.dataView == null ? this.getParent().getDataView(0) : this.dataView;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getDwellDelay() {
        return this.dwellDelay;
    }

    public boolean getIsConnected() {
        return this.isConnected;
    }

    public boolean getIsDwellLabel() {
        return this.isDwellLabel;
    }

    public Point getOffset() {
        return new Point(this.offsetX, this.offsetY);
    }

    public void loadParams(String string, JCChart jCChart) {
        super.loadParams(string, jCChart);
        this.setAnchor(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".anchor"), "anchor", anchor_strings, anchor_values, this.getAnchor()));
        this.setAttachMethod(JCChart.getConverter().toEnum(jCChart.getParam(String.valueOf(string) + ".attachMethod"), "attachMethod", attachMethod_strings, attachMethod_values, this.getAttachMethod()));
        this.attachX = JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".attachX"), this.attachX);
        this.attachY = JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".attachY"), this.attachY);
        this.dataAttachX = JCChart.getConverter().toDouble(jCChart.getParam(String.valueOf(string) + ".dataAttachX"), this.dataAttachX);
        this.dataAttachY = JCChart.getConverter().toDouble(jCChart.getParam(String.valueOf(string) + ".dataAttachY"), this.dataAttachY);
        this.offsetX = JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".offsetX"), this.offsetX);
        this.offsetY = JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".offsetY"), this.offsetY);
        this.setIsDwellLabel(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isDwellLabel"), this.getIsDwellLabel()));
        this.setIsConnected(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isConnected"), this.getIsConnected()));
        this.setIsShowing(JCChart.getConverter().toBoolean(jCChart.getParam(String.valueOf(string) + ".isShowing"), this.getIsShowing()));
        this.setDwellDelay(JCChart.getConverter().toInt(jCChart.getParam(String.valueOf(string) + ".dwellDelay"), this.getDwellDelay()));
        JCChartConverter jCChartConverter = new JCChartConverter();
        this.setDataView(jCChartConverter.toDataView(jCChart, jCChart.getParam(String.valueOf(string) + ".dataView"), this.getDataView()));
        this.setDataIndex(jCChartConverter.toDataIndex(jCChart, jCChart.getParam(String.valueOf(string) + ".dataIndex"), this.getDataIndex()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recalc() {
        this.setChanged(true, 2, false);
        Object object = this.getRegionLock();
        synchronized (object) {
            Point point;
            super.recalc();
            ChartDataView chartDataView = this.getDataView();
            if (chartDataView == null) {
                return;
            }
            int n = this.getWidth() / 2;
            int n2 = this.getHeight() / 2;
            try {
                switch (this.attachMethod) {
                    case 1: {
                        point = new Point(this.attachX, this.attachY);
                        break;
                    }
                    case 2: {
                        point = chartDataView.dataCoordToCoord(this.dataAttachX, this.dataAttachY);
                        try {
                            Rectangle rectangle = this.getChart().getDrawingArea();
                            point.x -= rectangle.x;
                            point.y -= rectangle.y;
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 3: {
                        point = chartDataView.dataIndexToCoord(this.attachDataIndex);
                        try {
                            Rectangle rectangle = this.getChart().getDrawingArea();
                            point.x -= rectangle.x;
                            point.y -= rectangle.y;
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (Exception exception) {
                point = null;
            }
            if (point == null) {
                this.attachBeforeAnchor = null;
                point = new Point(-9999, -9999);
            } else {
                this.attachBeforeAnchor = new Point(point.x, point.y);
                point.x -= n;
                point.y -= n2;
                switch (this.anchor) {
                    case 1: 
                    case 4: 
                    case 6: {
                        point.x += n;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 8: {
                        point.x -= n;
                        break;
                    }
                }
                switch (this.anchor) {
                    case 1: 
                    case 2: 
                    case 3: {
                        point.y -= n2;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        point.y += n2;
                        break;
                    }
                }
                point.x += this.offsetX;
                point.y += this.offsetY;
                this.setChanged(false, 0);
            }
            this.move(point.x, point.y);
            this.attachPoint = new Point(point.x, point.y);
            return;
        }
    }

    public void saveParams(String string, HTMLSaveDriver hTMLSaveDriver) {
        Object object;
        JCChartLabel jCChartLabel = new JCChartLabel();
        super.saveParams(string, hTMLSaveDriver);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".attachMethod", JCUtilConverter.fromEnum(this.attachMethod, attachMethod_strings, attachMethod_values));
        switch (this.attachMethod) {
            case 2: {
                hTMLSaveDriver.writeParam(String.valueOf(string) + ".dataAttachX", this.dataAttachX);
                hTMLSaveDriver.writeParam(String.valueOf(string) + ".dataAttachY", this.dataAttachY);
                break;
            }
            case 3: {
                hTMLSaveDriver.writeParam(String.valueOf(string) + ".dataIndex", "AttachIndex" + (index_no + 1));
                hTMLSaveDriver.writeParam("IndexName" + (index_no + 1), "AttachIndex" + (index_no + 1));
                object = this.getDataIndex();
                ((JCDataIndex)object).saveParams("AttachIndex" + (index_no + 1), hTMLSaveDriver);
                ++index_no;
                break;
            }
            default: {
                hTMLSaveDriver.writeParam(String.valueOf(string) + ".attachX", this.attachX);
                hTMLSaveDriver.writeParam(String.valueOf(string) + ".attachY", this.attachY);
            }
        }
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".anchor", JCUtilConverter.fromEnum(jCChartLabel.anchor, anchor_strings, anchor_values), JCUtilConverter.fromEnum(this.anchor, anchor_strings, anchor_values));
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".offsetX", jCChartLabel.offsetX, this.offsetX);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".offsetY", jCChartLabel.offsetX, this.offsetY);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isDwellLabel", jCChartLabel.isDwellLabel, this.isDwellLabel);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isConnected", jCChartLabel.isConnected, this.isConnected);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".isShowing", jCChartLabel.isShowing, this.isShowing);
        hTMLSaveDriver.writeParam(String.valueOf(string) + ".dwellDelay", jCChartLabel.dwellDelay, this.dwellDelay);
        if (this.dataView != null) {
            object = new JCChartConverter();
            hTMLSaveDriver.writeParam(String.valueOf(string) + ".dataView", ((JCChartConverter)object).toDataViewName(this.getParent(), this.dataView.getName(), "data"));
        }
    }

    public void setAnchor(int n) {
        JCChartLabel jCChartLabel = this;
        synchronized (jCChartLabel) {
            if (n == this.anchor) {
                Object var3_3 = null;
                return;
            }
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.anchor = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key48"));
                }
            }
        }
        this.setChanged(true, 2);
    }

    public void setAttachMethod(int n) {
        if (n == this.attachMethod) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.attachMethod = n;
                this.setChanged(true, 2);
                break;
            }
            default: {
                throw new IllegalArgumentException(JCChartBundle.string("jclass.chart.Key52"));
            }
        }
    }

    public void setCoord(Point point) {
        this.attachX = point.x;
        this.attachY = point.y;
        this.setChanged(true, 2);
    }

    public void setDataCoord(JCDataCoord jCDataCoord) {
        this.dataAttachX = jCDataCoord.x;
        this.dataAttachY = jCDataCoord.y;
        this.setChanged(true, 2);
        this.recalc();
    }

    public void setDataIndex(JCDataIndex jCDataIndex) {
        this.attachDataIndex = jCDataIndex;
        this.setChanged(true, 2);
        this.recalc();
    }

    public void setDataView(ChartDataView chartDataView) {
        this.dataView = chartDataView;
        this.setChanged(true, 2);
    }

    public void setDwellDelay(int n) {
        this.dwellDelay = n;
    }

    public void setIsConnected(boolean bl) {
        if (bl == this.isConnected) {
            return;
        }
        JCChartLabel jCChartLabel = this;
        synchronized (jCChartLabel) {
            this.isConnected = bl;
        }
        this.setChanged(true, 2);
    }

    public void setIsDwellLabel(boolean bl) {
        if (bl == this.isDwellLabel) {
            return;
        }
        Changeable changeable = this;
        synchronized (changeable) {
            this.isDwellLabel = bl;
            this.isShowing = bl ^ true;
        }
        changeable = this.getParent();
        if (changeable != null) {
            if (bl) {
                ((JCChart)changeable).addToDwellLabels(this);
            } else {
                ((JCChart)changeable).removeFromDwellLabels(this);
            }
        }
        this.setChanged(true, 2);
    }

    public void setOffset(Point point) {
        this.offsetX = point.x;
        this.offsetY = point.y;
        this.setChanged(true, 2);
        this.recalc();
    }

    public boolean shouldPopupHere(JCDataIndex jCDataIndex) {
        if (this.attachMethod != 3) {
            return false;
        }
        return jCDataIndex != null && jCDataIndex.equals(this.attachDataIndex);
    }
}

