/*
 * Decompiled with CFR 0.152.
 */
package jclass.cell.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.FocusManager;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jclass.cell.CellEditor;
import jclass.cell.CellEditorEvent;
import jclass.cell.CellEditorListener;
import jclass.cell.CellEditorSupport;
import jclass.cell.CellInfo;
import jclass.cell.InitialEvent;
import jclass.cell.KeyModifier;
import jclass.cell.ValidateEvent;
import jclass.cell.ValidateListener;
import jclass.cell.ValidateSupport;
import jclass.util.JCEnvironment;
import jclass.util.JCWordWrap;

public class WordWrapCellEditor
extends JScrollPane
implements CellEditor,
KeyListener {
    protected Object data;
    protected CellInfo cellInfo;
    protected String originalText;
    protected InitialEvent initialEvent;
    protected CellEditorSupport support = new CellEditorSupport();
    protected boolean selectAll = false;
    protected boolean editable = true;
    protected ValidateSupport validate_support = new ValidateSupport();
    protected JTextArea text = null;
    final int VERTICAL_SB_WIDTH = 25;
    protected KeyModifier[] keys = null;

    public WordWrapCellEditor() {
        this.addKeyListener(this);
        this.text = new JTextArea();
        this.getViewport().add(this.text);
        this.setDoubleBuffered(true);
        this.text.setDoubleBuffered(true);
        this.text.addKeyListener(this);
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.addCellEditorListener(cellEditorListener);
    }

    public void addValidateListener(ValidateListener validateListener) {
        this.validate_support.addValidateListener(validateListener);
    }

    public void cancelCellEditing() {
        this.setText(this.originalText);
        this.selectAllText();
    }

    protected boolean fireValidated(ValidateEvent validateEvent) {
        boolean bl = this.validate_support.fireValidateEvents(validateEvent);
        if (bl) {
            this.show();
        }
        return bl;
    }

    public Object getCellEditorValue() {
        if (this.editable) {
            return JCWordWrap.replace(this.getText(), "\n", "");
        }
        return this.data;
    }

    public Component getComponent() {
        this.validate();
        this.text.show();
        this.text.requestFocus();
        return this;
    }

    public Dimension getPreferredSize(CellInfo cellInfo, Object object) {
        return this.preferredSize();
    }

    public KeyModifier[] getReservedKeys() {
        if (this.keys == null) {
            this.keys = new KeyModifier[9];
            this.keys[0] = new KeyModifier(10);
            this.keys[1] = new KeyModifier(40);
            this.keys[2] = new KeyModifier(38);
            this.keys[3] = new KeyModifier(37);
            this.keys[4] = new KeyModifier(39);
            this.keys[5] = new KeyModifier(33);
            this.keys[6] = new KeyModifier(34);
            this.keys[7] = new KeyModifier(36);
            this.keys[8] = new KeyModifier(35);
        }
        return this.keys;
    }

    public String getText() {
        return this.text.getText();
    }

    public void initialize(InitialEvent initialEvent, CellInfo cellInfo, Object object) {
        this.initialEvent = initialEvent;
        this.cellInfo = cellInfo;
        this.data = object;
        this.selectAll = cellInfo.getSelectAll();
        this.editable = cellInfo.isEditable();
        this.text.setEditable(this.editable);
        if (!this.text.isEditable()) {
            this.selectAll = false;
        }
        if (this.data != null) {
            FontMetrics fontMetrics = cellInfo.getFontMetrics();
            Insets insets = cellInfo.getBorderInsets();
            int n = cellInfo.getDrawingArea().width + insets.left + insets.right;
            String string = this.data.toString();
            if ((JCEnvironment.getOS() == 1 || JCEnvironment.getJavaVersion() == 102) && (char)initialEvent.getKey() >= ' ' && (char)initialEvent.getKey() <= '~') {
                string = String.valueOf(string) + String.valueOf((char)initialEvent.getKey());
            }
            this.setText(JCWordWrap.wrapText(string, fontMetrics, n - 25, "\n", true));
        } else {
            this.setText("");
        }
        this.originalText = this.getText();
        this.setBackground(cellInfo.getBackground());
        this.setForeground(cellInfo.getForeground());
    }

    public boolean isModified() {
        if (this.data == null) {
            return this.getCellEditorValue() != null;
        }
        return this.data.equals(this.getCellEditorValue()) ^ true;
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.support.fireStopEditing(new CellEditorEvent(keyEvent));
                break;
            }
            case 27: {
                this.support.fireCancelEditing(new CellEditorEvent(keyEvent));
                break;
            }
            default: {
                if (keyEvent.getComponent() != this.text) break;
                this.processKeyEvent(new KeyEvent(this, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public Dimension minimumSize() {
        return new Dimension(0, 0);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        FocusManager focusManager = FocusManager.getCurrentManager();
        FocusManager.disableSwingFocusManager();
        super.processKeyEvent(keyEvent);
        FocusManager.setCurrentManager(focusManager);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.removeCellEditorListener(cellEditorListener);
    }

    public void removeValidateListener(ValidateListener validateListener) {
        this.validate_support.removeValidateListener(validateListener);
    }

    public void selectAllText() {
        if (this.getPeer() == null) {
            return;
        }
        if (this.selectAll) {
            this.text.setCaretPosition(0);
            this.text.setCaretPosition(this.data == null ? 0 : this.data.toString().length());
            this.text.selectAll();
        } else {
            this.text.setCaretPosition(this.data == null ? 0 : this.data.toString().length());
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.setText(this.wrapText(this.unwrapText(this.getText())));
    }

    public void setText(String string) {
        this.text.setText(string);
    }

    public void show() {
        super.show();
        this.selectAllText();
    }

    public boolean stopCellEditing() {
        String string = this.getText();
        ValidateEvent validateEvent = new ValidateEvent(this, this.data, string, true);
        boolean bl = this.fireValidated(validateEvent);
        if (bl) {
            this.selectAllText();
        }
        return bl;
    }

    String unwrapText(String string) {
        return JCWordWrap.replace(string, "\n", "");
    }

    String wrapText(String string) {
        String string2 = "";
        if (string != null) {
            FontMetrics fontMetrics = this.cellInfo.getFontMetrics();
            Insets insets = this.cellInfo.getBorderInsets();
            int n = this.cellInfo.getDrawingArea().width + insets.left + insets.right;
            string2 = JCWordWrap.wrapText(string, fontMetrics, n - 25, "\n", true);
        }
        return string2;
    }
}

