/*
 * Decompiled with CFR 0.152.
 */
package jclass.cell.editors;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import jclass.cell.CellEditor;
import jclass.cell.CellEditorEvent;
import jclass.cell.CellEditorListener;
import jclass.cell.CellEditorSupport;
import jclass.cell.CellInfo;
import jclass.cell.InitialEvent;
import jclass.cell.KeyModifier;

public class ChoiceCellEditor
extends Choice
implements CellEditor,
ItemListener,
KeyListener {
    protected int firstSelection = 0;
    protected int newSelection = 0;
    protected CellEditorSupport support = new CellEditorSupport();
    protected int[] values;
    protected boolean ignoreEnterKey = false;

    public ChoiceCellEditor() {
        this.values = null;
    }

    public ChoiceCellEditor(String[] stringArray) {
        this(stringArray, null);
    }

    public ChoiceCellEditor(String[] stringArray, int[] nArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.addItem(stringArray[n]);
            ++n;
        }
        this.values = nArray;
        this.addItemListener(this);
        this.addKeyListener(this);
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.addCellEditorListener(cellEditorListener);
    }

    public void cancelCellEditing() {
    }

    public Object getCellEditorValue() {
        if (this.values != null) {
            return new Integer(this.values[this.newSelection]);
        }
        return this.getSelectedItem();
    }

    public Component getComponent() {
        return this;
    }

    private int getIndexFromValue(int n) {
        if (this.values == null) {
            return n;
        }
        int n2 = 0;
        while (n2 < this.values.length) {
            if (this.values[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Dimension getPreferredSize(CellInfo cellInfo, Object object) {
        return this.getComponent().preferredSize();
    }

    public KeyModifier[] getReservedKeys() {
        return null;
    }

    public void initialize(InitialEvent initialEvent, CellInfo cellInfo, Object object) {
        if (initialEvent.getEventType() == 2 && initialEvent.getKey() == 10) {
            this.ignoreEnterKey = true;
        }
        if (object instanceof Number) {
            this.firstSelection = this.newSelection = this.getIndexFromValue(((Number)object).intValue());
            this.select(this.newSelection);
        } else if (object instanceof String) {
            this.select((String)object);
            this.firstSelection = this.newSelection = this.getSelectedIndex();
        }
    }

    public boolean isModified() {
        return this.firstSelection != this.newSelection;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.newSelection = this.getSelectedIndex();
        this.support.fireStopEditing(new CellEditorEvent(itemEvent));
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        Object var2_2 = null;
        if (keyEvent.getKeyCode() == 27) {
            this.support.fireStopEditing(new CellEditorEvent(keyEvent));
        } else if (keyEvent.getKeyCode() == 10 && !this.ignoreEnterKey) {
            this.support.fireStopEditing(new CellEditorEvent(keyEvent));
        }
        this.ignoreEnterKey = false;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.removeCellEditorListener(cellEditorListener);
    }

    public boolean stopCellEditing() {
        return true;
    }
}

