/*
 * Decompiled with CFR 0.152.
 */
package jclass.cell.editors;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import jclass.cell.CellEditor;
import jclass.cell.CellEditorEvent;
import jclass.cell.CellEditorListener;
import jclass.cell.CellEditorSupport;
import jclass.cell.CellInfo;
import jclass.cell.CellRenderer;
import jclass.cell.InitialEvent;
import jclass.cell.KeyModifier;
import jclass.cell.Utilities;
import jclass.cell.renderers.CheckboxCellRenderer;

public class CheckboxEditor
extends Canvas
implements CellEditor,
KeyListener,
MouseListener {
    protected Object data;
    protected boolean currentValue;
    protected boolean editable = true;
    protected CellRenderer renderer = new CheckboxCellRenderer();
    protected CellInfo cellInfo;
    protected CellEditorSupport support = new CellEditorSupport();
    protected static final int BORDER_SIZE = 2;
    protected KeyModifier[] keys = null;

    public CheckboxEditor() {
        this.addKeyListener(this);
        this.addMouseListener(this);
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.addCellEditorListener(cellEditorListener);
    }

    public void cancelCellEditing() {
        this.initData();
        this.repaint();
    }

    public Object getCellEditorValue() {
        return new Boolean(this.currentValue);
    }

    public Component getComponent() {
        return this;
    }

    public Dimension getPreferredSize(CellInfo cellInfo, Object object) {
        Rectangle rectangle = cellInfo.getDrawingArea();
        return new Dimension(rectangle.width, rectangle.height);
    }

    public KeyModifier[] getReservedKeys() {
        return this.keys;
    }

    void initData() {
        this.currentValue = (Boolean)this.data;
    }

    public void initialize(InitialEvent initialEvent, CellInfo cellInfo, Object object) {
        this.cellInfo = cellInfo;
        this.data = object;
        this.initData();
        this.editable = cellInfo.isEditable();
        if (initialEvent.getEventType() == 1) {
            this.toggleValue();
            this.repaint();
            this.support.fireStopEditing(new CellEditorEvent(initialEvent));
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isModified() {
        return (Boolean)this.data != this.currentValue;
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.support.fireStopEditing(new CellEditorEvent(keyEvent));
                break;
            }
            case 27: {
                this.support.fireCancelEditing(new CellEditorEvent(keyEvent));
                break;
            }
            case 32: {
                this.toggleValue();
                this.repaint();
                this.support.fireStopEditing(new CellEditorEvent(keyEvent));
                break;
            }
            default: {
                if (keyEvent.isActionKey() || !Character.isLetterOrDigit(keyEvent.getKeyChar())) break;
                this.toggleValue();
                this.repaint();
                this.support.fireStopEditing(new CellEditorEvent(keyEvent));
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.toggleValue();
        this.repaint();
        this.support.fireStopEditing(new CellEditorEvent(mouseEvent));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        graphics.setColor(this.cellInfo.isEditable() ? this.cellInfo.getBackground().brighter() : this.cellInfo.getBackground());
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        int n = this.cellInfo.getMarginInsets().left + this.cellInfo.getBorderInsets().left;
        int n2 = this.cellInfo.getMarginInsets().top + this.cellInfo.getBorderInsets().top;
        graphics.translate(n, n2);
        this.renderer.draw(graphics, this.cellInfo, this.getCellEditorValue(), false);
        graphics.translate(-n, -n2);
        Utilities.drawBorder(graphics, 8, 2, 0, 0, rectangle.width, rectangle.height, Color.black, Color.white);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.removeCellEditorListener(cellEditorListener);
    }

    public boolean stopCellEditing() {
        return true;
    }

    void toggleValue() {
        if (this.editable) {
            this.currentValue ^= true;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

