/*
 * Decompiled with CFR 0.152.
 */
package jclass.cell;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import jclass.cell.CellInfo;
import jclass.cell.KeyModifier;

public class Utilities
implements Serializable {
    private static final Color WHITE_BRIGHTER = new Color(200, 200, 200);
    private static final Color WHITE_DARKER = new Color(140, 140, 140);
    private static final Color BLACK_BRIGHTER = new Color(125, 125, 125);
    private static final Color BLACK_DARKER = new Color(75, 75, 75);
    private static final double FACTOR = 0.5;
    public static final int NONE = 0;
    public static final int ETCHED_IN = 1;
    public static final int ETCHED_OUT = 2;
    public static final int IN = 3;
    public static final int OUT = 4;
    public static final int PLAIN = 5;
    public static final int FRAME_IN = 6;
    public static final int FRAME_OUT = 7;
    public static final int CONTROL_IN = 8;
    public static final int CONTROL_OUT = 9;
    public static final int NUM_BORDER_STYLES = 10;
    public static final int DEFAULT_CLIP_ARROW_SIZE = 4;
    static int[] xpoints = new int[3];
    static int[] ypoints = new int[3];

    public static KeyModifier[] addKey(KeyModifier[] keyModifierArray, KeyModifier keyModifier) {
        KeyModifier[] keyModifierArray2 = new KeyModifier[keyModifierArray.length + 1];
        System.arraycopy(keyModifierArray, 0, keyModifierArray2, 0, keyModifierArray.length);
        keyModifierArray2[keyModifierArray.length] = keyModifier;
        return keyModifierArray2;
    }

    public static Color brighter(Color color) {
        if (color.equals(Color.white)) {
            return WHITE_BRIGHTER;
        }
        if (color.equals(Color.black)) {
            return BLACK_BRIGHTER;
        }
        int n = color.getRed();
        n += (int)((double)(255 - n) * 0.5);
        int n2 = color.getBlue();
        n2 += (int)((double)(255 - n2) * 0.5);
        int n3 = color.getGreen();
        n3 += (int)((double)(255 - n3) * 0.5);
        return new Color(Math.min(n, 255), Math.min(n3, 255), Math.min(n2, 255));
    }

    public static Color darker(Color color) {
        if (color.equals(Color.white)) {
            return WHITE_DARKER;
        }
        if (color.equals(Color.black)) {
            return BLACK_DARKER;
        }
        return color.darker();
    }

    public static void drawBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2) {
        Utilities.drawBorder(graphics, n, n2, n3, n4, n5, n6, Utilities.brighter(color), Utilities.darker(color), color2);
    }

    public static void drawBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2, Color color3) {
        Color color4 = graphics.getColor();
        switch (n) {
            case 5: {
                Utilities.drawNormal(graphics, n2, n3, n4, n5, n6, color3, color3);
                break;
            }
            case 3: {
                Utilities.drawNormal(graphics, n2, n3, n4, n5, n6, color2, color);
                break;
            }
            case 4: {
                Utilities.drawNormal(graphics, n2, n3, n4, n5, n6, color, color2);
                break;
            }
            case 8: {
                if (n2 == 2) {
                    Utilities.drawNormal(graphics, 1, n3 + 1, n4 + 1, n5 - 2, n6 - 2, Color.black, color);
                    Utilities.drawNormal(graphics, 1, n3, n4, n5, n6, color2, Utilities.brighter(color));
                    break;
                }
                Utilities.drawNormal(graphics, n2, n3, n4, n5, n6, color2, color);
                break;
            }
            case 9: {
                if (n2 == 2) {
                    Utilities.drawNormal(graphics, 1, n3, n4, n5, n6, Utilities.brighter(color), color2);
                    Utilities.drawNormal(graphics, 1, n3 + 1, n4 + 1, n5 - 2, n6 - 2, color, Color.black);
                    break;
                }
                Utilities.drawNormal(graphics, n2, n3, n4, n5, n6, color, color2);
                break;
            }
            case 1: {
                int n7 = n2 % 2;
                int n8 = n7 == 0 ? n2 / 2 : n2 / 2 + 1;
                int n9 = n2 - n8;
                Utilities.drawNormal(graphics, n8, n3, n4, n5, n6, color2, color);
                Utilities.drawNormal(graphics, n9, n3 + n8, n4 + n8, n5 - n2 - n7, n6 - n2 - n7, color, color2);
                break;
            }
            case 2: {
                int n10 = n2 % 2;
                int n11 = n10 == 0 ? n2 / 2 : n2 / 2 + 1;
                int n12 = n2 - n11;
                Utilities.drawNormal(graphics, n11, n3, n4, n5, n6, color, color2);
                Utilities.drawNormal(graphics, n12, n3 + n11, n4 + n11, n5 - n2 - n10, n6 - n2 - n10, color2, color);
                break;
            }
            case 7: {
                Utilities.drawNormal(graphics, n2, n3, n4, n5, n6, color, color2);
                Utilities.drawNormal(graphics, n2 - 1, n3, n4, n5, n6, color3, color3);
                break;
            }
            case 6: {
                Utilities.drawNormal(graphics, n2, n3, n4, n5, n6, color2, color);
                Utilities.drawNormal(graphics, n2 - 1, n3, n4, n5, n6, color3, color3);
                break;
            }
        }
        graphics.setColor(color4);
    }

    public static void drawBottomLines(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
        graphics.setColor(color);
        int n6 = 1;
        while (n6 <= n) {
            graphics.drawLine(n2 + n6 - 1, n3 + n5 - n6, n2 + n4 - n6, n3 + n5 - n6);
            graphics.drawLine(n2 + n4 - n6, n3 + n6 - 1, n2 + n4 - n6, n3 + n5 - n6);
            ++n6;
        }
    }

    public static void drawClipArrows(Graphics graphics, CellInfo cellInfo, Dimension dimension, int n, boolean bl) {
        int n2;
        int n3;
        int n4 = cellInfo.getClipHints();
        Rectangle rectangle = cellInfo.getDrawingArea();
        Rectangle rectangle2 = graphics.getClipBounds();
        Rectangle rectangle3 = new Rectangle(rectangle);
        Utilities.translateToInsideBorders(graphics, cellInfo, rectangle3);
        graphics.setClip(rectangle3);
        if ((n4 == 1 || n4 == 3) && dimension.width > rectangle.width) {
            switch (cellInfo.getVerticalAlignment()) {
                default: {
                    n3 = rectangle3.height - n;
                    break;
                }
                case 1: {
                    n3 = (rectangle3.height + n) / 2;
                    break;
                }
                case 2: {
                    n3 = n * 2;
                }
            }
            n2 = cellInfo.getHorizontalAlignment();
            if (n2 == 1) {
                Utilities.drawHorizontalArrow(graphics, rectangle3, n3, 0, n, bl);
                Utilities.drawHorizontalArrow(graphics, rectangle3, n3, 2, n, bl);
            } else {
                Utilities.drawHorizontalArrow(graphics, rectangle3, n3, n2, n, bl);
            }
        }
        if ((n4 == 2 || n4 == 3) && dimension.height > rectangle.height) {
            switch (cellInfo.getHorizontalAlignment()) {
                default: {
                    n3 = rectangle3.width - n;
                    break;
                }
                case 1: {
                    n3 = (rectangle3.width + n) / 2;
                    break;
                }
                case 2: {
                    n3 = n * 2;
                }
            }
            n2 = cellInfo.getVerticalAlignment();
            if (n2 == 1) {
                Utilities.drawVerticalArrow(graphics, rectangle3, n3, 0, n, bl);
                Utilities.drawVerticalArrow(graphics, rectangle3, n3, 2, n, bl);
            } else {
                Utilities.drawVerticalArrow(graphics, rectangle3, n3, n2, n, bl);
            }
        }
        Utilities.restoreFromInsideBorders(graphics, cellInfo, rectangle3);
        graphics.setClip(rectangle2);
    }

    static void drawHorizontalArrow(Graphics graphics, Rectangle rectangle, int n, int n2, int n3, boolean bl) {
        switch (n2) {
            case 0: {
                int n4 = rectangle.width;
                Utilities.xpoints[0] = n4 - n3;
                Utilities.ypoints[0] = n - n3;
                Utilities.xpoints[1] = xpoints[0];
                Utilities.ypoints[1] = ypoints[0] + n3;
                Utilities.xpoints[2] = n4;
                Utilities.ypoints[2] = n - n3 / 2;
                break;
            }
            case 2: {
                int n5 = 0;
                Utilities.xpoints[0] = n5 + n3;
                Utilities.ypoints[0] = n - n3;
                Utilities.xpoints[1] = xpoints[0];
                Utilities.ypoints[1] = ypoints[0] + n3;
                Utilities.xpoints[2] = n5;
                Utilities.ypoints[2] = n - n3 / 2;
                break;
            }
            default: {
                return;
            }
        }
        Utilities.drawPolygon(graphics, bl);
    }

    public static void drawNormal(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, Color color2) {
        Utilities.drawTopLines(graphics, n, n2, n3, n4, n5, color);
        Utilities.drawBottomLines(graphics, n, n2, n3, n4, n5, color2);
    }

    static void drawPolygon(Graphics graphics, boolean bl) {
        if (bl) {
            graphics.drawLine(xpoints[0], ypoints[0], xpoints[1], ypoints[1]);
            graphics.drawLine(xpoints[1], ypoints[1], xpoints[2], ypoints[2]);
            graphics.drawLine(xpoints[2], ypoints[2], xpoints[0], ypoints[0]);
        }
        graphics.fillPolygon(xpoints, ypoints, 3);
    }

    public static void drawTopLines(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
        graphics.setColor(color);
        int n6 = 0;
        while (n6 < n) {
            graphics.drawLine(n2 + n6, n3 + n6, n2 + n4 - (n6 + 1), n3 + n6);
            graphics.drawLine(n2 + n6, n3 + n6 + 1, n2 + n6, n3 + n5 - (n6 + 1));
            ++n6;
        }
    }

    static void drawVerticalArrow(Graphics graphics, Rectangle rectangle, int n, int n2, int n3, boolean bl) {
        switch (n2) {
            case 0: {
                int n4 = rectangle.height;
                Utilities.xpoints[0] = n - n3;
                Utilities.ypoints[0] = n4 - n3;
                Utilities.xpoints[1] = xpoints[0] + n3;
                Utilities.ypoints[1] = ypoints[0];
                Utilities.xpoints[2] = n - n3 / 2;
                Utilities.ypoints[2] = n4;
                break;
            }
            case 2: {
                int n5 = 0;
                Utilities.xpoints[0] = n - n3;
                Utilities.ypoints[0] = n5 + n3;
                Utilities.xpoints[1] = xpoints[0] + n3;
                Utilities.ypoints[1] = ypoints[0];
                Utilities.xpoints[2] = n - n3 / 2;
                Utilities.ypoints[2] = n5;
                break;
            }
            default: {
                return;
            }
        }
        Utilities.drawPolygon(graphics, bl);
    }

    public static Rectangle getWholeCell(CellInfo cellInfo, Rectangle rectangle) {
        Insets insets = cellInfo.getMarginInsets();
        Insets insets2 = cellInfo.getBorderInsets();
        return new Rectangle(-(insets.right + insets2.right), -(insets.top + insets2.top), rectangle.width + insets.right + insets.left + insets2.right + insets2.left, rectangle.height + insets.top + insets.bottom + insets2.top + insets2.bottom);
    }

    public static void restoreFromInsideBorders(Graphics graphics, CellInfo cellInfo, Rectangle rectangle) {
        Insets insets = cellInfo.getMarginInsets();
        graphics.translate(insets.right, insets.top);
        rectangle.setSize(rectangle.width - insets.right - insets.left, rectangle.height - insets.top - insets.bottom);
    }

    public static void restoreFromWholeCell(Graphics graphics, CellInfo cellInfo, Rectangle rectangle) {
        Insets insets = cellInfo.getMarginInsets();
        Insets insets2 = cellInfo.getBorderInsets();
        graphics.translate(insets.right + insets2.right, insets.top + insets2.top);
        rectangle.setSize(rectangle.width - insets.right - insets.left - insets2.right - insets2.left, rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom);
    }

    public static void translateToInsideBorders(Graphics graphics, CellInfo cellInfo, Rectangle rectangle) {
        Insets insets = cellInfo.getMarginInsets();
        graphics.translate(-insets.right, -insets.top);
        rectangle.setSize(rectangle.width + insets.right + insets.left, rectangle.height + insets.top + insets.bottom);
    }

    public static void translateToWholeCell(Graphics graphics, CellInfo cellInfo, Rectangle rectangle) {
        Rectangle rectangle2 = Utilities.getWholeCell(cellInfo, rectangle);
        graphics.translate(rectangle2.x, rectangle2.y);
        rectangle.setSize(rectangle2.width, rectangle2.height);
    }
}

