/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.peer.ComponentPeer;
import java.io.Serializable;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCButton;
import jclass.bwt.JCComponent;
import jclass.bwt.JCTabManager;
import jclass.bwt.TabPanel;

public class JCTabButton
extends JCButton {
    Component page;
    JCTabManager tab_manager;
    TabPanel tab_panel;
    int shape;
    boolean size_adjusted = false;
    protected Polygon polygon;
    protected boolean current_tab = false;
    private static final String base = "tabbutton";
    private static int nameCounter = 0;
    boolean valid = false;
    boolean visible = true;

    public JCTabButton(JCTabManager jCTabManager) {
        this(jCTabManager, null, null);
    }

    public JCTabButton(JCTabManager jCTabManager, Applet applet, String string) {
        super(null, applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.tab_manager = jCTabManager;
        this.traversable = true;
        this.arm_offset = 0;
        this.highlight = 0;
        this.alignment = -999;
        this.shape = jCTabManager.getTabShape();
        if (this.getClass().getName().equals("jclass.bwt.JCTabButton")) {
            this.getParameters(applet);
        }
        this.insets = new Insets(-1, 5, -1, 5);
    }

    public void addNotify() {
        if (this.getParent() instanceof TabPanel) {
            this.tab_panel = (TabPanel)this.getParent();
            this.tab_panel.addButton(this);
            if (this.getFont() == null) {
                this.setFont(this.tab_panel.getFont());
            }
            if (this.getBackground() == null) {
                this.setBackground(this.tab_panel.getBackground());
            }
            if (this.getForeground() == null) {
                this.setForeground(this.tab_panel.getForeground());
            }
            this.valid = false;
        }
        if (this.applet == null) {
            this.applet = BWTUtil.getApplet(this);
        }
        this.applet_context = this.getAppletContext();
        if (this.tab_manager.getTabColorPolicy() == 0 && this.page != null && this.page.getBackground() != null) {
            this.setBackground(this.page.getBackground());
        }
    }

    public void armAction(Event event) {
        this.tab_manager.setCurrentTab(this.tab_manager.getTab(this), true);
    }

    public void disarmAction(Event event) {
    }

    protected void drawBorder(Graphics graphics) {
        if (this.shape == 0) {
            this.drawRectangleBorder(graphics);
        } else if (this.shape == 1) {
            this.drawSlantedBorder(graphics);
        }
    }

    private void drawEdgeBorder(Graphics graphics) {
        int[] nArray = this.polygon.xpoints;
        int[] nArray2 = this.polygon.ypoints;
        graphics.setColor(BWTUtil.brighter(this.getBackground()));
        if (this.tab_manager.getTabSide() == 1) {
            graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
            graphics.drawLine(nArray[1], nArray2[1], nArray[2] - 1, nArray2[2]);
        } else if (this.tab_manager.getTabSide() == 5) {
            graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1] - 1);
            graphics.drawLine(nArray[1], nArray2[1] - 1, nArray[2] - 1, nArray2[2] - 1);
        }
        graphics.setColor(Color.black);
        if (this.tab_manager.getTabSide() == 1) {
            graphics.drawLine(nArray[2] - 1, nArray2[2], nArray[3] - 1, nArray2[3] - 1);
        } else if (this.tab_manager.getTabSide() == 5) {
            if (this.shape == 1) {
                graphics.drawLine(nArray[2], nArray2[2] - 1, nArray[3], nArray2[3] - 1);
            } else {
                graphics.drawLine(nArray[2] - 1, nArray2[2] - 3, nArray[3] - 1, nArray2[3] - 2);
            }
        }
    }

    protected void drawHighlight(Graphics graphics, boolean bl) {
    }

    protected void drawRectangleBorder(Graphics graphics) {
        this.drawEdgeBorder(graphics);
        graphics.setColor(this.getParent().getBackground());
        int[] nArray = this.polygon.xpoints;
        int[] nArray2 = this.polygon.ypoints;
        if (this.tab_manager.getTabSide() == 1) {
            graphics.drawRect(nArray[1], nArray2[1], 1, 1);
            graphics.drawRect(nArray[2] - 2, nArray2[2], 1, 1);
            graphics.setColor(BWTUtil.brighter(this.getBackground()));
            graphics.drawLine(nArray[1] + 1, nArray2[1] + 1, nArray[1] + 1, nArray2[1] + 1);
            graphics.setColor(Color.black);
            graphics.drawLine(nArray[2] - 2, nArray2[2] + 1, nArray[2] - 2, nArray2[2] + 1);
        } else {
            graphics.drawRect(nArray[1], nArray2[1] - 2, 1, 1);
            graphics.drawRect(nArray[2] - 2, nArray2[2] - 2, 1, 1);
            graphics.setColor(BWTUtil.brighter(this.getBackground()));
            graphics.drawLine(nArray[1] + 1, nArray2[1] - 2, nArray[1] + 1, nArray2[1] - 2);
            graphics.setColor(Color.black);
            graphics.drawLine(nArray[2] - 2, nArray2[2] - 2, nArray[2] - 2, nArray2[2] - 2);
        }
    }

    protected void drawSlantedBorder(Graphics graphics) {
        this.drawEdgeBorder(graphics);
    }

    protected void fillBackground(Graphics graphics) {
        graphics.fillPolygon(this.polygon);
    }

    static Font getCurrentTabFont(JCTabManager jCTabManager) {
        if (jCTabManager.tab_current_font != null) {
            return jCTabManager.tab_current_font;
        }
        Font font = jCTabManager.getFont();
        return new Font(font.getName(), 1, font.getSize());
    }

    public Graphics getGraphics() {
        if (this.draw_gc != null) {
            return this.draw_gc.create();
        }
        Graphics graphics = this.getParent().getGraphics();
        if (graphics == null) {
            return null;
        }
        Rectangle rectangle = this.bounds();
        Point point = BWTUtil.translateToParent(this.getParent(), this, 0, 0);
        Graphics graphics2 = graphics.create(point.x, point.y, rectangle.width, rectangle.height);
        graphics.dispose();
        return graphics2;
    }

    public Component getPage() {
        return this.page;
    }

    public ComponentPeer getPeer() {
        return this.tab_panel != null ? this.tab_panel.getPeer() : super.getPeer();
    }

    public boolean gotFocus(Event event, Object object) {
        if (this.isFocusTraversable()) {
            this.tab_manager.makeTabVisible(this.tab_manager.getTab(this));
        }
        if (this.isFocusTraversable() && this.tab_panel != null) {
            if (this.tab_panel.focus_target != this) {
                this.tab_panel.dispatchEvent(this.tab_panel.focus_target, event, 1005);
            }
            this.tab_panel.focus_target = this;
        }
        return super.gotFocus(event, object);
    }

    public void hide() {
        super.hide();
        if (this.tab_panel == null || !this.visible) {
            return;
        }
        this.visible = false;
        Rectangle rectangle = this.bounds();
        this.tab_panel.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean inside(int n, int n2) {
        return this.isEnabled() && this.polygon != null && this.polygon.inside(n, n2);
    }

    public void invalidate() {
        this.valid = false;
        if (this.getParent() != null && this.getParent().isValid()) {
            this.getParent().invalidate();
        }
    }

    public boolean isShowing() {
        if (this.visible && this.getPeer() != null) {
            return this.getParent() == null || this.getParent().isShowing();
        }
        return false;
    }

    public boolean isValid() {
        return this.getPeer() != null && this.valid;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public synchronized void layout() {
        if (this.getPeer() == null) {
            return;
        }
        int n = this.alignment;
        if (this.alignment == -999) {
            this.alignment = this.tab_manager.getAlignment();
        }
        super.layout();
        this.alignment = n;
    }

    public void paint(Graphics graphics) {
        this.clipGCToAncestors(graphics);
        super.paint(graphics);
    }

    protected synchronized void paintComponent(Graphics graphics) {
        if (this.tab_manager.getTab(this.tab_manager.getCurrentTab()) == this) {
            graphics.setFont(JCTabButton.getCurrentTabFont(this.tab_manager));
        } else {
            graphics.setFont(this.getFont());
        }
        int n = this.alignment == -999 ? this.tab_manager.getAlignment() : this.alignment;
        super.paintComponent(graphics);
    }

    protected int preferredWidth() {
        int n = super.preferredWidth();
        if (this.shape == 1) {
            n += this.preferredHeight();
        }
        return n;
    }

    public void repaint(int n, int n2, int n3, int n4) {
        if (this.getPeer() == null || !this.isShowing() || n3 <= 0 || n4 <= 0 || this.in_repaint) {
            return;
        }
        int n5 = this.size().width;
        int n6 = this.size().height;
        if (n5 <= n || n6 <= n2 || n + n3 < 0 || n2 + n4 < 0) {
            return;
        }
        try {
            this.in_repaint = true;
            if (n + n3 > n5) {
                n3 = n5 - n;
            }
            if (n2 + n4 > n6) {
                n4 = n6 - n2;
            }
            if (this.tab_panel != null) {
                Point point = BWTUtil.translateToParent(this.tab_panel, this, n, n2);
                this.tab_panel.repaint(point.x, point.y, n3, n4);
            } else {
                Graphics graphics = this.getGraphics();
                graphics.clipRect(n, n2, n3, n4);
                this.paint(graphics);
                graphics.dispose();
            }
        }
        catch (Exception exception) {
            this.in_repaint = false;
        }
        this.in_repaint = false;
    }

    protected void resize(boolean bl) {
        this.current_tab = bl;
        if (this.getPeer() == null) {
            return;
        }
        int n = 0;
        if (this.tab_manager.getTabSide() == 1) {
            n = this.border;
        }
        if (bl && !this.size_adjusted) {
            this.size_adjusted = true;
            JCComponent.setBounds(this, this.location().x - this.border, 0, this.size().width + 2 * this.border, this.size().height + this.border);
        } else if (!bl && this.size_adjusted) {
            this.size_adjusted = false;
            JCComponent.setBounds(this, this.location().x + this.border, n, this.size().width - 2 * this.border, this.size().height - this.border);
        }
        if (bl) {
            this.toFront();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 < 0) return;
        if (n4 < 0) {
            return;
        }
        boolean bl = false;
        Serializable serializable = this;
        synchronized (serializable) {
            this.setShape(this.shape, n3, n4);
            boolean bl2 = bl = this.size().width != n3 || this.size().height != n4;
            if (!bl && this.location().x == n && this.location().y == n2) {
                return;
            }
            if (this.getPeer() == null || this.tab_panel == null) {
                super.setBounds(n, n2, n3, n4);
                return;
            }
        }
        serializable = this.bounds();
        this.do_repaint = false;
        try {
            super.setBounds(n, n2, n3, n4);
        }
        catch (Exception exception) {
            this.do_repaint = true;
        }
        this.do_repaint = true;
        Rectangle rectangle = this.bounds();
        if (bl) {
            this.invalidate();
        }
        if (this.getParent().isValid()) {
            this.getParent().invalidate();
        }
        if (!rectangle.intersects((Rectangle)serializable)) {
            this.tab_panel.repaint((Rectangle)serializable);
            this.repaint();
            return;
        }
        Rectangle rectangle2 = rectangle.union((Rectangle)serializable);
        this.tab_panel.repaint(rectangle2);
    }

    public void setPage(Component component) {
        this.page = component;
        if (this.tab_manager != null && this.tab_manager.page_area != null) {
            this.tab_manager.page_area.addPage(component);
        }
        if (this.tab_manager.getTabColorPolicy() == 0 && component != null && component.getBackground() != null) {
            this.setBackground(component.getBackground());
        }
    }

    void setShape(int n) {
        this.setShape(n, this.size().width, this.size().height);
    }

    /*
     * Enabled aggressive block sorting
     */
    void setShape(int n, int n2, int n3) {
        this.shape = n;
        this.polygon = new Polygon();
        switch (this.shape) {
            case 0: {
                switch (this.tab_manager.getTabSide()) {
                    case 1: {
                        this.polygon.addPoint(0, n3);
                        this.polygon.addPoint(0, 0);
                        this.polygon.addPoint(n2, 0);
                        this.polygon.addPoint(n2, n3);
                        return;
                    }
                    case 5: {
                        this.polygon.addPoint(0, 0);
                        this.polygon.addPoint(0, n3);
                        this.polygon.addPoint(n2, n3);
                        this.polygon.addPoint(n2, 0);
                        return;
                    }
                }
                return;
            }
            case 1: {
                switch (this.tab_manager.getTabSide()) {
                    case 1: {
                        this.polygon.addPoint(0, n3);
                        this.polygon.addPoint(n3 / 2, 0);
                        this.polygon.addPoint(n2 - n3 / 2, 0);
                        this.polygon.addPoint(n2, n3);
                        return;
                    }
                    case 5: {
                        this.polygon.addPoint(0, 0);
                        this.polygon.addPoint(n3 / 2, n3);
                        this.polygon.addPoint(n2 - n3 / 2, n3);
                        this.polygon.addPoint(n2, 0);
                        return;
                    }
                }
                return;
            }
        }
    }

    public void show() {
        super.show();
        if (this.tab_panel == null || this.visible) {
            return;
        }
        this.visible = true;
        this.repaint();
    }

    public void toFront() {
        if (this.getParent() instanceof TabPanel) {
            ((TabPanel)this.getParent()).toFront(this);
            this.repaint();
        }
    }

    public void validate() {
        if (!this.valid && this.getPeer() != null) {
            this.layout();
            this.valid = true;
        }
    }
}

