/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import jclass.bwt.JCComponent;
import jclass.bwt.JCContainer;
import jclass.bwt.JCSeparator;
import jclass.bwt.SplitterWindowSeparator;
import jclass.util.JCUtilConverter;

public class JCSplitterWindow
extends JCContainer {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    int dir = 0;
    int min_child_size = 20;
    protected boolean resized = false;
    private static final String base = "splitterwindow";
    private static int nameCounter = 0;
    static final String[] orient_strings = new String[]{"horizontal", "vertical"};
    static final int[] orient_values;

    static {
        int[] nArray = new int[2];
        nArray[1] = 1;
        orient_values = nArray;
    }

    public JCSplitterWindow() {
        this(0, null, null);
    }

    public JCSplitterWindow(int n) {
        this(n, null, null);
    }

    public JCSplitterWindow(int n, Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.dir = n;
        if (this.getClass().getName().equals("jclass.bwt.JCSplitterWindow")) {
            this.getParameters(applet);
        }
        this.setLayout(null);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.countComponents() % 2 != 0) {
            super.addImpl(new SplitterWindowSeparator(this), null, n);
        }
        super.addImpl(component, null, n);
        this.layout();
    }

    protected Rectangle getDrawingArea() {
        return new Rectangle(JCComponent.getInsets((Container)this).left, JCComponent.getInsets((Container)this).top, this.size().width - JCComponent.getInsets((Container)this).left - JCComponent.getInsets((Container)this).right, this.size().height - JCComponent.getInsets((Container)this).top - JCComponent.getInsets((Container)this).bottom);
    }

    protected Dimension getLayoutSize(Component component) {
        return JCComponent.getPreferredSize(component);
    }

    public int getMinChildSize() {
        return this.min_child_size;
    }

    public int getOrientation() {
        return this.dir;
    }

    protected void getParameters() {
        super.getParameters();
        this.dir = JCContainer.conv.toEnum(this.getParam("Orientation"), "orientation", orient_strings, orient_values, this.dir);
        this.min_child_size = JCContainer.conv.toInt(this.getParam("MinChildSize"), this.min_child_size);
    }

    public void layout() {
        int n;
        int n2;
        int n3;
        int n4;
        Rectangle rectangle;
        int n5;
        if (this.getPeer() == null) {
            return;
        }
        int n6 = 0;
        Component[] componentArray = this.getComponents();
        if (componentArray.length == 0) {
            return;
        }
        int[] nArray = new int[componentArray.length];
        JCSplitterWindow jCSplitterWindow = this;
        synchronized (jCSplitterWindow) {
            int n7;
            int n8;
            n5 = this.getOrientation();
            rectangle = this.getDrawingArea();
            n4 = n8 = rectangle.x;
            n3 = n7 = rectangle.y;
        }
        int n9 = n2 = n5 == 1 ? rectangle.height : rectangle.width;
        if (componentArray.length == 1) {
            JCComponent.setBounds(componentArray[0], n4, n3, rectangle.width, rectangle.height);
            componentArray[0].layout();
            return;
        }
        int n10 = 0;
        while (n10 < componentArray.length) {
            Component component = componentArray[n10];
            Dimension dimension = this.resized && component.size().width > 0 && component.size().height > 0 ? component.size() : this.getLayoutSize(component);
            int n11 = n5 == 1 ? rectangle.width : dimension.width;
            int n12 = n5 == 0 ? rectangle.height : dimension.height;
            int n13 = n = n5 == 1 ? n12 : n11;
            if (n10 == componentArray.length - 1 && n6 + n < n2) {
                n11 = n5 == 1 ? rectangle.width : rectangle.width - n4;
                int n14 = n12 = n5 == 0 ? rectangle.height : rectangle.height - n3;
            }
            if (this.resized) {
                JCComponent.setBounds(component, n4, n3, n11, n12);
            } else {
                nArray[n10] = n5 == 1 ? n12 : n11;
            }
            n6 += nArray[n10];
            n4 += n5 == 1 ? 0 : n11 + 1;
            n3 += n5 == 1 ? n12 + 1 : 0;
            ++n10;
        }
        if (this.resized) {
            return;
        }
        int n15 = n6 - n2;
        while (n15 > 0) {
            int n16 = 0;
            n = -1;
            int n17 = 0;
            while (n17 < nArray.length) {
                if (!(componentArray[n17] instanceof JCSeparator) && nArray[n17] >= n16) {
                    n16 = nArray[n17];
                    n = n17;
                }
                ++n17;
            }
            if (n == -1) break;
            Component component = componentArray[n];
            int n18 = Math.max(nArray[n] - n15, this.getMinChildSize());
            n15 -= nArray[n] - n18;
            nArray[n] = -n18;
        }
        this.layout(nArray);
    }

    void layout(int[] nArray) {
        if (nArray == null) {
            return;
        }
        Rectangle rectangle = this.getDrawingArea();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = this.getOrientation();
        Component[] componentArray = this.getComponents();
        int n4 = 0;
        while (n4 < Math.min(nArray.length, componentArray.length)) {
            Component component = componentArray[n4];
            nArray[n4] = Math.abs(nArray[n4]);
            int n5 = n3 == 1 ? rectangle.width : nArray[n4];
            int n6 = n3 == 0 ? rectangle.height : nArray[n4];
            JCComponent.setBounds(component, n, n2, n5, n6);
            component.layout();
            n += n3 == 1 ? 0 : nArray[n4] + 1;
            n2 += n3 == 1 ? nArray[n4] + 1 : 0;
            ++n4;
        }
    }

    protected int preferredHeight() {
        Component[] componentArray = this.getComponents();
        if (componentArray.length == 0) {
            return 100;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.countComponents()) {
            int n3 = JCComponent.getPreferredSize((Component)componentArray[n2]).height;
            n = this.dir == 1 ? (n += n3) : Math.max(n, n3);
            ++n2;
        }
        return n;
    }

    protected int preferredWidth() {
        Component[] componentArray = this.getComponents();
        if (componentArray.length == 0) {
            return 100;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.countComponents()) {
            int n3 = JCComponent.getPreferredSize((Component)componentArray[n2]).width;
            n = this.dir == 0 ? (n += n3) : Math.max(n, n3);
            ++n2;
        }
        return n;
    }

    public void remove(Component component) {
        Component component2;
        int n = this.getComponent(component);
        if (n < 0) {
            return;
        }
        if (!(component instanceof JCSeparator) && (component2 = this.getComponent(n == 0 ? n + 1 : n - 1)) instanceof JCSeparator) {
            super.remove(component2);
            component2.hide();
            this.resized = false;
        }
        super.remove(component);
        this.layout();
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    public void setMinChildSize(int n) {
        this.min_child_size = n;
    }

    public void setOrientation(int n) {
        JCUtilConverter.checkEnum(n, "orientation", orient_values);
        this.dir = n;
        Component[] componentArray = this.getComponents();
        int n2 = this.dir == 1 ? 0 : 1;
        int n3 = 0;
        while (n3 < componentArray.length) {
            if (componentArray[n3] instanceof JCSeparator) {
                ((JCSeparator)componentArray[n3]).setOrientation(n2);
            }
            ++n3;
        }
        this.resized = false;
        this.layout();
    }
}

