/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import jclass.base.Border;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCCheckbox;
import jclass.util.JCImageCreator;

public class Indicator {
    private static final String[] box_pixels = new String[]{"ggggggggggggl", "gbbbbbbbbbbl.", "gb.........l.", "gb.........l.", "gb.........l.", "gb.........l.", "gb.........l.", "gb.........l.", "gb.........l.", "gb.........l.", "gb.........l.", "gbllllllllll.", "l............"};
    private static Image box_image;
    private static final String[] cross_pixels;
    private static Image cross_image;
    private static final String[] mixed_cross_pixels;
    private static Image mixed_cross_image;
    private static final String[] check_pixels;
    private static Image check_image;
    private static final String[] mixed_check_pixels;
    private static Image mixed_check_image;
    private static final String[] circle_pixels;
    private static Image circle_image;
    private static final String[] circle_empty_pixels;
    private static Image circle_empty_image;
    private static final String[] diamond_pixels;

    static {
        cross_pixels = new String[]{"bb...bb", "bbb.bbb", ".bbbbb.", "..bbb..", ".bbbbb.", "bbb.bbb", "bb...bb"};
        mixed_cross_pixels = new String[]{"l.l.l.l.l", ".bb.l.bb.", "lbbb.bbbl", ".lbbbbbl.", "l..bbb.l.", ".lbbbbb.l", "lbbb.bbb.", ".bb.l.bb.", "l.l.l.l.l"};
        check_pixels = new String[]{".........", ".......b.", "......bb.", ".b...bbb.", ".bb.bbb..", ".bbbbb...", "..bbb....", "...b.....", "........."};
        mixed_check_pixels = new String[]{"l.l.l.l..", ".l.l.l.bl", "l.l.l.bb.", ".b.l.bbbl", "lbb.bbbl.", ".bbbbbl.l", "l.bbbl.l.", ".l.b.l.l.", "l.l.l.l.l"};
        circle_pixels = new String[]{"    llll     ", "  lbbbbbbl   ", " lbl.....bl  ", " bl..lll..l  ", "lb..bbbbb..l.", "lb.lbbbbbl.l.", "lb.lbbbbbl.l.", "lb.lbbbbbl.l.", " b..bbbbb..l.", " lb..lll..l. ", "  ll.....l . ", "    lllll..  ", "    .....    "};
        circle_empty_pixels = new String[]{"    llll     ", "  lbbbbbbl   ", " lbl.....bl  ", " bl.......l  ", "lb.........l.", "lb.........l.", "lb.........l.", "lb.........l.", " b.........l.", " lb.......l. ", "  ll.....l . ", "    lllll..  ", "    .....    "};
        diamond_pixels = new String[]{"      t      ", "     ttt     ", "    ttttt    ", "   tttmttt   ", "  tttmmmttt  ", " tttmmmmmttt ", "tttmmmmmmmbbb", " bbbmmmmmbbb ", "  bbbmmmbbb  ", "   bbbmbbb   ", "    bbbbb    ", "     bbb     ", "      b      "};
    }

    private static Image createImage(Component component, String[] stringArray, Image image) {
        if (image != null) {
            return image;
        }
        JCImageCreator jCImageCreator = new JCImageCreator(component);
        jCImageCreator.setColor('g', Color.gray);
        jCImageCreator.setColor('l', Color.lightGray);
        jCImageCreator.setColor('b', Color.black);
        jCImageCreator.setColor('.', Color.white);
        jCImageCreator.setSize(stringArray.length, stringArray.length);
        return jCImageCreator.create(stringArray);
    }

    public static void draw(JCCheckbox jCCheckbox, Graphics graphics) {
        switch (jCCheckbox.indicator) {
            case 0: {
                Indicator.drawFilledBox(jCCheckbox, graphics);
                break;
            }
            case 1: {
                Indicator.drawBox(jCCheckbox, graphics);
                if (jCCheckbox.state == 1) {
                    Indicator.drawCheck(jCCheckbox, graphics);
                    break;
                }
                if (jCCheckbox.state == 0) break;
                Indicator.drawMixedCheck(jCCheckbox, graphics);
                break;
            }
            case 2: {
                if (jCCheckbox.state != 0) {
                    Indicator.drawCircle(jCCheckbox, graphics);
                    break;
                }
                Indicator.drawEmptyCircle(jCCheckbox, graphics);
                break;
            }
            case 3: {
                Indicator.drawBox(jCCheckbox, graphics);
                if (jCCheckbox.state == 1) {
                    Indicator.drawCross(jCCheckbox, graphics);
                    break;
                }
                if (jCCheckbox.state == 0) break;
                Indicator.drawMixedCross(jCCheckbox, graphics);
                break;
            }
            case 4: {
                Indicator.drawDiamond(jCCheckbox, graphics);
                break;
            }
            case 5: {
                if (jCCheckbox.image_list == null || jCCheckbox.state >= jCCheckbox.image_list.length || jCCheckbox.image_list[jCCheckbox.state] == null) break;
                graphics.setColor(jCCheckbox.getBackground());
                graphics.fillRect(jCCheckbox.ind_x, jCCheckbox.ind_y, jCCheckbox.ind_width, jCCheckbox.ind_height);
                graphics.drawImage(jCCheckbox.image_list[jCCheckbox.state], jCCheckbox.ind_x, jCCheckbox.ind_y, null);
                break;
            }
        }
    }

    private static void drawBox(JCCheckbox jCCheckbox, Graphics graphics) {
        Indicator.drawImage(jCCheckbox, graphics, box_pixels, box_image, 0);
    }

    private static void drawCheck(JCCheckbox jCCheckbox, Graphics graphics) {
        Indicator.drawImage(jCCheckbox, graphics, check_pixels, check_image, 2);
    }

    private static void drawCircle(JCCheckbox jCCheckbox, Graphics graphics) {
        Indicator.drawImage(jCCheckbox, graphics, circle_pixels, circle_image, 0);
    }

    private static void drawCross(JCCheckbox jCCheckbox, Graphics graphics) {
        Indicator.drawImage(jCCheckbox, graphics, cross_pixels, cross_image, 3);
    }

    private static void drawDiamond(JCCheckbox jCCheckbox, Graphics graphics) {
        Color color = Indicator.getFillColor(jCCheckbox);
        Color color2 = jCCheckbox.state == 1 ? BWTUtil.darker(color) : BWTUtil.brighter(color);
        Color color3 = jCCheckbox.state == 1 ? BWTUtil.brighter(color) : BWTUtil.darker(color);
        JCImageCreator jCImageCreator = new JCImageCreator(jCCheckbox, 13, 13);
        jCImageCreator.setColor('t', color2);
        jCImageCreator.setColor('m', color);
        jCImageCreator.setColor('b', color3);
        graphics.drawImage(jCImageCreator.create(diamond_pixels), jCCheckbox.ind_x, jCCheckbox.ind_y, null);
    }

    private static void drawEmptyCircle(JCCheckbox jCCheckbox, Graphics graphics) {
        Indicator.drawImage(jCCheckbox, graphics, circle_empty_pixels, circle_empty_image, 0);
    }

    private static void drawFilledBox(JCCheckbox jCCheckbox, Graphics graphics) {
        graphics.setColor(Indicator.getFillColor(jCCheckbox));
        graphics.fillRect(jCCheckbox.ind_x, jCCheckbox.ind_y, jCCheckbox.ind_width - 1, jCCheckbox.ind_height - 1);
        int n = jCCheckbox.state == 1 ? 3 : 4;
        Border.draw(graphics, n, 2, jCCheckbox.ind_x, jCCheckbox.ind_y, jCCheckbox.ind_width, jCCheckbox.ind_height, graphics.getColor(), null);
    }

    private static void drawImage(JCCheckbox jCCheckbox, Graphics graphics, String[] stringArray, Image image, int n) {
        image = Indicator.createImage(jCCheckbox, stringArray, image);
        graphics.drawImage(image, jCCheckbox.ind_x + n, jCCheckbox.ind_y + n, null);
    }

    private static void drawMixedCheck(JCCheckbox jCCheckbox, Graphics graphics) {
        Indicator.drawImage(jCCheckbox, graphics, mixed_check_pixels, mixed_check_image, 2);
    }

    private static void drawMixedCross(JCCheckbox jCCheckbox, Graphics graphics) {
        Indicator.drawImage(jCCheckbox, graphics, mixed_cross_pixels, mixed_cross_image, 2);
    }

    private static Color getFillColor(JCCheckbox jCCheckbox) {
        Color color = null;
        color = jCCheckbox.state == 1 ? jCCheckbox.select_color : jCCheckbox.unselect_color;
        return color != null ? color : jCCheckbox.getBackground();
    }
}

