/*
 * Decompiled with CFR 0.152.
 */
package jclass.beans;

import java.beans.PropertyEditorSupport;
import jclass.util.ConvertUtil;
import jclass.util.JCString;
import jclass.util.JCUtilConverter;

public class ObjectEditor
extends PropertyEditorSupport {
    public String getAsText() {
        Object object = this.getValue();
        if (object == null) {
            return "";
        }
        if (object instanceof JCString) {
            return ((JCString)object).toString2();
        }
        return JCUtilConverter.fromNewLine(object.toString());
    }

    public String getJavaInitializationString() {
        Object object = this.getValue();
        String string = this.getAsText();
        if (object instanceof String) {
            return "\"" + string + "\"";
        }
        if (object instanceof Integer) {
            return "\"" + string + "\"";
        }
        if (object instanceof Boolean) {
            return object == Boolean.TRUE ? "\"true\"" : "\"false\"";
        }
        return "jclass.util.ConvertUtil.toCellValue(null, \"" + string + "\", true)";
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null) {
            this.setValue(null);
            return;
        }
        Object object = ConvertUtil.toCellValue(null, string, true);
        if (object == null) {
            throw new IllegalArgumentException("invalid object: " + string);
        }
        if (object instanceof String && object.equals(string)) {
            this.setValue(object);
            return;
        }
        try {
            this.setValue(new Integer(Integer.parseInt(string)));
            return;
        }
        catch (Exception exception) {
            if (string.equalsIgnoreCase("true")) {
                this.setValue(Boolean.TRUE);
            } else if (string.equalsIgnoreCase("false")) {
                this.setValue(Boolean.FALSE);
            } else {
                this.setValue(JCUtilConverter.toNewLine(string));
            }
            return;
        }
    }
}

