/*
 * Decompiled with CFR 0.152.
 */
package jclass.base;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import jclass.base.BaseComponent;
import jclass.base.Border;
import jclass.util.JCEnvironment;

public abstract class TransientComponent
extends BaseComponent {
    public static long popdown_event_timestamp;
    public static long mouse_down_event_timestamp;
    protected int highlight = 2;
    protected Color highlight_color;
    protected int pref_width = -999;
    protected int pref_height = -999;
    protected boolean traversable = true;
    protected transient Graphics draw_gc;
    private static final int[][] keyCodes;
    private boolean ignoreNextEvent = false;
    private static final boolean TRACE = false;

    static {
        keyCodes = new int[][]{{127, 127}, {40, 1005}, {35, 1001}, {10, 10}, {36, 1000}, {37, 1006}, {34, 1003}, {33, 1002}, {39, 1007}, {38, 1004}};
    }

    public TransientComponent() {
        this(null, null);
    }

    public TransientComponent(Applet applet, String string) {
        super(applet, string);
    }

    protected void clipGCToAncestors(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        int n = rectangle.x;
        int n2 = rectangle.y;
        Container container = this;
        while (container.getParent() != null) {
            Rectangle rectangle2 = container.getParent().getBounds();
            rectangle.x += rectangle2.x;
            rectangle.y += rectangle2.y;
            n += rectangle2.x;
            n2 += rectangle2.y;
            SwingUtilities.computeIntersection(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle);
            container = container.getParent();
        }
        rectangle.x -= n;
        rectangle.y -= n2;
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static final Event convertEvent(Component component, KeyEvent keyEvent) {
        int n = keyEvent.getKeyChar();
        int n2 = keyEvent.getKeyCode();
        int n3 = 0;
        while (n3 < keyCodes.length) {
            if (keyCodes[n3][0] == n2) {
                n = keyCodes[n3][1];
                break;
            }
            ++n3;
        }
        if (JCEnvironment.getOS() == 1 && JCEnvironment.getJavaVersion() >= 116 && (n & 0xFF00) != 0 && keyEvent.getKeyChar() != '\r' && n2 != 10 && n2 != 38 && n2 != 40 && n2 != 37 && n2 != 39 && n2 != 33 && n2 != 34 && n2 != 36 && n2 != 35) {
            n -= 65280;
        }
        return new Event(component, keyEvent.getWhen(), 0, 0, 0, n, keyEvent.getModifiers());
    }

    public void disable() {
        if (this.isEnabled()) {
            this.drawHighlight(false);
            super.disable();
            this.repaint();
        }
    }

    protected void drawBorder(Graphics graphics) {
        if (!this.intersects(this.paint_rect, this.border)) {
            return;
        }
        if (this.getBorder() != null) {
            this.getBorder().paintBorder(this, graphics, this.highlight, this.highlight, this.getSize().width - 2 * this.highlight, this.getSize().height - 2 * this.highlight);
        } else {
            Border.draw(graphics, this.border_style, this.border, this.highlight, this.highlight, this.getSize().width - 2 * this.highlight, this.getSize().height - 2 * this.highlight, this.getBackground(), this.getForeground());
        }
    }

    protected void drawHighlight(Graphics graphics, boolean bl) {
        Color color;
        if (this.highlight == 0) {
            return;
        }
        if (!this.intersects(this.paint_rect, this.highlight)) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        Color color2 = color = bl ? this.highlight_color : this.getParent().getBackground();
        if (color == null) {
            color = Color.black;
        }
        graphics.setColor(color);
        int n5 = 0;
        while (n5 < this.highlight) {
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            ++n5;
            ++n;
            ++n2;
            n3 -= 2;
            n4 -= 2;
        }
    }

    protected void drawHighlight(boolean bl) {
        Graphics graphics;
        if (this.isShowing() && (graphics = this.getGraphics()) != null) {
            this.clipGCToAncestors(graphics);
            this.drawHighlight(graphics, bl);
            graphics.dispose();
        }
    }

    protected void drawHighlightAndBorder(Graphics graphics) {
        this.drawHighlight(graphics, this.has_focus);
        if (this.border > 0 && this.border_style != 0) {
            this.drawBorder(graphics);
        }
    }

    public void enable() {
        if (!this.isEnabled()) {
            super.enable();
            this.repaint();
        }
    }

    public Rectangle getDrawingArea() {
        Rectangle rectangle = new Rectangle();
        this.getDrawingArea(rectangle);
        return rectangle;
    }

    public void getDrawingArea(Rectangle rectangle) {
        int n = this.highlight + this.border;
        rectangle.setBounds(n + this.insets.left, n + this.insets.top, Math.max(0, this.getSize().width - (2 * n + this.insets.left + this.insets.right)), Math.max(0, this.getSize().height - (2 * n + this.insets.top + this.insets.bottom)));
    }

    public int getDrawingAreaHeight() {
        int n = 2 * this.border + 2 * this.highlight + this.insets.top + this.insets.bottom;
        return Math.max(0, this.getSize().height - n);
    }

    public int getDrawingAreaWidth() {
        int n = 2 * this.border + 2 * this.highlight + this.insets.left + this.insets.right;
        return Math.max(0, this.getSize().width - n);
    }

    public Color getHighlightColor() {
        return this.highlight_color != null ? this.highlight_color : Color.black;
    }

    public int getHighlightThickness() {
        return this.highlight;
    }

    public Rectangle getPaintRect() {
        return this.paint_rect;
    }

    public int getPreferredHeightInternal() {
        return this.pref_height;
    }

    public int getPreferredWidthInternal() {
        return this.pref_width;
    }

    public boolean gotFocus102(Event event, Object object) {
        if (!this.isEnabled()) {
            this.drawHighlight(false);
            return true;
        }
        super.gotFocus102(event, object);
        this.has_focus = true;
        if (this.isShowing()) {
            this.drawHighlight(true);
        }
        return true;
    }

    protected boolean isBustedVM() {
        return JCEnvironment.getOS() == 1 && JCEnvironment.getJavaVersion() >= 116;
    }

    public boolean isFocusTraversable() {
        return this.traversable && this.isEnabled() && this.isShowing();
    }

    public boolean isTraversable() {
        return this.traversable;
    }

    public synchronized void layout() {
        this.needs_layout = false;
    }

    public boolean lostFocus102(Event event, Object object) {
        super.lostFocus102(event, object);
        if (this.isShowing()) {
            this.drawHighlight(false);
        }
        return true;
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public void paint(Graphics graphics) {
        Object object = this.getAWTLock();
        synchronized (object) {
            block13: {
                block12: {
                    if (graphics == null) break block12;
                    if (this.getBackground() != null) break block13;
                }
                Object var3_3 = null;
                return;
            }
            this.draw_gc = graphics;
            this.paint_rect = graphics.getClipRect();
            if (this.double_buffer) {
                graphics = this.getDoubleBufferGraphics();
                if (graphics == null) {
                    graphics = this.draw_gc;
                }
                this.dblbuffer_image = this.getDoubleBufferImage();
                if (this.paint_rect != null) {
                    graphics.setClip(this.paint_rect);
                }
            }
            if (this.paint_rect == null) {
                this.paint_rect = new Rectangle(this.getSize());
                graphics.setClip(this.paint_rect);
            }
            this.rect.setBounds(0, 0, this.getSize().width, this.getSize().height);
            graphics.setColor(this.getBackground());
            this.fillBackground(graphics);
            this.drawHighlightAndBorder(graphics);
            graphics.setFont(this.getFont());
            graphics.setColor(this.getForeground());
            this.getDrawingArea(this.rect);
            graphics.clipRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            Image image = this.dblbuffer_image;
            this.paintComponent(graphics);
            if (this.double_buffer && this.dblbuffer_image != null) {
                this.draw_gc.drawImage(this.dblbuffer_image, 0, 0, null);
                if (image != this.dblbuffer_image) {
                    this.drawHighlightAndBorder(this.draw_gc);
                }
            }
            this.dblbuffer_image = image;
            this.draw_gc = null;
            this.paint_rect = null;
        }
    }

    protected int preferredHeight() {
        return -999;
    }

    public Dimension preferredSize() {
        int n = this.pref_width != -999 ? this.pref_width : (this.getPeer() != null ? this.preferredWidth() : 0);
        int n2 = n = n < 0 ? 50 : n + 2 * this.border + 2 * this.highlight + this.insets.left + this.insets.right;
        int n3 = this.pref_height != -999 ? this.pref_height : (this.getPeer() != null ? this.preferredHeight() : 0);
        n3 = n3 < 0 ? 50 : n3 + 2 * this.border + 2 * this.highlight + this.insets.top + this.insets.bottom;
        return new Dimension(n, n3);
    }

    protected int preferredWidth() {
        return -999;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        Event event = new Event(this, 0L, focusEvent.getID(), 0, 0, 0, 0);
        switch (event.id) {
            case 1005: {
                this.lostFocus(event, this);
                break;
            }
            case 1004: {
                this.gotFocus(event, this);
                break;
            }
        }
        super.processFocusEvent(focusEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        int n;
        int n2 = keyEvent.getID();
        int n3 = keyEvent.getKeyCode();
        if (this.isBustedVM() && this.ignoreNextEvent) {
            this.ignoreNextEvent = false;
            return;
        }
        if (this.isBustedVM() && !keyEvent.isControlDown() && keyEvent.getKeyChar() != '\r' && keyEvent.getKeyChar() != '\n' && n3 != 10 && n3 != 38 && n3 != 40 && n3 != 37 && n3 != 39 && n3 != 33 && n3 != 34 && n3 != 36 && n3 != 35) {
            n = 400;
        } else {
            n = 401;
            if (n2 != 402 && keyEvent.isControlDown()) {
                this.ignoreNextEvent = true;
            }
        }
        if (JCEnvironment.getOS() == 0 && n2 == 400 && keyEvent.isControlDown() && keyEvent.isAltDown()) {
            n2 = n;
            keyEvent = new KeyEvent(this, n2, keyEvent.getWhen(), 0, keyEvent.getKeyCode(), keyEvent.getKeyChar());
        }
        if (n2 == n) {
            if (keyEvent.isActionKey()) {
                n2 = 403;
            }
            if (n3 == 16 || n3 == 17 || n3 == 18) {
                return;
            }
            Event event = TransientComponent.convertEvent(this, keyEvent);
            event.id = n2;
            this.keyDown(event, event.key);
        }
        super.processKeyEvent(keyEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX(), mouseEvent.getY(), 0, mouseEvent.getModifiers());
        event.clickCount = mouseEvent.getClickCount();
        switch (event.id) {
            case 501: {
                mouse_down_event_timestamp = event.when;
                if (event.when - popdown_event_timestamp <= 50L && JCEnvironment.getOS() != 1) break;
                this.mouseDown(event, event.x, event.y);
                break;
            }
            case 502: {
                this.mouseUp(event, event.x, event.y);
                break;
            }
            case 504: {
                this.mouseEnter(event, event.x, event.y);
                break;
            }
            case 505: {
                this.mouseExit(event, event.x, event.y);
                break;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        Event event = new Event(this, mouseEvent.getWhen(), mouseEvent.getID(), mouseEvent.getX(), mouseEvent.getY(), 0, mouseEvent.getModifiers());
        switch (event.id) {
            case 503: {
                this.mouseMove(event, event.x, event.y);
                break;
            }
            case 506: {
                this.mouseDrag(event, event.x, event.y);
                break;
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        TransientComponent transientComponent = this;
        synchronized (transientComponent) {
            boolean bl;
            boolean bl2 = bl = this.size().width != n3 || this.size().height != n4;
            if (!bl && this.location().x == n && this.location().y == n2) {
                Object var6_7 = null;
                return;
            }
        }
        super.setBounds(n, n2, n3, n4);
        if (JCEnvironment.getJavaVersion() >= 110 || JCEnvironment.isJavaOS()) {
            this.layout();
        }
        if (this.do_repaint) {
            this.repaint();
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setCursor(int n) {
        Window window = BaseComponent.getWindow(this);
        if (window != null) {
            ((Component)window).setCursor(Cursor.getPredefinedCursor(n));
            this.getToolkit().sync();
        }
    }

    public void setHighlightColor(Color color) {
        TransientComponent transientComponent = this;
        synchronized (transientComponent) {
            this.highlight_color = color;
        }
        this.repaint();
    }

    public void setHighlightThickness(int n) {
        TransientComponent transientComponent = this;
        synchronized (transientComponent) {
            this.highlight = n;
        }
        this.doLayout();
        this.repaint();
    }

    public void setPreferredSize(int n, int n2) {
        this.pref_width = n;
        this.pref_height = n2;
    }

    public void setPreferredSize(Dimension dimension) {
        this.pref_width = dimension.width;
        this.pref_height = dimension.height;
    }

    public void setTraversable(boolean bl) {
        this.traversable = bl;
    }
}

