/*
 * Decompiled with CFR 0.152.
 */
package gramatica;

import gramatica.ListaProducciones;
import gramatica.ListaSimbolos;
import gramatica.Produccion;
import gramatica.Simbolo;
import java.util.Enumeration;
import java.util.Hashtable;

public class Gramatica
implements Cloneable {
    protected ListaSimbolos terminales = new ListaSimbolos();
    protected Hashtable tTerminales;
    protected ListaSimbolos noTerminales = new ListaSimbolos();
    protected Hashtable tNoTerminales;
    protected Simbolo simboloInicio = null;
    protected ListaProducciones producciones = new ListaProducciones();
    protected Hashtable tproducciones = new Hashtable();
    private Hashtable conjuntoPrimeros;
    private Hashtable conjuntoSiguientes;

    public Gramatica() {
        this.tTerminales = new Hashtable();
        this.tNoTerminales = new Hashtable();
    }

    public void ponerTerminal(Simbolo terminal) {
        if (!this.estaTerminal(terminal)) {
            this.terminales.anyadeElemento(terminal);
        }
        this.tTerminales.put(terminal.toString(), "si");
    }

    public void ponerTTerminales(Hashtable tprod) {
        this.tTerminales = tprod;
    }

    public Hashtable tTerminales() {
        return this.tTerminales;
    }

    public Simbolo terminal(int indice) {
        return (Simbolo)this.terminales.elementoEnSC(indice);
    }

    public int numTerminales() {
        return this.terminales.tamanyoLista();
    }

    public boolean estaTerminal(Simbolo simbolo) {
        if (simbolo.esLambda()) {
            return true;
        }
        return this.tTerminales.get(simbolo.toString()) == "si";
    }

    public void ponerNoTerminal(Simbolo noTerminal) {
        if (!this.estaNoTerminal(noTerminal)) {
            this.noTerminales.anyadeElemento(noTerminal);
        }
        this.tNoTerminales.put(noTerminal.toString(), "si");
    }

    public void quitarNoTerminal(Simbolo noTerminal) {
        if (this.estaNoTerminal(noTerminal)) {
            this.noTerminales.borraElemento(noTerminal);
        }
        this.tNoTerminales.put(noTerminal.toString(), "no");
    }

    public void ponerTNoTerminales(Hashtable tprod) {
        this.tNoTerminales = tprod;
    }

    public Hashtable tNoTerminales() {
        return this.tNoTerminales;
    }

    public Simbolo noTerminal(int indice) {
        return (Simbolo)this.noTerminales.elementoEnSC(indice);
    }

    public int numNoTerminales() {
        return this.noTerminales.tamanyoLista();
    }

    public boolean estaNoTerminal(Simbolo simbolo) {
        return this.tNoTerminales.get(simbolo.toString()) == "si";
    }

    public void ponerSimboloInicial(Simbolo simboloInicial) {
        this.simboloInicio = simboloInicial.copiar();
    }

    public Simbolo simboloInicial() {
        if (this.simboloInicio != null) {
            return this.simboloInicio.copiar();
        }
        return null;
    }

    public void ponerProduccion(Produccion produccion) {
        if (!this.estaProduccion(produccion)) {
            this.producciones.anyadeElemento(produccion);
            ListaProducciones set = (ListaProducciones)this.tproducciones.get(produccion.parteIzda().toString());
            if (set == null) {
                set = new ListaProducciones();
            }
            set.anyadeElemento(produccion);
            this.tproducciones.put(produccion.parteIzda().toString(), set);
        }
    }

    public void quitarProduccion(Produccion produccion) {
        ListaProducciones set;
        if (this.estaProduccion(produccion)) {
            this.producciones.borraElemento(produccion);
        }
        if ((set = (ListaProducciones)this.tproducciones.get(produccion.parteIzda().toString())) != null) {
            set.borraElemento(produccion);
            this.tproducciones.put(produccion.parteIzda().toString(), set);
        }
    }

    public void ponerTProducciones(Hashtable tprod) {
        this.tproducciones = tprod;
    }

    public Hashtable tablaProducciones() {
        return this.tproducciones;
    }

    public ListaProducciones dameProducciones(Simbolo simbolo) {
        ListaProducciones aux = new ListaProducciones();
        aux = (ListaProducciones)this.tproducciones.get(simbolo.toString());
        if (aux == null) {
            return new ListaProducciones();
        }
        return aux.copiar();
    }

    public boolean estaProduccion(Produccion produccion) {
        return this.producciones.estaElemento(produccion);
    }

    public int numProducciones() {
        return this.producciones.tamanyoLista();
    }

    public Produccion produccion(int indice) {
        return (Produccion)this.producciones.elementoEn(indice);
    }

    public void mostrar() {
        System.out.println("Simbolo Inicial");
        System.out.println(this.simboloInicio.toString());
        System.out.println("Terminales");
        this.terminales.mostrar();
        System.out.println("No Terminales");
        this.noTerminales.mostrar();
        System.out.println("Producciones");
        this.producciones.mostrar();
    }

    public ListaSimbolos listaTerminales() {
        return this.terminales.copiar();
    }

    public ListaSimbolos listaNoTerminales() {
        return this.noTerminales.copiar();
    }

    public ListaProducciones listaProducciones() {
        return this.producciones.copiar();
    }

    public Gramatica copiar() {
        int i;
        Gramatica resultado = new Gramatica();
        resultado.ponerSimboloInicial(this.simboloInicio.copiar());
        for (i = 0; i < this.terminales.tamanyoLista(); ++i) {
            resultado.ponerTerminal(((Simbolo)this.terminales.elementoEn(i)).copiar());
        }
        for (i = 0; i < this.noTerminales.tamanyoLista(); ++i) {
            resultado.ponerNoTerminal(((Simbolo)this.noTerminales.elementoEn(i)).copiar());
        }
        for (i = 0; i < this.producciones.tamanyoLista(); ++i) {
            resultado.ponerProduccion(((Produccion)this.producciones.elementoEn(i)).copiar());
        }
        resultado.ponerTProducciones(this.copiarTablaProducciones());
        resultado.ponerConjPrimeros((Hashtable)this.conjPrimeros().clone());
        resultado.ponerConjSiguientes((Hashtable)this.conjSiguientes().clone());
        resultado.ponerTNoTerminales((Hashtable)this.tNoTerminales().clone());
        resultado.ponerTTerminales((Hashtable)this.tTerminales().clone());
        return resultado;
    }

    public Hashtable conjPrimeros() {
        return this.conjuntoPrimeros;
    }

    public void ponerConjPrimeros(Hashtable conj) {
        this.conjuntoPrimeros = conj;
    }

    public Hashtable conjSiguientes() {
        return this.conjuntoSiguientes;
    }

    public void ponerConjSiguientes(Hashtable conj) {
        this.conjuntoSiguientes = conj;
    }

    private Hashtable copiarTablaProducciones() {
        Enumeration elementos = this.tproducciones.elements();
        Enumeration claves = this.tproducciones.keys();
        Hashtable copia = new Hashtable();
        while (claves.hasMoreElements()) {
            copia.put(claves.nextElement(), ((ListaProducciones)elementos.nextElement()).copiar());
        }
        return copia;
    }
}

