/*
 * Decompiled with CFR 0.152.
 */
package grafos;

import grafos.Conjunto;
import grafos.Dimension2D;
import grafos.Punto2D;

public class Nodo
implements Cloneable {
    private Conjunto adyacencias;
    protected double x;
    protected double y;
    protected int ancho;
    protected int alto;
    private String texto;
    protected int indice;
    protected int id;
    protected boolean tieneId;

    public Nodo(double x, double y, int ancho, int alto, int indice, String texto) {
        this.x = x;
        this.y = y;
        this.indice = indice;
        this.ancho = ancho;
        this.alto = alto;
        this.texto = texto;
        this.tieneId = false;
        this.adyacencias = new Conjunto();
    }

    public void ponerId(int id) {
        this.tieneId = true;
        this.id = id;
    }

    public Integer obtenerObjetoId() {
        if (!this.tieneId) {
            return null;
        }
        return new Integer(this.id);
    }

    public int obtenerId() {
        return this.id;
    }

    public void ponerPosicion(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void ponerPosicion(Punto2D nuevaPosicion) {
        this.x = nuevaPosicion.x;
        this.y = nuevaPosicion.y;
    }

    public Punto2D obtenerPosicion() {
        Punto2D posicion = new Punto2D(this.x, this.y);
        return posicion;
    }

    public void ponerDimension(int ancho, int alto) {
        this.ancho = ancho;
        this.alto = alto;
    }

    public void ponerDimension(Dimension2D dimension) {
        this.ancho = dimension.ancho;
        this.alto = dimension.alto;
    }

    public Dimension2D obtenerDimension() {
        Dimension2D dimension = new Dimension2D(this.ancho, this.alto);
        return dimension;
    }

    public void ponerTexto(String texto) {
        this.texto = texto;
    }

    public String obtenerTexto() {
        return this.texto;
    }

    public void ponerHijo(int hijo) {
        this.adyacencias.incluyeElemento(hijo);
    }

    public void quitarHijo(int hijo) {
        this.adyacencias.borraElemento(hijo);
    }

    public Conjunto obtenerHijos() {
        return (Conjunto)this.adyacencias.clone();
    }

    public int primerHijo() {
        return this.adyacencias.primero();
    }

    public int siguienteHijo() {
        return this.adyacencias.siguiente();
    }

    public int obtenerIndice() {
        return this.indice;
    }

    public int buscarSiguienteHijo(int n) {
        return this.adyacencias.buscaSiguiente(n);
    }

    public boolean tieneHijo(int hijo) {
        return this.adyacencias.estaElemento(hijo);
    }

    public boolean tieneHijo(Nodo hijo) {
        return this.adyacencias.estaElemento(hijo.indice);
    }

    public int numeroDeHijos() {
        return this.adyacencias.numberoDeElementos();
    }

    public Object clone() throws CloneNotSupportedException {
        Nodo copia = (Nodo)super.clone();
        copia.adyacencias = (Conjunto)this.adyacencias.clone();
        return copia;
    }
}

