/*
 * Decompiled with CFR 0.152.
 */
package grafos;

import java.util.NoSuchElementException;

public class Conjunto
implements Cloneable {
    static final int BITS = 6;
    static final int MASK = 63;
    private long[] bits = new long[1];
    private int posicionSiguiente = 0;

    public Conjunto() {
    }

    public Conjunto(int elemento) {
        this.incluyeElemento(elemento);
    }

    private void crecer(int tamanyo) {
        long[] nuevosbits = new long[tamanyo];
        System.arraycopy(this.bits, 0, nuevosbits, 0, this.bits.length);
        this.bits = nuevosbits;
    }

    public int buscaSiguiente(int n) {
        long bit;
        int val;
        int bytepos;
        int i;
        for (i = bytepos = n >> 6; i < this.bits.length && this.bits[i] == (long)0; ++i) {
        }
        if (i == this.bits.length) {
            return -1;
        }
        long byteval = this.bits[i];
        if (i == bytepos) {
            val = n;
            bit = 1L << (val & 0x3F);
            while ((bit & byteval) == (long)0 && bit != Long.MIN_VALUE) {
                bit <<= 1;
                ++val;
            }
            if ((bit & byteval) != (long)0) {
                return val;
            }
            ++i;
            while (i < this.bits.length && this.bits[i] == (long)0) {
                ++i;
            }
            if (i == this.bits.length) {
                return -1;
            }
            byteval = this.bits[i];
        }
        val = i << 6;
        bit = 1L;
        while ((bit & byteval) == (long)0 && bit != Long.MIN_VALUE) {
            bit <<= 1;
            ++val;
        }
        if ((bit & byteval) == (long)0) {
            return -1;
        }
        return val;
    }

    public boolean esVacio() {
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] == (long)0) continue;
            return false;
        }
        return true;
    }

    public int primero() {
        this.posicionSiguiente = this.buscaSiguiente(0) + 1;
        return this.posicionSiguiente - 1;
    }

    public int siguiente() {
        this.posicionSiguiente = this.buscaSiguiente(this.posicionSiguiente) + 1;
        return this.posicionSiguiente - 1;
    }

    public boolean estaElemento(int n) {
        int bytepos = n >> 6;
        if (bytepos >= this.bits.length) {
            return false;
        }
        return (this.bits[bytepos] & 1L << (n & 0x3F)) != (long)0;
    }

    public void incluyeElemento(int n) {
        int bytepos = n >> 6;
        if (bytepos >= this.bits.length) {
            this.crecer(bytepos + 1);
        }
        int n2 = bytepos;
        this.bits[n2] = this.bits[n2] | 1L << (n & 0x3F);
    }

    public void borraElemento(int n) throws NoSuchElementException {
        int bytepos = n >> 6;
        if (bytepos >= this.bits.length) {
            return;
        }
        int n2 = bytepos;
        this.bits[n2] = this.bits[n2] & (1L << (n & 0x3F) ^ 0L - 1L);
    }

    public boolean esSubconjunto(Conjunto s) {
        int i;
        int minsize = Math.min(this.bits.length, s.bits.length);
        if (minsize < s.bits.length) {
            for (i = minsize; i < s.bits.length; ++i) {
                if (s.bits[i] == (long)0) continue;
                return false;
            }
        }
        for (i = 0; i < minsize; ++i) {
            if ((s.bits[i] & this.bits[i]) == s.bits[i]) continue;
            return false;
        }
        return true;
    }

    public void interseccion(Conjunto s) {
        int i;
        int minsize = Math.min(this.bits.length, s.bits.length);
        for (i = 0; i < minsize; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & s.bits[i];
        }
        if (this.bits.length > s.bits.length) {
            for (i = s.bits.length; i < this.bits.length; ++i) {
                this.bits[i] = 0L;
            }
        }
    }

    public void union(Conjunto s) {
        if (s.bits.length > this.bits.length) {
            this.crecer(s.bits.length);
        }
        for (int i = 0; i < s.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] | s.bits[i];
        }
    }

    public void diferencia(Conjunto s) {
        if (s.bits.length > this.bits.length) {
            this.crecer(s.bits.length);
        }
        for (int i = 0; i < s.bits.length; ++i) {
            this.bits[i] = (this.bits[i] | s.bits[i]) ^ s.bits[i];
        }
    }

    public Object clone() {
        Conjunto set = new Conjunto();
        set.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, set.bits, 0, this.bits.length);
        return set;
    }

    public boolean esIgualQue(Conjunto s) {
        int i;
        int minsize = Math.min(this.bits.length, s.bits.length);
        if (minsize < s.bits.length) {
            for (i = minsize; i < s.bits.length; ++i) {
                if (s.bits[i] == (long)0) continue;
                return false;
            }
        }
        if (minsize < this.bits.length) {
            for (i = minsize; i < s.bits.length; ++i) {
                if (this.bits[i] == (long)0) continue;
                return false;
            }
        }
        for (i = 0; i < minsize; ++i) {
            if (s.bits[i] == this.bits[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String cadena = "(";
        boolean primerElemento = true;
        int i = this.primero();
        while (i != -1) {
            if (primerElemento) {
                primerElemento = false;
            } else {
                cadena = String.valueOf(String.valueOf(cadena)).concat(", ");
            }
            cadena = String.valueOf(String.valueOf(cadena)).concat(String.valueOf(String.valueOf(i)));
            i = this.siguiente();
        }
        cadena = String.valueOf(String.valueOf(cadena)).concat(")");
        return cadena;
    }

    public int numberoDeElementos() {
        int num = 0;
        int i = this.primero();
        while (i != -1) {
            i = this.siguiente();
            ++num;
        }
        return num;
    }

    public void rellenar(int n) {
        int i;
        int bytepos;
        if ((bytepos = --n >> 6) >= this.bits.length) {
            this.crecer(bytepos + 1);
        }
        for (i = 0; i < this.bits.length - 1; ++i) {
            this.bits[i] = -1L;
        }
        for (long bit = 1L; bit <= 1L << (n & 0x3F); bit <<= 1) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] | bit;
        }
    }

    static {
        BITS = 6;
        MASK = 63;
    }
}

