/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.dx.dataset.CustomPaintSite;
import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jb.util.VetoableDispatch;
import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphModel;
import com.borland.jbcl.model.GraphModelEvent;
import com.borland.jbcl.model.GraphModelListener;
import com.borland.jbcl.model.GraphModelMulticaster;
import com.borland.jbcl.model.GraphSelectionEvent;
import com.borland.jbcl.model.GraphSelectionListener;
import com.borland.jbcl.model.GraphSelectionMulticaster;
import com.borland.jbcl.model.GraphSubfocusEvent;
import com.borland.jbcl.model.GraphSubfocusListener;
import com.borland.jbcl.model.GraphViewManager;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.NullGraphSelection;
import com.borland.jbcl.model.ToggleItemEditor;
import com.borland.jbcl.model.WritableGraphModel;
import com.borland.jbcl.model.WritableGraphSelection;
import com.borland.jbcl.util.DottedLine;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.util.ImageTexture;
import com.borland.jbcl.util.KeyMulticaster;
import com.borland.jbcl.util.SerializableImage;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.CustomItemEditor;
import com.borland.jbcl.view.CustomItemListener;
import com.borland.jbcl.view.CustomItemPainter;
import com.borland.jbcl.view.DataToolTip;
import com.borland.jbcl.view.GraphView;
import com.borland.jbcl.view.GridCore;
import com.borland.jbcl.view.NodeState;
import com.borland.jbcl.view.TreeEvent;
import com.borland.jbcl.view.TreeListener;
import com.objectspace.jgl.Array;
import com.objectspace.jgl.ArrayIterator;
import com.objectspace.jgl.HashMap;
import com.objectspace.jgl.HashMapIterator;
import com.objectspace.jgl.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

class TreeCore
extends BeanPanel
implements Serializable,
ItemEditSite,
FocusListener,
KeyListener,
GraphView,
GraphModelListener,
GraphSelectionListener {
    private transient GraphSelectionMulticaster selectionMulticaster;
    private transient GraphModelMulticaster modelMulticaster;
    private transient KeyMulticaster keyMulticaster;
    transient EventMulticaster subfocusListeners;
    transient EventMulticaster treeListeners;
    private boolean customizeEditors = false;
    private transient Array customizeListeners;
    private transient CustomItemEditor customEditor;
    private transient CustomItemPainter customPainter;
    private int itemOffset = 14;
    private int hIndent = 19;
    private int vgap = 0;
    private Dimension boxSize;
    private int alignment = 33;
    private int topMargin = 0;
    private int leftMargin = 2;
    private Insets margins;
    private transient DataToolTip toolTip;
    private boolean showRollover = false;
    private boolean batchMode = false;
    private boolean debugPaint = false;
    private boolean dragSubfocus = true;
    private boolean lockSubfocus = false;
    private boolean hSnap = false;
    private boolean growEditor = true;
    private boolean autoEdit = true;
    private boolean editInPlace = true;
    private Array presetCollapseList;
    private Array presetExpandList;
    private boolean initialized = false;
    private int lastClickPosition;
    private int lineCount;
    private int canvasHeight;
    private int canvasWidth;
    private JScrollPane scroller;
    private int style = 1;
    private NodeState lastCalc;
    private NodeState firstNode;
    private transient HashMap cache;
    private boolean showRoot = true;
    private boolean showFocus = true;
    private boolean hasFocus = false;
    private boolean expandByDefault = false;
    private boolean postOnEndEdit = true;
    private boolean snapOrigin = true;
    private Point editClickPoint;
    private NodeState editorNode;
    private transient ItemEditor editor;
    private boolean subfocusChecked = false;
    private NodeState mouseDown;
    private NodeState rollover;
    private NodeState subfocus;
    private NodeState selectAnchor;
    private boolean readOnly;
    private transient Image contractedArrow;
    private transient Image expandedArrow;
    private transient WritableGraphSelection selection = new NullGraphSelection();
    private transient GraphViewManager viewManager;
    private transient WritableGraphModel writeModel;
    private transient GraphModel model;
    boolean doStartEdit = false;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Hashtable hashtable = (Hashtable)objectInputStream.readObject();
        Object v = hashtable.get("m");
        if (v instanceof GraphModel) {
            this.model = (GraphModel)v;
        }
        if (this.model instanceof WritableGraphModel) {
            this.writeModel = (WritableGraphModel)this.model;
        }
        if ((v = hashtable.get("v")) instanceof GraphViewManager) {
            this.viewManager = (GraphViewManager)v;
        }
        if ((v = hashtable.get("s")) instanceof WritableGraphSelection) {
            this.selection = (WritableGraphSelection)v;
        }
        if ((v = hashtable.get("e")) instanceof SerializableImage) {
            this.expandedArrow = ((SerializableImage)v).getImage();
        }
        if ((v = hashtable.get("c")) instanceof SerializableImage) {
            this.contractedArrow = ((SerializableImage)v).getImage();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(5);
        if (this.model instanceof Serializable) {
            hashtable.put("m", this.model);
        }
        if (this.viewManager instanceof Serializable) {
            hashtable.put("v", this.viewManager);
        }
        if (this.selection instanceof Serializable) {
            hashtable.put("s", this.selection);
        }
        if (this.expandedArrow != null) {
            hashtable.put("e", SerializableImage.create(this.expandedArrow));
        }
        if (this.contractedArrow != null) {
            hashtable.put("c", SerializableImage.create(this.contractedArrow));
        }
        objectOutputStream.writeObject(hashtable);
    }

    public synchronized void removeCustomItemListener(CustomItemListener customItemListener) {
        if (this.customizeListeners != null) {
            this.customizeListeners.remove((Object)customItemListener);
        }
        if (this.customizeListeners.size() == 0) {
            this.customizeListeners = null;
        }
    }

    public synchronized void addCustomItemListener(CustomItemListener customItemListener) {
        if (this.customizeListeners == null) {
            this.customizeListeners = new Array();
        }
        this.customizeListeners.add((Object)customItemListener);
    }

    protected void fireCustomizeItemEvent(Object object, Object object2, int n, CustomPaintSite customPaintSite) {
        if (this.customizeListeners != null) {
            customPaintSite.reset();
            for (int i = 0; i < this.customizeListeners.size(); ++i) {
                ((CustomItemListener)this.customizeListeners.at(i)).customizeItem(object, object2, n, customPaintSite);
            }
        }
    }

    private void fireActionEvent() {
        Object object = this.model != null ? this.model.get(this.subfocus.node) : null;
        String string = object != null ? object.toString() : "";
        this.processActionEvent(new ActionEvent(this.scroller, 1001, string));
    }

    public void checkParentWindow() {
        this.findParentWindow();
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.keyMulticaster.remove(keyListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyMulticaster.add(keyListener);
    }

    public Point getEditClickPoint() {
        return this.editClickPoint;
    }

    public void doLayout() {
        if (this.editorNode != null && this.editor != null) {
            Rectangle rectangle = this.editorNode.itemRect;
            if (rectangle != null) {
                this.editor.changeBounds(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
            } else {
                this.editor.changeBounds(new Rectangle(0, 0, 0, 0));
            }
        }
    }

    public void safeEndEdit(boolean bl) {
        try {
            this.endEdit(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void safeEndEdit() {
        this.safeEndEdit(this.postOnEndEdit);
    }

    public void endEdit(boolean bl) throws Exception {
        this.lockSubfocus = false;
        ItemEditor itemEditor = this.editor;
        this.editor = null;
        if (itemEditor != null) {
            boolean bl2 = true;
            try {
                if (!bl || (bl2 = itemEditor.canPost())) {
                    if (bl && bl2) {
                        this.writeModel.set(this.editorNode.node, itemEditor.getValue());
                    }
                    this.repaintNode(this.editorNode);
                    if (bl2) {
                        Component component = itemEditor.getComponent();
                        itemEditor.endEdit(bl);
                        itemEditor.removeKeyListener(this);
                        itemEditor.removeKeyListener(this.keyMulticaster);
                        if (component != null) {
                            this.remove(component);
                            component.removeFocusListener(this);
                        }
                        this.updateViewState(this.editorNode.node, this.editorNode.level);
                        this.editClickPoint = null;
                        this.editorNode = null;
                        itemEditor = null;
                        this.requestFocus();
                    }
                }
            }
            catch (Exception exception) {
                this.lockSubfocus = true;
                this.editor = itemEditor;
                throw exception;
            }
        }
        this.editor = itemEditor;
    }

    public void endEdit() throws Exception {
        this.endEdit(this.postOnEndEdit);
    }

    private boolean isToggleItem(NodeState nodeState) {
        int n;
        if (this.model == null || this.viewManager == null || !this.editInPlace || this.batchMode) {
            return false;
        }
        Object object = this.model.get(nodeState.node);
        ItemEditor itemEditor = this.getEditor(nodeState, object, n = this.getState(nodeState));
        if (itemEditor instanceof ToggleItemEditor) {
            Rectangle rectangle = new Rectangle(nodeState.itemRect);
            return ((ToggleItemEditor)itemEditor).isToggle(object, rectangle, this) && this.canSet(nodeState.node);
        }
        return false;
    }

    protected void resyncEditor() {
        if (this.editorNode != null && this.editor != null) {
            Rectangle rectangle = this.getEditorRect();
            this.editor.changeBounds(rectangle != null ? rectangle : new Rectangle());
        }
    }

    protected Rectangle getEditorRect() {
        Component component;
        Rectangle rectangle = null;
        if (this.editorNode != null && this.editor != null && (rectangle = this.editorNode.itemRect) != null && this.growEditor && (component = this.editor.getComponent()) != null) {
            Dimension dimension = component.getPreferredSize();
            if (dimension.height > rectangle.height) {
                rectangle.height = dimension.height;
            }
        }
        return rectangle;
    }

    protected void startEdit(NodeState nodeState) {
        if (this.model == null || this.viewManager == null || !this.editInPlace || this.batchMode) {
            return;
        }
        this.rollover = null;
        this.editorNode = nodeState;
        if (nodeState == this.subfocus) {
            if (this.selection.getCount() != 1 || !this.selection.contains(nodeState.node)) {
                this.selection.removeAll();
                this.selection.add(nodeState.node);
            }
        } else {
            this.setSubfocus(this.editorNode, 67);
        }
        Object object = this.model.get(this.editorNode.node);
        int n = this.getState(this.editorNode);
        this.editor = this.getEditor(this.editorNode, object, n);
        if (this.editor == null) {
            this.editorNode = null;
            return;
        }
        Component component = this.editor.getComponent();
        if (component != null) {
            component.setVisible(false);
            this.add(component);
        }
        Rectangle rectangle = this.getEditorRect();
        this.editor.addKeyListener(this);
        this.editor.addKeyListener(this.keyMulticaster);
        this.editor.startEdit(object, rectangle, this);
        this.resyncEditor();
        if (this.editor != null && this.editor.getComponent() != null) {
            this.editor.getComponent().addFocusListener(this);
        }
        this.editClickPoint = null;
    }

    public void startEdit(GraphLocation graphLocation) {
        this.startEdit(this.getViewState(graphLocation));
    }

    public void modelStructureChanged(GraphModelEvent graphModelEvent) {
        if (!this.initialized) {
            return;
        }
        GraphLocation graphLocation = graphModelEvent.getLocation();
        switch (graphModelEvent.getChange()) {
            case 18: {
                this.updateViewState();
                NodeState nodeState = this.getViewState(graphLocation.getParent());
                if (nodeState == null) {
                    nodeState = this.firstNode;
                }
                if (this.expandByDefault && !nodeState.expanded && nodeState.node.hasChildren() == 1) {
                    this.expandNode(nodeState, true);
                    break;
                }
                this.updateNodeRects(nodeState, this.getSiteGraphics());
                this.repaintToEnd(nodeState);
                break;
            }
            case 34: {
                NodeState nodeState;
                NodeState nodeState2 = this.getViewState(graphLocation);
                if (nodeState2 != null && nodeState2.nextVisible != null && nodeState2.nextVisible.level == nodeState2.level) {
                    nodeState = nodeState2.nextVisible;
                } else if (nodeState2 != null && nodeState2.prevVisible != null) {
                    nodeState = nodeState2.prevVisible;
                } else if (nodeState2 != this.firstNode) {
                    nodeState = this.firstNode;
                } else {
                    nodeState = null;
                    this.subfocus = null;
                }
                if (this.selection != null && nodeState2 != null && this.selection.contains(nodeState2.node)) {
                    this.selection.remove(nodeState2.node);
                }
                if (nodeState2 == this.subfocus || this.subfocus != null && this.subfocus.isDescendentOf(graphLocation)) {
                    this.setSubfocus(nodeState, 66);
                }
                this.updateViewState();
                this.updateNodeRects(nodeState, this.getSiteGraphics());
                break;
            }
            case 50: {
                this.updateViewState();
                NodeState nodeState = this.getViewState(graphLocation);
                this.updateNodeRects(nodeState, this.getSiteGraphics());
                break;
            }
            case 2: {
                this.updateViewState();
                this.updateNodeRects(this.firstNode, this.getSiteGraphics());
                break;
            }
            default: {
                this.updateViewState();
                this.updateNodeRects(this.firstNode, this.getSiteGraphics());
            }
        }
        this.recalcVisible(true);
    }

    public void modelContentChanged(GraphModelEvent graphModelEvent) {
        GraphLocation graphLocation = graphModelEvent.getLocation();
        NodeState nodeState = this.getViewState(graphLocation);
        if (!this.initialized || graphLocation == null || nodeState == null) {
            return;
        }
        this.updateNodeRects(nodeState, this.getSiteGraphics());
        switch (graphModelEvent.getChange()) {
            case 33: {
                if (this.editor != null && this.editorNode != null && this.editorNode.equals(graphModelEvent.getLocation())) {
                    this.safeEndEdit(false);
                }
                this.repaintToEnd(nodeState);
                break;
            }
            default: {
                if (this.editor != null && this.editorNode != null && this.editorNode.equals(graphModelEvent.getLocation())) {
                    this.safeEndEdit(false);
                }
                this.repaintNode(nodeState);
            }
        }
        this.recalcVisible(true);
    }

    protected boolean makeExpanded(NodeState nodeState) {
        boolean bl = false;
        do {
            if (nodeState.expanded) continue;
            bl = true;
            nodeState.expanded = true;
        } while ((nodeState = this.getViewState(nodeState.node.getParent())) != null);
        return bl;
    }

    boolean isVisible(NodeState nodeState) {
        NodeState nodeState2;
        if (!this.isVisible()) {
            return false;
        }
        Rectangle rectangle = this.scroller.getViewport().getViewRect();
        if (nodeState == null || nodeState.itemRect.y < rectangle.y || nodeState.itemRect.y - rectangle.y > rectangle.height) {
            return false;
        }
        do {
            if ((nodeState2 = this.getViewState(nodeState.node.getParent())) != nodeState) continue;
            return false;
        } while ((nodeState = nodeState2) != null && nodeState.expanded);
        return nodeState == null;
    }

    void dump(NodeState nodeState) {
    }

    private int getState(NodeState nodeState) {
        int n = 0;
        if (nodeState == null) {
            return 0;
        }
        if (this.selection != null && this.selection.contains(nodeState.node)) {
            n |= 4;
        }
        if (!this.isEnabled()) {
            n |= 0x21;
        } else {
            if (this.showFocus && this.hasFocus && this.subfocus == nodeState) {
                n |= 2;
            }
            if ((this.focusState & 0x20) != 0) {
                n |= 0x20;
            }
            if (nodeState.expanded) {
                n |= 0x10;
            }
            if (this.showRollover && this.rollover != null && this.rollover == nodeState) {
                n |= 0x40;
            }
        }
        if (!this.hasFocus) {
            n |= 0x80;
        }
        return n;
    }

    public Component getSiteComponent() {
        return this;
    }

    public Graphics getSiteGraphics() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            graphics.setFont(this.getFont());
        }
        return graphics;
    }

    public boolean isTransparent() {
        return this.texture != null ? true : !this.isOpaque();
    }

    private void collapseChildNodes(GraphLocation graphLocation) {
        NodeState nodeState = this.getViewState(graphLocation);
        if (nodeState != null && nodeState.node.hasChildren() != 0) {
            this.expandNode(nodeState, false);
            GraphLocation[] graphLocationArray = graphLocation.getChildren();
            for (int i = 0; i < graphLocationArray.length; ++i) {
                this.collapseChildNodes(graphLocationArray[i]);
            }
        }
    }

    private void expandChildNodes(GraphLocation graphLocation) {
        NodeState nodeState = this.getViewState(graphLocation);
        if (nodeState != null && nodeState.node.hasChildren() != 0) {
            this.expandNode(nodeState, true);
            GraphLocation[] graphLocationArray = graphLocation.getChildren();
            for (int i = 0; i < graphLocationArray.length; ++i) {
                this.expandChildNodes(graphLocationArray[i]);
            }
        }
    }

    public void collapseAll(GraphLocation graphLocation) {
        if (graphLocation == null) {
            return;
        }
        this.collapseChildNodes(graphLocation);
        NodeState nodeState = this.getViewState(graphLocation);
        if (nodeState != null) {
            this.recalcVisible(true);
            this.repaintToEnd(nodeState);
        }
        if (this.subfocus != null && this.subfocus.isDescendentOf(graphLocation)) {
            this.setSubfocus(nodeState, 66);
        }
    }

    public void expandAll(GraphLocation graphLocation) {
        if (graphLocation == null) {
            return;
        }
        this.expandChildNodes(graphLocation);
        NodeState nodeState = this.getViewState(graphLocation);
        if (nodeState != null) {
            this.recalcVisible(true);
            this.repaintToEnd(nodeState);
        }
    }

    public void toggleExpanded(GraphLocation graphLocation) {
        if (!this.initialized || graphLocation == null) {
            return;
        }
        NodeState nodeState = this.getViewState(graphLocation);
        if (nodeState != null && nodeState.node.hasChildren() != 0) {
            boolean bl = false;
            bl = !nodeState.expanded ? this.expandNode(nodeState, true) : this.expandNode(nodeState, false);
            if (bl) {
                this.recalcVisible(true);
                this.repaintToEnd(nodeState);
            }
        }
    }

    public void collapse(GraphLocation graphLocation) {
        if (!this.initialized) {
            this.presetCollapseList.add((Object)graphLocation);
            return;
        }
        NodeState nodeState = this.getViewState(graphLocation);
        if (nodeState != null) {
            if (this.expandNode(nodeState, false)) {
                this.recalcVisible(true);
                this.repaintToEnd(nodeState);
            }
            if (this.subfocus != null && this.subfocus.isDescendentOf(graphLocation)) {
                this.setSubfocus(nodeState, 66);
            }
        }
    }

    public void expand(GraphLocation graphLocation) {
        if (!this.initialized) {
            this.presetExpandList.add((Object)graphLocation);
            return;
        }
        NodeState nodeState = this.getViewState(graphLocation);
        if (nodeState != null && this.expandNode(nodeState, true)) {
            this.recalcVisible(true);
            this.repaintToEnd(nodeState);
        }
    }

    public boolean isExpanded(GraphLocation graphLocation) {
        NodeState nodeState = this.getViewState(graphLocation);
        if (nodeState != null) {
            return nodeState.expanded;
        }
        return false;
    }

    protected boolean expandNode(NodeState nodeState, boolean bl) {
        if (nodeState.node.hasChildren() == 0) {
            return false;
        }
        if (nodeState.expanded != bl) {
            this.processTreeEvent(new TreeEvent(this, bl ? 1000 : 1001, nodeState.node));
            nodeState.expanded = bl;
            if (bl) {
                this.updateViewState(nodeState.node, nodeState.level);
                this.updateNodeRects(nodeState, this.getSiteGraphics());
            }
            return true;
        }
        return false;
    }

    public void removeSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.selectionMulticaster.remove(graphSelectionListener);
    }

    public void addSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.selectionMulticaster.add(graphSelectionListener);
    }

    public WritableGraphSelection getSelection() {
        return this.selection;
    }

    public void setSelection(WritableGraphSelection writableGraphSelection) {
        if (this.selection != null) {
            this.selection.removeSelectionListener(this);
            this.selection.removeSelectionListener(this.selectionMulticaster);
        }
        this.selection = writableGraphSelection;
        if (this.selection != null) {
            this.selection.addSelectionListener(this);
            this.selection.addSelectionListener(this.selectionMulticaster);
        }
    }

    int recalcVisible(GraphLocation graphLocation, int n) {
        NodeState nodeState;
        while (graphLocation != null && (nodeState = this.getViewState(graphLocation)) != null) {
            GraphLocation[] graphLocationArray;
            int n2 = this.leftMargin + nodeState.level * this.hIndent;
            nodeState.prevVisible = this.lastCalc;
            nodeState.nextVisible = null;
            ++this.lineCount;
            nodeState.lineNumber = nodeState.lineNumber;
            if (this.lastCalc != null) {
                this.lastCalc.nextVisible = nodeState;
            }
            this.lastCalc = nodeState;
            if (graphLocation.hasChildren() != 0) {
                nodeState.boxRect.x = n2;
                nodeState.boxRect.y = n + (nodeState.itemRect.height - nodeState.boxRect.height) / 2;
            }
            nodeState.boxRect.width = this.boxSize.width;
            nodeState.boxRect.height = this.boxSize.height;
            nodeState.itemRect.x = n2 += this.itemOffset;
            nodeState.itemRect.y = n;
            this.canvasHeight += nodeState.itemRect.height + this.vgap;
            if (nodeState.itemRect.x + nodeState.itemRect.width > this.canvasWidth) {
                this.canvasWidth = nodeState.itemRect.x + nodeState.itemRect.width;
            }
            n += nodeState.itemRect.height + this.vgap;
            if (nodeState.expanded && nodeState.node.hasChildren() != 0 && (graphLocationArray = nodeState.node.getChildren()).length > 0) {
                n = this.recalcVisible(graphLocationArray[0], n);
            }
            graphLocation = nodeState.getNextSibling();
        }
        return n;
    }

    void recalcVisible(boolean bl) {
        NodeState nodeState;
        int n = this.canvasWidth;
        int n2 = this.canvasHeight;
        this.lastCalc = null;
        this.lineCount = 0;
        this.canvasWidth = 0;
        this.canvasHeight = 0;
        if (this.model != null && (nodeState = this.getViewState(this.model.getRoot())) != null) {
            if (this.showRoot) {
                this.recalcVisible(nodeState.node, this.topMargin);
            } else if (nodeState.nextVisible != null) {
                this.recalcVisible(nodeState.nextVisible.node, this.topMargin);
            }
        }
        this.scroller.getVerticalScrollBar().setUnitIncrement(this.lineCount > 0 ? this.canvasHeight / this.lineCount : 0);
        if (this.canvasWidth != n || this.canvasHeight != n2) {
            this.invalidate();
            this.repaintNodes();
            if (bl && this.isShowing() && !this.batchMode) {
                this.scroller.validate();
                this.scrollView();
            }
        }
    }

    public void selectionChanged(GraphSelectionEvent graphSelectionEvent) {
        this.repaintSelection();
    }

    public void selectionItemChanged(GraphSelectionEvent graphSelectionEvent) {
        NodeState nodeState = this.getViewState(graphSelectionEvent.getLocation());
        if (nodeState != null) {
            if (this.subfocus == null) {
                this.subfocus = nodeState;
            }
            nodeState.selected = this.selection.contains(nodeState.node);
            this.repaintNode(nodeState);
        }
    }

    protected void repaintSelection() {
        Enumeration enumeration = this.cache.elements();
        while (enumeration.hasMoreElements()) {
            NodeState nodeState = (NodeState)enumeration.nextElement();
            boolean bl = this.selection.contains(nodeState.node);
            if (nodeState.selected != bl) {
                nodeState.selected = bl;
                this.repaintNode(nodeState);
                continue;
            }
            if (!nodeState.selected) continue;
            this.repaintNode(nodeState);
        }
    }

    private ItemEditor getEditor(NodeState nodeState, Object object, int n) {
        ItemEditor itemEditor;
        ItemEditor itemEditor2 = itemEditor = this.viewManager != null ? this.viewManager.getEditor(nodeState.node, object, n) : null;
        if (itemEditor != null && this.customizeEditors && this.customizeListeners != null) {
            this.customEditor.setEditor(itemEditor);
            this.fireCustomizeItemEvent(nodeState.node, object, n, this.customEditor);
            return this.customEditor;
        }
        return itemEditor;
    }

    private ItemPainter getPainter(NodeState nodeState, Object object, int n) {
        ItemPainter itemPainter;
        ItemPainter itemPainter2 = itemPainter = this.viewManager != null ? this.viewManager.getPainter(nodeState.node, object, n) : null;
        if (itemPainter != null && this.customizeListeners != null) {
            this.customPainter.setPainter(itemPainter);
            this.fireCustomizeItemEvent(nodeState.node, object, n, this.customPainter);
            return this.customPainter;
        }
        return itemPainter;
    }

    protected void processSubfocusEvent(GraphSubfocusEvent graphSubfocusEvent) {
        if (this.subfocusListeners.hasListeners()) {
            this.subfocusListeners.dispatch((DispatchableEvent)graphSubfocusEvent);
        }
    }

    protected boolean preProcessSubfocusEvent(GraphSubfocusEvent graphSubfocusEvent) {
        if (this.subfocusListeners.hasListeners()) {
            return this.subfocusListeners.vetoableDispatch((VetoableDispatch)graphSubfocusEvent);
        }
        return true;
    }

    public void removeSubfocusListener(GraphSubfocusListener graphSubfocusListener) {
        this.subfocusListeners.remove((EventListener)graphSubfocusListener);
    }

    public void addSubfocusListener(GraphSubfocusListener graphSubfocusListener) {
        this.subfocusListeners.add((EventListener)graphSubfocusListener);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        switch (focusEvent.getID()) {
            case 1004: {
                if (this.editor != null && this.editor.getComponent() != null) {
                    this.editor.getComponent().requestFocus();
                }
                if (this.hasFocus) break;
                this.hasFocus = true;
                break;
            }
            case 1005: {
                if (this.editor != null) break;
                this.hasFocus = false;
            }
        }
        if (this.model != null && this.subfocus == null) {
            this.setSubfocus(this.model.getRoot());
        }
        this.repaintNode(this.subfocus);
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.hasFocus) {
            this.hasFocus = false;
            this.repaintNode(this.subfocus);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void windowActiveChanged(boolean bl) {
        super.windowActiveChanged(bl);
        this.repaintSelection();
    }

    protected void processTreeEvent(TreeEvent treeEvent) {
        if (this.treeListeners.hasListeners()) {
            this.treeListeners.dispatch((DispatchableEvent)treeEvent);
        }
    }

    public void removeTreeListener(TreeListener treeListener) {
        this.treeListeners.remove((EventListener)treeListener);
    }

    public void addTreeListener(TreeListener treeListener) {
        this.treeListeners.add((EventListener)treeListener);
    }

    protected void processKeyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (this.editor != null || !this.autoEdit || keyEvent.isConsumed() || this.isReadOnly() || c == '\u0000' || c == '\t' || c == '\r' || c == '\n' || c == ' ' || c == '\u001b' || c == '+' || c == '-' || this.isToggleItem(this.subfocus) || keyEvent.isAltDown() || keyEvent.isControlDown() || !this.writeModel.canSet(this.subfocus.node)) {
            return;
        }
        this.startEdit(this.subfocus);
        Component component = null;
        if (this.editor != null && (component = this.editor.getComponent()) != null) {
            component.dispatchEvent(keyEvent);
        }
    }

    protected void processKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = keyEvent.isControlDown();
        boolean bl2 = keyEvent.isShiftDown();
        boolean bl3 = keyEvent.isAltDown();
        if (this.subfocus == null && this.model != null) {
            this.setSubfocus(this.model.getRoot());
        }
        int n2 = bl2 && bl ? 2 : (bl2 ? 2 : (bl ? 64 : 67));
        if (this.subfocus == null) {
            this.subfocus = this.firstNode;
        }
        switch (n) {
            case 36: {
                this.setSubfocus(this.hitTestLine(0), n2);
                keyEvent.consume();
                break;
            }
            case 35: {
                this.setSubfocus(this.hitTestLine(this.lineCount - 1), n2);
                keyEvent.consume();
                break;
            }
            case 38: {
                if (this.subfocus == null) break;
                this.setSubfocus(this.subfocus.prevVisible, n2);
                keyEvent.consume();
                break;
            }
            case 40: {
                if (this.subfocus == null) break;
                this.setSubfocus(this.subfocus.nextVisible, n2);
                keyEvent.consume();
                break;
            }
            case 33: {
                if (this.subfocus == null || this.lineCount <= 0 || this.canvasHeight <= 0) break;
                int n3 = this.canvasHeight / this.lineCount;
                int n4 = this.scroller.getViewport().getExtentSize().height / n3;
                NodeState nodeState = this.subfocus;
                while (nodeState.prevVisible != null && --n4 > 0) {
                    nodeState = nodeState.prevVisible;
                }
                this.setSubfocus(nodeState, n2);
                keyEvent.consume();
                break;
            }
            case 34: {
                if (this.subfocus == null || this.lineCount <= 0 || this.canvasHeight <= 0) break;
                int n5 = this.canvasHeight / this.lineCount;
                int n6 = this.scroller.getViewport().getExtentSize().height / n5;
                NodeState nodeState = this.subfocus;
                while (nodeState.nextVisible != null && --n6 > 0) {
                    nodeState = nodeState.nextVisible;
                }
                this.setSubfocus(nodeState, n2);
                keyEvent.consume();
                break;
            }
            case 37: {
                if (!(this.subfocus == null || this.subfocus.expanded && this.subfocus.node.hasChildren() != 0)) {
                    GraphLocation graphLocation = this.subfocus.node.getParent();
                    this.setSubfocus(this.getViewState(graphLocation), n2);
                    keyEvent.consume();
                    break;
                }
            }
            case 109: {
                if (bl3 || bl2 || bl || this.subfocus == null || !this.subfocus.expanded) break;
                this.expandNode(this.subfocus, false);
                this.recalcVisible(true);
                this.repaintToEnd(this.subfocus);
                keyEvent.consume();
                break;
            }
            case 39: {
                if (this.subfocus != null && this.subfocus.expanded && this.subfocus.node.hasChildren() != 0) {
                    this.setSubfocus(this.subfocus.nextVisible, n2);
                    keyEvent.consume();
                    break;
                }
            }
            case 107: {
                if (bl3 || bl2 || bl || this.subfocus == null || this.subfocus.expanded || this.subfocus.node.hasChildren() == 0) break;
                this.expandNode(this.subfocus, true);
                this.recalcVisible(true);
                this.repaintToEnd(this.subfocus);
                keyEvent.consume();
                break;
            }
            case 32: {
                if (this.subfocus == null || bl2 || bl3) break;
                if (bl && this.selection.contains(this.subfocus.node)) {
                    this.selection.remove(this.subfocus.node);
                } else {
                    this.selection.add(this.subfocus.node);
                }
                if (this.isToggleItem(this.subfocus)) {
                    this.startEdit(this.subfocus);
                }
                keyEvent.consume();
                break;
            }
            case 10: {
                if (bl && this.editor == null && this.canSet(this.subfocus.node)) {
                    this.startEdit(this.subfocus);
                } else {
                    this.fireActionEvent();
                }
                keyEvent.consume();
                break;
            }
            case 113: {
                if (this.editor != null || this.isToggleItem(this.subfocus) || !this.canSet(this.subfocus.node)) break;
                this.startEdit(this.subfocus);
                keyEvent.consume();
                break;
            }
            case 74: {
                if (!bl2 || !bl || !bl3) break;
                this.debugPaint = !this.debugPaint;
                break;
            }
            default: {
                return;
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.editor == null || keyEvent.isConsumed()) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.safeEndEdit(true);
                if (this.lockSubfocus) break;
                keyEvent.consume();
                break;
            }
            case 27: {
                this.safeEndEdit(false);
                keyEvent.consume();
                break;
            }
            case 33: 
            case 34: 
            case 38: 
            case 40: {
                this.safeEndEdit();
                this.processKeyPressed(keyEvent);
                break;
            }
            case 37: 
            case 39: {
                if (!keyEvent.isControlDown()) break;
                this.safeEndEdit();
                this.processKeyPressed(keyEvent);
            }
        }
    }

    protected void processMouseExited(MouseEvent mouseEvent) {
        if (this.showRollover) {
            NodeState nodeState = this.rollover;
            this.rollover = null;
            this.repaintNode(nodeState);
        }
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Rectangle rectangle;
        NodeState nodeState;
        if (this.toolTip.active && this.getToolTipText(mouseEvent) != null && (nodeState = this.hitTestXY(mouseEvent.getX(), mouseEvent.getY())) != null && (rectangle = this.getNodeRect(nodeState.node)) != null && this.model != null && this.viewManager != null) {
            Object object = this.model.get(nodeState.node);
            int n = this.getState(nodeState);
            this.toolTip.data = object;
            this.toolTip.painter = this.getPainter(nodeState, object, n);
            this.toolTip.state = n;
            return new Point(rectangle.x - 1, rectangle.y - 1);
        }
        this.toolTip.painter = null;
        return null;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.toolTip.active) {
            Object object;
            NodeState nodeState = this.hitTestXY(mouseEvent.getX(), mouseEvent.getY());
            if (nodeState != null && this.model != null && this.viewManager != null && (object = this.model.get(nodeState.node)) != null) {
                Rectangle rectangle = this.getNodeRect(nodeState.node);
                Rectangle rectangle2 = this.scroller.getViewport().getViewRect();
                if (!(rectangle == null || rectangle2.contains(rectangle.x, rectangle.y) && rectangle2.contains(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.width - 1))) {
                    int n = this.getState(nodeState);
                    this.toolTip.data = object;
                    this.toolTip.painter = this.getPainter(nodeState, object, n);
                    this.toolTip.state = n;
                    return object.toString();
                }
            }
            return null;
        }
        this.toolTip.painter = null;
        return this.getToolTipText();
    }

    public JToolTip createToolTip() {
        return this.toolTip;
    }

    protected void processMouseMoved(MouseEvent mouseEvent) {
        NodeState nodeState;
        if (this.showRollover && (nodeState = this.hitTestXY(mouseEvent.getX(), mouseEvent.getY())) != this.rollover) {
            NodeState nodeState2 = this.rollover;
            this.rollover = nodeState;
            this.repaintNode(nodeState2);
            this.repaintNode(this.rollover);
        }
    }

    protected void processMouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = mouseEvent.isShiftDown();
        boolean bl2 = mouseEvent.isControlDown();
        boolean bl3 = mouseEvent.isMetaDown();
        NodeState nodeState = this.hitTestY(n2);
        if (nodeState != null && nodeState == this.mouseDown && nodeState.hitTest(n, n2) == 1) {
            this.editClickPoint = new Point(n, n2);
            if (!bl3 && (this.doStartEdit || this.isToggleItem(nodeState))) {
                this.startEdit(nodeState);
                this.doStartEdit = false;
            } else if (!(bl3 || bl || bl2 || this.selection.getCount() <= 1)) {
                this.selection.removeAll();
                this.selection.add(nodeState.node);
            }
            this.editClickPoint = null;
        }
        this.mouseDown = null;
    }

    protected void processMouseDragged(MouseEvent mouseEvent) {
        NodeState nodeState;
        this.rollover = null;
        if (this.dragSubfocus && !mouseEvent.isMetaDown() && (nodeState = this.hitTestY(mouseEvent.getY())) != null) {
            int n = mouseEvent.isControlDown() ? 64 : 3;
            this.setSubfocus(nodeState, n);
        }
    }

    protected void processMousePressed(MouseEvent mouseEvent) {
        boolean bl = this.hasFocus;
        this.hasFocus = true;
        super.processMousePressed(mouseEvent);
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl2 = mouseEvent.isShiftDown();
        boolean bl3 = mouseEvent.isControlDown();
        boolean bl4 = mouseEvent.isAltDown();
        boolean bl5 = mouseEvent.isMetaDown();
        NodeState nodeState = this.hitTestY(n2);
        if (nodeState == null) {
            return;
        }
        this.rollover = null;
        if (this.subfocus == null) {
            this.setSubfocus(nodeState.node);
        }
        this.lastClickPosition = nodeState.hitTest(n, n2);
        switch (this.lastClickPosition) {
            case 2: {
                this.mouseDown = null;
                boolean bl6 = !nodeState.expanded;
                Point point = this.scroller.getViewport().getViewPosition();
                this.expandNode(nodeState, bl6);
                this.recalcVisible(true);
                this.repaintToEnd(nodeState);
                this.scroller.getViewport().setViewPosition(point);
                if (bl6 || this.subfocus == null || !this.subfocus.isDescendentOf(nodeState.node)) break;
                this.setSubfocus(nodeState, 67);
                break;
            }
            case 1: {
                this.mouseDown = nodeState;
                if (this.editor != null) {
                    if (this.editorNode.equals(nodeState)) {
                        return;
                    }
                    this.safeEndEdit();
                }
                if (nodeState == this.subfocus) {
                    if (!bl5 && mouseEvent.getClickCount() == 2) {
                        this.fireActionEvent();
                    }
                    if (!(bl3 || bl2 || bl4)) {
                        if (bl && !this.selection.contains(nodeState.node)) {
                            this.selection.removeAll();
                            this.selection.add(nodeState.node);
                        } else if (!bl) {
                            this.selection.removeAll();
                            this.selection.add(nodeState.node);
                        }
                    } else if (bl3 && !bl2) {
                        if (this.selection.contains(nodeState.node)) {
                            this.selection.remove(nodeState.node);
                        } else {
                            this.selection.add(nodeState.node);
                        }
                    }
                    if (bl && !bl5 && !bl3 && !bl2 && !this.isToggleItem(nodeState) && this.canSet(nodeState.node)) {
                        this.doStartEdit = true;
                        return;
                    }
                }
                int n3 = bl2 && bl3 ? 2 : (bl2 ? 2 : (bl3 ? 72 : 67));
                this.setSubfocus(nodeState, n3);
            }
        }
    }

    private boolean canSet(GraphLocation graphLocation) {
        return this.isReadOnly() ? false : this.writeModel.canSet(graphLocation);
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 20);
    }

    public Dimension getPreferredSize() {
        if (!this.initialized) {
            this.initialize(this.getGraphics());
        }
        return new Dimension(this.leftMargin + this.canvasWidth, this.topMargin + this.canvasHeight);
    }

    protected void repaintToEnd(NodeState nodeState) {
        if (this.batchMode || nodeState == null) {
            return;
        }
        int n = nodeState.itemRect.y;
        this.repaint(0, n, this.getSize().width, this.getSize().height - n);
    }

    public void repaintNodes() {
        if (this.batchMode) {
            return;
        }
        this.repaint(100L);
    }

    public void repaintNode(GraphLocation graphLocation) {
        this.repaintNode(this.getViewState(graphLocation));
    }

    protected void repaintNode(NodeState nodeState) {
        if (!this.batchMode && nodeState != null && this.isVisible(nodeState)) {
            int n = nodeState.node.hasChildren() == 0 ? nodeState.itemRect.x : nodeState.boxRect.x;
            this.repaint(n, nodeState.itemRect.y, this.getSize().width - n, nodeState.itemRect.height);
        }
    }

    protected void updateNodeRect(NodeState nodeState, Graphics graphics) {
        if (nodeState == null || this.model == null || this.viewManager == null) {
            return;
        }
        int n = this.getState(nodeState);
        Object object = this.model.get(nodeState.node);
        ItemPainter itemPainter = this.getPainter(nodeState, object, n);
        if (itemPainter != null) {
            Dimension dimension = itemPainter.getPreferredSize(object, graphics, n, this);
            nodeState.itemRect.width = dimension.width;
            nodeState.itemRect.height = dimension.height;
        }
    }

    protected void updateNodeRects(NodeState nodeState, Graphics graphics) {
        if (nodeState != null) {
            this.updateNodeRect(nodeState, graphics);
            if (!nodeState.expanded) {
                return;
            }
            GraphLocation[] graphLocationArray = nodeState.node.getChildren();
            for (int i = 0; i < graphLocationArray.length; ++i) {
                NodeState nodeState2;
                if (graphLocationArray[i] == null || (nodeState2 = this.getViewState(graphLocationArray[i])) == null) continue;
                this.updateNodeRects(nodeState2, graphics);
            }
        }
    }

    protected void updateViewState(GraphLocation graphLocation, int n) {
        if (graphLocation != null) {
            NodeState nodeState = this.getViewState(graphLocation);
            if (nodeState == null || !nodeState.isDescendentOf(this.model.getRoot())) {
                nodeState = new NodeState(this, graphLocation, n, this.expandByDefault && graphLocation.hasChildren() == 1);
                this.putViewState(graphLocation, nodeState);
            } else {
                nodeState.update(n);
            }
            if (!nodeState.expanded) {
                return;
            }
            GraphLocation[] graphLocationArray = nodeState.node.getChildren();
            for (int i = 0; i < graphLocationArray.length; ++i) {
                if (graphLocationArray[i] == null) continue;
                NodeState nodeState2 = this.getViewState(graphLocationArray[i]);
                if (nodeState2 == null) {
                    nodeState2 = new NodeState(this, graphLocationArray[i], n + 1, this.expandByDefault && graphLocationArray[i].hasChildren() == 1);
                    this.putViewState(graphLocationArray[i], nodeState2);
                } else {
                    nodeState2.update(n + 1);
                }
                if (!nodeState.expanded) continue;
                this.updateViewState(graphLocationArray[i], n + 1);
            }
        }
    }

    protected void cleanViewState(GraphLocation graphLocation) {
        HashMapIterator hashMapIterator = this.cache.begin();
        while (!hashMapIterator.atEnd()) {
            NodeState nodeState = (NodeState)((Pair)hashMapIterator.get()).second;
            if (!nodeState.inUse && this.model.get(nodeState.node) == null) {
                this.cache.remove((Enumeration)hashMapIterator);
            }
            hashMapIterator.advance();
        }
    }

    protected void markViewState(GraphLocation graphLocation) {
        Enumeration enumeration = this.cache.elements();
        while (enumeration.hasMoreElements()) {
            ((NodeState)enumeration.nextElement()).inUse = false;
        }
    }

    protected void updateViewState() {
        GraphLocation graphLocation;
        if (this.initialized && this.model != null && (graphLocation = this.model.getRoot()) != null) {
            this.markViewState(graphLocation);
            this.updateViewState(graphLocation, this.showRoot ? 0 : -1);
            this.cleanViewState(graphLocation);
            if (this.firstNode == null || !this.firstNode.inUse) {
                this.firstNode = this.getViewState(graphLocation);
            }
        }
    }

    protected void putViewState(GraphLocation graphLocation, NodeState nodeState) {
        if (graphLocation != null && this.cache.get((Object)graphLocation) == null) {
            this.cache.put((Object)graphLocation, (Object)nodeState);
        }
    }

    protected NodeState getViewState(GraphLocation graphLocation) {
        if (graphLocation == null) {
            return null;
        }
        NodeState nodeState = null;
        try {
            NodeState nodeState2 = nodeState = (NodeState)this.cache.get((Object)graphLocation);
            return nodeState2;
        }
        catch (Exception exception) {
            this.updateViewState();
            try {
                NodeState nodeState3 = nodeState = (NodeState)this.cache.get((Object)graphLocation);
                return nodeState3;
            }
            catch (Exception exception2) {
                NodeState nodeState4 = null;
                return nodeState4;
            }
        }
    }

    protected void paintVLines(Graphics graphics, NodeState nodeState) {
        if (graphics == null || nodeState == null) {
            return;
        }
        NodeState nodeState2 = nodeState;
        for (int i = nodeState.level - 1; i > 0 && nodeState2 != null; --i) {
            nodeState2 = this.getViewState(nodeState2.node.getParent());
            if (nodeState2 == null || nodeState2.getNextSibling() == null) continue;
            int n = this.boxSize.width / 2 + this.hIndent * i + this.leftMargin;
            graphics.setColor(this.isEnabled() ? SystemColor.controlShadow : SystemColor.controlShadow.brighter());
            DottedLine.drawVLine(graphics, n, nodeState.itemRect.y, nodeState.itemRect.y + nodeState.itemRect.height + 1);
        }
    }

    protected void paintLink(Graphics graphics, NodeState nodeState) {
        int n;
        int n2 = this.boxSize.width / 2 + this.hIndent * nodeState.level + this.leftMargin;
        int n3 = n = nodeState.node.hasChildren() != 0 ? nodeState.boxRect.y : nodeState.itemRect.y + nodeState.itemRect.height / 2;
        NodeState nodeState2 = nodeState.prevVisible;
        if (nodeState2 != null) {
            if (nodeState2.level >= nodeState.level) {
                while (nodeState2.level > nodeState.level && nodeState2 != null) {
                    nodeState2 = nodeState2.prevVisible;
                }
                n3 = nodeState2.node.hasChildren() == 0 ? nodeState2.itemRect.y + nodeState2.itemRect.height / 2 : nodeState2.boxRect.y + nodeState2.boxRect.height;
            } else if (nodeState2.expanded || nodeState2.node.hasChildren() != -1) {
                GraphLocation[] graphLocationArray = nodeState2.node.getChildren();
                if (graphLocationArray.length > 0 && graphLocationArray[0] == nodeState.node) {
                    n3 = nodeState2.itemRect.y + nodeState2.itemRect.height;
                } else {
                    if (nodeState.node.getParent() == null) {
                        return;
                    }
                    NodeState nodeState3 = this.getViewState(nodeState.node.getParent());
                    if (nodeState3 == null) {
                        return;
                    }
                    n3 = nodeState3.boxRect.y + nodeState3.boxRect.height;
                }
            }
        } else {
            n3 = n;
        }
        graphics.setColor(this.isEnabled() ? SystemColor.controlShadow : SystemColor.controlShadow.brighter());
        DottedLine.drawVLine(graphics, n2, n3, n);
        if (nodeState.node.hasChildren() == 0) {
            int n4 = nodeState.itemRect.x;
            int n5 = nodeState.itemRect.y + nodeState.itemRect.height / 2;
            DottedLine.drawHLine(graphics, n2, n4, n5);
        }
    }

    protected void paintItem(Graphics graphics, NodeState nodeState) {
        if (this.viewManager != null) {
            int n = this.getState(nodeState);
            Object object = this.model.get(nodeState.node);
            ItemPainter itemPainter = this.getPainter(nodeState, object, n);
            if (itemPainter != null) {
                Dimension dimension = itemPainter.getPreferredSize(object, graphics, n, this);
                nodeState.itemRect.width = dimension.width;
                nodeState.itemRect.height = dimension.height;
                graphics.setColor(this.getBackground());
                Rectangle rectangle = new Rectangle(nodeState.itemRect.x, nodeState.itemRect.y, dimension.width, dimension.height);
                itemPainter.paint(object, graphics, rectangle, n, this);
            }
        }
    }

    protected void paintArrow(Graphics graphics, NodeState nodeState) {
        if (nodeState.node != null && nodeState.node.hasChildren() != 0) {
            Image image;
            Image image2 = image = nodeState.expanded ? this.expandedArrow : this.contractedArrow;
            if (image != null) {
                graphics.drawImage(image, nodeState.boxRect.x, nodeState.boxRect.y, this);
            }
        }
    }

    protected void paintBox(Graphics graphics, NodeState nodeState) {
        if (nodeState.node != null && nodeState.node.hasChildren() != 0) {
            int n = nodeState.boxRect.x;
            int n2 = nodeState.boxRect.y;
            if (this.texture != null) {
                ImageTexture.texture(this.texture, graphics, n, n2, this.boxSize.width - 1, this.boxSize.height - 1);
            } else if (this.isOpaque()) {
                graphics.setColor(SystemColor.window);
                graphics.fillRect(n, n2, this.boxSize.width - 1, this.boxSize.height - 1);
            }
            graphics.setColor(this.isEnabled() ? SystemColor.controlShadow : SystemColor.controlShadow.brighter());
            DottedLine.drawHLine(graphics, n + this.boxSize.width + 1, n + this.itemOffset, n2 + this.boxSize.width / 2);
            graphics.drawRect(n, n2, this.boxSize.width - 1, this.boxSize.height - 1);
            graphics.setColor(this.isEnabled() ? SystemColor.controlText : SystemColor.controlText.brighter());
            if (!nodeState.expanded) {
                graphics.drawLine(n + this.boxSize.width / 2, n2 + 2, n + this.boxSize.width / 2, n2 + this.boxSize.height - 3);
            }
            graphics.drawLine(n + 2, n2 + this.boxSize.height / 2, n + this.boxSize.width - 3, n2 + this.boxSize.height / 2);
        }
    }

    protected void paintNode(Graphics graphics, NodeState nodeState) {
        if (graphics != null && nodeState != null) {
            Dimension dimension = this.scroller.getViewport().getExtentSize();
            if (this.texture != null) {
                ImageTexture.texture(this.texture, graphics, 0, nodeState.itemRect.y, dimension.width, nodeState.itemRect.height + this.vgap);
            } else if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, nodeState.itemRect.y, dimension.width, nodeState.itemRect.height + this.vgap);
            }
            if (this.style == 1) {
                this.paintBox(graphics, nodeState);
                this.paintItem(graphics, nodeState);
                this.paintLink(graphics, nodeState);
                this.paintVLines(graphics, nodeState);
            } else if (this.style == 2) {
                this.paintArrow(graphics, nodeState);
                this.paintItem(graphics, nodeState);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        int n;
        if (this.batchMode) {
            return;
        }
        super.paintComponent(graphics);
        graphics.clipRect(0, 0, this.getSize().width, this.getSize().height);
        Rectangle rectangle = this.scroller.getViewport().getViewRect();
        Rectangle rectangle2 = graphics.getClipBounds();
        if (rectangle2 == null) {
            return;
        }
        Rectangle rectangle3 = rectangle2.width > rectangle.width || rectangle2.height > rectangle.height ? rectangle2.intersection(rectangle) : rectangle2;
        if (rectangle3.width <= 0 || rectangle3.height <= 0 || rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        NodeState nodeState = this.hitTestY(rectangle3.y);
        NodeState nodeState2 = this.hitTestY(rectangle3.y + rectangle3.height - 1);
        NodeState nodeState3 = nodeState;
        if (nodeState == nodeState2) {
            this.paintNode(graphics, nodeState);
        } else {
            nodeState3 = nodeState;
            while (nodeState2 != null && nodeState3 != nodeState2.nextVisible) {
                this.paintNode(graphics, nodeState3);
                if (nodeState3.nextVisible == null) break;
                nodeState3 = nodeState3.nextVisible;
            }
        }
        if (this.style == 1) {
            nodeState3 = nodeState;
            while (nodeState3 != null) {
                NodeState nodeState4 = this.getViewState(nodeState3.getNextSibling());
                if (nodeState4 != null) {
                    this.paintLink(graphics, nodeState4);
                }
                if (nodeState3.nextVisible == null) break;
                nodeState3 = nodeState3.nextVisible;
            }
        }
        int n2 = n = nodeState3 != null ? nodeState3.itemRect.y + nodeState3.itemRect.height : 0;
        if (n < rectangle.y + rectangle.height) {
            if (this.texture != null) {
                ImageTexture.texture(this.texture, graphics, rectangle.x, n, rectangle.width, rectangle.height - n);
            } else if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(rectangle.x, n, rectangle.width, rectangle.height - n);
            }
        }
        if (this.debugPaint) {
            GridCore.debugRect(graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
    }

    void initialize(Graphics graphics) {
        if (!this.initialized) {
            NodeState nodeState;
            this.initialized = true;
            this.updateViewState();
            ArrayIterator arrayIterator = this.presetExpandList.begin();
            while (!arrayIterator.atEnd()) {
                nodeState = this.getViewState((GraphLocation)arrayIterator.get());
                if (nodeState != null) {
                    this.expandNode(nodeState, true);
                }
                arrayIterator.advance();
            }
            arrayIterator = this.presetCollapseList.begin();
            while (!arrayIterator.atEnd()) {
                nodeState = this.getViewState((GraphLocation)arrayIterator.get());
                if (nodeState != null) {
                    this.expandNode(nodeState, false);
                }
                arrayIterator.advance();
            }
            this.updateViewState();
            this.updateNodeRects(this.firstNode, graphics);
            this.recalcVisible(false);
        }
    }

    NodeState hitTestLine(int n) {
        NodeState nodeState = this.firstNode;
        while (nodeState != null && nodeState.lineNumber < n) {
            nodeState = nodeState.nextVisible;
        }
        return nodeState;
    }

    public void addNotify() {
        super.addNotify();
        Graphics graphics = this.getSiteGraphics();
        if (graphics != null) {
            this.updateViewState();
            this.updateNodeRects(this.firstNode, graphics);
            this.recalcVisible(false);
        }
    }

    NodeState hitTestAbsY(int n) {
        NodeState nodeState = this.firstNode;
        while (nodeState != null && nodeState.itemRect.y + nodeState.itemRect.height <= n) {
            nodeState = nodeState.nextVisible;
        }
        return nodeState;
    }

    NodeState hitTestY(int n) {
        NodeState nodeState = this.firstNode;
        while (nodeState != null && nodeState.itemRect.y + nodeState.itemRect.height <= n) {
            nodeState = nodeState.nextVisible;
        }
        if (nodeState == null) {
            nodeState = this.lastCalc;
        }
        return nodeState;
    }

    NodeState hitTestXY(int n, int n2) {
        NodeState nodeState = this.hitTestY(n2);
        if (nodeState != null && nodeState.hitTest(n, n2) == 1) {
            return nodeState;
        }
        return null;
    }

    public GraphLocation hitTest(int n, int n2) {
        NodeState nodeState = this.hitTestY(n2);
        if (nodeState != null && nodeState.hitTest(n, n2) == 1) {
            return nodeState.node;
        }
        return null;
    }

    private void scrollView() {
        if (this.subfocus == null) {
            return;
        }
        Rectangle rectangle = this.scroller.getViewport().getViewRect();
        Rectangle rectangle2 = this.subfocus.itemRect;
        int n = rectangle.x;
        int n2 = rectangle.y;
        if (rectangle2 != null) {
            if (rectangle2.width > rectangle.width || rectangle2.x < rectangle.x) {
                n = rectangle2.x;
            } else if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
                int n3 = n = this.getSize().width - rectangle.width < rectangle2.x + rectangle2.width - rectangle.width ? this.getSize().width - rectangle.width : rectangle2.x + rectangle2.width - rectangle.width;
            }
            if (rectangle2.y < rectangle.y) {
                n2 = rectangle2.y;
            } else if (rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                NodeState nodeState;
                int n4 = n2 = this.getSize().height - rectangle.height < rectangle2.y + rectangle2.height - rectangle.height ? this.getSize().height - rectangle.height : rectangle2.y + rectangle2.height - rectangle.height;
                if (this.snapOrigin && (nodeState = this.hitTestAbsY(n2)) != null && nodeState.nextVisible != null) {
                    n2 = nodeState.nextVisible.itemRect.y;
                }
            }
            if (n > 0 && rectangle2.width < rectangle.width) {
                int n5 = n = 0 > rectangle2.x + rectangle2.width - rectangle.width ? 0 : rectangle2.x + rectangle2.width - rectangle.width;
            }
            if (this.hSnap) {
                if (rectangle.x != n || rectangle.y != n2) {
                    this.scroller.getViewport().setViewPosition(new Point(n, n2));
                }
            } else if (rectangle.y != n2) {
                this.scroller.getViewport().setViewPosition(new Point(rectangle.x, n2));
            }
            this.scroller.getHorizontalScrollBar().setUnitIncrement(rectangle2.width);
            this.scroller.getVerticalScrollBar().setUnitIncrement(rectangle2.height);
        }
    }

    protected void setSubfocus(NodeState nodeState, int n) {
        if (nodeState == null || this.subfocus == nodeState) {
            return;
        }
        if (this.editor != null) {
            if (this.lockSubfocus) {
                return;
            }
            this.safeEndEdit();
        }
        if (this.lockSubfocus || this.editor != null) {
            return;
        }
        if (this.subfocusChecked) {
            this.subfocusChecked = false;
        } else if (!this.preProcessSubfocusEvent(new GraphSubfocusEvent(this, 1, nodeState.node))) {
            return;
        }
        if (this.subfocus == null) {
            this.subfocus = nodeState;
            this.selectAnchor = nodeState;
            if ((n & 2) != 0) {
                this.selection.add(this.subfocus.node);
            }
            this.scrollView();
            this.processSubfocusEvent(new GraphSubfocusEvent(this, 2, this.subfocus.node));
            return;
        }
        if (this.selectAnchor == null) {
            this.selectAnchor = nodeState;
        }
        NodeState nodeState2 = this.subfocus;
        this.subfocus = nodeState;
        boolean bl = false;
        if ((n & 1) != 0) {
            bl = true;
            this.selection.enableSelectionEvents(false);
            this.selection.removeAll();
        }
        if ((n & 2) != 0) {
            this.selection.add(this.subfocus.node);
        }
        if ((n & 8) != 0) {
            if (this.selection.contains(this.subfocus.node)) {
                this.selection.remove(this.subfocus.node);
            } else {
                this.selection.add(this.subfocus.node);
            }
        }
        if ((n & 0x40) != 0) {
            this.selectAnchor = this.subfocus;
        }
        if (bl) {
            this.selection.enableSelectionEvents(true);
        }
        this.scrollView();
        this.repaintNode(nodeState2);
        this.repaintNode(this.subfocus);
        this.processSubfocusEvent(new GraphSubfocusEvent(this, 2, nodeState.node));
    }

    public void setSubfocus(GraphLocation graphLocation) {
        NodeState nodeState;
        if (this.editor != null) {
            if (this.lockSubfocus) {
                return;
            }
            this.safeEndEdit();
        }
        if (this.lockSubfocus || this.editor != null) {
            return;
        }
        NodeState nodeState2 = this.getViewState(graphLocation);
        if (nodeState2 == null) {
            return;
        }
        if (!this.preProcessSubfocusEvent(new GraphSubfocusEvent(this, 1, graphLocation))) {
            return;
        }
        GraphLocation graphLocation2 = nodeState2.node.getParent();
        if (graphLocation2 != null && this.makeExpanded(nodeState = this.getViewState(graphLocation2))) {
            this.updateNodeRects(nodeState, this.getSiteGraphics());
            this.recalcVisible(true);
        }
        this.subfocusChecked = true;
        this.setSubfocus(nodeState2, 67);
    }

    public GraphLocation getSubfocus() {
        return this.subfocus != null ? this.subfocus.node : null;
    }

    public void setViewManager(GraphViewManager graphViewManager) {
        this.viewManager = graphViewManager;
        this.repaintNodes();
    }

    public GraphViewManager getViewManager() {
        return this.viewManager;
    }

    public void setShowRoot(boolean bl) {
        this.showRoot = bl;
        this.repaintNodes();
        this.recalcVisible(true);
    }

    public boolean isShowRoot() {
        return this.showRoot;
    }

    public void setShowFocus(boolean bl) {
        this.showFocus = bl;
    }

    public boolean isShowFocus() {
        return this.showFocus;
    }

    public void setPostOnEndEdit(boolean bl) {
        this.postOnEndEdit = bl;
    }

    public boolean isPostOnEndEdit() {
        return this.postOnEndEdit;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void removeModelListener(GraphModelListener graphModelListener) {
        this.modelMulticaster.remove(graphModelListener);
    }

    public void addModelListener(GraphModelListener graphModelListener) {
        this.modelMulticaster.add(graphModelListener);
    }

    public Rectangle getNodeRect(GraphLocation graphLocation) {
        NodeState nodeState = this.getViewState(graphLocation);
        if (nodeState != null) {
            return new Rectangle(nodeState.itemRect);
        }
        return null;
    }

    public void setModel(GraphModel graphModel) {
        if (graphModel != this.model) {
            if (this.model != null) {
                this.model.removeModelListener(this);
                this.model.removeModelListener(this.modelMulticaster);
            }
            this.model = graphModel;
            if (this.model != null) {
                this.model.addModelListener(this);
                this.model.addModelListener(this.modelMulticaster);
            }
            this.writeModel = graphModel instanceof WritableGraphModel ? (WritableGraphModel)graphModel : null;
            this.cache.clear();
            this.firstNode = null;
            this.subfocus = null;
            this.selectAnchor = null;
            this.updateViewState();
            Graphics graphics = this.getSiteGraphics();
            if (graphics != null) {
                this.updateNodeRects(this.firstNode, graphics);
                this.recalcVisible(true);
            }
            if (graphModel != null) {
                this.setSubfocus(graphModel.getRoot());
            }
        }
    }

    public WritableGraphModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public GraphModel getModel() {
        return this.model;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(boolean bl) {
        if (this.batchMode != bl) {
            this.batchMode = bl;
            if (!this.batchMode) {
                this.repaintNodes();
                if (this.isShowing()) {
                    this.scroller.validate();
                }
            }
        }
    }

    public ItemEditor getEditor() {
        return this.editor;
    }

    public boolean isEditing() {
        return this.editor != null;
    }

    public boolean isGrowEditor() {
        return this.growEditor;
    }

    public void setGrowEditor(boolean bl) {
        this.growEditor = bl;
    }

    public void setAutoEdit(boolean bl) {
        this.autoEdit = bl;
    }

    public boolean isAutoEdit() {
        return this.autoEdit;
    }

    public void setEditInPlace(boolean bl) {
        this.editInPlace = bl;
    }

    public boolean isEditInPlace() {
        return this.editInPlace;
    }

    public boolean isDataToolTip() {
        return this.toolTip.active;
    }

    public void setDataToolTip(boolean bl) {
        this.toolTip.active = bl;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (this.toolTip.active) {
            toolTipManager.registerComponent(this);
        } else if (this.getToolTipText() == null) {
            toolTipManager.unregisterComponent(this);
        }
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setShowRollover(boolean bl) {
        this.showRollover = bl;
    }

    public void setHSnap(boolean bl) {
        this.hSnap = bl;
    }

    public boolean isHSnap() {
        return this.hSnap;
    }

    public boolean isDragSubfocus() {
        return this.dragSubfocus;
    }

    public void setDragSubfocus(boolean bl) {
        this.dragSubfocus = bl;
    }

    public void setSnapOrigin(boolean bl) {
        this.snapOrigin = bl;
    }

    public boolean isSnapOrigin() {
        return this.snapOrigin;
    }

    public void setItemOffset(int n) {
        this.itemOffset = n;
        this.repaintNodes();
    }

    public int getItemOffset() {
        return this.itemOffset;
    }

    public void setHIndent(int n) {
        this.hIndent = n;
        this.repaintNodes();
    }

    public int getHIndent() {
        return this.hIndent;
    }

    public void setVgap(int n) {
        this.vgap = n;
        this.repaintNodes();
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setBoxSize(Dimension dimension) {
        if (dimension != null) {
            this.boxSize = dimension;
            this.repaintNodes();
        }
    }

    public Dimension getBoxSize() {
        return this.boxSize;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.refresh();
        if (this.isVisible() && !this.batchMode) {
            this.validate();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaintNodes();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.repaintNodes();
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setTopMargin(int n) {
        this.topMargin = n;
        this.refresh();
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setLeftMargin(int n) {
        this.leftMargin = n;
        this.refresh();
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setItemMargins(Insets insets) {
        this.margins = insets;
        this.invalidate();
        this.repaintNodes();
    }

    public Insets getItemMargins() {
        return this.margins;
    }

    public void setExpandByDefault(boolean bl) {
        this.expandByDefault = bl;
    }

    public boolean isExpandByDefault() {
        return this.expandByDefault;
    }

    public void setStyle(int n) {
        this.style = n;
        if (n == 2 && this.expandedArrow == null) {
            this.contractedArrow = ImageLoader.loadFromResource("image/contractedArrow.gif", this);
            this.expandedArrow = ImageLoader.loadFromResource("image/expandedArrow.gif", this);
        }
        if (n == 2) {
            this.setBoxSize(new Dimension(12, 12));
        } else {
            this.setBoxSize(new Dimension(9, 9));
        }
        this.repaintNodes();
    }

    public int getStyle() {
        return this.style;
    }

    public void refresh() {
        this.updateViewState();
        Graphics graphics = this.getSiteGraphics();
        if (graphics != null) {
            this.updateNodeRects(this.firstNode, graphics);
            this.recalcVisible(true);
        }
        this.repaintNodes();
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("Tree.background"));
    }

    public TreeCore(JScrollPane jScrollPane) {
        this.cache = new HashMap();
        this.presetExpandList = new Array();
        this.presetCollapseList = new Array();
        this.toolTip = new DataToolTip(this);
        this.margins = new Insets(2, 2, 2, 2);
        this.boxSize = new Dimension(9, 9);
        this.customPainter = new CustomItemPainter();
        this.customEditor = new CustomItemEditor();
        this.treeListeners = new EventMulticaster();
        this.subfocusListeners = new EventMulticaster();
        this.keyMulticaster = new KeyMulticaster();
        this.modelMulticaster = new GraphModelMulticaster();
        this.selectionMulticaster = new GraphSelectionMulticaster();
        this.scroller = jScrollPane;
        this.setFocusAware(true);
        super.addKeyListener(this.keyMulticaster);
        this.scroller.getVerticalScrollBar().setUnitIncrement(20);
        this.scroller.getHorizontalScrollBar().setUnitIncrement(10);
        super.setBackground(UIManager.getColor("Tree.background"));
    }
}

