/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.objectspace.jgl.Array;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.Serializable;
import java.text.BreakIterator;
import java.util.Enumeration;

public class TextWrapper
implements Serializable {
    Dimension size;
    int maxAscent;
    int charHeight;
    int lineCount;
    int hintWidth;
    String text;
    int[] length;
    String[] lines;
    Font font;
    BreakIterator textBoundary;
    FontMetrics fontMetrics;
    int alignment;
    private static final long serialVersionUID = 200L;

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n2 + n4 + this.charHeight;
        int n6 = this.alignment & 0xF;
        int n7 = this.alignment & 0xF0;
        n2 -= this.charHeight - this.maxAscent;
        switch (n7) {
            case 32: {
                n2 += (n4 - this.lineCount * this.charHeight) / 2;
                break;
            }
            case 48: {
                n2 += n4 - this.lineCount * this.charHeight;
            }
        }
        for (int i = 0; i < this.lineCount; ++i) {
            int n8 = 0;
            switch (n6) {
                case 2: {
                    n8 = (n3 - this.length[i]) / 2;
                    break;
                }
                case 3: {
                    n8 = n3 - this.length[i];
                }
            }
            if (this.lines[i] != null) {
                graphics.drawString(this.lines[i], n + n8, n2 + this.charHeight);
            }
            if ((n2 += this.charHeight) <= n5) continue;
            return;
        }
    }

    protected void calcSize(Graphics graphics) {
        Array array = new Array();
        this.textBoundary.setText(this.text);
        int n = this.textBoundary.first();
        int n2 = this.textBoundary.next();
        while (n2 != -1) {
            array.add((Object)this.text.substring(n, n2));
            n = n2;
            n2 = this.textBoundary.next();
        }
        this.lines = new String[array.size()];
        this.length = new int[array.size()];
        this.lineCount = 0;
        n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Enumeration enumeration = array.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl;
            String string = (String)enumeration.nextElement();
            int n6 = this.fontMetrics.stringWidth(string);
            int n7 = this.length[n3] + n6;
            boolean bl2 = string.charAt(0) == '\r';
            boolean bl3 = bl = string.charAt(0) == '\n';
            if (bl2) continue;
            if (!bl && n7 <= this.hintWidth) {
                if (this.lines[n3] == null) {
                    this.lines[n3] = string;
                    this.length[n3] = n6;
                    n2 = 0;
                    ++this.lineCount;
                    n5 += this.charHeight;
                    if (n7 <= n4) continue;
                    n4 = n7;
                    continue;
                }
                this.lines[n3] = String.valueOf(this.lines[n3]).concat(String.valueOf(string));
                this.length[n3] = n7;
                if (n7 <= n4) continue;
                n4 = n7;
                continue;
            }
            if (bl) {
                n6 = 0;
                string = string.substring(1);
            }
            if (n6 > n4) {
                n4 = n6;
            }
            if (this.length[n3] == 0) {
                this.lines[n3] = string;
                this.length[n3] = n6;
                ++this.lineCount;
                ++n3;
            } else {
                ++this.lineCount;
                this.lines[++n3] = string;
                this.length[n3] = n6;
            }
            n2 = 0;
            n5 += this.charHeight;
        }
        this.size = new Dimension(n4, n5);
    }

    public Dimension getSize(Graphics graphics) {
        if (this.size == null) {
            this.calcSize(graphics);
        }
        return this.size;
    }

    TextWrapper(Font font, String string, int n, int n2) {
        this.alignment = n;
        this.font = font;
        this.fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.textBoundary = BreakIterator.getWordInstance();
        this.text = string;
        this.hintWidth = n2;
        this.charHeight = this.fontMetrics.getHeight();
        this.maxAscent = this.fontMetrics.getMaxAscent();
    }
}

