/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.model.SingletonModelListener;
import com.borland.jbcl.model.SingletonModelMulticaster;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.view.SingletonModelView;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TextFieldView
extends TextField
implements Serializable,
SingletonModelListener,
SingletonModelView {
    protected boolean locateOnly = false;
    protected boolean postOnFocusLost = true;
    protected boolean readOnly;
    protected transient SingletonModelMulticaster modelMulticaster = new SingletonModelMulticaster();
    protected transient WritableSingletonModel writeModel;
    protected transient SingletonModel model;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof SingletonModel) {
            this.model = (SingletonModel)object;
        }
        if (this.model instanceof WritableSingletonModel) {
            this.writeModel = (WritableSingletonModel)this.model;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.model instanceof Serializable ? this.model : null);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1005) {
            String string = super.getText();
            Object object = this.model.get();
            if (this.postOnFocusLost && !string.equals(object)) {
                this.postText();
            }
        }
    }

    public boolean canSet(boolean bl) {
        return this.locateOnly ? true : (this.isReadOnly() ? false : this.writeModel.canSet(bl));
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        this.canSet(true);
        if (keyEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    this.postText();
                    break;
                }
                case 27: {
                    this.updateText();
                }
            }
        }
    }

    public void modelContentChanged(SingletonModelEvent singletonModelEvent) {
        this.updateText();
    }

    protected void postText() {
        if (this.canSet(true) && !this.locateOnly) {
            String string = super.getText();
            this.writeModel.set(string);
        }
    }

    public void setText(String string) {
        if (this.canSet(true) && !this.locateOnly) {
            String string2 = this.getText();
            if (string2 == null && string == null) {
                return;
            }
            if (string2 != null && string != null && string2.equals(string)) {
                return;
            }
            this.writeModel.set(string);
        }
    }

    protected void setSuperText(String string) {
        super.setText(string);
    }

    protected void updateText() {
        if (this.model != null) {
            Object object = this.model.get();
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            super.setText(object != null ? object.toString() : "");
            this.setSelectionStart(n);
            this.setSelectionEnd(n2);
        }
    }

    public void setPostOnFocusLost(boolean bl) {
        this.postOnFocusLost = bl;
    }

    public boolean isPostOnFocusLost() {
        return this.postOnFocusLost;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
        this.setEditable(!this.isReadOnly());
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void removeModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.remove(singletonModelListener);
    }

    public void addModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.add(singletonModelListener);
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void setModel(SingletonModel singletonModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = singletonModel;
        this.writeModel = this.model instanceof WritableSingletonModel ? (WritableSingletonModel)singletonModel : null;
        this.setEditable(!this.isReadOnly());
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
            this.updateText();
        }
    }

    public SingletonModel getModel() {
        return this.model;
    }

    public TextFieldView() {
        this.enableEvents(12L);
    }
}

