/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.dx.dataset.CustomPaintSite;
import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jb.util.VetoableDispatch;
import com.borland.jbcl.model.BasicVectorSelection;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.NullVectorSelection;
import com.borland.jbcl.model.ToggleItemEditor;
import com.borland.jbcl.model.VectorModel;
import com.borland.jbcl.model.VectorModelEvent;
import com.borland.jbcl.model.VectorModelListener;
import com.borland.jbcl.model.VectorModelMulticaster;
import com.borland.jbcl.model.VectorSelectionEvent;
import com.borland.jbcl.model.VectorSelectionListener;
import com.borland.jbcl.model.VectorSelectionMulticaster;
import com.borland.jbcl.model.VectorSubfocusEvent;
import com.borland.jbcl.model.VectorSubfocusListener;
import com.borland.jbcl.model.VectorViewManager;
import com.borland.jbcl.model.WritableVectorModel;
import com.borland.jbcl.model.WritableVectorSelection;
import com.borland.jbcl.util.ImageTexture;
import com.borland.jbcl.util.KeyMulticaster;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.CustomItemEditor;
import com.borland.jbcl.view.CustomItemListener;
import com.borland.jbcl.view.CustomItemPainter;
import com.borland.jbcl.view.DataToolTip;
import com.borland.jbcl.view.GridCore;
import com.borland.jbcl.view.VectorView;
import com.objectspace.jgl.Array;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Hashtable;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

class ListCore
extends BeanPanel
implements Serializable,
VectorView,
VectorSelectionListener,
VectorModelListener,
FocusListener,
KeyListener,
ItemEditSite {
    private transient VectorSelectionMulticaster selectionMulticaster;
    private transient VectorModelMulticaster modelMulticaster;
    private transient KeyMulticaster keyMulticaster;
    private transient EventMulticaster subfocusListeners;
    private transient Array customizeListeners;
    private transient CustomItemEditor customEditor;
    private transient CustomItemPainter customPainter;
    private DataToolTip toolTip;
    private boolean showRollover = false;
    private boolean batchMode = false;
    private boolean debugPaint = false;
    private boolean dragSubfocus = true;
    private boolean autoAppend = false;
    private boolean growEditor = true;
    private boolean autoEdit = true;
    private boolean editInPlace = true;
    private int alignment = 33;
    private Insets itemMargins;
    private transient JScrollPane scroller;
    private Point editClickPoint;
    private int editorLocation;
    private transient ItemEditor editor;
    private int mouseDown = -1;
    private int rollover = -1;
    private int selectAnchor = -1;
    private boolean snapOrigin = true;
    private int subfocus = 0;
    private int itemHeight = 0;
    private int itemWidth = 0;
    private boolean uniformHeight = true;
    private boolean uniformWidth = false;
    private boolean postOnEndEdit = true;
    private boolean dumpingRange = false;
    private boolean rangeSelecting = false;
    private boolean hasFocus = false;
    private boolean showFocus = true;
    private boolean readOnly = false;
    private transient int[] oldSelected;
    private transient WritableVectorSelection selection = new NullVectorSelection();
    private transient VectorViewManager viewManager;
    private transient WritableVectorModel writeModel;
    private transient VectorModel model;
    private boolean lockSubfocus = false;
    boolean doStartEdit = false;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Hashtable hashtable = (Hashtable)objectInputStream.readObject();
        Object v = hashtable.get("m");
        if (v instanceof VectorModel) {
            this.model = (VectorModel)v;
        }
        if (this.model instanceof WritableVectorModel) {
            this.writeModel = (WritableVectorModel)this.model;
        }
        if ((v = hashtable.get("v")) instanceof VectorViewManager) {
            this.viewManager = (VectorViewManager)v;
        }
        if ((v = hashtable.get("s")) instanceof WritableVectorSelection) {
            this.selection = (WritableVectorSelection)v;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(3);
        if (this.model instanceof Serializable) {
            hashtable.put("m", this.model);
        }
        if (this.viewManager instanceof Serializable) {
            hashtable.put("v", this.viewManager);
        }
        if (this.selection instanceof Serializable) {
            hashtable.put("s", this.selection);
        }
        objectOutputStream.writeObject(hashtable);
    }

    public synchronized void removeCustomItemListener(CustomItemListener customItemListener) {
        if (this.customizeListeners != null) {
            this.customizeListeners.remove((Object)customItemListener);
        }
        if (this.customizeListeners.size() == 0) {
            this.customizeListeners = null;
        }
    }

    public synchronized void addCustomItemListener(CustomItemListener customItemListener) {
        if (this.customizeListeners == null) {
            this.customizeListeners = new Array();
        }
        this.customizeListeners.add((Object)customItemListener);
    }

    protected void fireCustomizeItemEvent(Object object, Object object2, int n, CustomPaintSite customPaintSite) {
        if (this.customizeListeners != null) {
            customPaintSite.reset();
            for (int i = 0; i < this.customizeListeners.size(); ++i) {
                ((CustomItemListener)this.customizeListeners.at(i)).customizeItem(object, object2, n, customPaintSite);
            }
        }
    }

    private void fireActionEvent() {
        Object object = this.model != null ? this.model.get(this.subfocus) : null;
        String string = object != null ? object.toString() : "";
        this.processActionEvent(new ActionEvent(this.scroller, 1001, string));
    }

    public void checkParentWindow() {
        this.findParentWindow();
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.keyMulticaster.remove(keyListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyMulticaster.add(keyListener);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(0, 0);
        int n = this.getCount();
        if (n > 0) {
            Graphics graphics = this.getSiteGraphics();
            if (this.uniformHeight && this.uniformWidth) {
                this.checkItemHeight();
                Object object = this.model.get(0);
                ItemPainter itemPainter = this.getPainter(0, object, 0);
                Dimension dimension2 = itemPainter.getPreferredSize(object, graphics, 0, this);
                dimension.width = this.itemWidth > 0 ? this.itemWidth : dimension2.width;
                dimension.height = this.itemHeight > 0 ? this.itemHeight * n : dimension2.height * n;
                this.scroller.getVerticalScrollBar().setUnitIncrement(this.itemHeight > 0 ? this.itemHeight : dimension2.height);
            } else {
                Object object;
                Object object2;
                boolean bl = true;
                for (int i = 0; i < n; ++i) {
                    Dimension dimension3;
                    object2 = this.model.get(i);
                    object = this.getPainter(i, object2, 0);
                    Dimension dimension4 = dimension3 = object != null ? object.getPreferredSize(object2, graphics, 0, this) : new Dimension(0, 0);
                    if (bl && dimension3.height > 0) {
                        this.scroller.getVerticalScrollBar().setUnitIncrement(dimension3.height);
                        bl = false;
                    }
                    if (dimension3.width > dimension.width) {
                        dimension.width = dimension3.width;
                    }
                    dimension.height += dimension3.height;
                }
                if (this.uniformWidth || this.uniformHeight) {
                    Object object3 = this.model.get(0);
                    object2 = this.getPainter(0, object3, 0);
                    Object object4 = object = object2 != null ? object2.getPreferredSize(object3, graphics, 0, this) : new Dimension(0, 0);
                    if (this.uniformWidth) {
                        int n2 = dimension.width = this.itemWidth > 0 ? this.itemWidth : ((Dimension)object).width;
                    }
                    if (this.uniformHeight) {
                        int n3 = dimension.height = this.itemHeight > 0 ? this.itemHeight * n : ((Dimension)object).height * n;
                        if (this.scroller != null && this.scroller.getVerticalScrollBar() != null) {
                            this.scroller.getVerticalScrollBar().setUnitIncrement(this.itemHeight > 0 ? this.itemHeight : ((Dimension)object).height);
                        }
                    }
                }
            }
        }
        return dimension;
    }

    protected ItemEditor getEditor(int n, Object object, int n2) {
        ItemEditor itemEditor;
        ItemEditor itemEditor2 = itemEditor = this.viewManager != null ? this.viewManager.getEditor(n, object, n2) : null;
        if (itemEditor != null && this.customizeListeners != null) {
            this.customEditor.setEditor(itemEditor);
            this.fireCustomizeItemEvent(new Integer(n), object, n2, this.customEditor);
            return this.customEditor;
        }
        return itemEditor;
    }

    protected ItemPainter getPainter(int n, Object object, int n2) {
        ItemPainter itemPainter;
        ItemPainter itemPainter2 = itemPainter = this.viewManager != null ? this.viewManager.getPainter(n, object, n2) : null;
        if (itemPainter != null && this.customizeListeners != null) {
            this.customPainter.setPainter(itemPainter);
            this.fireCustomizeItemEvent(new Integer(n), object, n2, this.customPainter);
            return this.customPainter;
        }
        return itemPainter;
    }

    public Rectangle getVisibleScrollRect() {
        if (this.scroller.getViewport() == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = this.scroller.getViewport().getViewRect();
        return rectangle;
    }

    public void paintComponent(Graphics graphics) {
        if (this.batchMode) {
            return;
        }
        super.paintComponent(graphics);
        graphics.clipRect(0, 0, this.getSize().width, this.getSize().height);
        Rectangle rectangle = this.getVisibleScrollRect();
        Rectangle rectangle2 = graphics.getClipBounds();
        if (rectangle2 == null) {
            return;
        }
        this.checkItemHeight();
        Rectangle rectangle3 = rectangle2.width > rectangle.width || rectangle2.height > rectangle.height ? rectangle2.intersection(rectangle) : rectangle2;
        if (rectangle3.width <= 0 || rectangle3.height <= 0 || rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        int n = this.hitTest(rectangle3.y);
        int n2 = this.hitTest(rectangle3.y + rectangle3.height);
        Rectangle rectangle4 = this.getItemRect(n);
        if (rectangle4 != null) {
            for (int i = n; i <= n2; ++i) {
                int n3;
                Object object = this.model.get(i);
                ItemPainter itemPainter = this.getPainter(i, object, n3 = this.getState(i));
                if (itemPainter == null) continue;
                Dimension dimension = itemPainter.getPreferredSize(object, graphics, n3, this);
                Rectangle rectangle5 = new Rectangle(rectangle4.x, rectangle4.y, rectangle4.width, dimension.height);
                if (this.uniformHeight && this.itemHeight > 0) {
                    rectangle5.height = this.itemHeight;
                }
                graphics.setFont(this.getFont());
                graphics.setColor(this.getBackground());
                itemPainter.paint(object, graphics, rectangle5, n3, this);
                rectangle4.y = rectangle4.y + (this.uniformHeight && this.itemHeight > 0 ? this.itemHeight : dimension.height);
            }
            if (rectangle4.y < rectangle.y + rectangle.height) {
                if (this.texture != null) {
                    ImageTexture.texture(this.texture, graphics, rectangle.x, rectangle.y + rectangle4.y, rectangle.width, rectangle.y + rectangle.height - rectangle4.y);
                } else if (this.isOpaque()) {
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(rectangle.x, rectangle.y + rectangle4.y, rectangle.width, rectangle.y + rectangle.height - rectangle4.y);
                }
            }
        } else if (this.texture != null) {
            ImageTexture.texture(this.texture, graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        } else if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
        if (this.debugPaint) {
            GridCore.debugRect(graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
    }

    void checkItemHeight() {
        int n;
        Object object;
        ItemPainter itemPainter;
        if (this.uniformHeight && this.itemHeight < 1 && this.model != null && this.model.getCount() > 0 && (itemPainter = this.getPainter(0, object = this.model.get(0), n = this.getState(0))) != null) {
            Dimension dimension = itemPainter.getPreferredSize(object, this.getSiteGraphics(), n, this);
            this.itemHeight = dimension.height;
        }
    }

    public Rectangle getItemRect(int n) {
        if (n >= 0 && n < this.getCount()) {
            int n2 = this.getCount();
            if (this.scroller.getViewport() == null) {
                return null;
            }
            Rectangle rectangle = this.getVisibleScrollRect();
            Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, 0);
            Graphics graphics = this.getSiteGraphics();
            if (this.uniformHeight) {
                Dimension dimension;
                this.checkItemHeight();
                Object object = this.model.get(0);
                ItemPainter itemPainter = this.getPainter(0, object, 0);
                Dimension dimension2 = dimension = itemPainter != null ? itemPainter.getPreferredSize(object, graphics, 0, this) : new Dimension(0, 0);
                if (this.itemHeight > 0) {
                    rectangle2.y = this.itemHeight * n;
                    rectangle2.height = this.itemHeight;
                } else {
                    rectangle2.y = dimension.height * n;
                    rectangle2.height = dimension.height;
                }
                rectangle2.width = this.getSize().width;
                return rectangle2;
            }
            for (int i = 0; i < n2; ++i) {
                Object object = this.model.get(i);
                ItemPainter itemPainter = this.getPainter(i, object, 0);
                Dimension dimension = itemPainter != null ? itemPainter.getPreferredSize(object, graphics, 0, this) : new Dimension(0, 0);
                rectangle2.height = dimension.height;
                rectangle2.width = this.getSize().width;
                if (i == n) {
                    return rectangle2;
                }
                rectangle2.y += dimension.height;
            }
        }
        return null;
    }

    public int hitTestAbs(int n) {
        int n2 = 0;
        int n3 = this.getCount();
        if (this.getCount() < 1) {
            return -1;
        }
        Graphics graphics = this.getSiteGraphics();
        if (this.uniformHeight) {
            int n4;
            this.checkItemHeight();
            Object object = this.model.get(0);
            ItemPainter itemPainter = this.getPainter(0, object, 0);
            int n5 = this.itemHeight > 0 ? this.itemHeight : (n4 = itemPainter != null ? itemPainter.getPreferredSize((Object)object, (Graphics)graphics, (int)0, (ItemPaintSite)this).height : 0);
            if (n4 == 0) {
                return -1;
            }
            int n6 = n / n4;
            if (n6 < n3) {
                return n6;
            }
            return -1;
        }
        for (int i = 0; i < n3; ++i) {
            Object object = this.model.get(i);
            ItemPainter itemPainter = this.getPainter(i, object, 0);
            if ((n2 += itemPainter != null ? itemPainter.getPreferredSize((Object)object, (Graphics)graphics, (int)0, (ItemPaintSite)this).height : 0) < n) continue;
            return i;
        }
        return -1;
    }

    public int hitTest(int n) {
        int n2 = 0;
        int n3 = this.getCount();
        if (this.getCount() < 1) {
            return -1;
        }
        Graphics graphics = this.getSiteGraphics();
        if (this.uniformHeight) {
            int n4;
            this.checkItemHeight();
            Object object = this.model.get(0);
            ItemPainter itemPainter = this.getPainter(0, object, 0);
            int n5 = this.itemHeight > 0 ? this.itemHeight : (n4 = itemPainter != null ? itemPainter.getPreferredSize((Object)object, (Graphics)graphics, (int)0, (ItemPaintSite)this).height : 0);
            if (n4 == 0) {
                return -1;
            }
            int n6 = n / n4;
            if (n6 < n3) {
                return n6;
            }
            return n3 - 1;
        }
        for (int i = 0; i < n3; ++i) {
            Object object = this.model.get(i);
            ItemPainter itemPainter = this.getPainter(i, object, 0);
            if ((n2 += itemPainter != null ? itemPainter.getPreferredSize((Object)object, (Graphics)graphics, (int)0, (ItemPaintSite)this).height : 0) < n) continue;
            return i;
        }
        if (n >= n2) {
            return n3 - 1;
        }
        return 0;
    }

    private int getState(int n) {
        int n2;
        int n3 = n2 = this.isEnabled() ? 0 : 1;
        if (this.selection.contains(n)) {
            n2 |= 4;
        }
        if (!this.isEnabled()) {
            n2 |= 0x21;
        } else {
            if (this.showFocus && (this.focusState & 2) != 0 && this.subfocus == n) {
                n2 |= 2;
            }
            if ((this.focusState & 0x20) != 0) {
                n2 |= 0x20;
            }
            if (this.showRollover && this.rollover >= 0 && this.rollover == n) {
                n2 |= 0x40;
            }
        }
        if (!this.hasFocus) {
            n2 |= 0x80;
        }
        return n2;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private boolean canSet(int n, boolean bl) {
        return !this.isReadOnly() ? this.writeModel.canSet(n, bl) : false;
    }

    private int getCount() {
        return this.model != null ? this.model.getCount() : 0;
    }

    public Component getSiteComponent() {
        return this;
    }

    public Graphics getSiteGraphics() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            graphics.setFont(this.getFont());
        }
        return graphics;
    }

    public boolean isTransparent() {
        return this.texture != null ? true : !this.isOpaque();
    }

    public Point getEditClickPoint() {
        return this.editClickPoint;
    }

    public void repaintItems() {
        if (this.batchMode) {
            return;
        }
        this.repaint(100L);
    }

    public void repaintItem(int n) {
        if (this.batchMode) {
            return;
        }
        Rectangle rectangle = this.getItemRect(n);
        if (rectangle != null) {
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void pageJump(boolean bl, int n) {
        int n2;
        int n3 = this.getCount();
        if (n3 == 0) {
            ++n3;
        }
        if ((n2 = this.getSize().height / n3) == 0) {
            ++n2;
        }
        Rectangle rectangle = this.getVisibleScrollRect();
        int n4 = rectangle.height / n2 - 1;
        n4 = bl ? n4 : -n4;
        this.setSubfocus(this.subfocus + n4, n);
    }

    protected void processKeyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (this.editor != null || !this.autoEdit || keyEvent.isConsumed() || this.isReadOnly() || c == '\u0000' || c == '\t' || c == '\r' || c == '\n' || c == ' ' || c == '\u001b' || this.isToggleItem(this.subfocus) || keyEvent.isAltDown() ^ keyEvent.isControlDown() || !this.canSet(this.subfocus, false)) {
            return;
        }
        this.startEdit(this.subfocus);
        Component component = null;
        if (this.editor != null && (component = this.editor.getComponent()) != null) {
            component.dispatchEvent(keyEvent);
        }
    }

    protected void processKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = keyEvent.isControlDown();
        boolean bl2 = keyEvent.isShiftDown();
        boolean bl3 = keyEvent.isAltDown();
        int n2 = bl2 && bl ? 16 : (bl2 ? 16 : (bl ? 64 : 67));
        switch (n) {
            case 40: {
                if (bl3) break;
                if ((this.autoAppend || bl) && this.subfocus == this.getCount() - 1 && !this.isReadOnly() && this.writeModel.isVariableSize()) {
                    this.writeModel.addItem(null);
                    this.setSubfocus(this.getCount() - 1, 67);
                    keyEvent.consume();
                    break;
                }
                if (this.subfocus == this.getCount() - 1) break;
                this.setSubfocus(this.subfocus + 1, n2);
                keyEvent.consume();
                break;
            }
            case 38: {
                if (bl3 || this.subfocus <= 0) break;
                this.setSubfocus(this.subfocus - 1, n2);
                keyEvent.consume();
                break;
            }
            case 33: {
                if (bl3 || this.subfocus <= 0) break;
                this.pageJump(false, n2);
                keyEvent.consume();
                break;
            }
            case 34: {
                if (bl3 || this.subfocus == this.getCount() - 1) break;
                this.pageJump(true, n2);
                keyEvent.consume();
                break;
            }
            case 36: {
                if (bl3 || this.subfocus <= 0) break;
                if (bl && !bl2) {
                    this.setSubfocus(0, 67);
                } else {
                    this.setSubfocus(0, n2);
                }
                keyEvent.consume();
                break;
            }
            case 35: {
                if (bl3 || this.subfocus == this.getCount() - 1) break;
                if (bl && !bl2) {
                    this.setSubfocus(this.getCount() - 1, 67);
                } else {
                    this.setSubfocus(this.getCount() - 1, n2);
                }
                keyEvent.consume();
                break;
            }
            case 32: {
                if (bl3 || bl2) break;
                if (bl && this.selection.contains(this.subfocus)) {
                    this.selection.remove(this.subfocus);
                } else {
                    this.selection.add(this.subfocus);
                }
                if (this.isToggleItem(this.subfocus)) {
                    this.startEdit(this.subfocus);
                }
                keyEvent.consume();
                break;
            }
            case 155: {
                if (bl3 || this.isReadOnly() || !this.writeModel.isVariableSize()) break;
                this.writeModel.addItem(this.subfocus, null);
                keyEvent.consume();
                break;
            }
            case 127: {
                if (bl3 || !bl || this.isReadOnly() || !this.writeModel.isVariableSize() || this.getCount() <= 0) break;
                this.writeModel.remove(this.subfocus);
                if (this.subfocus == this.getCount()) {
                    this.setSubfocus(this.getCount() - 1);
                }
                keyEvent.consume();
                break;
            }
            case 10: {
                if (bl && this.editor == null && this.canSet(this.subfocus, false)) {
                    this.startEdit(this.subfocus);
                } else {
                    this.fireActionEvent();
                }
                keyEvent.consume();
                break;
            }
            case 113: {
                if (this.editor != null || this.isToggleItem(this.subfocus) || !this.canSet(this.subfocus, false)) break;
                this.startEdit(this.subfocus);
                keyEvent.consume();
                break;
            }
            case 74: {
                if (!bl2 || !bl || !bl3) break;
                this.debugPaint = !this.debugPaint;
                break;
            }
            case 25: 
            case 229: {
                this.startEdit(this.subfocus);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl = keyEvent.isAltDown();
        if (this.editor == null || keyEvent.isConsumed()) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.safeEndEdit(true);
                if (this.lockSubfocus) break;
                keyEvent.consume();
                this.fireActionEvent();
                break;
            }
            case 27: {
                this.safeEndEdit(false);
                keyEvent.consume();
                break;
            }
            case 33: 
            case 34: 
            case 38: 
            case 40: {
                if (bl) break;
                this.safeEndEdit();
                this.processKeyPressed(keyEvent);
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        switch (focusEvent.getID()) {
            case 1004: {
                if (this.selectAnchor < 0) {
                    this.selectAnchor = this.subfocus;
                }
                if (this.editor != null && this.editor.getComponent() != null) {
                    this.editor.getComponent().requestFocus();
                }
                if (this.hasFocus) break;
                this.hasFocus = true;
                break;
            }
            case 1005: {
                if (this.editor != null) break;
                this.hasFocus = false;
            }
        }
        this.repaintItem(this.subfocus);
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.hasFocus) {
            this.hasFocus = false;
            this.repaintItem(this.subfocus);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void windowActiveChanged(boolean bl) {
        super.windowActiveChanged(bl);
        this.repaintSelection();
    }

    protected boolean preprocessSubfocusEvent(VectorSubfocusEvent vectorSubfocusEvent) {
        return this.subfocusListeners.hasListeners() ? this.subfocusListeners.vetoableDispatch((VetoableDispatch)vectorSubfocusEvent) : true;
    }

    protected void processSubfocusEvent(VectorSubfocusEvent vectorSubfocusEvent) {
        if (this.subfocusListeners.hasListeners()) {
            this.subfocusListeners.dispatch((DispatchableEvent)vectorSubfocusEvent);
        }
    }

    public void removeSubfocusListener(VectorSubfocusListener vectorSubfocusListener) {
        this.subfocusListeners.remove((EventListener)vectorSubfocusListener);
    }

    public void addSubfocusListener(VectorSubfocusListener vectorSubfocusListener) {
        this.subfocusListeners.add((EventListener)vectorSubfocusListener);
    }

    private void repaintSelection() {
        for (int i = 0; i < this.oldSelected.length; ++i) {
            this.repaintItem(this.oldSelected[i]);
        }
    }

    public void doLayout() {
        if (this.editorLocation > -1 && this.editor != null) {
            Rectangle rectangle = this.getItemRect(this.editorLocation);
            if (rectangle != null) {
                this.editor.changeBounds(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
            } else {
                this.editor.changeBounds(new Rectangle(0, 0, 0, 0));
            }
        }
    }

    public void safeEndEdit(boolean bl) {
        try {
            this.endEdit(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void safeEndEdit() {
        this.safeEndEdit(this.postOnEndEdit);
    }

    public void endEdit(boolean bl) throws Exception {
        ItemEditor itemEditor = this.editor;
        this.editor = null;
        if (itemEditor != null) {
            try {
                boolean bl2 = itemEditor.canPost();
                if (!bl2) {
                    this.lockSubfocus = true;
                }
                if (bl2 || !bl) {
                    this.lockSubfocus = false;
                    if (bl && bl2 && this.writeModel.canSet(this.editorLocation, true)) {
                        this.writeModel.set(this.editorLocation, itemEditor.getValue());
                        this.fireActionEvent();
                    }
                    Component component = itemEditor.getComponent();
                    itemEditor.endEdit(bl);
                    itemEditor.removeKeyListener(this);
                    itemEditor.removeKeyListener(this.keyMulticaster);
                    if (component != null) {
                        this.remove(component);
                        component.removeFocusListener(this);
                    }
                    this.repaintItem(this.editorLocation);
                    this.editorLocation = -1;
                    this.editClickPoint = null;
                    itemEditor = null;
                    this.requestFocus();
                } else {
                    this.lockSubfocus = true;
                }
            }
            catch (Exception exception) {
                this.lockSubfocus = true;
                this.editor = itemEditor;
                throw exception;
            }
        }
        this.editor = itemEditor;
    }

    public void endEdit() throws Exception {
        this.endEdit(this.postOnEndEdit);
    }

    private boolean isToggleItem(int n) {
        int n2;
        if (this.model == null || this.viewManager == null || !this.editInPlace || this.batchMode) {
            return false;
        }
        Object object = this.model.get(n);
        ItemEditor itemEditor = this.getEditor(n, object, n2 = this.getState(n));
        if (itemEditor instanceof ToggleItemEditor) {
            Rectangle rectangle = this.getItemRect(n);
            return ((ToggleItemEditor)itemEditor).isToggle(object, rectangle, this) && this.canSet(n, false);
        }
        return false;
    }

    protected void resyncEditor() {
        if (this.editorLocation >= 0 && this.editor != null) {
            Rectangle rectangle = this.getEditorRect();
            this.editor.changeBounds(rectangle != null ? rectangle : new Rectangle());
        }
    }

    protected Rectangle getEditorRect() {
        Component component;
        Rectangle rectangle = null;
        if (this.editorLocation >= 0 && this.editor != null && (rectangle = this.getItemRect(this.editorLocation)) != null && this.growEditor && (component = this.editor.getComponent()) != null) {
            Dimension dimension = component.getPreferredSize();
            if (dimension.height > rectangle.height) {
                rectangle.height = dimension.height;
            }
        }
        return rectangle;
    }

    protected void startEdit(int n) {
        if (this.model == null || this.viewManager == null || !this.editInPlace || this.batchMode || !this.canSet(n, true)) {
            return;
        }
        this.rollover = -1;
        this.editorLocation = n;
        this.selection.removeAll();
        this.selection.add(this.editorLocation);
        Object object = this.model.get(this.editorLocation);
        this.editor = this.getEditor(this.editorLocation, object, 0);
        if (this.editor != null) {
            Component component = this.editor.getComponent();
            if (component != null) {
                component.setVisible(false);
                this.add(component);
            }
            Rectangle rectangle = this.getEditorRect();
            this.editor.addKeyListener(this);
            this.editor.addKeyListener(this.keyMulticaster);
            object = this.model.get(this.editorLocation);
            this.editor.startEdit(object, rectangle, this);
            this.resyncEditor();
            if (this.editor != null && this.editor.getComponent() != null) {
                this.editor.getComponent().addFocusListener(this);
            }
            this.editClickPoint = null;
        }
    }

    protected void processMouseExited(MouseEvent mouseEvent) {
        if (this.showRollover) {
            int n = this.rollover;
            this.rollover = -1;
            this.repaintItem(n);
        }
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Rectangle rectangle;
        int n;
        if (this.toolTip.active && this.getToolTipText(mouseEvent) != null && (n = this.hitTestAbs(mouseEvent.getY())) != -1 && (rectangle = this.getItemRect(n)) != null && this.model != null) {
            Object object = this.model.get(n);
            int n2 = this.getState(n);
            this.toolTip.data = object;
            this.toolTip.painter = this.getPainter(n, object, n2);
            this.toolTip.state = n2;
            return new Point(rectangle.x - 1, rectangle.y - 1);
        }
        this.toolTip.painter = null;
        return null;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.toolTip.active) {
            Object object;
            int n = this.hitTestAbs(mouseEvent.getY());
            if (n != -1 && this.model != null && this.viewManager != null && (object = this.model.get(n)) != null) {
                Rectangle rectangle = this.getItemRect(n);
                Dimension dimension = this.getPreferredItemSize(n, object);
                Rectangle rectangle2 = this.getVisibleScrollRect();
                if (!(rectangle == null || rectangle.contains(rectangle.x + dimension.width - 1, rectangle.y + dimension.height - 1) && rectangle2.contains(rectangle.x, rectangle.y) && rectangle2.contains(rectangle.x + dimension.width - 1, rectangle.y + dimension.width - 1))) {
                    int n2 = this.getState(n);
                    this.toolTip.data = object;
                    this.toolTip.painter = this.getPainter(n, object, n2);
                    this.toolTip.state = n2;
                    return object.toString();
                }
            }
            return null;
        }
        this.toolTip.painter = null;
        return this.getToolTipText();
    }

    public JToolTip createToolTip() {
        return this.toolTip;
    }

    protected void processMouseMoved(MouseEvent mouseEvent) {
        int n;
        if (this.showRollover && (n = this.hitTestAbs(mouseEvent.getY())) != this.rollover) {
            int n2 = this.rollover;
            this.rollover = n;
            if (n2 >= 0) {
                this.repaintItem(n2);
            }
            if (this.rollover >= 0) {
                this.repaintItem(this.rollover);
            }
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 20);
    }

    protected Dimension getPreferredItemSize(int n, Object object) {
        int n2 = this.getState(n);
        ItemPainter itemPainter = this.getPainter(n, object, n2);
        Dimension dimension = new Dimension(0, 0);
        if (itemPainter != null) {
            dimension = itemPainter.getPreferredSize(object, this.getSiteGraphics(), n2, this);
        }
        return dimension;
    }

    protected void processMouseReleased(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getY();
        boolean bl = mouseEvent.isShiftDown();
        boolean bl2 = mouseEvent.isControlDown();
        boolean bl3 = mouseEvent.isMetaDown();
        this.rollover = -1;
        this.rangeSelecting = false;
        if (this.editor != null && this.subfocus == this.editorLocation && this.editor.getComponent() != null) {
            this.editor.getComponent().requestFocus();
        }
        if ((n = this.hitTest(n2)) >= 0 && n == this.mouseDown) {
            if (!bl3 && (this.doStartEdit || this.isToggleItem(n))) {
                this.editClickPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                this.startEdit(n);
                this.doStartEdit = false;
            } else if (!(bl3 || bl || bl2 || this.selection.getCount() <= 1)) {
                this.selection.removeAll();
                this.selection.add(n);
            }
        }
        this.mouseDown = -1;
    }

    protected void processMouseDragged(MouseEvent mouseEvent) {
        int n;
        this.rollover = -1;
        if (this.dragSubfocus && !mouseEvent.isMetaDown() && this.rangeSelecting && (n = this.hitTest(mouseEvent.getY())) != -1) {
            int n2 = mouseEvent.isControlDown() ? 64 : 16;
            this.setSubfocus(n, n2);
        }
    }

    protected void processMousePressed(MouseEvent mouseEvent) {
        boolean bl = this.hasFocus;
        this.hasFocus = true;
        super.processMousePressed(mouseEvent);
        int n = this.hitTest(mouseEvent.getY());
        if (n == -1) {
            return;
        }
        this.rollover = -1;
        this.mouseDown = n;
        boolean bl2 = mouseEvent.isShiftDown();
        boolean bl3 = mouseEvent.isControlDown();
        boolean bl4 = mouseEvent.isAltDown();
        boolean bl5 = mouseEvent.isMetaDown();
        int n2 = bl2 && bl3 ? 16 : (bl2 ? 17 : (bl3 ? 72 : 67));
        if (this.selectAnchor < 0) {
            this.selectAnchor = this.subfocus;
        }
        if (this.editor != null) {
            if (this.editorLocation == n) {
                return;
            }
            this.safeEndEdit();
        }
        if (n == this.subfocus) {
            if (!bl5 && mouseEvent.getClickCount() == 2) {
                this.fireActionEvent();
            }
            if (!(bl3 || bl2 || bl4)) {
                if (bl && !this.selection.contains(n)) {
                    this.selection.removeAll();
                    this.selection.add(n);
                } else if (!bl) {
                    this.selection.removeAll();
                    this.selection.add(n);
                }
            } else if (bl3 && !bl2) {
                if (this.selection.contains(n)) {
                    this.selection.remove(n);
                } else {
                    this.selection.add(n);
                }
            }
            if (bl && !bl5 && !bl3 && !bl2 && !this.isToggleItem(n) && this.canSet(n, false)) {
                this.doStartEdit = true;
                return;
            }
        }
        this.rangeSelecting = true;
        this.setSubfocus(n, n2);
    }

    public void selectionChanged(VectorSelectionEvent vectorSelectionEvent) {
        int n;
        int[] nArray = vectorSelectionEvent.getSelection().getAll();
        BasicVectorSelection basicVectorSelection = new BasicVectorSelection(this.oldSelected);
        for (n = 0; n < nArray.length; ++n) {
            if (!basicVectorSelection.contains(nArray[n])) {
                this.repaintItem(nArray[n]);
                continue;
            }
            basicVectorSelection.remove(nArray[n]);
        }
        this.oldSelected = basicVectorSelection.getAll();
        for (n = 0; n < this.oldSelected.length; ++n) {
            this.repaintItem(this.oldSelected[n]);
        }
        this.oldSelected = vectorSelectionEvent.getSelection().getAll();
    }

    public void selectionRangeChanged(VectorSelectionEvent vectorSelectionEvent) {
        for (int i = vectorSelectionEvent.getRangeStart(); i < vectorSelectionEvent.getRangeEnd(); ++i) {
            this.repaintItem(i);
        }
        this.oldSelected = vectorSelectionEvent.getSelection().getAll();
    }

    public void selectionItemChanged(VectorSelectionEvent vectorSelectionEvent) {
        this.repaintItem(vectorSelectionEvent.getLocation());
        this.oldSelected = vectorSelectionEvent.getSelection().getAll();
    }

    public void modelStructureChanged(VectorModelEvent vectorModelEvent) {
        if (this.editor != null) {
            this.safeEndEdit(false);
        }
        this.invalidate();
        if (this.getCount() <= this.subfocus) {
            this.setSubfocus(this.getCount() - 1);
        }
        this.repaintItems();
        if (this.isShowing() && !this.batchMode) {
            this.scroller.validate();
            this.scrollView();
        }
    }

    public void modelContentChanged(VectorModelEvent vectorModelEvent) {
        switch (vectorModelEvent.getChange()) {
            case 1: {
                this.repaintItems();
                break;
            }
            case 17: 
            case 33: {
                if (this.editor != null && this.editorLocation == vectorModelEvent.getLocation()) {
                    this.safeEndEdit(false);
                }
                this.repaintItem(vectorModelEvent.getLocation());
            }
        }
    }

    protected void setSubfocus(int n, int n2) {
        int n3 = this.getCount();
        if (n3 <= 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        } else if (n >= n3) {
            n = n3 - 1;
        }
        if (this.editor != null) {
            if (this.lockSubfocus) {
                return;
            }
            this.safeEndEdit();
        }
        if (n >= n3 || n < 0 || this.subfocus == n || !this.preprocessSubfocusEvent(new VectorSubfocusEvent(this, 1, n))) {
            return;
        }
        if (this.selectAnchor < 0) {
            this.selectAnchor = n;
        }
        int n4 = this.subfocus;
        this.subfocus = n;
        if ((n2 & 1) != 0) {
            this.selection.removeAll();
        }
        if ((n2 & 2) != 0) {
            this.selection.add(this.subfocus);
        }
        if ((n2 & 8) != 0) {
            if (this.selection.contains(this.subfocus)) {
                this.selection.remove(this.subfocus);
            } else {
                this.selection.add(this.subfocus);
            }
        }
        if ((n2 & 0x10) != 0) {
            this.dumpingRange = true;
            this.selection.removeRange(this.selectAnchor, n4);
            this.selection.addRange(this.selectAnchor, this.subfocus);
        }
        if ((n2 & 0x40) != 0) {
            this.selectAnchor = n;
        }
        this.repaintItem(n4);
        this.repaintItem(this.subfocus);
        this.scrollView();
        this.processSubfocusEvent(new VectorSubfocusEvent(this, 2, this.subfocus));
    }

    public void setSubfocus(int n) {
        this.setSubfocus(n, 67);
    }

    public int getSubfocus() {
        return this.subfocus;
    }

    private void scrollView() {
        if (this.scroller.getViewport() == null) {
            return;
        }
        Rectangle rectangle = this.getVisibleScrollRect();
        Rectangle rectangle2 = this.getItemRect(this.subfocus);
        if (rectangle2 != null) {
            if (rectangle2.y < rectangle.y) {
                this.scroller.getViewport().setViewPosition(new Point(rectangle.x, rectangle2.y));
            } else if (rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                int n;
                int n2 = this.getSize().height;
                int n3 = n = n2 - rectangle.height < rectangle2.y + rectangle2.height - rectangle.height ? n2 - rectangle.height : rectangle2.y + rectangle2.height - rectangle.height;
                if (this.snapOrigin) {
                    Rectangle rectangle3;
                    int n4 = this.hitTest(n);
                    if ((rectangle3 = this.getItemRect(++n4)) != null) {
                        n = rectangle3.y;
                    }
                }
                this.scroller.getViewport().setViewPosition(new Point(rectangle.x, n));
            }
            this.scroller.getVerticalScrollBar().setUnitIncrement(rectangle2.height);
        }
    }

    public void setTopIndex(int n) {
        if (n < 0 || n >= this.getCount()) {
            return;
        }
        Rectangle rectangle = this.getVisibleScrollRect();
        Rectangle rectangle2 = this.getItemRect(this.subfocus);
        if (this.uniformHeight) {
            this.checkItemHeight();
            Object object = this.model.get(0);
            ItemPainter itemPainter = this.getPainter(0, object, 0);
            Graphics graphics = this.getSiteGraphics();
            int n2 = this.itemHeight > 0 ? this.itemHeight : (itemPainter != null ? itemPainter.getPreferredSize((Object)object, (Graphics)graphics, (int)0, (ItemPaintSite)this).height : 0);
            int n3 = (this.getCount() - n) * n2;
            if (rectangle.height <= n3) {
                this.scroller.getViewport().setViewPosition(new Point(rectangle.x, n * n2));
            } else if (rectangle.height <= this.getCount() * n2) {
                this.scroller.getViewport().setViewPosition(new Point(rectangle.x, this.getCount() * n2 - rectangle.height));
            } else {
                this.scroller.getViewport().setViewPosition(new Point(rectangle.x, 0));
            }
        }
        this.scroller.getVerticalScrollBar().setUnitIncrement(rectangle2.height);
    }

    public int getTopIndex() {
        return this.hitTest(this.scroller.getViewport().getViewPosition().y);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.invalidate();
        this.repaintItems();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaintItems();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.repaintItems();
    }

    public void setAlignment(int n) {
        this.alignment = n;
        this.repaintItems();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setItemMargins(Insets insets) {
        this.itemMargins = insets;
        this.invalidate();
        this.repaintItems();
    }

    public Insets getItemMargins() {
        return this.itemMargins;
    }

    public void removeSelectionListener(VectorSelectionListener vectorSelectionListener) {
        this.selectionMulticaster.remove(vectorSelectionListener);
    }

    public void addSelectionListener(VectorSelectionListener vectorSelectionListener) {
        this.selectionMulticaster.add(vectorSelectionListener);
    }

    public void setSelection(WritableVectorSelection writableVectorSelection) {
        if (this.selection != null) {
            this.selection.removeSelectionListener(this);
            this.selection.removeSelectionListener(this.selectionMulticaster);
        }
        this.selection = writableVectorSelection;
        if (this.selection != null) {
            this.selection.addSelectionListener(this);
            this.selection.addSelectionListener(this.selectionMulticaster);
        }
        this.repaintItems();
    }

    public WritableVectorSelection getSelection() {
        return this.selection;
    }

    public void setViewManager(VectorViewManager vectorViewManager) {
        this.viewManager = vectorViewManager;
        this.invalidate();
        this.repaintItems();
        if (this.isShowing() && !this.batchMode) {
            this.scroller.validate();
        }
    }

    public VectorViewManager getViewManager() {
        return this.viewManager;
    }

    public void setItemHeight(int n) {
        this.uniformHeight = n > 0;
        this.itemHeight = n;
        this.invalidate();
        if (this.scroller.isShowing() && !this.batchMode) {
            this.scroller.validate();
        }
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void setUniformHeight(boolean bl) {
        this.uniformHeight = bl;
        this.invalidate();
        if (this.scroller.isShowing() && !this.batchMode) {
            this.scroller.validate();
        }
    }

    public boolean isUniformHeight() {
        return this.uniformHeight;
    }

    public void setItemWidth(int n) {
        this.uniformWidth = n > 0;
        this.itemWidth = n;
        this.invalidate();
        if (this.scroller.isShowing() && !this.batchMode) {
            this.scroller.validate();
        }
    }

    public int getItemWidth() {
        return this.itemWidth;
    }

    public void setUniformWidth(boolean bl) {
        this.uniformWidth = bl;
        this.invalidate();
        if (this.scroller.isShowing() && !this.batchMode) {
            this.scroller.validate();
        }
    }

    public boolean isUniformWidth() {
        return this.uniformWidth;
    }

    public boolean isDragSubfocus() {
        return this.dragSubfocus;
    }

    public void setDragSubfocus(boolean bl) {
        this.dragSubfocus = bl;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(boolean bl) {
        if (this.batchMode != bl) {
            this.batchMode = bl;
            if (!this.batchMode) {
                this.repaintItems();
                if (this.isShowing()) {
                    this.scroller.validate();
                }
            }
        }
    }

    public ItemEditor getEditor() {
        return this.editor;
    }

    public boolean isEditing() {
        return this.editor != null;
    }

    public void setEditInPlace(boolean bl) {
        this.editInPlace = bl;
    }

    public boolean isEditInPlace() {
        return this.editInPlace;
    }

    public void setSnapOrigin(boolean bl) {
        this.snapOrigin = bl;
    }

    public boolean isSnapOrigin() {
        return this.snapOrigin;
    }

    public boolean isDataToolTip() {
        return this.toolTip.active;
    }

    public void setDataToolTip(boolean bl) {
        this.toolTip.active = bl;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (this.toolTip.active) {
            toolTipManager.registerComponent(this);
        } else if (this.getToolTipText() == null) {
            toolTipManager.unregisterComponent(this);
        }
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setShowRollover(boolean bl) {
        this.showRollover = bl;
    }

    public void setShowFocus(boolean bl) {
        this.showFocus = bl;
        this.repaintItem(this.subfocus);
    }

    public boolean isShowFocus() {
        return this.showFocus;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void removeModelListener(VectorModelListener vectorModelListener) {
        this.modelMulticaster.remove(vectorModelListener);
    }

    public void addModelListener(VectorModelListener vectorModelListener) {
        this.modelMulticaster.add(vectorModelListener);
    }

    public void setModel(VectorModel vectorModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = vectorModel;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
        }
        this.writeModel = this.model instanceof WritableVectorModel ? (WritableVectorModel)this.model : null;
        this.invalidate();
        this.repaintItems();
        if (this.isShowing() && !this.batchMode) {
            this.scroller.validate();
        }
    }

    public WritableVectorModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public VectorModel getModel() {
        return this.model;
    }

    public boolean isAutoAppend() {
        return this.autoAppend;
    }

    public void setAutoAppend(boolean bl) {
        this.autoAppend = bl;
    }

    public boolean isGrowEditor() {
        return this.growEditor;
    }

    public void setGrowEditor(boolean bl) {
        this.growEditor = bl;
    }

    public boolean isAutoEdit() {
        return this.autoEdit;
    }

    public void setAutoEdit(boolean bl) {
        this.autoEdit = bl;
    }

    public void setPostOnEndEdit(boolean bl) {
        this.postOnEndEdit = bl;
    }

    public boolean isPostOnEndEdit() {
        return this.postOnEndEdit;
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("List.background"));
        this.setForeground(UIManager.getColor("List.foreground"));
    }

    public ListCore(JScrollPane jScrollPane) {
        this.oldSelected = new int[0];
        this.itemMargins = new Insets(2, 2, 2, 2);
        this.toolTip = new DataToolTip(this);
        this.customPainter = new CustomItemPainter();
        this.customEditor = new CustomItemEditor();
        this.subfocusListeners = new EventMulticaster();
        this.keyMulticaster = new KeyMulticaster();
        this.modelMulticaster = new VectorModelMulticaster();
        this.selectionMulticaster = new VectorSelectionMulticaster();
        this.setLayout(null);
        this.scroller = jScrollPane;
        super.addKeyListener(this.keyMulticaster);
        this.scroller.getVerticalScrollBar().setUnitIncrement(20);
        this.scroller.getHorizontalScrollBar().setUnitIncrement(10);
        super.setBackground(UIManager.getColor("List.background"));
        super.setForeground(UIManager.getColor("List.foreground"));
    }
}

