/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.util.SerializableImage;
import com.borland.jbcl.view.ImageItemPainter;
import com.objectspace.jgl.Array;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ImageArrayItemPainter
extends ImageItemPainter
implements Serializable {
    protected transient int imageCount;
    protected transient Image[] images;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Array array = (Array)objectInputStream.readObject();
        this.images = new Image[array.size()];
        for (int i = 0; i < this.images.length; ++i) {
            this.images[i] = ((SerializableImage)array.at(i)).getImage();
        }
        this.imageCount = this.images.length;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Array array = new Array();
        for (int i = 0; i < this.images.length; ++i) {
            array.add((Object)SerializableImage.create(this.images[i]));
        }
        objectOutputStream.writeObject(array);
    }

    protected void assureSpace(int n) {
        if (n >= this.images.length) {
            Image[] imageArray = new Image[Math.max(this.images.length * 2, n + 4)];
            System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
            this.images = imageArray;
        }
    }

    public void paint(Object object, Graphics graphics, Rectangle rectangle, int n, ItemPaintSite itemPaintSite) {
        super.paint(this.images[((Number)object).intValue()], graphics, rectangle, n, itemPaintSite);
    }

    public Dimension getPreferredSize(Object object, Graphics graphics, int n, ItemPaintSite itemPaintSite) {
        return super.getPreferredSize(this.images[((Number)object).intValue()], graphics, n, itemPaintSite);
    }

    public int find(Image image) {
        for (int i = 0; i < this.imageCount; ++i) {
            if (image != this.images[i] && !image.equals(this.images[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean remove(int n) {
        if (n < 0 || n >= this.imageCount) {
            return false;
        }
        if (n < this.imageCount - 1) {
            System.arraycopy(this.images, n + 1, this.images, n, this.imageCount - n);
        } else {
            this.images[n] = null;
        }
        --this.imageCount;
        return true;
    }

    public boolean remove(Image image) {
        return this.remove(this.find(image));
    }

    public int insert(Image image, int n) {
        if (n < 0 || n > this.imageCount) {
            return -1;
        }
        this.assureSpace(this.imageCount + 1);
        if (n < this.imageCount) {
            System.arraycopy(this.images, n, this.images, n + 1, this.imageCount - n);
        }
        ++this.imageCount;
        this.images[n] = image;
        return n;
    }

    public int add(Image image) {
        this.assureSpace(this.imageCount + 1);
        this.images[this.imageCount] = image;
        return this.imageCount++;
    }

    public ImageArrayItemPainter(Component component, int n, Image[] imageArray) {
        super(component, n);
        this.images = imageArray;
        this.imageCount = 0;
        while (this.imageCount < imageArray.length && imageArray[this.imageCount] != null) {
            ++this.imageCount;
        }
    }

    public ImageArrayItemPainter(Image[] imageArray) {
        this.images = imageArray;
        this.imageCount = 0;
        while (this.imageCount < imageArray.length && imageArray[this.imageCount] != null) {
            ++this.imageCount;
        }
    }

    public ImageArrayItemPainter() {
        this.images = new Image[0];
    }
}

