/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.BasicVectorContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.VectorModel;
import com.borland.jbcl.model.VectorModelEvent;
import com.borland.jbcl.model.VectorModelListener;
import com.borland.jbcl.model.VectorViewManager;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.ButtonItemPainter;
import com.borland.jbcl.view.FixedSizeVector;
import com.borland.jbcl.view.HeaderEvent;
import com.borland.jbcl.view.HeaderListener;
import com.borland.jbcl.view.SizeVector;
import com.borland.jbcl.view.TextItemPainter;
import com.borland.jbcl.view.VariableSizeVector;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Hashtable;
import javax.swing.UIManager;

public class HeaderView
extends BeanPanel
implements Serializable,
VectorModelListener,
ItemPaintSite {
    private static Cursor V_SIZE_CURSOR;
    private static Cursor H_SIZE_CURSOR;
    private static Cursor MOVE_CURSOR;
    private static Cursor DEFAULT_CURSOR;
    private transient EventMulticaster headerListeners;
    private int clickItem;
    private int offset;
    private int rollover = -1;
    private boolean showRollover = false;
    private boolean batchMode = false;
    private boolean moving = false;
    private boolean startMove = false;
    private boolean resizing = false;
    private boolean moveable = true;
    private boolean liveResize = true;
    private boolean resizable = true;
    private Insets margins;
    private int alignment = 34;
    private int margin = 8;
    private int selection = -1;
    private boolean horz = true;
    private int orientation = 0;
    private int thickness = 0;
    private transient SizeVector sizes = new VariableSizeVector(new int[0]);
    private transient VectorModel model;
    private transient VectorViewManager viewManager;
    private static final long serialVersionUID = 200L;

    static {
        DEFAULT_CURSOR = Cursor.getDefaultCursor();
        MOVE_CURSOR = new Cursor(13);
        H_SIZE_CURSOR = new Cursor(10);
        V_SIZE_CURSOR = new Cursor(8);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Hashtable hashtable = (Hashtable)objectInputStream.readObject();
        Object v = hashtable.get("m");
        if (v instanceof VectorModel) {
            this.model = (VectorModel)v;
        }
        if ((v = hashtable.get("v")) instanceof VectorViewManager) {
            this.viewManager = (VectorViewManager)v;
        }
        if ((v = hashtable.get("s")) instanceof SizeVector) {
            this.sizes = (SizeVector)v;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(3);
        if (this.model instanceof Serializable) {
            hashtable.put("m", this.model);
        }
        if (this.viewManager instanceof Serializable) {
            hashtable.put("v", this.viewManager);
        }
        if (this.sizes instanceof Serializable) {
            hashtable.put("s", this.sizes);
        }
        objectOutputStream.writeObject(hashtable);
    }

    public void paintComponent(Graphics graphics) {
        if (this.batchMode) {
            return;
        }
        super.paintComponent(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            return;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        if (rectangle2.isEmpty() || rectangle.isEmpty()) {
            return;
        }
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = this.model != null ? this.model.getCount() : 0;
        int n2 = this.horz ? rectangle.x : rectangle.y;
        int n3 = this.horz ? rectangle.width : rectangle.height;
        int n4 = this.hitTest(n2) < n ? this.hitTest(n2) : n;
        int n5 = this.hitTest(n2 + n3) < n ? this.hitTest(n2 + n3) : n;
        int n6 = (this.isEnabled() ? 0 : 1) | this.focusState;
        if (n > 0 && n4 >= 0) {
            Rectangle rectangle3 = this.getItemBounds(n4);
            for (int i = n4; i <= n5; ++i) {
                ItemPainter itemPainter;
                if (this.horz) {
                    rectangle3.width = this.sizes.getSize(i);
                } else {
                    rectangle3.height = this.sizes.getSize(i);
                }
                Object object = this.model.get(i);
                int n7 = n6 | (i == this.selection ? 4 : 0);
                int n8 = i == this.rollover && this.showRollover ? 64 : 0;
                graphics.setColor(this.getBackground());
                graphics.setFont(this.getFont());
                ItemPainter itemPainter2 = itemPainter = this.viewManager != null ? this.viewManager.getPainter(i, object, n7 |= n8) : null;
                if (itemPainter != null) {
                    graphics.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    itemPainter.paint(object, graphics, rectangle3, n7, this);
                    graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (this.horz) {
                    rectangle3.x += rectangle3.width;
                    continue;
                }
                rectangle3.y += rectangle3.height;
            }
            if (this.horz) {
                rectangle3.width = rectangle2.x + rectangle2.width - rectangle3.x;
            } else {
                rectangle3.height = rectangle2.y + rectangle2.height - rectangle3.y;
            }
            if (rectangle3.width > 0 && rectangle3.height > 0 && this.isOpaque() && this.texture == null) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            }
        } else if (this.isOpaque() && this.texture == null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void repaintItem(int n) {
        Rectangle rectangle = this.getItemBounds(n);
        if (rectangle != null) {
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public Rectangle getItemBounds(int n) {
        Rectangle rectangle = this.getBounds();
        if (rectangle == null) {
            return new Rectangle();
        }
        rectangle.x -= rectangle.x;
        rectangle.y -= rectangle.y;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.sizes.getSize(i);
        }
        if (this.horz) {
            rectangle.x = n2;
            rectangle.width = this.sizes.getSize(n);
        } else {
            rectangle.y = n2;
            rectangle.height = this.sizes.getSize(n);
        }
        return rectangle;
    }

    protected void processMouseClicked(MouseEvent mouseEvent) {
        this.rollover = -1;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.horz ? n : n2;
        int n4 = this.hitTest(n3);
        if (n4 == this.clickItem) {
            this.processHeaderEvent(new HeaderEvent(this, 0, n4, n, n2));
        }
        this.setCursor(DEFAULT_CURSOR);
    }

    protected void processMouseExited(MouseEvent mouseEvent) {
        if (this.showRollover) {
            int n = this.rollover;
            this.rollover = -1;
            this.repaintItem(n);
        }
        this.setCursor(DEFAULT_CURSOR);
    }

    protected void processMouseReleased(MouseEvent mouseEvent) {
        this.rollover = -1;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.headerListeners.hasListeners()) {
            if (this.resizing) {
                this.processHeaderEvent(new HeaderEvent(this, 6, this.clickItem, n, n2));
                this.repaint();
            }
            if (this.moving) {
                this.processHeaderEvent(new HeaderEvent(this, 3, this.clickItem, n, n2));
                this.repaint();
            }
        }
        this.resizing = false;
        this.moving = false;
        this.startMove = false;
        this.setCursor(DEFAULT_CURSOR);
    }

    protected void processMouseDragged(MouseEvent mouseEvent) {
        this.rollover = -1;
        if (this.headerListeners.hasListeners()) {
            if (this.resizing || this.moving || this.startMove) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (this.resizing) {
                    if (this.sizes instanceof FixedSizeVector && this.clickItem != 0) {
                        this.setCursor(DEFAULT_CURSOR);
                        return;
                    }
                    if (this.liveResize) {
                        Rectangle rectangle = this.getItemBounds(this.clickItem);
                        int n3 = (this.horz ? n : n2) - (this.horz ? rectangle.x : rectangle.y) + this.offset;
                        if (n3 < 4) {
                            n3 = 4;
                        }
                        this.sizes.setSize(this.clickItem, n3);
                        this.resetSize();
                    }
                    this.processHeaderEvent(new HeaderEvent(this, 5, this.clickItem, n, n2));
                    return;
                }
                if (this.startMove) {
                    this.startMove = false;
                    this.moving = true;
                    this.processHeaderEvent(new HeaderEvent(this, 1, this.clickItem, n, n2));
                    return;
                }
                if (this.moving) {
                    this.setCursor(MOVE_CURSOR);
                    this.processHeaderEvent(new HeaderEvent(this, 2, this.clickItem, n, n2));
                    return;
                }
            }
            this.setCursor(DEFAULT_CURSOR);
        }
    }

    protected void processMouseMoved(MouseEvent mouseEvent) {
        int n = this.horz ? mouseEvent.getX() : mouseEvent.getY();
        int n2 = this.hitTest(n);
        if (this.showRollover && n2 >= 0 && n2 != this.rollover) {
            int n3 = this.rollover;
            this.rollover = n2;
            this.repaintItem(n3);
            this.repaintItem(this.rollover);
        }
        if (this.sizes instanceof FixedSizeVector && n2 != 0) {
            this.setCursor(DEFAULT_CURSOR);
            return;
        }
        Rectangle rectangle = this.getItemBounds(n2);
        if (this.horz) {
            if (n <= rectangle.x + rectangle.width && n >= rectangle.x + rectangle.width - this.margin && this.resizable) {
                this.setCursor(H_SIZE_CURSOR);
                return;
            }
        } else if (n <= rectangle.y + rectangle.height && n >= rectangle.y + rectangle.height - this.margin && this.resizable) {
            this.setCursor(V_SIZE_CURSOR);
            return;
        }
        this.setCursor(DEFAULT_CURSOR);
    }

    protected void processMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.rollover = -1;
        if (this.headerListeners.hasListeners()) {
            int n3 = this.horz ? this.hitTest(n) : this.hitTest(n2);
            Rectangle rectangle = this.getItemBounds(n3);
            if (this.horz) {
                if (n <= rectangle.x + rectangle.width) {
                    this.clickItem = n3;
                    if (n >= rectangle.x + rectangle.width - this.margin && this.resizable) {
                        if (this.sizes instanceof FixedSizeVector && n3 != 0) {
                            return;
                        }
                        this.offset = rectangle.x + rectangle.width - n;
                        this.resizing = true;
                        this.processHeaderEvent(new HeaderEvent(this, 4, this.clickItem, n, n2));
                    } else if (this.moveable) {
                        this.startMove = true;
                    }
                }
            } else if (n2 <= rectangle.y + rectangle.height) {
                this.clickItem = n3;
                if (n2 >= rectangle.y + rectangle.height - this.margin && this.resizable) {
                    if (this.sizes instanceof FixedSizeVector && n3 != 0) {
                        return;
                    }
                    this.offset = rectangle.y + rectangle.height - n2;
                    this.resizing = true;
                    this.processHeaderEvent(new HeaderEvent(this, 4, this.clickItem, n, n2));
                }
            }
        }
    }

    protected void processHeaderEvent(HeaderEvent headerEvent) {
        if (this.headerListeners.hasListeners()) {
            this.headerListeners.dispatch((DispatchableEvent)headerEvent);
        }
    }

    protected void resetSize() {
        this.getThickness();
        Dimension dimension = new Dimension(this.thickness, this.thickness);
        if (this.horz) {
            dimension.width = this.sizes.getSizeUpTo(this.model.getCount());
        } else {
            dimension.height = this.sizes.getSizeUpTo(this.model.getCount());
        }
        this.setSize(dimension);
    }

    private int hitTest(int n) {
        int n2 = 0;
        int n3 = this.model.getCount();
        for (int i = this.sizes.getSize(n2); n >= i && ++n2 < n3; i += this.sizes.getSize(n2)) {
        }
        if (n2 == n3) {
            --n2;
        }
        return n2;
    }

    public Dimension getPreferredSize() {
        this.getThickness();
        if (this.model == null || this.sizes == null) {
            return new Dimension(this.thickness, this.thickness);
        }
        if (this.horz) {
            return new Dimension(this.sizes.getSizeUpTo(this.model.getCount()), this.thickness);
        }
        return new Dimension(this.thickness, this.sizes.getSizeUpTo(this.model.getCount()));
    }

    public void setItemSizes(SizeVector sizeVector) {
        this.sizes = sizeVector;
    }

    public SizeVector getItemSizes() {
        return this.sizes;
    }

    public void setThickness(int n) {
        if (this.thickness != n) {
            this.thickness = n;
            this.getThickness();
            this.invalidate();
            this.repaint();
        }
    }

    public int getThickness() {
        if (this.thickness == 0 && this.model != null && this.viewManager != null) {
            Graphics graphics = this.getGraphics();
            if (graphics == null) {
                return 0;
            }
            Font font = this.getFont();
            if (this.horz) {
                FontMetrics fontMetrics;
                Dimension dimension;
                graphics.setFont(font);
                Object object = this.model.getCount() > 0 ? this.model.get(0) : null;
                ItemPainter itemPainter = this.viewManager.getPainter(0, null, 0);
                Dimension dimension2 = dimension = itemPainter != null ? itemPainter.getPreferredSize(object, graphics, 0, null) : new Dimension(0, 0);
                this.thickness = this.model.getCount() > 0 ? (dimension != null ? dimension.height : 0) : ((fontMetrics = graphics.getFontMetrics(font)) != null ? fontMetrics.getHeight() : 0);
            } else {
                FontMetrics fontMetrics = graphics.getFontMetrics(font);
                this.thickness = fontMetrics != null ? fontMetrics.stringWidth("WWW") : 0;
            }
        }
        return this.thickness;
    }

    public void modelContentChanged(VectorModelEvent vectorModelEvent) {
        this.resetSize();
    }

    public void modelStructureChanged(VectorModelEvent vectorModelEvent) {
        this.resetSize();
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(boolean bl) {
        this.batchMode = bl;
        if (!this.batchMode) {
            this.repaint();
        }
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setShowRollover(boolean bl) {
        this.showRollover = bl;
    }

    public void setMoveable(boolean bl) {
        this.moveable = bl;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public void setLiveResize(boolean bl) {
        this.liveResize = bl;
    }

    public boolean isLiveResize() {
        return this.liveResize;
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setOrientation(int n) {
        this.orientation = n;
        this.horz = n == 0;
        this.invalidate();
        this.repaint();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void removeHeaderListener(HeaderListener headerListener) {
        this.headerListeners.remove((EventListener)headerListener);
    }

    public void addHeaderListener(HeaderListener headerListener) {
        this.headerListeners.add((EventListener)headerListener);
    }

    public void setViewManager(VectorViewManager vectorViewManager) {
        this.viewManager = vectorViewManager;
    }

    public VectorViewManager getViewManager() {
        return this.viewManager;
    }

    public Component getSiteComponent() {
        return this;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public Insets getItemMargins() {
        return this.margins;
    }

    public void setItemMargins(Insets insets) {
        this.margins = insets;
    }

    public boolean isTransparent() {
        return this.texture != null ? true : !this.isOpaque();
    }

    public void setModel(VectorModel vectorModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
        }
        this.model = vectorModel;
        if (this.model != null) {
            this.model.addModelListener(this);
        }
    }

    public VectorModel getModel() {
        return this.model;
    }

    protected VectorViewManager createDefaultViewManager() {
        return new BasicViewManager(new ButtonItemPainter(new TextItemPainter()));
    }

    protected VectorModel createDefaultModel() {
        return new BasicVectorContainer();
    }

    public void updateUI() {
        super.updateUI();
        super.setBackground(UIManager.getColor("TableHeader.background"));
        super.setForeground(UIManager.getColor("TableHeader.foreground"));
    }

    public HeaderView(int n) {
        super(null);
        this.margins = new Insets(1, 1, 1, 1);
        this.headerListeners = new EventMulticaster();
        this.orientation = n;
        this.horz = this.orientation == 0;
        this.model = this.createDefaultModel();
        this.viewManager = this.createDefaultViewManager();
        this.setFocusAware(false);
        super.setBackground(UIManager.getColor("TableHeader.background"));
        super.setForeground(UIManager.getColor("TableHeader.foreground"));
    }

    public HeaderView() {
        this(0);
    }
}

