/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.dx.dataset.CustomPaintSite;
import com.borland.dx.dataset.Variant;
import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jb.util.VetoableDispatch;
import com.borland.jbcl.model.BasicMatrixSelection;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixModel;
import com.borland.jbcl.model.MatrixModelEvent;
import com.borland.jbcl.model.MatrixModelListener;
import com.borland.jbcl.model.MatrixModelMulticaster;
import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.MatrixSelectionMulticaster;
import com.borland.jbcl.model.MatrixSubfocusEvent;
import com.borland.jbcl.model.MatrixSubfocusListener;
import com.borland.jbcl.model.MatrixViewManager;
import com.borland.jbcl.model.NullMatrixSelection;
import com.borland.jbcl.model.ToggleItemEditor;
import com.borland.jbcl.model.WritableMatrixModel;
import com.borland.jbcl.model.WritableMatrixSelection;
import com.borland.jbcl.util.ColorWheel;
import com.borland.jbcl.util.ImageTexture;
import com.borland.jbcl.util.KeyMulticaster;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.ColumnView;
import com.borland.jbcl.view.CustomItemEditor;
import com.borland.jbcl.view.CustomItemListener;
import com.borland.jbcl.view.CustomItemPainter;
import com.borland.jbcl.view.DataToolTip;
import com.borland.jbcl.view.FixedSizeVector;
import com.borland.jbcl.view.GridCore_Divider;
import com.borland.jbcl.view.MatrixView;
import com.borland.jbcl.view.Res;
import com.borland.jbcl.view.SizeVector;
import com.borland.jbcl.view.VariableSizeVector;
import com.objectspace.jgl.Array;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Hashtable;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

class GridCore
extends BeanPanel
implements Serializable,
MatrixView,
MatrixSelectionListener,
MatrixModelListener,
FocusListener,
KeyListener,
ItemEditSite {
    private static Cursor CURSOR_SIZE_H;
    private static Cursor CURSOR_SIZE_V;
    private static Cursor CURSOR_MOVE;
    private static Cursor CURSOR_DEFAULT;
    private static int TRACE_MOUSE;
    private transient EventMulticaster subfocusMulticaster;
    private transient MatrixSelectionMulticaster selectionMulticaster;
    private transient MatrixModelMulticaster modelMulticaster;
    private transient KeyMulticaster keyMulticaster;
    private transient Array customizeListeners;
    private transient CustomItemEditor customEditor;
    private transient CustomItemPainter customPainter;
    public static final int MIN_CELL_SIZE = 4;
    private boolean useBackingStore = false;
    private DataToolTip toolTip;
    private boolean showRollover = false;
    private boolean batchMode = false;
    private boolean debugPaint = false;
    private boolean dragSubfocus = true;
    private boolean navigateOnTab = true;
    private boolean navigateOnEnter = true;
    private boolean autoAppend = false;
    private boolean autoEdit = true;
    private boolean editInPlace = true;
    private Color lineColor;
    private int defaultColWidth = 100;
    private Insets margins;
    private boolean snapOrigin = true;
    private boolean dumpingRange = false;
    private boolean resizeColumn;
    private boolean resizingGrid;
    private boolean rangeSelecting;
    private int moveIndex;
    private MatrixLocation mouseDown;
    private MatrixLocation rollover;
    private MatrixLocation movingLocation;
    private MatrixLocation resize1;
    private MatrixLocation resize;
    private MatrixLocation selectAnchor;
    private boolean growEditor = true;
    private MatrixLocation editorLocation;
    private MatrixLocation subfocus;
    private ItemEditor editor;
    private Point editClickPoint;
    private int dividerDelta;
    private int dividerWidth = 4;
    private GridCore_Divider divider;
    private boolean showFocus = true;
    private boolean hasFocus = false;
    private boolean postOnEndEdit = true;
    private boolean vGridLines = true;
    private boolean hGridLines = true;
    private boolean visibleGrid = true;
    private boolean liveResize = false;
    private boolean readOnly = false;
    private MatrixLocation[] oldSelected;
    private ColumnView[] columnViews;
    private transient Object actionSource;
    private transient JScrollPane scroller;
    private transient SizeVector rowSizes;
    private transient SizeVector columnSizes;
    private transient WritableMatrixSelection selection = new NullMatrixSelection();
    private transient MatrixViewManager viewManager;
    private transient WritableMatrixModel writeModel;
    private transient MatrixModel model;
    private static boolean debugRectHashLeft;
    private static int debugRectInc;
    private static ColorWheel colorWheel;
    private boolean lockSubfocus = false;
    boolean doStartEdit = false;
    private static final long serialVersionUID = 200L;

    static {
        colorWheel = new ColorWheel(Color.red, 1, 100);
        debugRectInc = 10;
        debugRectHashLeft = true;
        TRACE_MOUSE = 23;
        CURSOR_DEFAULT = Cursor.getDefaultCursor();
        CURSOR_MOVE = new Cursor(13);
        CURSOR_SIZE_V = new Cursor(8);
        CURSOR_SIZE_H = new Cursor(10);
    }

    public static void debugRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (graphics == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            return;
        }
        graphics.setClip(n, n2, n3, n4);
        Color color = graphics.getColor();
        graphics.setColor(colorWheel.next());
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
        if (debugRectHashLeft) {
            for (int i = 0; i < n + n3 + n4; i += debugRectInc) {
                graphics.drawLine(n, n2 + i, n + i, n2);
            }
        } else {
            for (int i = 0; i < n + n3 + n4; i += debugRectInc) {
                graphics.drawLine(n + n3, n2 + i, n + n3 - i, n2);
            }
        }
        boolean bl = debugRectHashLeft = !debugRectHashLeft;
        debugRectInc = debugRectInc > 15 ? 5 : (debugRectInc += 2);
        graphics.setColor(color);
        if (rectangle != null) {
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Hashtable hashtable = (Hashtable)objectInputStream.readObject();
        Object v = hashtable.get("mo");
        if (v != null) {
            this.model = (MatrixModel)v;
        }
        if (this.model instanceof WritableMatrixModel) {
            this.writeModel = (WritableMatrixModel)this.model;
        }
        if ((v = hashtable.get("vm")) instanceof MatrixViewManager) {
            this.viewManager = (MatrixViewManager)v;
        }
        if ((v = hashtable.get("se")) instanceof WritableMatrixSelection) {
            this.selection = (WritableMatrixSelection)v;
        }
        if ((v = hashtable.get("cs")) instanceof SizeVector) {
            this.columnSizes = (SizeVector)v;
        }
        if ((v = hashtable.get("rs")) instanceof SizeVector) {
            this.rowSizes = (SizeVector)v;
        }
        this.actionSource = hashtable.get("as");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(8);
        if (this.model instanceof Serializable) {
            hashtable.put("mo", this.model);
        }
        if (this.viewManager instanceof Serializable) {
            hashtable.put("vm", this.viewManager);
        }
        if (this.selection instanceof Serializable) {
            hashtable.put("se", this.selection);
        }
        if (this.columnSizes instanceof Serializable) {
            hashtable.put("cs", this.columnSizes);
        }
        if (this.rowSizes instanceof Serializable) {
            hashtable.put("rs", this.rowSizes);
        }
        if (this.actionSource instanceof Serializable) {
            hashtable.put("as", this.actionSource);
        }
        objectOutputStream.writeObject(hashtable);
    }

    public synchronized void removeCustomItemListener(CustomItemListener customItemListener) {
        if (this.customizeListeners != null) {
            this.customizeListeners.remove((Object)customItemListener);
        }
        if (this.customizeListeners.size() == 0) {
            this.customizeListeners = null;
        }
    }

    public synchronized void addCustomItemListener(CustomItemListener customItemListener) {
        if (this.customizeListeners == null) {
            this.customizeListeners = new Array();
        }
        this.customizeListeners.add((Object)customItemListener);
    }

    protected void fireCustomizeItemEvent(Object object, Object object2, int n, CustomPaintSite customPaintSite) {
        if (this.customizeListeners != null) {
            customPaintSite.reset();
            for (int i = 0; i < this.customizeListeners.size(); ++i) {
                ((CustomItemListener)this.customizeListeners.at(i)).customizeItem(object, object2, n, customPaintSite);
            }
        }
    }

    private void resetColumnSizes() {
        for (int i = 0; i < this.columnViews.length; ++i) {
            int n = this.columnViews[i].getWidth();
            if (n == 0) {
                n = this.defaultColWidth;
            }
            this.columnSizes.setSize(i, n > 4 ? n : 4);
            this.columnViews[i].setWidth(this.columnSizes.getSize(i));
        }
    }

    private void fireActionEvent() {
        Object object = this.model != null ? this.model.get(this.subfocus.row, this.getColumnOrdinal(this.subfocus.column)) : null;
        String string = object != null ? object.toString() : "";
        this.processActionEvent(new ActionEvent(this.actionSource, 1001, string));
    }

    public void checkParentWindow() {
        this.findParentWindow();
    }

    public void stopMove(boolean bl, int n, int n2, int n3) {
        this.divider.setVisible(false);
        if (bl) {
            MatrixLocation matrixLocation = this.hitTest(n2, 0);
            int n4 = -1;
            if (matrixLocation != null) {
                if (matrixLocation.column != this.movingLocation.column) {
                    Rectangle rectangle = this.getCellRect(matrixLocation);
                    n4 = matrixLocation.column;
                    if (n2 - rectangle.x > rectangle.width / 2) {
                        ++n4;
                    }
                }
            } else if (n2 >= this.columnSizes.getSizeUpTo(this.columnViews.length - 1)) {
                n4 = this.columnViews.length;
            } else if (n2 < 0) {
                n4 = 0;
            }
            if (n4 != this.moveIndex && n4 - 1 != this.moveIndex && n4 != -1) {
                this.moveColumnView(this.moveIndex, n4);
                this.repaintCells();
            }
        }
        this.movingLocation = null;
    }

    private void moveColumnView(int n, int n2) {
        int n3;
        if (n >= this.columnViews.length || n2 > this.columnViews.length) {
            return;
        }
        for (n3 = 0; n3 < this.columnViews.length; ++n3) {
            this.columnViews[n3].setOrdinal(this.getColumnOrdinal(n3));
        }
        n3 = n > n2 ? n2 : n2 - 1;
        ColumnView columnView = this.columnViews[n];
        int n4 = this.columnSizes.getSize(n);
        if (n3 < n) {
            for (int i = n; i > n3; --i) {
                this.columnViews[i] = this.columnViews[i - 1];
                this.columnSizes.setSize(i, this.columnSizes.getSize(i - 1));
            }
        } else {
            for (int i = n; i < n3; ++i) {
                this.columnViews[i] = this.columnViews[i + 1];
                this.columnSizes.setSize(i, this.columnSizes.getSize(i + 1));
            }
        }
        this.columnViews[n3] = columnView;
        this.columnSizes.setSize(n3, n4);
    }

    public void whileMove(boolean bl, int n, int n2, int n3) {
        block2: {
            int n4;
            MatrixLocation matrixLocation;
            block3: {
                this.divider.setVisible(true);
                if (!bl) break block2;
                matrixLocation = this.hitTest(n2, 0);
                if (matrixLocation == this.resize1 || matrixLocation == null) break block3;
                Rectangle rectangle = this.getCellRect(matrixLocation);
                Rectangle rectangle2 = this.scroller.getViewport().getViewRect();
                if (n2 - rectangle.x > rectangle.width / 2) {
                    this.divider.setLocation(rectangle.x + rectangle.width - this.dividerWidth / 2, rectangle2.y);
                } else {
                    this.divider.setLocation(rectangle.x - this.dividerWidth / 2, rectangle2.y);
                }
                this.resize1 = matrixLocation;
                break block2;
            }
            if (matrixLocation != null || n2 < this.columnSizes.getSizeUpTo(n4 = this.getColumnCount() - 1)) break block2;
            Rectangle rectangle = this.getCellRect(0, n4);
            this.divider.setLocation(rectangle.x + rectangle.width - this.dividerWidth / 2, this.scroller.getViewport().getViewPosition().y);
            this.resize1 = matrixLocation;
        }
    }

    public void startMove(boolean bl, int n, int n2, int n3) {
        block0: {
            if (!bl) break block0;
            this.moveIndex = n;
            this.resize1 = this.movingLocation = this.hitTest(n2, 0);
            Rectangle rectangle = this.getCellRect(0, n);
            Rectangle rectangle2 = this.scroller.getViewport().getViewRect();
            this.divider.setBounds(rectangle.x - this.dividerWidth / 2, rectangle2.y, this.dividerWidth, rectangle2.height);
        }
    }

    public boolean whileResize(boolean bl, int n, int n2, int n3) {
        if (bl) {
            // empty if block
        }
        this.invalidate();
        Point point = this.scroller.getViewport().getViewPosition();
        this.scroller.validate();
        this.scroller.getViewport().setViewPosition(point);
        this.repaintCells();
        return true;
    }

    public boolean stopResize(boolean bl, MatrixLocation matrixLocation, int n, int n2) {
        if (matrixLocation != null) {
            Rectangle rectangle = this.getCellRect(matrixLocation);
            if (bl) {
                if (n - this.dividerDelta - rectangle.x > 1) {
                    this.columnSizes.setSize(matrixLocation.column, n - this.dividerDelta - rectangle.x);
                    if (this.columnViews != null && this.columnViews.length > matrixLocation.column) {
                        this.columnViews[matrixLocation.column].setWidth(this.columnSizes.getSize(matrixLocation.column));
                    }
                }
            } else if (n2 - this.dividerDelta - rectangle.y > 1) {
                this.rowSizes.setSize(matrixLocation.row, n2 - this.dividerDelta - rectangle.y);
            }
        }
        this.resizingGrid = false;
        return true;
    }

    public boolean stopResize(boolean bl, int n, int n2, int n3) {
        boolean bl2 = this.stopResize(bl, this.resize1, n2, n3);
        this.resize1 = null;
        this.invalidate();
        this.repaintCells();
        if (this.isShowing() && !this.batchMode) {
            Point point = this.scroller.getViewport().getViewPosition();
            this.scroller.validate();
            this.scroller.getViewport().setViewPosition(point);
        }
        return bl2;
    }

    boolean startResize(boolean bl, MatrixLocation matrixLocation, int n, int n2) {
        if (this.editorLocation != null) {
            this.safeEndEdit();
        }
        Rectangle rectangle = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        if (bl) {
            Rectangle rectangle2 = this.getCellRect(matrixLocation);
            this.dividerDelta = n - (rectangle2.x + rectangle2.width);
        } else {
            Rectangle rectangle3 = this.getCellRect(matrixLocation);
            this.dividerDelta = n2 - (rectangle3.y + rectangle3.height);
        }
        this.resizingGrid = true;
        return true;
    }

    public boolean startResize(boolean bl, int n, int n2, int n3) {
        this.resize1 = bl ? new MatrixLocation(0, n) : new MatrixLocation(n, 0);
        return this.startResize(bl, this.resize1, n2, n3);
    }

    public void reset() {
        this.safeEndEdit(false);
        this.resize = null;
        this.setSubfocus(0, 0, 67);
        this.scroller.getViewport().setViewPosition(new Point());
        this.repaintCells();
    }

    protected void resyncEditor() {
        if (this.editorLocation != null && this.editor != null) {
            Rectangle rectangle = this.getEditorRect();
            this.editor.changeBounds(rectangle != null ? rectangle : new Rectangle());
        }
    }

    public void doLayout() {
        this.resyncEditor();
    }

    protected Rectangle getEditorRect() {
        Rectangle rectangle = null;
        if (this.editorLocation != null && this.editor != null && (rectangle = this.getCellRect(this.editorLocation)) != null) {
            Component component;
            if (this.visibleGrid) {
                --rectangle.x;
                ++rectangle.width;
                --rectangle.y;
                ++rectangle.height;
            }
            if (this.growEditor && (component = this.editor.getComponent()) != null) {
                Dimension dimension = component.getPreferredSize();
                if (dimension.height > rectangle.height) {
                    rectangle.height = dimension.height;
                }
            }
        }
        return rectangle;
    }

    public Rectangle getCellRangeRect(MatrixLocation matrixLocation, MatrixLocation matrixLocation2) {
        Rectangle rectangle;
        MatrixLocation matrixLocation3 = new MatrixLocation(matrixLocation.row < matrixLocation2.row ? matrixLocation.row : matrixLocation2.row, matrixLocation.column < matrixLocation2.column ? matrixLocation.column : matrixLocation2.column);
        MatrixLocation matrixLocation4 = new MatrixLocation(matrixLocation.row > matrixLocation2.row ? matrixLocation.row : matrixLocation2.row, matrixLocation.column > matrixLocation2.column ? matrixLocation.column : matrixLocation2.column);
        if (matrixLocation3.row <= matrixLocation4.row && matrixLocation3.column <= matrixLocation4.column && (rectangle = this.getCellRect(matrixLocation3)) != null) {
            Rectangle rectangle2 = this.getCellRect(matrixLocation4);
            if (rectangle2 != null) {
                return rectangle.union(rectangle2);
            }
            Dimension dimension = this.getSize();
            Rectangle rectangle3 = this.getCellRect(new MatrixLocation(0, matrixLocation4.column));
            int n = rectangle3 != null ? rectangle3.x + rectangle3.width - 1 : dimension.width - 1;
            Rectangle rectangle4 = this.getCellRect(new MatrixLocation(matrixLocation4.row, 0));
            int n2 = rectangle4 != null ? rectangle4.y + rectangle4.height - 1 : dimension.height - 1;
            rectangle.add(n, n2);
            return rectangle;
        }
        return null;
    }

    public void safeEndEdit(boolean bl) {
        try {
            this.endEdit(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void safeEndEdit() {
        this.safeEndEdit(this.postOnEndEdit);
    }

    public void endEdit(boolean bl) throws Exception {
        ItemEditor itemEditor = this.editor;
        this.editor = null;
        if (itemEditor != null) {
            Component component = itemEditor.getComponent();
            if (bl) {
                try {
                    boolean bl2 = itemEditor.canPost();
                    if (!bl2) {
                        throw new IllegalStateException(Res.getString(10));
                    }
                    if (bl && bl2 && this.canSet(this.editorLocation.row, this.editorLocation.column, true)) {
                        this.writeModel.set(this.editorLocation.row, this.getColumnOrdinal(this.editorLocation.column), itemEditor.getValue());
                    }
                    itemEditor.endEdit(bl);
                }
                catch (Exception exception) {
                    this.lockSubfocus = true;
                    this.editor = itemEditor;
                    throw exception;
                }
            }
            itemEditor.removeKeyListener(this);
            itemEditor.removeKeyListener(this.keyMulticaster);
            if (component != null) {
                this.remove(component);
                component.removeFocusListener(this);
            }
            this.lockSubfocus = false;
            this.repaintCell(this.editorLocation);
            this.editorLocation = null;
            this.editClickPoint = null;
            this.requestFocus();
        }
    }

    public void endEdit() throws Exception {
        this.endEdit(this.postOnEndEdit);
    }

    private boolean isToggleItem(int n, int n2) {
        int n3;
        if (this.model == null || this.viewManager == null || !this.editInPlace || this.batchMode) {
            return false;
        }
        Object object = this.model.get(n, this.getColumnOrdinal(n2));
        ItemEditor itemEditor = this.getEditor(n, n2, object, n3 = this.getState(n, n2));
        if (itemEditor instanceof ToggleItemEditor) {
            Rectangle rectangle = this.getCellRect(n, n2);
            ItemEditSite itemEditSite = this;
            if (this.columnViews != null && n2 < this.columnViews.length) {
                itemEditSite = this.columnViews[n2];
            }
            return ((ToggleItemEditor)itemEditor).isToggle(object, rectangle, itemEditSite) && this.canSet(n, n2, false);
        }
        return false;
    }

    protected void startEdit(MatrixLocation matrixLocation) {
        if (this.model == null || this.viewManager == null || !this.editInPlace || !this.canSet(matrixLocation.row, matrixLocation.column, true) || this.batchMode) {
            return;
        }
        this.rollover = null;
        this.editorLocation = new MatrixLocation(matrixLocation);
        this.selection.removeAll();
        this.selection.add(new MatrixLocation(this.editorLocation));
        Object object = this.model.get(this.editorLocation.row, this.getColumnOrdinal(this.editorLocation.column));
        int n = this.getState(this.editorLocation.row, this.editorLocation.column);
        this.editor = this.getEditor(this.editorLocation.row, this.editorLocation.column, object, n);
        if (this.editor != null) {
            Component component = this.editor.getComponent();
            if (component != null) {
                component.setVisible(false);
                this.add(component);
            }
            Rectangle rectangle = this.getEditorRect();
            ItemEditSite itemEditSite = this;
            if (this.columnViews != null && this.columnViews.length > this.editorLocation.column) {
                itemEditSite = this.columnViews[this.editorLocation.column];
            }
            this.editor.addKeyListener(this);
            this.editor.addKeyListener(this.keyMulticaster);
            this.editor.startEdit(object, rectangle, itemEditSite);
            this.resyncEditor();
            if (this.editor != null && this.editor.getComponent() != null) {
                this.editor.getComponent().addFocusListener(this);
            }
            this.editClickPoint = null;
        }
    }

    protected void processMouseExited(MouseEvent mouseEvent) {
        if (this.showRollover) {
            MatrixLocation matrixLocation = this.rollover;
            this.rollover = null;
            this.repaintCell(matrixLocation);
        }
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Rectangle rectangle;
        MatrixLocation matrixLocation;
        if (this.toolTip.active && this.getToolTipText(mouseEvent) != null && (matrixLocation = this.hitTest(mouseEvent.getX(), mouseEvent.getY())) != null && (rectangle = this.getCellRect(matrixLocation)) != null && this.model != null) {
            Object object = this.model.get(matrixLocation.row, matrixLocation.column);
            int n = this.getState(matrixLocation.row, matrixLocation.column);
            this.toolTip.data = object;
            this.toolTip.painter = this.getPainter(matrixLocation.row, matrixLocation.column, object, n);
            this.toolTip.state = n;
            return new Point(rectangle.x - 1, rectangle.y - 1);
        }
        this.toolTip.painter = null;
        return null;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.toolTip.active) {
            Object object;
            MatrixLocation matrixLocation = this.hitTest(mouseEvent.getX(), mouseEvent.getY());
            if (matrixLocation != null && this.model != null && this.viewManager != null && (object = this.model.get(matrixLocation.row, this.getColumnOrdinal(matrixLocation.column))) != null) {
                Rectangle rectangle = this.getCellRect(matrixLocation);
                Dimension dimension = this.getPreferredCellSize(matrixLocation, object);
                Rectangle rectangle2 = this.scroller.getViewport().getViewRect();
                if (!(rectangle == null || rectangle.contains(rectangle.x + dimension.width - 1, rectangle.y + dimension.height - 1) && rectangle2.contains(rectangle.x, rectangle.y) && rectangle2.contains(rectangle.x + dimension.width - 1, rectangle.y + dimension.width - 1))) {
                    int n = this.getState(matrixLocation.row, matrixLocation.column);
                    this.toolTip.data = object;
                    this.toolTip.painter = this.getPainter(matrixLocation.row, matrixLocation.column, object, n);
                    this.toolTip.state = n;
                    return object.toString();
                }
            }
            return null;
        }
        this.toolTip.painter = null;
        return this.getToolTipText();
    }

    public JToolTip createToolTip() {
        return this.toolTip;
    }

    protected void processMouseMoved(MouseEvent mouseEvent) {
        MatrixLocation matrixLocation;
        if (this.showRollover && (matrixLocation = this.hitTest(mouseEvent.getX(), mouseEvent.getY())) != null && !matrixLocation.equals(this.rollover)) {
            MatrixLocation matrixLocation2 = this.rollover;
            this.rollover = matrixLocation;
            this.repaintCell(matrixLocation2);
            this.repaintCell(this.rollover);
        }
    }

    protected Dimension getPreferredCellSize(MatrixLocation matrixLocation, Object object) {
        int n = this.getState(matrixLocation.row, matrixLocation.column);
        ColumnView columnView = this.getColumnView(matrixLocation.column);
        ItemPainter itemPainter = this.getPainter(matrixLocation.row, matrixLocation.column, object, n);
        Dimension dimension = new Dimension(0, 0);
        if (itemPainter != null) {
            dimension = itemPainter.getPreferredSize(object, this.getSiteGraphics(), n, columnView);
        }
        return dimension;
    }

    protected void processMouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = mouseEvent.isShiftDown();
        boolean bl2 = mouseEvent.isControlDown();
        boolean bl3 = mouseEvent.isMetaDown();
        MatrixLocation matrixLocation = this.hitTest(n, n2);
        if (matrixLocation != null && matrixLocation.equals(this.mouseDown)) {
            this.editClickPoint = new Point(n, n2);
            if (!bl3 && (this.doStartEdit || this.isToggleItem(matrixLocation.row, matrixLocation.column))) {
                this.startEdit(matrixLocation);
                this.doStartEdit = false;
            }
            this.editClickPoint = null;
        }
        if (this.resizingGrid && !this.liveResize) {
            this.stopResize(this.resizeColumn, this.resize, n, n2);
            this.resize = null;
        }
        this.rangeSelecting = false;
        this.resizingGrid = false;
        this.mouseDown = null;
    }

    protected void processMouseDragged(MouseEvent mouseEvent) {
        this.rollover = null;
        if (this.dragSubfocus && !mouseEvent.isMetaDown() && this.rangeSelecting) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.isControlDown() ? 64 : 16;
            MatrixLocation matrixLocation = this.hitTest(n, n2);
            if (matrixLocation != null) {
                this.setSubfocus(matrixLocation.row, matrixLocation.column, n3);
            }
        }
    }

    protected void processMousePressed(MouseEvent mouseEvent) {
        super.processMousePressed(mouseEvent);
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = mouseEvent.isShiftDown();
        boolean bl2 = mouseEvent.isControlDown();
        boolean bl3 = mouseEvent.isMetaDown();
        this.rollover = null;
        int n3 = bl && bl2 ? 16 : (bl ? 17 : (bl2 ? 72 : 67));
        MatrixLocation matrixLocation = this.hitTest(n, n2);
        MatrixLocation matrixLocation2 = this.mouseDown = matrixLocation != null ? new MatrixLocation(matrixLocation) : null;
        if (this.editor != null) {
            if (this.editorLocation.equals(matrixLocation)) {
                return;
            }
            this.safeEndEdit();
        }
        this.resize = null;
        if (matrixLocation != null) {
            if (matrixLocation.equals(this.subfocus)) {
                if (!bl3 && mouseEvent.getClickCount() == 2) {
                    this.fireActionEvent();
                }
                if (!(bl3 || bl2 || bl || this.isToggleItem(matrixLocation.row, matrixLocation.column) || !this.canSet(matrixLocation.row, matrixLocation.column, false))) {
                    this.doStartEdit = true;
                    return;
                }
                if (bl2 && !bl) {
                    if (this.selection.contains(matrixLocation)) {
                        this.selection.remove(matrixLocation);
                    } else {
                        this.selection.add(new MatrixLocation(matrixLocation));
                    }
                }
            }
            this.rangeSelecting = true;
            this.setSubfocus(matrixLocation.row, matrixLocation.column, n3);
        }
        if (this.resizingGrid && !this.liveResize) {
            this.resize1 = this.resize;
            this.startResize(this.resizeColumn, this.resize1, n, n2);
        }
    }

    protected void processSubfocusEvent(MatrixSubfocusEvent matrixSubfocusEvent) {
        if (this.subfocusMulticaster.hasListeners()) {
            this.subfocusMulticaster.dispatch((DispatchableEvent)matrixSubfocusEvent);
        }
    }

    protected boolean preprocessSubfocusEvent(MatrixSubfocusEvent matrixSubfocusEvent) {
        return this.subfocusMulticaster.hasListeners() ? this.subfocusMulticaster.vetoableDispatch((VetoableDispatch)matrixSubfocusEvent) : true;
    }

    private void pageJump(boolean bl, int n) {
        int n2 = 10;
        if (this.rowSizes instanceof FixedSizeVector) {
            int n3;
            int n4 = this.getRowCount();
            if (n4 == 0) {
                ++n4;
            }
            if ((n3 = this.getPreferredSize().height / n4) == 0) {
                ++n3;
            }
            n2 = this.scroller.getViewport().getExtentSize().height / n3 - 1;
        }
        n2 = bl ? n2 : -n2;
        this.moveFocus(n2, 0, n);
    }

    protected void processKeyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (this.editor != null || !this.autoEdit || keyEvent.isConsumed() || this.isReadOnly() || c == '\u0000' || c == '\t' || c == '\r' || c == '\n' || c == ' ' || c == '\u001b' || this.isToggleItem(this.subfocus.row, this.subfocus.column) || keyEvent.isAltDown() ^ keyEvent.isControlDown() || !this.writeModel.canSet(this.subfocus.row, this.getColumnOrdinal(this.subfocus.column), false)) {
            return;
        }
        this.startEdit(this.subfocus);
        Component component = null;
        if (this.editor != null && (component = this.editor.getComponent()) != null) {
            component.dispatchEvent(keyEvent);
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 9 && this.navigateOnTab && !keyEvent.isControlDown() && !keyEvent.isAltDown() && this.editor == null) {
            this.doTabKey(keyEvent);
            return;
        }
        super.processKeyEvent(keyEvent);
    }

    protected void doTabKey(KeyEvent keyEvent) {
        if (!keyEvent.isShiftDown()) {
            if (this.subfocus.column < this.getColumnCount() - 1) {
                this.moveFocus(0, 1, 67);
                keyEvent.consume();
            } else if (this.subfocus.row < this.getRowCount() - 1) {
                this.moveFocus(1, -this.subfocus.column, 67);
                keyEvent.consume();
            } else if (this.subfocus.row == this.getRowCount() - 1 && this.subfocus.column == this.getColumnCount() - 1) {
                this.setSubfocus(0, 0, 67);
                keyEvent.consume();
            }
        } else if (this.subfocus.column > 0) {
            this.moveFocus(0, -1, 67);
            keyEvent.consume();
        } else if (this.subfocus.row > 0) {
            this.moveFocus(-1, this.getColumnCount() - 1, 67);
            keyEvent.consume();
        } else if (this.subfocus.row == 0 && this.subfocus.column == 0) {
            this.setSubfocus(this.getRowCount() - 1, this.getColumnCount() - 1, 67);
            keyEvent.consume();
        }
    }

    protected void processKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = keyEvent.isControlDown();
        boolean bl2 = keyEvent.isShiftDown();
        boolean bl3 = keyEvent.isAltDown();
        int n2 = bl2 && bl ? 16 : (bl2 ? 16 : (bl ? 64 : 67));
        switch (n) {
            case 40: {
                if ((this.autoAppend || bl) && this.subfocus.row == this.getRowCount() - 1 && !this.isReadOnly() && this.writeModel.isVariableRows()) {
                    this.writeModel.addRow();
                    this.setSubfocus(this.getRowCount() - 1, this.subfocus.column, n2);
                    keyEvent.consume();
                    break;
                }
                if (this.subfocus.row >= this.getRowCount() - 1 || bl3) break;
                this.moveFocus(1, 0, n2);
                keyEvent.consume();
                break;
            }
            case 39: {
                if (bl && this.subfocus.column == this.getColumnCount() - 1 && !this.isReadOnly() && this.writeModel.isVariableColumns()) {
                    this.writeModel.addColumn();
                    this.setSubfocus(this.subfocus.row, this.getColumnCount() - 1, n2);
                    keyEvent.consume();
                    break;
                }
                if (this.subfocus.column >= this.getColumnCount() - 1 || bl3) break;
                this.moveFocus(0, 1, n2);
                keyEvent.consume();
                break;
            }
            case 38: {
                if (this.subfocus.row <= 0 || bl3) break;
                this.moveFocus(-1, 0, n2);
                keyEvent.consume();
                break;
            }
            case 37: {
                if (this.subfocus.column <= 0 || bl3) break;
                this.moveFocus(0, -1, n2);
                keyEvent.consume();
                break;
            }
            case 33: {
                if (this.subfocus.row <= 0 || bl3) break;
                this.pageJump(false, n2);
                keyEvent.consume();
                break;
            }
            case 34: {
                if (this.subfocus.row >= this.getRowCount() - 1 || bl3) break;
                this.pageJump(true, n2);
                keyEvent.consume();
                break;
            }
            case 32: {
                if (bl3 || bl2) break;
                if (bl && this.selection.contains(this.subfocus)) {
                    this.selection.remove(this.subfocus);
                } else {
                    this.selection.add(this.subfocus);
                }
                keyEvent.consume();
                if (!this.isToggleItem(this.subfocus.row, this.subfocus.column)) break;
                this.startEdit(this.subfocus);
                break;
            }
            case 36: {
                if (bl3) break;
                if (bl && bl2) {
                    if (this.subfocus.row == 0 && this.subfocus.column == 0) break;
                    this.setSubfocus(0, 0, 16);
                    keyEvent.consume();
                    break;
                }
                if (bl) {
                    if (this.subfocus.row == 0 && this.subfocus.column == 0) break;
                    this.setSubfocus(0, 0, 67);
                    keyEvent.consume();
                    break;
                }
                if (this.subfocus.column == 0) break;
                this.moveFocus(0, -this.subfocus.column, n2);
                keyEvent.consume();
                break;
            }
            case 35: {
                if (bl3) break;
                if (bl && bl2) {
                    if (this.subfocus.row == this.getRowCount() - 1 && this.subfocus.column == this.getColumnCount() - 1) break;
                    this.setSubfocus(this.getRowCount() - 1, this.getColumnCount() - 1, 16);
                    keyEvent.consume();
                    break;
                }
                if (bl) {
                    if (this.subfocus.row == this.getRowCount() - 1 && this.subfocus.column == this.getColumnCount() - 1) break;
                    this.setSubfocus(this.getRowCount() - 1, this.getColumnCount() - 1, 67);
                    keyEvent.consume();
                    break;
                }
                if (this.subfocus.column == this.getColumnCount() - 1) break;
                this.setSubfocus(this.subfocus.row, this.getColumnCount() - 1, n2);
                keyEvent.consume();
                break;
            }
            case 155: {
                if (bl2 && bl) {
                    if (this.isReadOnly() || !this.writeModel.isVariableColumns()) break;
                    this.writeModel.addColumn(this.getColumnOrdinal(this.subfocus.column));
                    keyEvent.consume();
                    break;
                }
                if (this.isReadOnly() || !this.writeModel.isVariableRows()) break;
                this.writeModel.addRow(this.subfocus.row);
                keyEvent.consume();
                break;
            }
            case 127: {
                if (bl2 && bl) {
                    if (this.isReadOnly() || !this.writeModel.isVariableColumns() || this.writeModel.getColumnCount() <= 0) break;
                    this.writeModel.removeColumn(this.getColumnOrdinal(this.subfocus.column));
                    keyEvent.consume();
                    if (this.subfocus.column != this.getColumnCount()) break;
                    this.moveFocus(0, -1, 67);
                    break;
                }
                if (!bl || this.isReadOnly() || !this.writeModel.isVariableRows() || this.writeModel.getRowCount() <= 0) break;
                this.writeModel.removeRow(this.subfocus.row);
                keyEvent.consume();
                if (this.subfocus.row != this.getRowCount()) break;
                this.moveFocus(-1, 0, 67);
                break;
            }
            case 10: {
                if (bl && !bl2 && !bl3 && this.editor == null && this.canSet(this.subfocus.row, this.subfocus.column, false)) {
                    this.startEdit(this.subfocus);
                    keyEvent.consume();
                    break;
                }
                if (this.navigateOnEnter && this.subfocus.column < this.getColumnCount() - 1) {
                    this.moveFocus(0, 1, 67);
                    keyEvent.consume();
                    break;
                }
                if (!this.navigateOnEnter || this.subfocus.row >= this.getRowCount() - 1) break;
                this.moveFocus(1, -this.subfocus.column, 67);
                keyEvent.consume();
                break;
            }
            case 113: {
                if (this.editor != null || this.isToggleItem(this.subfocus.row, this.subfocus.column) || !this.canSet(this.subfocus.row, this.subfocus.column, false)) break;
                this.startEdit(this.subfocus);
                keyEvent.consume();
                break;
            }
            case 68: {
                if (!bl || this.editor != null || this.subfocus.row <= 0 || !this.canSet(this.subfocus.row, this.subfocus.column, true)) break;
                this.writeModel.set(this.subfocus.row, this.getColumnOrdinal(this.subfocus.column), this.model.get(this.subfocus.row - 1, this.getColumnOrdinal(this.subfocus.column)));
                keyEvent.consume();
                break;
            }
            case 74: {
                if (!bl2 || !bl || !bl3) break;
                this.debugPaint = !this.debugPaint;
                break;
            }
            case 25: 
            case 229: {
                if (this.editor != null || !this.canSet(this.subfocus.row, this.subfocus.column, false)) break;
                this.startEdit(this.subfocus);
                keyEvent.consume();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl = keyEvent.isAltDown();
        boolean bl2 = keyEvent.isControlDown();
        boolean bl3 = keyEvent.isShiftDown();
        if (this.editor == null || keyEvent.isConsumed()) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if (bl2 || bl || bl3) break;
                this.safeEndEdit(true);
                if (this.lockSubfocus) break;
                keyEvent.consume();
                this.fireActionEvent();
                this.processKeyPressed(keyEvent);
                break;
            }
            case 27: {
                this.safeEndEdit(false);
                keyEvent.consume();
                break;
            }
            case 33: 
            case 34: 
            case 38: 
            case 40: {
                if (bl) break;
                this.safeEndEdit();
                this.processKeyPressed(keyEvent);
                break;
            }
            case 37: 
            case 39: {
                if (!bl2 || bl || bl3) break;
                this.safeEndEdit();
                this.processKeyPressed(keyEvent);
                break;
            }
            case 9: {
                if (bl) break;
                this.safeEndEdit();
                this.doTabKey(keyEvent);
            }
        }
    }

    protected void moveFocus(int n, int n2, int n3) {
        int n4 = this.getRowCount() - 1;
        int n5 = this.getColumnCount() - 1;
        int n6 = this.subfocus.row + n < n4 ? this.subfocus.row + n : n4;
        int n7 = this.subfocus.column + n2 < n5 ? this.subfocus.column + n2 : n5;
        int n8 = 0 > n6 ? 0 : n6;
        int n9 = 0 > n7 ? 0 : n7;
        this.setSubfocus(n8, n9, n3);
    }

    protected void setSubfocus(int n, int n2, int n3) {
        if (this.getRowCount() < 1 || this.getColumnCount() < 1) {
            return;
        }
        if (n < 0 || n2 < 0 || n > this.getRowCount() || n2 > this.getColumnCount()) {
            if (this.batchMode) {
                return;
            }
            throw new IllegalArgumentException(Res.getString(8));
        }
        if (this.editor != null) {
            if (this.lockSubfocus) {
                return;
            }
            this.safeEndEdit();
            if (this.lockSubfocus) {
                return;
            }
        }
        if (n > this.getRowCount() - 1 || n < 0 || n2 > this.getColumnCount() - 1 || n2 < 0 || this.subfocus != null && this.subfocus.row == n && this.subfocus.column == n2) {
            if (n == this.getRowCount()) {
                if (!this.isReadOnly() && this.writeModel.isVariableRows()) {
                    this.writeModel.addRow();
                }
            } else if (n2 == this.getColumnCount()) {
                if (!this.isReadOnly() && this.writeModel.isVariableColumns()) {
                    this.writeModel.addColumn();
                }
            } else {
                return;
            }
        }
        if (!this.preprocessSubfocusEvent(new MatrixSubfocusEvent(this, 1, new MatrixLocation(n, n2)))) {
            return;
        }
        if (this.subfocus == null) {
            this.subfocus = new MatrixLocation(n, n2);
            this.selectAnchor = new MatrixLocation(n, n2);
            if ((n3 & 2) != 0) {
                this.selection.add(this.subfocus);
            }
            this.scrollView();
            this.processSubfocusEvent(new MatrixSubfocusEvent(this, 2, new MatrixLocation(this.subfocus)));
            return;
        }
        if (n != this.subfocus.row || n2 != this.subfocus.column) {
            if (this.selectAnchor == null) {
                this.selectAnchor = new MatrixLocation(n, n2);
            }
            MatrixLocation matrixLocation = new MatrixLocation(this.subfocus);
            this.subfocus = new MatrixLocation(n, n2);
            if ((n3 & 1) != 0) {
                this.selection.removeAll();
            }
            if ((n3 & 2) != 0) {
                this.selection.add(new MatrixLocation(this.subfocus));
            }
            if ((n3 & 8) != 0) {
                if (this.selection.contains(this.subfocus)) {
                    this.selection.remove(this.subfocus);
                } else {
                    this.selection.add(new MatrixLocation(this.subfocus));
                }
            }
            if ((n3 & 0x10) != 0) {
                this.dumpingRange = true;
                this.selection.removeRange(this.selectAnchor, matrixLocation);
                this.selection.addRange(this.selectAnchor, this.subfocus);
            }
            if ((n3 & 0x40) != 0) {
                this.selectAnchor = new MatrixLocation(this.subfocus);
            }
            this.repaintCell(matrixLocation);
            this.scrollView();
            this.repaintCell(this.subfocus);
            this.processSubfocusEvent(new MatrixSubfocusEvent(this, 2, new MatrixLocation(this.subfocus)));
        }
    }

    public void setSubfocus(int n, int n2) {
        this.setSubfocus(n, n2, 67);
    }

    public void setSubfocus(MatrixLocation matrixLocation) {
        this.setSubfocus(matrixLocation.row, matrixLocation.column);
    }

    public MatrixLocation getSubfocus() {
        return this.subfocus;
    }

    public int getColumnCount() {
        return this.model == null ? 0 : this.model.getColumnCount();
    }

    public int getRowCount() {
        return this.model == null ? 0 : this.model.getRowCount();
    }

    private boolean canSet(int n, int n2, boolean bl) {
        return this.isReadOnly() ? false : this.writeModel.canSet(n, this.getColumnOrdinal(n2), bl);
    }

    public Rectangle getCellRect(MatrixLocation matrixLocation) {
        int n;
        Rectangle rectangle = new Rectangle();
        for (n = 0; n < matrixLocation.column; ++n) {
            rectangle.x += this.columnSizes.getSize(n);
        }
        for (n = 0; n < matrixLocation.row; ++n) {
            rectangle.y += this.rowSizes.getSize(n);
        }
        rectangle.width = this.columnSizes.getSize(matrixLocation.column);
        rectangle.height = this.rowSizes.getSize(matrixLocation.row);
        return rectangle;
    }

    public Rectangle getCellRect(int n, int n2) {
        return this.getCellRect(new MatrixLocation(n, n2));
    }

    public MatrixLocation hitTest(int n, int n2) {
        int n3;
        int n4;
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0) {
            return null;
        }
        int n5 = 0;
        if (this.columnSizes instanceof FixedSizeVector) {
            n5 = n / n4;
            if (n5 >= this.getColumnCount()) {
                n5 = this.getColumnCount() - 1;
            }
            n4 *= n5 + 1;
        } else {
            for (n4 = this.columnSizes.getSize(0); n >= n4 && ++n5 < this.getColumnCount(); n4 += this.columnSizes.getSize(n5)) {
            }
        }
        int n6 = 0;
        if (this.rowSizes instanceof FixedSizeVector) {
            n6 = n2 / n3;
            if (n6 >= this.getRowCount()) {
                n6 = this.getRowCount() - 1;
            }
            n3 *= n6 + 1;
        } else {
            for (n3 = this.rowSizes.getSize(0); n2 >= n3 && ++n6 < this.getRowCount(); n3 += this.rowSizes.getSize(n6)) {
            }
        }
        MatrixLocation matrixLocation = null;
        if (n >= 0 && n < n4 && n2 >= 0 && n2 < n3) {
            matrixLocation = new MatrixLocation(n6, n5);
        }
        return matrixLocation;
    }

    public MatrixLocation hitTest(Point point) {
        return this.hitTest(point.x, point.y);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(10, 10);
        if (this.columnSizes != null) {
            dimension.width = this.columnSizes.getSize(0);
        }
        if (this.rowSizes != null) {
            dimension.height = this.rowSizes.getSize(0);
        }
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(10, 10);
        if (this.columnSizes != null) {
            dimension.width = this.columnSizes.getSizeUpTo(this.getColumnCount());
        }
        if (this.rowSizes != null) {
            dimension.height = this.rowSizes.getSizeUpTo(this.getRowCount());
        }
        return dimension;
    }

    public void paintComponent(Graphics graphics) {
        if (this.batchMode) {
            return;
        }
        super.paintComponent(graphics);
        graphics.clipRect(0, 0, this.getSize().width, this.getSize().height);
        Rectangle rectangle = this.scroller.getViewport().getViewRect();
        Rectangle rectangle2 = graphics.getClipBounds();
        if (rectangle2 == null) {
            return;
        }
        Rectangle rectangle3 = rectangle2.width > rectangle.width || rectangle2.height > rectangle.height ? rectangle2.intersection(rectangle) : rectangle2;
        if (rectangle3.width <= 0 || rectangle3.height <= 0 || rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        int n = rectangle3.x;
        int n2 = rectangle3.y;
        MatrixLocation matrixLocation = this.hitTest(rectangle3.x, rectangle3.y);
        if (matrixLocation != null) {
            int n3;
            graphics.setFont(this.getFont());
            MatrixLocation matrixLocation2 = this.hitTest(rectangle3.x + rectangle3.width - 1, rectangle3.y);
            int n4 = matrixLocation2 != null ? matrixLocation2.column : this.getColumnCount() - 1;
            MatrixLocation matrixLocation3 = this.hitTest(rectangle3.x, rectangle3.y + rectangle3.height - 1);
            int n5 = matrixLocation3 != null ? matrixLocation3.row : this.getRowCount() - 1;
            Rectangle rectangle4 = this.getCellRect(matrixLocation);
            int n6 = rectangle4.x;
            for (int i = matrixLocation.row; i <= n5; ++i) {
                rectangle4.x = n6;
                rectangle4.height = this.rowSizes.getSize(i);
                if (rectangle4.height <= 0) continue;
                for (n3 = matrixLocation.column; n3 <= n4; ++n3) {
                    ColumnView columnView;
                    rectangle4.width = this.columnSizes.getSize(n3);
                    if (rectangle4.width <= 0) continue;
                    Object object = this.model.get(i, this.getColumnOrdinal(n3));
                    if (object instanceof Variant) {
                        object = ((Variant)object).clone();
                    }
                    int n7 = this.getState(i, n3);
                    ItemPainter itemPainter = this.getPainter(i, n3, object, n7);
                    ColumnView columnView2 = columnView = this.columnViews != null && this.columnViews.length > n3 ? this.columnViews[n3] : null;
                    if (this.texture != null) {
                        ImageTexture.texture(this.texture, graphics, rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    }
                    if (itemPainter != null) {
                        graphics.setColor(this.getBackground());
                        if (this.visibleGrid) {
                            Rectangle rectangle5 = new Rectangle(rectangle4);
                            if (this.vGridLines) {
                                --rectangle5.width;
                            }
                            if (this.hGridLines) {
                                --rectangle5.height;
                            }
                            graphics.clipRect(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height);
                            itemPainter.paint(object, graphics, rectangle5, n7, columnView);
                        } else {
                            graphics.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                            itemPainter.paint(object, graphics, rectangle4, n7, columnView);
                        }
                        graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    }
                    rectangle4.x += rectangle4.width;
                }
                rectangle4.y += rectangle4.height;
            }
            n = rectangle4.x;
            n2 = rectangle4.y;
            if (n < rectangle3.x + rectangle3.width) {
                if (this.texture != null) {
                    ImageTexture.texture(this.texture, graphics, n, rectangle3.y, rectangle3.x + rectangle3.width - n, rectangle3.height);
                } else if (this.isOpaque()) {
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(n, rectangle3.y, rectangle3.x + rectangle3.width - n, rectangle3.height);
                }
            }
            if (n2 < rectangle3.y + rectangle3.height) {
                if (this.texture != null) {
                    ImageTexture.texture(this.texture, graphics, rectangle3.x, n2, rectangle3.width, rectangle3.y + rectangle3.height - n2);
                } else if (this.isOpaque()) {
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(rectangle3.x, n2, rectangle3.width, rectangle3.y + rectangle3.height - n2);
                }
            }
            if (this.visibleGrid) {
                graphics.setColor(this.isEnabled() ? this.lineColor : this.lineColor.brighter());
                rectangle4 = this.getCellRect(matrixLocation);
                --rectangle4.x;
                --rectangle4.y;
                --n;
                --n2;
                Dimension dimension = new Dimension(rectangle4.x, rectangle4.y);
                if (this.vGridLines) {
                    graphics.drawLine(dimension.width, dimension.height, dimension.width, n2);
                    for (n3 = matrixLocation.column; n3 <= n4; ++n3) {
                        dimension.width += this.columnSizes.getSize(n3);
                        graphics.drawLine(dimension.width, dimension.height, dimension.width, n2);
                    }
                }
                if (this.hGridLines) {
                    dimension.width = rectangle4.x;
                    dimension.height = rectangle4.y;
                    graphics.drawLine(dimension.width, dimension.height, n, dimension.height);
                    for (n3 = matrixLocation.row; n3 <= n5; ++n3) {
                        dimension.height += this.rowSizes.getSize(n3);
                        graphics.drawLine(dimension.width, dimension.height, n, dimension.height);
                    }
                }
            }
        } else if (this.texture != null) {
            ImageTexture.texture(this.texture, graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        } else if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
        if (this.debugPaint) {
            GridCore.debugRect(graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void repaintCells(MatrixLocation matrixLocation, MatrixLocation matrixLocation2) {
        if (this.batchMode) {
            return;
        }
        Rectangle rectangle = this.getCellRangeRect(matrixLocation, matrixLocation2);
        if (rectangle != null) {
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void repaintCells() {
        if (this.batchMode) {
            return;
        }
        this.repaint(100L);
    }

    public void repaintCell(MatrixLocation matrixLocation) {
        Rectangle rectangle;
        if (this.batchMode || matrixLocation == null) {
            return;
        }
        if (matrixLocation.row < this.getRowCount() && matrixLocation.column < this.getColumnCount() && (rectangle = this.getCellRect(matrixLocation)) != null) {
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void repaintSelection() {
        for (int i = 0; i < this.oldSelected.length; ++i) {
            this.repaintCell(this.oldSelected[i]);
        }
    }

    private ItemEditor getEditor(int n, int n2, Object object, int n3) {
        ItemEditor itemEditor = this.columnViews != null && n2 < this.columnViews.length ? this.columnViews[n2].getItemEditor() : null;
        n2 = this.getColumnOrdinal(n2);
        if (itemEditor == null) {
            itemEditor = this.viewManager.getEditor(n, n2, object, n3);
        }
        if (itemEditor != null && this.customizeListeners != null) {
            this.customEditor.setEditor(itemEditor);
            this.fireCustomizeItemEvent(new MatrixLocation(n, n2), object, n3, this.customEditor);
            return this.customEditor;
        }
        return itemEditor;
    }

    private ItemPainter getPainter(int n, int n2, Object object, int n3) {
        ItemPainter itemPainter = this.columnViews != null && n2 < this.columnViews.length ? (this.columnViews[n2] != null ? this.columnViews[n2].getItemPainter() : null) : null;
        n2 = this.getColumnOrdinal(n2);
        if (itemPainter == null) {
            itemPainter = this.viewManager.getPainter(n, n2, object, n3);
        }
        if (itemPainter != null && this.customizeListeners != null) {
            this.customPainter.setPainter(itemPainter);
            this.fireCustomizeItemEvent(new MatrixLocation(n, n2), object, n3, this.customPainter);
            return this.customPainter;
        }
        return itemPainter;
    }

    public int getColumnOrdinal(int n) {
        int n2;
        if (this.columnViews != null && this.columnViews.length > n && (n2 = this.columnViews[n].getOrdinal()) >= 0) {
            return n2;
        }
        return n;
    }

    private int getState(int n, int n2) {
        int n3 = 0;
        if (this.selection.contains(n, n2)) {
            n3 |= 4;
        }
        if (!this.isEnabled()) {
            n3 |= 0x21;
        } else {
            if (this.showFocus && this.hasFocus && this.subfocus.row == n && this.subfocus.column == n2) {
                n3 |= 2;
            }
            if ((this.focusState & 0x20) != 0) {
                n3 |= 0x20;
            }
            if (this.showRollover && this.rollover != null && this.rollover.row == n && this.rollover.column == n2) {
                n3 |= 0x40;
            }
        }
        if (!this.hasFocus) {
            n3 |= 0x80;
        }
        return n3;
    }

    private void scrollView() {
        Rectangle rectangle = this.getCellRect(this.subfocus);
        Rectangle rectangle2 = this.scroller.getViewport().getViewRect();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        if (rectangle != null) {
            Serializable serializable;
            boolean bl = false;
            boolean bl2 = false;
            if (rectangle.width > rectangle2.width || rectangle.x < rectangle2.x) {
                n = rectangle.x;
            } else if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
                n = this.getSize().width - rectangle2.width < rectangle.x + rectangle.width - rectangle2.width ? this.getSize().width - rectangle2.width : rectangle.x + rectangle.width - rectangle2.width;
                bl = true;
            }
            if (rectangle.y < rectangle2.y) {
                n2 = rectangle.y;
            } else if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
                n2 = this.getSize().height - rectangle2.height < rectangle.y + rectangle.height - rectangle2.height ? this.getSize().height - rectangle2.height : rectangle.y + rectangle.height - rectangle2.height;
                bl2 = true;
            }
            if (this.snapOrigin && (serializable = this.hitTest(n, n2)) != null) {
                if (bl && bl2) {
                    ++((MatrixLocation)serializable).row;
                    ++((MatrixLocation)serializable).column;
                    Rectangle rectangle3 = this.getCellRect((MatrixLocation)serializable);
                    n = rectangle3.x;
                    n2 = rectangle3.y;
                } else if (bl) {
                    ++((MatrixLocation)serializable).column;
                    Rectangle rectangle4 = this.getCellRect((MatrixLocation)serializable);
                    n = rectangle4.x;
                } else if (bl2) {
                    ++((MatrixLocation)serializable).row;
                    Rectangle rectangle5 = this.getCellRect((MatrixLocation)serializable);
                    n2 = rectangle5.y;
                }
            }
            if (rectangle2.x != n || rectangle2.y != n2) {
                serializable = this.scroller.getViewport();
                ((JViewport)serializable).setViewPosition(new Point(n, n2));
                this.repaint();
            }
            this.scroller.getHorizontalScrollBar().setUnitIncrement(rectangle.width);
            this.scroller.getVerticalScrollBar().setUnitIncrement(rectangle.height);
        }
    }

    public void setColumnSizes(SizeVector sizeVector) {
        this.columnSizes = sizeVector;
        this.invalidate();
        this.repaintCells();
    }

    public SizeVector getColumnSizes() {
        return this.columnSizes;
    }

    public void setRowSizes(SizeVector sizeVector) {
        this.rowSizes = sizeVector;
        this.invalidate();
        this.repaintCells();
    }

    public SizeVector getRowSizes() {
        return this.rowSizes;
    }

    public Component getSiteComponent() {
        return this;
    }

    public Graphics getSiteGraphics() {
        return this.getGraphics();
    }

    public boolean isTransparent() {
        return this.texture != null ? true : !this.isOpaque();
    }

    public Point getEditClickPoint() {
        return this.editClickPoint;
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(boolean bl) {
        if (this.batchMode != bl) {
            this.batchMode = bl;
            if (!this.batchMode) {
                this.repaintCells();
                if (this.isShowing()) {
                    this.scroller.validate();
                }
            }
        }
    }

    public boolean isEditInPlace() {
        return this.editInPlace;
    }

    public void setEditInPlace(boolean bl) {
        this.editInPlace = bl;
    }

    public boolean isDataToolTip() {
        return this.toolTip.active;
    }

    public void setDataToolTip(boolean bl) {
        this.toolTip.active = bl;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (this.toolTip.active) {
            toolTipManager.registerComponent(this);
        } else if (this.getToolTipText() == null) {
            toolTipManager.unregisterComponent(this);
        }
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setShowRollover(boolean bl) {
        this.showRollover = bl;
    }

    public boolean isSnapOrigin() {
        return this.snapOrigin;
    }

    public void setSnapOrigin(boolean bl) {
        this.snapOrigin = bl;
    }

    public boolean isDragSubfocus() {
        return this.dragSubfocus;
    }

    public void setDragSubfocus(boolean bl) {
        this.dragSubfocus = bl;
    }

    public boolean isNavigateOnTab() {
        return this.navigateOnTab;
    }

    public void setNavigateOnTab(boolean bl) {
        this.navigateOnTab = bl;
    }

    public boolean isNavigateOnEnter() {
        return this.navigateOnEnter;
    }

    public void setNavigateOnEnter(boolean bl) {
        this.navigateOnEnter = bl;
    }

    public boolean isAutoAppend() {
        return this.autoAppend;
    }

    public void setAutoAppend(boolean bl) {
        this.autoAppend = bl;
    }

    public boolean isGrowEditor() {
        return this.growEditor;
    }

    public void setGrowEditor(boolean bl) {
        this.growEditor = bl;
    }

    public boolean isAutoEdit() {
        return this.autoEdit;
    }

    public void setAutoEdit(boolean bl) {
        this.autoEdit = bl;
    }

    public ItemEditor getEditor() {
        return this.editor;
    }

    public boolean isEditing() {
        return this.editor != null;
    }

    public void setPostOnEndEdit(boolean bl) {
        this.postOnEndEdit = bl;
    }

    public boolean isPostOnEndEdit() {
        return this.postOnEndEdit;
    }

    public void setDefaultColumnWidth(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.defaultColWidth = n;
    }

    public int getDefaultColumnWidth() {
        return this.defaultColWidth;
    }

    public void setShowFocus(boolean bl) {
        if (this.showFocus != bl) {
            this.showFocus = bl;
            this.repaintCell(this.getSubfocus());
        }
    }

    public boolean isShowFocus() {
        return this.showFocus;
    }

    public void setGridLineColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.lineColor = color;
        this.repaintCells();
    }

    public Color getGridLineColor() {
        return this.lineColor;
    }

    public void setVerticalLines(boolean bl) {
        if (this.vGridLines != bl) {
            this.vGridLines = bl;
            this.repaintCells();
        }
    }

    public boolean isVerticalLines() {
        return this.vGridLines;
    }

    public void setHorizontalLines(boolean bl) {
        if (this.hGridLines != bl) {
            this.hGridLines = bl;
            this.repaintCells();
        }
    }

    public boolean isHorizontalLines() {
        return this.hGridLines;
    }

    public void setGridVisible(boolean bl) {
        if (this.visibleGrid != bl) {
            this.visibleGrid = bl;
            this.repaintCells();
        }
    }

    public boolean isGridVisible() {
        return this.visibleGrid;
    }

    int getVisibleCount(boolean bl) {
        MatrixLocation matrixLocation;
        MatrixLocation matrixLocation2 = this.hitTest(1, 1);
        if (matrixLocation2 == null) {
            matrixLocation2 = new MatrixLocation();
        }
        if ((matrixLocation = this.hitTest(this.getSize().width, this.getSize().height)) == null) {
            matrixLocation = new MatrixLocation(this.getRowCount() - 1, this.getColumnCount() - 1);
        }
        return bl ? matrixLocation.row - matrixLocation2.row + 1 : matrixLocation.column - matrixLocation2.column + 1;
    }

    public int getVisibleColumns() {
        return this.getVisibleCount(false);
    }

    public int getVisibleRows() {
        return this.getVisibleCount(true);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        switch (focusEvent.getID()) {
            case 1004: {
                if (this.editor != null && this.editor.getComponent() != null) {
                    this.editor.getComponent().requestFocus();
                }
                if (this.hasFocus) break;
                this.hasFocus = true;
                this.repaintCell(this.subfocus);
                break;
            }
            case 1005: {
                if (this.editor != null) break;
                this.hasFocus = false;
                this.repaintCell(this.subfocus);
            }
        }
        super.processFocusEvent(focusEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.hasFocus) {
            this.hasFocus = false;
            this.repaintCell(this.subfocus);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void windowActiveChanged(boolean bl) {
        super.windowActiveChanged(bl);
        this.repaintSelection();
    }

    public void selectionChanged(MatrixSelectionEvent matrixSelectionEvent) {
        switch (matrixSelectionEvent.getChange()) {
            case 12289: {
                this.repaintSelection();
                break;
            }
            default: {
                int n;
                MatrixLocation[] matrixLocationArray = matrixSelectionEvent.getSelection().getAll();
                BasicMatrixSelection basicMatrixSelection = new BasicMatrixSelection(this.oldSelected);
                for (n = 0; n < matrixLocationArray.length; ++n) {
                    if (!basicMatrixSelection.contains(matrixLocationArray[n])) {
                        this.repaintCell(matrixLocationArray[n]);
                        continue;
                    }
                    basicMatrixSelection.remove(matrixLocationArray[n]);
                }
                this.oldSelected = basicMatrixSelection.getAll();
                for (n = 0; n < this.oldSelected.length; ++n) {
                    this.repaintCell(this.oldSelected[n]);
                }
            }
        }
        this.oldSelected = matrixSelectionEvent.getSelection().getAll();
    }

    public void selectionRangeChanged(MatrixSelectionEvent matrixSelectionEvent) {
        switch (matrixSelectionEvent.getChange()) {
            case 8193: {
                if (this.dumpingRange) {
                    this.selectionChanged(matrixSelectionEvent);
                    this.dumpingRange = false;
                    break;
                }
                this.repaintCells(matrixSelectionEvent.getRangeStart(), matrixSelectionEvent.getRangeEnd());
                this.oldSelected = matrixSelectionEvent.getSelection().getAll();
                break;
            }
            case 8194: {
                if (this.dumpingRange) break;
                this.repaintCells(matrixSelectionEvent.getRangeStart(), matrixSelectionEvent.getRangeEnd());
                this.oldSelected = matrixSelectionEvent.getSelection().getAll();
            }
        }
    }

    public void selectionItemChanged(MatrixSelectionEvent matrixSelectionEvent) {
        this.repaintCell(matrixSelectionEvent.getLocation());
        this.oldSelected = matrixSelectionEvent.getSelection().getAll();
    }

    protected void dropColumnView(int n) {
        ColumnView[] columnViewArray = new ColumnView[this.columnViews.length - 1];
        if (n == 0) {
            System.arraycopy(this.columnViews, 1, columnViewArray, 0, this.columnViews.length - 1);
        } else if (n == columnViewArray.length) {
            System.arraycopy(this.columnViews, 0, columnViewArray, 0, columnViewArray.length);
        } else {
            System.arraycopy(this.columnViews, 0, columnViewArray, 0, n);
            System.arraycopy(this.columnViews, n + 1, columnViewArray, n, columnViewArray.length - n);
        }
        for (int i = n; i < columnViewArray.length; ++i) {
            int n2 = columnViewArray[i].getWidth();
            this.columnSizes.setSize(i, n2 > 4 ? n2 : 4);
            columnViewArray[i].setWidth(this.columnSizes.getSize(i));
        }
        this.columnViews = columnViewArray;
        this.registerColumnViews();
    }

    protected void defaultColumnView(int n, ColumnView columnView) {
        String string = Res.format(5, new String[]{String.valueOf(n)});
        columnView.setName(string);
        columnView.setAlignment(33);
        columnView.setItemMargins(new Insets(0, 2, 0, 2));
        columnView.setWidth(this.defaultColWidth);
    }

    protected void addColumnView(int n) {
        ColumnView[] columnViewArray = new ColumnView[this.columnViews.length + 1];
        if (n == 0) {
            System.arraycopy(this.columnViews, 0, columnViewArray, 1, this.columnViews.length);
        } else if (n >= this.columnViews.length) {
            System.arraycopy(this.columnViews, 0, columnViewArray, 0, this.columnViews.length);
        } else {
            System.arraycopy(this.columnViews, 0, columnViewArray, 0, n);
            System.arraycopy(this.columnViews, n, columnViewArray, n + 1, this.columnViews.length - n);
        }
        columnViewArray[n] = new ColumnView();
        this.defaultColumnView(n, columnViewArray[n]);
        for (int i = 0; i < columnViewArray.length; ++i) {
            int n2 = columnViewArray[i].getWidth();
            this.columnSizes.setSize(i, n2 > 4 ? n2 : 4);
            columnViewArray[i].setWidth(this.columnSizes.getSize(i));
        }
        this.columnViews = columnViewArray;
        this.registerColumnViews();
    }

    public void modelStructureChanged(MatrixModelEvent matrixModelEvent) {
        MatrixLocation matrixLocation = matrixModelEvent.getLocation();
        switch (matrixModelEvent.getChange()) {
            case 2: {
                if (this.editor != null) {
                    this.safeEndEdit(false);
                }
                this.invalidate();
                this.repaintCells();
                if (!this.isShowing() || this.batchMode) break;
                this.scroller.validate();
                this.scrollView();
                break;
            }
            case 18: 
            case 34: {
                int n = matrixModelEvent.getModel().getRowCount();
                if (this.editor != null && this.editorLocation != null && (matrixLocation != null && matrixLocation.row == this.editorLocation.row || this.editorLocation.row >= n)) {
                    this.safeEndEdit(false);
                }
                this.invalidate();
                if (matrixModelEvent.getChange() == 34 && this.subfocus != null && n <= this.subfocus.row && n > 0) {
                    this.setSubfocus(n - 1, this.subfocus.column);
                }
                this.repaintCells();
                if (!this.isShowing() || this.batchMode) break;
                this.scroller.validate();
                this.scrollView();
                break;
            }
            case 50: {
                this.addColumnView(matrixLocation.column);
                this.invalidate();
                this.repaintCells();
                if (!this.isShowing() || this.batchMode) break;
                this.scroller.validate();
                this.scrollView();
                break;
            }
            case 66: {
                int n = matrixModelEvent.getModel().getColumnCount();
                if (this.subfocus != null && n <= this.subfocus.column && n > 0) {
                    this.setSubfocus(this.subfocus.row, n - 1);
                }
                this.dropColumnView(matrixLocation.column);
                this.invalidate();
                this.repaintCells();
                if (!this.isShowing() || this.batchMode) break;
                this.scroller.validate();
                this.scrollView();
            }
        }
    }

    public void modelContentChanged(MatrixModelEvent matrixModelEvent) {
        MatrixLocation matrixLocation = matrixModelEvent.getLocation();
        switch (matrixModelEvent.getChange()) {
            case 1: {
                this.repaintCells();
                break;
            }
            case 17: 
            case 33: {
                if (this.editor != null && this.editorLocation != null && this.editorLocation.equals(matrixLocation)) {
                    this.safeEndEdit(false);
                }
                this.repaintCell(matrixLocation);
                break;
            }
            case 49: {
                if (this.editor != null && this.editorLocation != null && this.editorLocation.row == matrixLocation.row) {
                    this.safeEndEdit(false);
                }
                this.repaintCells(new MatrixLocation(matrixLocation.row, 0), new MatrixLocation(this.getRowCount() - 1, this.getColumnCount() - 1));
                break;
            }
            case 65: {
                if (this.editor != null && this.editorLocation != null && this.editorLocation.column == matrixLocation.column) {
                    this.safeEndEdit(false);
                }
                this.repaintCells(new MatrixLocation(0, matrixLocation.column), new MatrixLocation(this.getRowCount() - 1, this.getColumnCount() - 1));
            }
        }
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.keyMulticaster.remove(keyListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyMulticaster.add(keyListener);
    }

    public void removeSubfocusListener(MatrixSubfocusListener matrixSubfocusListener) {
        this.subfocusMulticaster.remove((EventListener)matrixSubfocusListener);
    }

    public void addSubfocusListener(MatrixSubfocusListener matrixSubfocusListener) {
        this.subfocusMulticaster.add((EventListener)matrixSubfocusListener);
    }

    public void removeSelectionListener(MatrixSelectionListener matrixSelectionListener) {
        this.selectionMulticaster.remove(matrixSelectionListener);
    }

    public void addSelectionListener(MatrixSelectionListener matrixSelectionListener) {
        this.selectionMulticaster.add(matrixSelectionListener);
    }

    public void removeModelListener(MatrixModelListener matrixModelListener) {
        this.modelMulticaster.remove(matrixModelListener);
    }

    public void addModelListener(MatrixModelListener matrixModelListener) {
        this.modelMulticaster.add(matrixModelListener);
    }

    public int getAlignment() {
        if (this.subfocus != null && this.columnViews != null && this.columnViews.length > this.subfocus.column) {
            return this.columnViews[this.subfocus.column].getAlignment();
        }
        return 0;
    }

    public Insets getItemMargins() {
        if (this.subfocus != null && this.columnViews != null && this.columnViews.length > this.subfocus.column) {
            return this.columnViews[this.subfocus.column].getItemMargins();
        }
        return null;
    }

    public void setColumnView(int n, ColumnView columnView) {
        int n2;
        if (this.columnViews.length > n) {
            this.columnViews[n] = columnView;
            this.columnViews[n].setGridCore(this);
            n2 = columnView.getWidth();
            if (n2 == 0) {
                n2 = this.defaultColWidth;
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.columnSizes.setSize(n, n2 > 4 ? n2 : 4);
        columnView.setWidth(this.columnSizes.getSize(n));
    }

    public ColumnView getColumnView(int n) {
        return this.columnViews != null && this.columnViews.length > n ? this.columnViews[n] : null;
    }

    public void setColumnViews(ColumnView[] columnViewArray) {
        this.columnViews = columnViewArray == null ? new ColumnView[0] : columnViewArray;
        this.registerColumnViews();
        this.resetColumnSizes();
    }

    public ColumnView[] getColumnViews() {
        return this.columnViews;
    }

    public void columnViewChanged(ColumnView columnView, int n) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < this.columnViews.length; ++n2) {
            if (columnView != this.columnViews[n2]) continue;
            n3 = n2;
            break;
        }
        if (n3 == -1) {
            return;
        }
        if (n == 2 || n == 3 || n == 4 || n == 5 || n == 8 || n == 9) {
            this.repaintCells(new MatrixLocation(0, n3), new MatrixLocation(this.getRowCount() - 1, n3));
            return;
        }
        if (n == 7) {
            n2 = columnView.getWidth();
            this.columnSizes.setSize(n3, n2 > 4 ? n2 : 4);
            this.invalidate();
            this.processActionEvent(new ActionEvent(this, 1001, columnView.getName(), 7));
            this.scroller.validate();
            this.repaintCells();
        } else if (n == 6) {
            this.processActionEvent(new ActionEvent(this, 1001, columnView.getName(), 6));
        }
    }

    protected void registerColumnViews() {
        if (this.columnViews == null) {
            return;
        }
        for (int i = 0; i < this.columnViews.length; ++i) {
            this.columnViews[i].setGridCore(this);
        }
    }

    public void setActionSource(Object object) {
        this.actionSource = object;
    }

    public void setSelection(WritableMatrixSelection writableMatrixSelection) {
        if (this.selection != null) {
            this.selection.removeSelectionListener(this);
            this.selection.removeSelectionListener(this.selectionMulticaster);
        }
        this.selection = writableMatrixSelection;
        if (this.selection != null) {
            this.selection.addSelectionListener(this);
            this.selection.addSelectionListener(this.selectionMulticaster);
        }
        this.oldSelected = this.selection.getAll();
        this.repaintCells();
    }

    public WritableMatrixSelection getSelection() {
        return this.selection;
    }

    public void setViewManager(MatrixViewManager matrixViewManager) {
        if (this.editor != null) {
            this.safeEndEdit();
        }
        this.viewManager = matrixViewManager;
        this.invalidate();
        this.reset();
    }

    public MatrixViewManager getViewManager() {
        return this.viewManager;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public WritableMatrixModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void setModel(MatrixModel matrixModel) {
        if (this.editor != null) {
            this.safeEndEdit();
        }
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = matrixModel;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
        }
        this.writeModel = this.model instanceof WritableMatrixModel ? (WritableMatrixModel)this.model : null;
        if (this.model != null) {
            this.invalidate();
            this.reset();
        }
    }

    public MatrixModel getModel() {
        return this.model;
    }

    public void updateUI() {
        super.updateUI();
        super.setBackground(UIManager.getColor("Table.background"));
        super.setForeground(UIManager.getColor("Table.foreground"));
        this.setGridLineColor(UIManager.getColor("Table.gridColor"));
    }

    public GridCore(JScrollPane jScrollPane) {
        this.columnSizes = new VariableSizeVector();
        this.rowSizes = new VariableSizeVector();
        this.oldSelected = new MatrixLocation[0];
        this.divider = new GridCore_Divider();
        this.subfocus = new MatrixLocation(0, 0);
        this.selectAnchor = new MatrixLocation(0, 0);
        this.margins = new Insets(2, 2, 2, 2);
        this.lineColor = SystemColor.control;
        this.toolTip = new DataToolTip(this);
        this.customPainter = new CustomItemPainter();
        this.customEditor = new CustomItemEditor();
        this.keyMulticaster = new KeyMulticaster();
        this.modelMulticaster = new MatrixModelMulticaster();
        this.selectionMulticaster = new MatrixSelectionMulticaster();
        this.subfocusMulticaster = new EventMulticaster();
        this.scroller = jScrollPane;
        this.actionSource = jScrollPane;
        this.divider.setVisible(false);
        this.add(this.divider);
        super.addKeyListener(this.keyMulticaster);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        jScrollPane.getViewport().setBackingStoreEnabled(this.useBackingStore);
        super.setBackground(UIManager.getColor("Table.background"));
        super.setForeground(UIManager.getColor("Table.foreground"));
        this.setGridLineColor(UIManager.getColor("Table.gridColor"));
    }
}

