/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.model.SingletonModelListener;
import com.borland.jbcl.model.SingletonModelMulticaster;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.view.SingletonModelView;
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ChoiceView
extends Choice
implements Serializable,
KeyListener,
SingletonModelListener,
SingletonModelView {
    private boolean readOnly;
    private transient SingletonModelMulticaster modelAdapter = new SingletonModelMulticaster();
    private transient WritableSingletonModel writeModel;
    private transient SingletonModel model;
    private boolean autoAdd = true;
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof SingletonModel) {
            this.model = (SingletonModel)object;
        }
        if (this.model instanceof WritableSingletonModel) {
            this.writeModel = (WritableSingletonModel)this.model;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.model instanceof Serializable ? this.model : null);
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.isReadOnly() || !this.writeModel.canSet(false) || keyEvent.isAltDown()) {
            return;
        }
        char c = keyEvent.getKeyChar();
        String string = this.getSelectedItem();
        if (string == null) {
            return;
        }
        char c2 = (string = string.toLowerCase()).length() > 0 ? (char)string.charAt(0) : (char)'\uffff';
        int[] nArray = new int[]{};
        if (c != '\uffff') {
            int n;
            for (n = 0; n < this.getItemCount(); ++n) {
                String string2 = this.getItem(n).toLowerCase();
                if (string2.length() <= 0 || string2.charAt(0) != c) continue;
                if (c2 != c) {
                    this.writeModel.set(this.getItem(n));
                    return;
                }
                int[] nArray2 = nArray;
                nArray = new int[nArray2.length + 1];
                System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                nArray[nArray.length - 1] = n;
            }
            if (nArray.length > 0) {
                n = this.getSelectedIndex();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] > n) {
                        this.writeModel.set(this.getItem(nArray[i]));
                        return;
                    }
                    if (i != nArray.length - 1 || nArray[i] != n) continue;
                    this.writeModel.set(this.getItem(nArray[0]));
                    return;
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (!this.isReadOnly() && this.writeModel.canSet(true)) {
            String string = this.getSelectedItem();
            this.writeModel.set(string);
        }
        super.processItemEvent(itemEvent);
    }

    protected void updateSelection() {
        Object object = this.model.get();
        String string = object != null ? object.toString() : "";
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!string.equals(this.getItem(i))) continue;
            super.select(string);
            return;
        }
        if (this.autoAdd && object != null) {
            super.addItem(string);
            super.select(string);
        }
    }

    public boolean isAutoAdd() {
        return this.autoAdd;
    }

    public void setAutoAdd(boolean bl) {
        this.autoAdd = bl;
    }

    public void select(String string) {
        if (!this.isReadOnly() && this.writeModel.canSet(true)) {
            super.select(string);
            String string2 = this.getSelectedItem();
            this.writeModel.set(string2);
        }
    }

    public void modelContentChanged(SingletonModelEvent singletonModelEvent) {
        this.updateSelection();
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
        this.setEnabled(!this.readOnly);
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void removeModelListener(SingletonModelListener singletonModelListener) {
        this.model.removeModelListener(singletonModelListener);
    }

    public void addModelListener(SingletonModelListener singletonModelListener) {
        this.model.addModelListener(singletonModelListener);
    }

    public void setModel(SingletonModel singletonModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
        }
        this.model = singletonModel;
        WritableSingletonModel writableSingletonModel = this.writeModel = singletonModel instanceof WritableSingletonModel ? (WritableSingletonModel)singletonModel : null;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.modelContentChanged(null);
        }
        this.setEnabled(!this.isReadOnly());
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public SingletonModel getModel() {
        return this.model;
    }

    public synchronized void setItems(String[] stringArray) {
        this.removeAll();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                super.addItem(stringArray[i]);
            }
        }
        if (this.model.get() != null) {
            this.updateSelection();
        } else if (!this.isReadOnly() && this.writeModel.canSet(true) && stringArray != null && stringArray.length > 0) {
            this.writeModel.set(stringArray[0]);
        }
        if (stringArray != null && this.getPeer() != null) {
            this.addNotify();
        }
    }

    public synchronized String[] getItems() {
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getItem(i);
        }
        return stringArray;
    }

    public ChoiceView() {
        this.enableEvents(512L);
        this.addKeyListener(this);
    }
}

