/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jb.util.ExceptionHandler;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.model.SingletonModelListener;
import com.borland.jbcl.model.SingletonViewManager;
import com.borland.jbcl.model.WritableSingletonModel;
import java.awt.Component;
import java.util.EventListener;

public class SingletonDataSetManager
implements ExceptionHandler,
DataChangeListener,
NavigationListener,
SingletonViewManager,
WritableSingletonModel {
    private transient EventMulticaster modelListeners;
    private SingletonModelEvent singletonModelEvent = new SingletonModelEvent(this);
    private boolean events = true;
    private DataSetModel dataSetModel;
    private DataSet dataSet;

    public void handleException(Exception exception) {
        this.dataSetModel.handleThisException(exception);
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.processModelEvent();
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
        this.processModelEvent();
    }

    private void processModelEvent() {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)this.singletonModelEvent);
        }
    }

    public ItemEditor getEditor(Object object, int n) {
        return this.dataSetModel.getEditor();
    }

    public ItemPainter getPainter(Object object, int n) {
        return this.dataSetModel.getPainter(object);
    }

    public void enableModelEvents(boolean bl) {
        if (this.events != bl) {
            this.events = bl;
            if (bl) {
                this.processModelEvent();
            }
        }
    }

    public void touched() {
        this.processModelEvent();
    }

    public void set(Object object) {
        this.dataSetModel.set(object);
        this.processModelEvent();
    }

    public boolean canSet(boolean bl) {
        return this.dataSetModel.canSet(bl);
    }

    public void removeModelListener(SingletonModelListener singletonModelListener) {
        this.modelListeners.remove((EventListener)singletonModelListener);
        if (this.modelListeners.getListenerCount() == 0) {
            this.dataSet.removeDataChangeListener((DataChangeListener)this);
            this.dataSet.removeNavigationListener((NavigationListener)this);
        }
    }

    public void addModelListener(SingletonModelListener singletonModelListener) {
        this.modelListeners.add((EventListener)singletonModelListener);
        if (this.modelListeners.getListenerCount() == 1) {
            this.dataSet.addDataChangeListener((DataChangeListener)this);
            this.dataSet.addNavigationListener((NavigationListener)this);
        }
    }

    public Object get() {
        return this.dataSetModel.get();
    }

    public SingletonDataSetManager(DataSet dataSet, Column column, Component component) {
        this.modelListeners = new EventMulticaster();
        this.dataSet = dataSet;
        this.dataSetModel = new DataSetModel(dataSet, column, component);
    }

    public SingletonDataSetManager(DataSet dataSet, Column column) {
        this(dataSet, column, null);
    }
}

