/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.WritableMatrixSelection;
import java.io.Serializable;
import java.util.EventListener;

public class RowMatrixSelection
implements Serializable,
WritableMatrixSelection {
    private boolean events = true;
    private transient EventMulticaster selectionListeners = new EventMulticaster();
    private int columns;
    private int cellRow = -1;

    protected void processSelectionEvent(MatrixSelectionEvent matrixSelectionEvent) {
        if (this.events && this.selectionListeners.hasListeners()) {
            this.selectionListeners.dispatch((DispatchableEvent)matrixSelectionEvent);
        }
    }

    public void enableSelectionEvents(boolean bl) {
        this.events = bl;
        if (this.events) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeAll() {
        if (this.cellRow != -1) {
            this.cellRow = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12289));
        }
    }

    public void removeRange(int n, int n2, int n3, int n4) {
        if (this.cellRow != -1 && this.cellRow >= n && this.cellRow <= n3) {
            this.cellRow = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeRange(MatrixLocation matrixLocation, MatrixLocation matrixLocation2) {
        this.removeRange(matrixLocation.row, matrixLocation.column, matrixLocation2.row, matrixLocation2.column);
    }

    public void remove(MatrixLocation[] matrixLocationArray) {
        if (this.cellRow != -1) {
            for (int i = 0; i < matrixLocationArray.length; ++i) {
                if (matrixLocationArray[i].row != this.cellRow) continue;
                this.cellRow = -1;
                this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
                return;
            }
        }
    }

    public void remove(int n, int n2) {
        if (this.cellRow != -1 && n == this.cellRow) {
            this.cellRow = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation matrixLocation) {
        if (this.cellRow != -1 && matrixLocation.row == this.cellRow) {
            this.cellRow = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(int n, int n2, int n3, int n4) {
        if (this.cellRow != n3) {
            this.cellRow = n3;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(MatrixLocation matrixLocation, MatrixLocation matrixLocation2) {
        if (matrixLocation2.row != this.cellRow) {
            this.cellRow = matrixLocation2.row;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation[] matrixLocationArray) {
        if (matrixLocationArray.length > 0 && matrixLocationArray[0].row != this.cellRow) {
            this.cellRow = matrixLocationArray[0].row;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(int n, int n2) {
        if (n != this.cellRow) {
            this.cellRow = n;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation matrixLocation) {
        if (matrixLocation.row != this.cellRow) {
            this.cellRow = matrixLocation.row;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void set(MatrixLocation[] matrixLocationArray) {
        this.add(matrixLocationArray);
    }

    public void removeSelectionListener(MatrixSelectionListener matrixSelectionListener) {
        this.selectionListeners.remove((EventListener)matrixSelectionListener);
    }

    public void addSelectionListener(MatrixSelectionListener matrixSelectionListener) {
        this.selectionListeners.add((EventListener)matrixSelectionListener);
    }

    public MatrixLocation[] getAll() {
        MatrixLocation[] matrixLocationArray = new MatrixLocation[this.cellRow != -1 ? this.columns : 0];
        if (this.cellRow != -1) {
            for (int i = 0; i < matrixLocationArray.length; ++i) {
                matrixLocationArray[i] = new MatrixLocation(this.cellRow, i);
            }
        }
        return matrixLocationArray;
    }

    public int getCount() {
        return this.cellRow != -1 ? this.columns : 0;
    }

    public boolean contains(int n, int n2) {
        return this.cellRow != -1 ? n == this.cellRow : false;
    }

    public boolean contains(MatrixLocation matrixLocation) {
        return this.cellRow != -1 ? matrixLocation.row == this.cellRow : false;
    }

    public void setMaxColumns(int n) {
        this.columns = n;
        this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
    }

    public int getMaxColumns() {
        return this.columns;
    }

    public RowMatrixSelection(int n, int n2) {
        this.columns = n;
        this.cellRow = n2;
    }

    public RowMatrixSelection(int n) {
        this.columns = n;
    }

    public RowMatrixSelection() {
    }
}

