/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.GraphModelEvent;
import com.borland.jbcl.model.GraphModelListener;

public class GraphModelMulticaster
implements GraphModelListener {
    private transient GraphModelListener[] listeners;
    private static final long serialVersionUID = 200L;

    public final synchronized void remove(GraphModelListener graphModelListener) {
        int n = this.find(graphModelListener);
        if (n > -1) {
            if (this.listeners.length == 1) {
                this.listeners = null;
            } else {
                GraphModelListener[] graphModelListenerArray = new GraphModelListener[this.listeners.length - 1];
                System.arraycopy(this.listeners, 0, graphModelListenerArray, 0, n);
                if (n < graphModelListenerArray.length) {
                    System.arraycopy(this.listeners, n + 1, graphModelListenerArray, n, graphModelListenerArray.length - n);
                }
                this.listeners = graphModelListenerArray;
            }
        }
    }

    public final synchronized void add(GraphModelListener graphModelListener) {
        if (this.find(graphModelListener) < 0) {
            GraphModelListener[] graphModelListenerArray;
            if (this.listeners == null) {
                graphModelListenerArray = new GraphModelListener[1];
            } else {
                graphModelListenerArray = new GraphModelListener[this.listeners.length + 1];
                System.arraycopy(this.listeners, 0, graphModelListenerArray, 0, this.listeners.length);
            }
            graphModelListenerArray[graphModelListenerArray.length - 1] = graphModelListener;
            this.listeners = graphModelListenerArray;
        }
    }

    public int find(GraphModelListener graphModelListener) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != graphModelListener) continue;
                return i;
            }
        }
        return -1;
    }

    public final void dispatch(GraphModelEvent graphModelEvent) {
        GraphModelListener[] graphModelListenerArray = this.listeners;
        if (graphModelListenerArray != null) {
            int n = graphModelListenerArray.length;
            block4: for (int i = 0; i < n; ++i) {
                switch (graphModelEvent.getID()) {
                    case 1: {
                        graphModelListenerArray[i].modelContentChanged(graphModelEvent);
                        continue block4;
                    }
                    case 2: {
                        graphModelListenerArray[i].modelStructureChanged(graphModelEvent);
                    }
                }
            }
        }
    }

    public final boolean hasListeners() {
        return this.listeners != null;
    }

    public void modelStructureChanged(GraphModelEvent graphModelEvent) {
        if (this.listeners != null) {
            this.dispatch(graphModelEvent);
        }
    }

    public void modelContentChanged(GraphModelEvent graphModelEvent) {
        if (this.listeners != null) {
            this.dispatch(graphModelEvent);
        }
    }
}

