/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnPaintListener;
import com.borland.dx.dataset.ColumnVariant;
import com.borland.dx.dataset.CustomPaintSite;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.ExceptionEvent;
import com.borland.dx.dataset.MatrixData;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.PickListDescriptor;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.ReadWriteRow;
import com.borland.dx.dataset.Variant;
import com.borland.dx.text.ItemEditMask;
import com.borland.dx.text.ItemFormatter;
import com.borland.jb.util.DispatchableEvent;
import com.borland.jbcl.control.ExceptionDialog;
import com.borland.jbcl.control.MaskableTextItemEditor;
import com.borland.jbcl.control.PickListItemEditor;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.Res;
import com.borland.jbcl.view.BooleanToggleItemEditor;
import com.borland.jbcl.view.CheckboxItemPainter;
import com.borland.jbcl.view.CustomItemEditor;
import com.borland.jbcl.view.CustomItemPainter;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.ImageItemEditor;
import com.borland.jbcl.view.ImageItemPainter;
import com.borland.jbcl.view.SelectableItemPainter;
import com.borland.jbcl.view.TextItemPainter;
import java.awt.Component;
import java.awt.Frame;
import java.io.InputStream;

public class DataSetModel {
    private ColumnVariant value;
    private ItemEditor editor;
    private ColumnPaintListener paintListener;
    private CustomItemEditor customEditor;
    private CustomItemPainter customPainter;
    private ItemPainter painter;
    private Component component;
    private Column column;
    private DataSet dataSet;

    public static final void handleException(Exception exception, boolean bl) {
        DataSetModel.handleException(null, null, exception, bl);
    }

    public static final void handleException(Exception exception) {
        DataSetModel.handleException(null, null, exception);
    }

    public static final void handleException(Component component, Exception exception, boolean bl) {
        DataSetModel.handleException(null, component, exception, bl);
    }

    public static final void handleException(DataSet dataSet, Component component, Exception exception) {
        DataSetModel.handleException(dataSet, component, exception, false);
    }

    public static final void handleException(DataSet dataSet, Component component, Exception exception, boolean bl) {
        Frame frame = DataSetModel.getFrame(component);
        if (DataSetException.getExceptionListeners() != null) {
            DataSetException.getExceptionListeners().dispatch((DispatchableEvent)new ExceptionEvent(dataSet, component, exception));
        } else if ((dataSet == null || MatrixData.displayError((DataSet)dataSet, (Exception)exception)) && frame != null && ExceptionDialog.getShowCount() < 1) {
            ((Component)new ExceptionDialog(frame, Res.getString(25), exception, bl)).setVisible(true);
        }
    }

    private static final Frame getFrame(Component component) {
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (!(component2 instanceof Frame)) continue;
            return (Frame)component2;
        }
        return new Frame();
    }

    final void removeRow(int n) {
        try {
            if (n != this.dataSet.getRow()) {
                this.dataSet.goToRow(n);
            }
            this.dataSet.deleteRow();
        }
        catch (Exception exception) {
            this.handleThisException(exception);
        }
    }

    final void addRow() {
        try {
            if (!this.dataSet.atLast()) {
                if (this.dataSet.getStorageDataSet().provideMoreData()) {
                    return;
                }
                this.dataSet.last();
            }
            this.dataSet.insertRow(false);
        }
        catch (Exception exception) {
            this.handleThisException(exception);
        }
    }

    void addRow(int n) {
        try {
            if (n != this.dataSet.getRow()) {
                this.dataSet.goToRow(n);
            }
            this.dataSet.insertRow(true);
        }
        catch (Exception exception) {
            this.handleThisException(exception);
        }
    }

    final void set(int n, Object object) {
        if (n != this.dataSet.getRow()) {
            try {
                this.dataSet.goToRow(n);
            }
            catch (DataSetException dataSetException) {
                this.handleThisException((Exception)((Object)dataSetException));
                return;
            }
        }
        this.set(object);
    }

    final void set(Object object) {
        try {
            if (object instanceof Variant) {
                this.setVariant((Variant)object);
            } else if (object instanceof InputStream) {
                this.dataSet.setInputStream(this.column.getOrdinal(), (InputStream)object);
            } else if (object instanceof ReadRow && this.column.getPickList() != null) {
                PickListDescriptor pickListDescriptor = this.column.getPickList();
                ReadRow.copyTo((String[])pickListDescriptor.getPickListColumns(), (ReadRow)((ReadRow)object), (String[])pickListDescriptor.getDestinationColumns(), (ReadWriteRow)this.dataSet);
            } else if (object != null) {
                this.column.getFormatter().parse(object.toString(), (Variant)this.value);
                this.setVariant((Variant)this.value);
            } else {
                this.value.setAssignedNull();
                this.dataSet.setVariant(this.column.getOrdinal(), (Variant)this.value);
            }
        }
        catch (Exception exception) {
            this.handleThisException(exception);
            throw new IllegalArgumentException();
        }
    }

    private final void setVariant(Variant variant) throws DataSetException {
        int n = this.column.getOrdinal();
        this.dataSet.setDisplayVariant(n, variant);
    }

    final boolean canSet(int n, boolean bl) {
        if (!this.column.isEditable()) {
            return false;
        }
        try {
            if (bl) {
                this.dataSet.startEdit(this.column);
            } else {
                this.dataSet.startEditCheck(this.column);
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (DataSetException dataSetException) {
            this.handleThisException((Exception)((Object)dataSetException));
            return false;
        }
    }

    final boolean canSet(boolean bl) {
        return this.canSet(this.dataSet.getRow(), bl);
    }

    final int getRowCount() {
        try {
            int n = this.dataSet.getRowCount();
            return n;
        }
        catch (Exception exception) {
            this.handleThisException(exception);
            int n = 0;
            return n;
        }
    }

    final Variant get(int n) {
        if (this.column == null) {
            return null;
        }
        try {
            this.dataSet.getDisplayVariant(this.column.getOrdinal(), n, (Variant)this.value);
            ColumnVariant columnVariant = this.value;
            return columnVariant;
        }
        catch (Exception exception) {
            this.handleThisException(exception);
            this.value.setUnassignedNull();
            ColumnVariant columnVariant = this.value;
            return columnVariant;
        }
    }

    final Variant get() {
        try {
            this.dataSet.getDisplayVariant(this.column.getOrdinal(), this.dataSet.getRow(), (Variant)this.value);
            ColumnVariant columnVariant = this.value;
            return columnVariant;
        }
        catch (Exception exception) {
            this.handleThisException(exception);
            this.value.setUnassignedNull();
            ColumnVariant columnVariant = this.value;
            return columnVariant;
        }
    }

    final void handleThisException(Exception exception) {
        DataSetModel.handleException(this.dataSet, this.component, exception);
    }

    final void addNavigationListener(NavigationListener navigationListener) {
        this.dataSet.addNavigationListener(navigationListener);
    }

    final void addDataChangeListener(DataChangeListener dataChangeListener) {
        this.dataSet.addDataChangeListener(dataChangeListener);
    }

    ItemEditor getEditor() {
        if (this.editor == null) {
            switch (this.column.getDataType()) {
                case 11: {
                    this.editor = new BooleanToggleItemEditor();
                    break;
                }
                case 12: {
                    this.editor = new ImageItemEditor();
                    break;
                }
                default: {
                    PickListDescriptor pickListDescriptor = this.column.getPickList();
                    if (pickListDescriptor != null) {
                        PickListItemEditor pickListItemEditor = new PickListItemEditor();
                        pickListItemEditor.setCachePickList(true);
                        this.editor = pickListItemEditor;
                        break;
                    }
                    int n = -1;
                    ItemEditMask itemEditMask = this.column.getEditMasker();
                    if (this.column.getDataType() == 16 && itemEditMask == null) {
                        n = this.column.getPrecision();
                    }
                    this.editor = new MaskableTextItemEditor((ItemFormatter)this.column.getFormatter(), itemEditMask);
                }
            }
            this.paintListener = this.column.getColumnPaintListener();
            if (this.paintListener != null) {
                this.customEditor = new CustomItemEditor(this.editor);
                this.editor = this.customEditor;
            }
        }
        if (this.paintListener != null) {
            if (this.customEditor == null) {
                this.customEditor = new CustomItemEditor(this.editor);
                this.editor = this.customEditor;
            }
            this.customEditor.reset();
            this.paintListener.editing(this.dataSet, this.column, (CustomPaintSite)this.customEditor);
        }
        return this.editor;
    }

    ItemPainter getPainter(int n, Object object) {
        if (this.painter == null) {
            switch (this.column.getDataType()) {
                case 11: {
                    this.painter = new CheckboxItemPainter();
                    break;
                }
                case 12: {
                    this.painter = new ImageItemPainter();
                    break;
                }
                case 17: {
                    this.painter = new TextItemPainter((ItemFormatter)this.column.getFormatter());
                    break;
                }
                default: {
                    this.painter = new TextItemPainter((ItemFormatter)this.column.getFormatter());
                }
            }
            this.paintListener = this.column.getColumnPaintListener();
            if (this.paintListener != null) {
                this.customPainter = new CustomItemPainter(new SelectableItemPainter(this.painter));
                this.painter = new FocusableItemPainter(this.customPainter);
            } else {
                this.painter = new FocusableItemPainter(new SelectableItemPainter(this.painter));
            }
        }
        if (this.paintListener != null) {
            if (this.customPainter == null) {
                this.customPainter = new CustomItemPainter(new SelectableItemPainter(this.painter));
                this.painter = new FocusableItemPainter(this.customPainter);
            }
            this.customPainter.reset();
            this.paintListener.painting(this.dataSet, this.column, n, (Variant)object, (CustomPaintSite)this.customPainter);
        }
        return this.painter;
    }

    ItemPainter getPainter(Object object) {
        return this.getPainter(this.dataSet.getRow(), object);
    }

    Column getColumn() {
        return this.column;
    }

    DataSet getDataSet() {
        return this.dataSet;
    }

    DataSetModel(DataSet dataSet, Column column, Component component) {
        this.dataSet = dataSet;
        this.column = column;
        this.component = component;
        this.value = new ColumnVariant(column, dataSet);
        this.editor = (ItemEditor)column.getItemEditor();
        this.painter = (ItemPainter)column.getItemPainter();
    }
}

