/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.WritableMatrixSelection;
import java.io.Serializable;
import java.util.EventListener;

public class CrossMatrixSelection
implements Serializable,
WritableMatrixSelection {
    private boolean events = true;
    private transient EventMulticaster selectionListeners = new EventMulticaster();
    private boolean valid;
    private int columns;
    private int rows;
    private MatrixLocation cell;

    protected void processSelectionEvent(MatrixSelectionEvent matrixSelectionEvent) {
        if (this.events && this.selectionListeners.hasListeners()) {
            this.selectionListeners.dispatch((DispatchableEvent)matrixSelectionEvent);
        }
    }

    public void enableSelectionEvents(boolean bl) {
        this.events = bl;
        if (this.events) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeAll() {
        if (this.valid) {
            this.cell = null;
            this.valid = false;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12289));
        }
    }

    public void removeRange(int n, int n2, int n3, int n4) {
        if (this.valid && (this.cell.row >= n && this.cell.row <= n3 || this.cell.column >= n2 && this.cell.column <= n4)) {
            this.cell = null;
            this.valid = false;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeRange(MatrixLocation matrixLocation, MatrixLocation matrixLocation2) {
        this.removeRange(matrixLocation.row, matrixLocation.column, matrixLocation2.row, matrixLocation2.column);
    }

    public void remove(MatrixLocation[] matrixLocationArray) {
        if (this.valid && matrixLocationArray.length > 0) {
            for (int i = 0; i < matrixLocationArray.length; ++i) {
                if (matrixLocationArray[i] == null || !matrixLocationArray[i].equals(this.cell)) continue;
                this.cell = null;
                this.valid = false;
                this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
                return;
            }
        }
    }

    public void remove(int n, int n2) {
        if (this.valid && n == this.cell.row && n2 == this.cell.column) {
            this.cell = null;
            this.valid = false;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation matrixLocation) {
        if (this.valid && matrixLocation != null && matrixLocation.equals(this.cell)) {
            this.cell = null;
            this.valid = false;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(int n, int n2, int n3, int n4) {
        if (n3 != this.cell.row || n4 != this.cell.column) {
            this.cell = new MatrixLocation(n3, n4);
            this.checkValid();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(MatrixLocation matrixLocation, MatrixLocation matrixLocation2) {
        if (matrixLocation2 != null && !matrixLocation2.equals(this.cell)) {
            this.cell = matrixLocation2;
            this.checkValid();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation[] matrixLocationArray) {
        if (matrixLocationArray.length > 0 && !matrixLocationArray[0].equals(this.cell)) {
            this.cell = matrixLocationArray[0];
            this.checkValid();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(int n, int n2) {
        if (n != this.cell.row || n2 != this.cell.column) {
            this.cell = new MatrixLocation(n, n2);
            this.checkValid();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation matrixLocation) {
        if (matrixLocation != null && !matrixLocation.equals(this.cell)) {
            this.cell = matrixLocation;
            this.checkValid();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void set(MatrixLocation[] matrixLocationArray) {
        this.add(matrixLocationArray);
    }

    public void removeSelectionListener(MatrixSelectionListener matrixSelectionListener) {
        this.selectionListeners.remove((EventListener)matrixSelectionListener);
    }

    public void addSelectionListener(MatrixSelectionListener matrixSelectionListener) {
        this.selectionListeners.add((EventListener)matrixSelectionListener);
    }

    public MatrixLocation[] getAll() {
        MatrixLocation[] matrixLocationArray = new MatrixLocation[this.valid ? this.rows + this.columns - 1 : 0];
        if (this.valid) {
            int n;
            int n2 = 0;
            for (n = 0; n < this.rows; ++n) {
                matrixLocationArray[n2++] = new MatrixLocation(n, this.cell.column);
            }
            for (n = 0; n < this.columns; ++n) {
                if (n == this.cell.column) continue;
                matrixLocationArray[n2++] = new MatrixLocation(this.cell.row, n);
            }
        }
        return matrixLocationArray;
    }

    public int getCount() {
        return this.valid ? this.rows + this.columns - 1 : 0;
    }

    public boolean contains(int n, int n2) {
        return this.valid ? n == this.cell.row || n2 == this.cell.column : false;
    }

    public boolean contains(MatrixLocation matrixLocation) {
        return this.valid ? matrixLocation.row == this.cell.row || matrixLocation.column == this.cell.column : false;
    }

    private void checkValid() {
        this.valid = this.rows > 0 && this.columns > 0 && this.cell != null;
    }

    public void setMaxColumns(int n) {
        this.columns = n;
        this.checkValid();
        this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
    }

    public int getMaxColumns() {
        return this.columns;
    }

    public void setMaxRows(int n) {
        this.rows = n;
        this.checkValid();
        this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
    }

    public int getMaxRows() {
        return this.rows;
    }

    public CrossMatrixSelection(int n, int n2, MatrixLocation matrixLocation) {
        this(n, n2);
        this.cell = matrixLocation;
        this.checkValid();
    }

    public CrossMatrixSelection(int n, int n2) {
        this.rows = n;
        this.columns = n2;
    }

    public CrossMatrixSelection() {
    }
}

