/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixModelEvent;
import com.borland.jbcl.model.MatrixModelListener;
import com.borland.jbcl.model.Res;
import com.borland.jbcl.model.WritableMatrixModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class BasicMatrixContainer
implements Serializable,
WritableMatrixModel {
    private boolean events = true;
    private transient EventMulticaster modelListeners;
    private boolean variableColumns = true;
    private boolean variableRows = true;
    private int columns;
    private int rows;
    private transient Object[][] items = new Object[0][0];
    private static final long serialVersionUID = 200L;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.items = (Object[][])objectInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[][] objectArray = new Object[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                if (!(this.items[i][j] instanceof Serializable)) continue;
                objectArray[i][j] = this.items[i][j];
            }
        }
        objectOutputStream.writeObject(objectArray);
    }

    private Object[] deleteColumn(Object[] objectArray, int n) {
        Object[] objectArray2 = new Object[objectArray.length - 1];
        if (n == 0) {
            System.arraycopy(objectArray, 1, objectArray2, 0, objectArray.length - 1);
        } else if (n == objectArray2.length) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
        } else {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray2.length - n);
        }
        return objectArray2;
    }

    private Object[] appendColumn(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    private Object[] insertColumn(Object[] objectArray, int n) {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        if (n == 0) {
            System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        } else if (n == objectArray.length) {
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        } else {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            System.arraycopy(objectArray, n, objectArray2, n + 1, objectArray.length - n);
        }
        return objectArray2;
    }

    protected void processModelEvent(MatrixModelEvent matrixModelEvent) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)matrixModelEvent);
        }
    }

    public void enableModelEvents(boolean bl) {
        if (this.events != bl) {
            this.events = bl;
            if (bl) {
                this.processModelEvent(new MatrixModelEvent(this, 2));
            }
        }
    }

    public void removeAllColumns() {
        if (!this.variableColumns) {
            throw new IllegalStateException(Res.getString(24));
        }
        Object[][] objectArray = new Object[this.rows][0];
        this.items = objectArray;
        this.columns = 0;
        this.processModelEvent(new MatrixModelEvent(this, 2));
    }

    public void removeColumn(int n) {
        if (!this.variableColumns) {
            throw new IllegalStateException(Res.getString(24));
        }
        if (n >= 0 && n < this.columns) {
            Object[][] objectArray = new Object[this.rows][this.columns - 1];
            for (int i = 0; i < this.rows; ++i) {
                objectArray[i] = this.deleteColumn(this.items[i], n);
            }
            this.items = objectArray;
            --this.columns;
            this.processModelEvent(new MatrixModelEvent(this, 66, new MatrixLocation(0, n)));
        }
    }

    public void addColumn(int n) {
        if (!this.variableColumns) {
            throw new IllegalStateException(Res.getString(24));
        }
        if (n >= 0 && n < this.columns) {
            Object[][] objectArray = new Object[this.rows][this.columns + 1];
            for (int i = 0; i < this.rows; ++i) {
                objectArray[i] = this.insertColumn(this.items[i], n);
            }
            this.items = objectArray;
            ++this.columns;
            this.processModelEvent(new MatrixModelEvent(this, 50, new MatrixLocation(0, n)));
        }
    }

    public void addColumn() {
        if (!this.variableColumns) {
            throw new IllegalStateException(Res.getString(24));
        }
        Object[][] objectArray = new Object[this.rows][this.columns + 1];
        for (int i = 0; i < this.rows; ++i) {
            objectArray[i] = this.appendColumn(this.items[i]);
        }
        this.items = objectArray;
        ++this.columns;
        this.processModelEvent(new MatrixModelEvent(this, 50, new MatrixLocation(0, this.columns - 1)));
    }

    public void setVariableColumns(boolean bl) {
        this.variableColumns = bl;
    }

    public boolean isVariableColumns() {
        return this.variableColumns;
    }

    public void removeAllRows() {
        if (!this.variableRows) {
            throw new IllegalStateException(Res.getString(23));
        }
        Object[][] objectArray = new Object[0][this.columns];
        this.items = objectArray;
        this.rows = 0;
        this.processModelEvent(new MatrixModelEvent(this, 2));
    }

    public void removeRow(int n) {
        if (!this.variableRows) {
            throw new IllegalStateException(Res.getString(23));
        }
        Object[][] objectArray = new Object[this.rows - 1][this.columns];
        if (n == 0) {
            for (int i = 0; i < this.rows - 1; ++i) {
                System.arraycopy(this.items[i + 1], 0, objectArray[i], 0, this.items[i + 1].length);
            }
        } else if (n >= 0 && n < this.rows) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                System.arraycopy(this.items[n2], 0, objectArray[n2], 0, this.items[n2].length);
            }
            for (n2 = n; n2 < this.rows - 1; ++n2) {
                System.arraycopy(this.items[n2 + 1], 0, objectArray[n2], 0, this.items[n2 + 1].length);
            }
        } else {
            return;
        }
        this.items = objectArray;
        --this.rows;
        this.processModelEvent(new MatrixModelEvent(this, 34, new MatrixLocation(n, 0)));
    }

    public void addRow(int n) {
        if (!this.variableRows) {
            throw new IllegalStateException(Res.getString(23));
        }
        Object[][] objectArray = new Object[this.rows + 1][this.columns];
        if (n == 0) {
            for (int i = 0; i < this.rows; ++i) {
                System.arraycopy(this.items[i], 0, objectArray[i + 1], 0, this.items[i].length);
            }
        } else if (n >= 0 && n < this.rows) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                System.arraycopy(this.items[n2], 0, objectArray[n2], 0, this.items[n2].length);
            }
            for (n2 = n; n2 < this.rows; ++n2) {
                System.arraycopy(this.items[n2], 0, objectArray[n2 + 1], 0, this.items[n2].length);
            }
        } else {
            return;
        }
        this.items = objectArray;
        ++this.rows;
        this.processModelEvent(new MatrixModelEvent(this, 18, new MatrixLocation(n, 0)));
    }

    public void addRow() {
        if (!this.variableRows) {
            throw new IllegalStateException(Res.getString(23));
        }
        Object[][] objectArray = new Object[this.rows + 1][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            System.arraycopy(this.items[i], 0, objectArray[i], 0, this.items[i].length);
        }
        this.items = objectArray;
        ++this.rows;
        this.processModelEvent(new MatrixModelEvent(this, 18, new MatrixLocation(this.rows - 1, 0)));
    }

    public void setVariableRows(boolean bl) {
        this.variableRows = bl;
    }

    public boolean isVariableRows() {
        return this.variableRows;
    }

    public void touched(int n, int n2) {
        if (n >= 0 && n < this.rows && n2 >= 0 && n2 < this.columns) {
            this.processModelEvent(new MatrixModelEvent(this, 33, new MatrixLocation(n, n2)));
        }
    }

    public void set(int n, int n2, Object object) {
        if (n >= 0 && n < this.rows && n2 >= 0 && n2 < this.columns) {
            this.items[n][n2] = object;
            this.processModelEvent(new MatrixModelEvent(this, 17, new MatrixLocation(n, n2)));
        }
    }

    public boolean canSet(int n, int n2, boolean bl) {
        return n >= 0 && n < this.rows && n2 >= 0 && n2 < this.columns;
    }

    public void removeModelListener(MatrixModelListener matrixModelListener) {
        this.modelListeners.remove((EventListener)matrixModelListener);
    }

    public void addModelListener(MatrixModelListener matrixModelListener) {
        this.modelListeners.add((EventListener)matrixModelListener);
    }

    public void setColumnCount(int n) {
        if (!this.variableColumns || n == this.columns) {
            throw new IllegalStateException(Res.getString(24));
        }
        Object[][] objectArray = new Object[this.rows][n];
        int n2 = n < this.columns ? n : this.columns;
        for (int i = 0; i < this.rows; ++i) {
            System.arraycopy(this.items[i], 0, objectArray[i], 0, n2);
        }
        this.columns = n;
        this.items = objectArray;
        this.processModelEvent(new MatrixModelEvent(this, 2));
    }

    public int getColumnCount() {
        return this.columns;
    }

    public void setRowCount(int n) {
        if (!this.variableRows || n == this.rows) {
            throw new IllegalStateException(Res.getString(23));
        }
        Object[][] objectArray = new Object[n][this.columns];
        int n2 = n < this.rows ? n : this.rows;
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(this.items[i], 0, objectArray[i], 0, this.items[i].length);
        }
        this.rows = n;
        this.items = objectArray;
        this.processModelEvent(new MatrixModelEvent(this, 2));
    }

    public int getRowCount() {
        return this.rows;
    }

    public MatrixLocation find(Object object) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.items[i].length; ++j) {
                Object object2 = this.items[i][j];
                if (object2 != object && (object2 == null || !object2.equals(object))) continue;
                return new MatrixLocation(i, j);
            }
        }
        return null;
    }

    public Object get(int n, int n2) {
        if (n >= 0 && n < this.rows && n2 >= 0 && n2 < this.columns) {
            return this.items[n][n2];
        }
        return null;
    }

    public void setItems(Object[][] objectArray) {
        this.rows = objectArray.length;
        this.columns = this.rows > 0 ? objectArray[0].length : 0;
        this.items = objectArray;
        this.processModelEvent(new MatrixModelEvent(this, 2));
    }

    public Object[][] getItems() {
        return this.items;
    }

    public BasicMatrixContainer(Object[][] objectArray) {
        this.modelListeners = new EventMulticaster();
        this.rows = objectArray.length;
        this.columns = this.rows > 0 ? objectArray[0].length : 0;
        this.items = objectArray;
    }

    public BasicMatrixContainer(int n, int n2) {
        this.modelListeners = new EventMulticaster();
        this.rows = n;
        this.columns = n2;
        this.items = new Object[n][n2];
    }

    public BasicMatrixContainer() {
        this.modelListeners = new EventMulticaster();
    }
}

