/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.editors;

import com.borland.jb.util.FastStringBuffer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;

public class StringEditor
implements PropertyEditor {
    protected Object value;
    private PropertyChangeListener listener;
    private static char[] physicalChars;
    private static String[] logicalChars;

    static {
        logicalChars = new String[]{"<TAB>", "<CR>", "<NL>", "<FF>", "<<>", "<LF>"};
        physicalChars = new char[]{'\t', '\r', '\n', '\f', '<', '\n'};
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listener = propertyChangeListener;
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "StringEditor???", null, this.value));
        }
    }

    public static String displayTextToRaw(String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(string);
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer();
        char c = fastStringBuffer.firstChar();
        while (c != '\u0000') {
            if (c != '<') {
                fastStringBuffer2.append(c);
            } else {
                int n = fastStringBuffer.getOffset();
                FastStringBuffer fastStringBuffer3 = new FastStringBuffer();
                c = fastStringBuffer.nextChar();
                while (c != '\u0000') {
                    if (c == '>') {
                        int n2;
                        String string2 = String.valueOf(String.valueOf("<").concat(String.valueOf(fastStringBuffer3.toString()))).concat(String.valueOf(">"));
                        for (n2 = 0; n2 < logicalChars.length; ++n2) {
                            if (!string2.equalsIgnoreCase(logicalChars[n2])) continue;
                            fastStringBuffer2.append(physicalChars[n2]);
                            break;
                        }
                        if (n2 < logicalChars.length) break;
                        String string3 = fastStringBuffer3.toString();
                        try {
                            fastStringBuffer2.append((char)Integer.valueOf(string3, 16).intValue());
                        }
                        catch (Exception exception) {
                            fastStringBuffer2.append(string2);
                        }
                        break;
                    }
                    fastStringBuffer3.append(c);
                    c = fastStringBuffer.nextChar();
                }
                if (c == '\u0000') {
                    fastStringBuffer2.append('<');
                    fastStringBuffer.setOffset(n);
                }
            }
            c = fastStringBuffer.nextChar();
        }
        return fastStringBuffer2.toString();
    }

    public static String rawTextToDisplay(Object object) {
        if (!(object instanceof String)) {
            return object.toString();
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer((String)object);
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer();
        char c = fastStringBuffer.firstChar();
        while (c != '\u0000') {
            int n;
            for (n = 0; n < physicalChars.length; ++n) {
                if (c != physicalChars[n]) continue;
                fastStringBuffer2.append(logicalChars[n]);
                break;
            }
            if (n >= physicalChars.length) {
                if (c > '\u001f' && StringEditor.inCurrentCodePage(c)) {
                    fastStringBuffer2.append(c);
                } else {
                    fastStringBuffer2.append(String.valueOf(String.valueOf("<").concat(String.valueOf(Integer.toString(c, 16)))).concat(String.valueOf(">")));
                }
            }
            c = fastStringBuffer.nextChar();
        }
        return fastStringBuffer2.toString();
    }

    public static boolean inCurrentCodePage(char c) {
        String string = String.valueOf(c);
        byte[] byArray = string.getBytes();
        String string2 = new String(byArray);
        return string.charAt(0) == string2.charAt(0);
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Component getCustomEditor() {
        return null;
    }

    public String[] getTags() {
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.value = string == null ? null : StringEditor.displayTextToRaw(string);
    }

    public static String textToSource(Object object) {
        if (object instanceof String) {
            return FastStringBuffer.textToSource((String)((String)object), (boolean)false).toString();
        }
        return object.toString();
    }

    public String getJavaInitializationString() {
        String string = StringEditor.textToSource(this.value);
        return string;
    }

    public String getAsText() {
        String string = this.value == null ? null : StringEditor.rawTextToDisplay(this.value);
        return string;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public boolean isPaintable() {
        return false;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
        this.fire();
    }
}

