/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.Res;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.util.SerializableImage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;

public class TransparentImage
extends Component
implements Serializable {
    protected int alignment = 68;
    protected boolean transparent = true;
    protected boolean drawEdge = true;
    protected Color edgeColor = Color.black;
    protected URL url;
    protected String imageName;
    protected transient Image image;
    private transient Image canvas;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object instanceof SerializableImage) {
            this.image = ((SerializableImage)object).getImage();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.image != null ? SerializableImage.create(this.image) : null);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Color color = graphics.getColor();
        Graphics graphics2 = graphics;
        if (!this.transparent) {
            if (this.canvas == null || this.canvas.getWidth(null) != dimension.width || this.canvas.getHeight(null) != dimension.height) {
                this.canvas = this.createImage(dimension.width, dimension.height);
            }
            graphics2 = this.canvas.getGraphics();
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (this.image != null) {
            int n;
            int n2;
            int n3 = this.image.getWidth(null);
            int n4 = this.image.getHeight(null);
            int n5 = 0;
            switch (this.alignment & 0xF) {
                default: {
                    n2 = n3;
                    break;
                }
                case 2: {
                    n5 = (dimension.width - n3) / 2;
                    n2 = n3;
                    break;
                }
                case 3: {
                    n5 = dimension.width - n3;
                    n2 = n3;
                    break;
                }
                case 4: {
                    n2 = dimension.width;
                }
            }
            int n6 = 0;
            switch (this.alignment & 0xF0) {
                default: {
                    n = n4;
                    break;
                }
                case 32: {
                    n6 = (dimension.height - n4) / 2;
                    n = n4;
                    break;
                }
                case 48: {
                    n6 = dimension.height - n4;
                    n = n4;
                    break;
                }
                case 64: {
                    n = dimension.height;
                }
            }
            try {
                graphics2.drawImage(this.image, n5, n6, n2, n, this);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            if (!this.transparent) {
                graphics.drawImage(this.canvas, 0, 0, null);
                graphics2.dispose();
            }
        }
        if (this.drawEdge) {
            graphics2.setColor(this.edgeColor);
            graphics2.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
        graphics2.setColor(color);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Dimension getPreferredSize() {
        return this.image != null ? new Dimension(this.image.getWidth(this), this.image.getHeight(this)) : new Dimension(100, 100);
    }

    public boolean isDrawEdge() {
        return this.drawEdge;
    }

    public void setDrawEdge(boolean bl) {
        this.drawEdge = bl;
        this.repaint(100L);
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color color) {
        this.edgeColor = color;
        this.repaint(100L);
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean bl) {
        this.transparent = bl;
        this.repaint(100L);
    }

    protected void setupImage(Image image, String string) throws IOException {
        Graphics graphics;
        this.prepareImage(image, this);
        if ((this.checkImage(image, this) & 0x40) != 0) {
            throw new IOException(Res.format(22, new String[]{string}));
        }
        this.imageName = string;
        if (this.isVisible() && (graphics = this.getGraphics()) != null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
        this.image = image;
        this.repaint(100L);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public URL getImageURL() {
        return this.url;
    }

    public void setImageURL(URL uRL) throws IOException {
        this.url = uRL;
        this.setupImage(ImageLoader.load(uRL, (Component)this), uRL.toString());
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) throws IOException {
        this.setupImage(image, "");
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String string) throws IOException {
        if (string != null && !string.equals("")) {
            this.setupImage(ImageLoader.load(string, (Component)this), string);
        } else {
            this.imageName = null;
            this.image = null;
        }
    }

    public TransparentImage() {
        this.setSize(100, 100);
    }
}

